/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.transport;

import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionKey;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.ReaderPool;
import com.ibm.CORBA.transport.TransportConnection;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public abstract class TransportConnectionBase
implements TransportConnection {
    private int MAX_SOCKET_RETRIES;
    private Socket socket;
    private ConnectionKey key;
    private ORBConnection conn;
    private InputStream inputStream;
    private OutputStream outputStream;
    private ReaderPool readerPool;
    private ConnectionTable table;
    private Object readerHandle;
    private ORBForTransports orbForTransports;
    private String remoteHostName;
    private int remotePort;
    private String remoteHost;
    private String localHostName;
    private int localPort;
    private String localHost;
    private InetAddress localInetAddress;
    private int connectTimeout;
    private static final String DEFAULT_LOCAL_HOST = "127.0.0.1";
    private static final String DEFAULT_LOCAL_HOST_NAME = "localHost";
    private static final String thisClassName = "com.ibm.CORBA.transport.TransportConectionBase";
    private String theParameterString;

    protected TransportConnectionBase(ConnectionTable connectionTable, Socket socket, ReaderPool readerPool, ORBForTransports oRBForTransports) {
        block6: {
            this.MAX_SOCKET_RETRIES = 5;
            this.socket = null;
            this.key = null;
            this.conn = null;
            this.inputStream = null;
            this.outputStream = null;
            this.readerPool = null;
            this.table = null;
            this.readerHandle = null;
            this.orbForTransports = null;
            this.remoteHostName = null;
            this.remotePort = 0;
            this.remoteHost = null;
            this.localHostName = null;
            this.localPort = -1;
            this.localHost = null;
            this.localInetAddress = null;
            this.connectTimeout = 0;
            this.theParameterString = null;
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (Object)this, "<init> (server-side):163", (Object)("Server-side constructor, socket=" + socket));
            }
            try {
                this.table = connectionTable;
                this.socket = socket;
                this.readerPool = readerPool;
                this.orbForTransports = oRBForTransports;
                this.getIOStreams();
                this.remoteHostName = socket.getInetAddress().getHostName();
                this.remotePort = socket.getPort();
                this.conn = oRBForTransports.createORBConnectionForServer();
                this.conn.setStreams(this.inputStream, this.outputStream, this);
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "<init> (server-side):194", exception);
                try {
                    socket.close();
                }
                catch (Exception exception2) {
                    if (!ORBRas.isTrcLogging) break block6;
                    ORBRas.orbTrcLogger.trace(8208L, this, "<init> (server-side):203", exception2.toString());
                }
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "<init> (server-side):212");
        }
    }

    protected TransportConnectionBase(ORBForTransports oRBForTransports, ConnectionTable connectionTable, ConnectionKey connectionKey, ORBConnection oRBConnection, ReaderPool readerPool, Profile profile) {
        this.MAX_SOCKET_RETRIES = 5;
        this.socket = null;
        this.key = null;
        this.conn = null;
        this.inputStream = null;
        this.outputStream = null;
        this.readerPool = null;
        this.table = null;
        this.readerHandle = null;
        this.orbForTransports = null;
        this.remoteHostName = null;
        this.remotePort = 0;
        this.remoteHost = null;
        this.localHostName = null;
        this.localPort = -1;
        this.localHost = null;
        this.localInetAddress = null;
        this.connectTimeout = 0;
        this.theParameterString = null;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "<init> (client-side):253", (Object)("Client-side constructor, ConnectionKey=" + connectionKey));
        }
        this.orbForTransports = oRBForTransports;
        this.table = connectionTable;
        this.key = connectionKey;
        this.conn = oRBConnection;
        this.readerPool = readerPool;
        this.remoteHostName = profile.getHost();
        this.remotePort = profile.getPort();
        this.localInetAddress = this.getLocalInetAddress();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "<init> (client-side):274", (Object)("localHost=" + this.localInetAddress));
        }
        this.connectTimeout = oRBForTransports.getConnectTimeout();
    }

    private InetAddress getLocalInetAddress() {
        InetAddress inetAddress = null;
        Object object = this.orbForTransports.getTransportData();
        if (object == null) {
            block7: {
                String string = this.orbForTransports.getUserSpecifiedLocalHost();
                if (string != null && string.length() > 0) {
                    try {
                        inetAddress = InetAddress.getByName(string);
                        this.localHost = inetAddress.getHostAddress();
                        this.localHostName = inetAddress.getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (!ORBRas.isTrcLogging) break block7;
                        ORBRas.orbTrcLogger.exception(8200L, this, "getLocalInetAddress:309", (Exception)unknownHostException);
                    }
                }
            }
            if (inetAddress == null) {
                this.localHost = DEFAULT_LOCAL_HOST;
                this.localHostName = DEFAULT_LOCAL_HOST_NAME;
            } else {
                this.localHost = inetAddress.getHostAddress();
                this.localHostName = inetAddress.getHostName();
            }
            this.orbForTransports.setTransportData(inetAddress);
        } else {
            inetAddress = (InetAddress)object;
        }
        return inetAddress;
    }

    private void getIOStreams() {
        try {
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, this, "getIOStreams:346", exception);
            TRANSIENT tRANSIENT = new TRANSIENT(exception.toString() + ":socket=" + this.socket, 1229127173, CompletionStatus.COMPLETED_NO);
            tRANSIENT.initCause((Throwable)exception);
            throw tRANSIENT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect() {
        int n = 0;
        while (true) {
            try {
                block12: {
                    this.socket = this.localInetAddress == null ? this.createSocket(this.remoteHostName, this.remotePort) : this.createSocket(new InetSocketAddress(this.remoteHostName, this.remotePort), new InetSocketAddress(this.localInetAddress, 0));
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, this, "connect:384", "Client side constructor, successfully created a new " + this.socket);
                    }
                    try {
                        this.socket.setKeepAlive(true);
                        this.socket.setTcpNoDelay(true);
                    }
                    catch (Exception exception) {
                        if (!ORBRas.isTrcLogging) break block12;
                        ORBRas.orbTrcLogger.trace(8208L, this, "connect:399", exception.toString());
                    }
                }
                this.getIOStreams();
                this.conn.setStreams(this.inputStream, this.outputStream, this);
                TransportConnectionBase transportConnectionBase = this;
                synchronized (transportConnectionBase) {
                    this.readerHandle = this.readerPool.addConnection(this.conn);
                }
            }
            catch (Exception exception) {
                boolean bl;
                boolean bl2 = bl = exception instanceof SocketException && !(exception instanceof BindException) && !(exception instanceof ConnectException) && !(exception instanceof NoRouteToHostException);
                if (ORBRas.isTrcLogging || !(exception instanceof ConnectException) && !(exception instanceof SocketTimeoutException)) {
                    ORBRas.orbTrcLogger.exception(4104L, this, "connect:428", exception);
                }
                if (!bl || n == this.MAX_SOCKET_RETRIES || !this.table.cleanUp()) {
                    this.table.removeConnection(this.key);
                    this.conn.abortConnection();
                    if (exception instanceof SystemException) {
                        throw (SystemException)((Object)exception);
                    }
                    int n2 = exception instanceof SocketTimeoutException ? 1229127174 : 1229127170;
                    TRANSIENT tRANSIENT = new TRANSIENT(exception.toString() + ":host=" + this.remoteHostName + ",port=" + this.remotePort, n2, CompletionStatus.COMPLETED_NO);
                    tRANSIENT.initCause((Throwable)exception);
                    throw tRANSIENT;
                }
                ++n;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection() {
        block7: {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.entry(4100L, (Object)this, "removeConnection:481", (Object)("removing connection for " + this.socket));
            }
            this.table.removeConnection(this.key);
            TransportConnectionBase transportConnectionBase = this;
            synchronized (transportConnectionBase) {
                this.readerPool.removeConnection(this.conn, this.readerHandle);
                this.readerHandle = null;
            }
            try {
                this.socket.close();
                this.inputStream.close();
                this.outputStream.close();
            }
            catch (Exception exception) {
                if (!ORBRas.isTrcLogging) break block7;
                ORBRas.orbTrcLogger.trace(4104L, this, "removeConnection:509", exception.toString());
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "removeConnection:517");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateServer() {
        this.key = this.createKey(this.remoteHostName, this.remotePort);
        this.table.addConnection(this.key, this.conn);
        this.table.checkConnectionTable();
        TransportConnectionBase transportConnectionBase = this;
        synchronized (transportConnectionBase) {
            this.readerHandle = this.readerPool.addConnection(this.conn);
        }
    }

    public String getConnectionParameterString() {
        if (this.theParameterString == null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.getClass().getName(), ".");
            String string = "";
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
            this.theParameterString = string + "[addr=" + this.getRemoteHost() + ",port=" + this.getRemotePort() + ",local=" + this.getLocalPort() + "]";
        }
        return this.theParameterString;
    }

    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + " socket=" + this.socket + " key=" + this.key;
    }

    public abstract ConnectionKey createKey(String var1, int var2);

    public Socket createSocket(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2) throws Exception {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, this, "createSocket:621", "createSocket(InetAddress remote, InetAddress local) is not implemented by this transport. Using default values for local address.");
        }
        return this.createSocket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
    }

    public abstract Socket createSocket(String var1, int var2) throws Exception;

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public abstract Object getConnectionData();

    public ORBForTransports getORBForTransports() {
        return this.orbForTransports;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null && this.socket != null) {
            this.remoteHost = this.socket.getInetAddress().getHostAddress();
        }
        return this.remoteHost;
    }

    public String getRemoteHostName() {
        return this.remoteHostName;
    }

    public int getLocalPort() {
        if (this.localPort < 0 && this.socket != null) {
            this.localPort = this.socket.getLocalPort();
        }
        return this.localPort;
    }

    public String getLocalHost() {
        if (this.localHost == null) {
            if (this.socket == null) {
                return DEFAULT_LOCAL_HOST;
            }
            this.localHost = this.socket.getLocalAddress().getHostAddress();
        }
        return this.localHost;
    }

    public String getLocalHostName() {
        if (this.localHostName == null) {
            if (this.socket == null) {
                return DEFAULT_LOCAL_HOST_NAME;
            }
            try {
                this.localHostName = this.socket.getLocalAddress().getHostName();
            }
            catch (Throwable throwable) {
                this.localHostName = DEFAULT_LOCAL_HOST_NAME;
            }
            if (this.localHostName == null) {
                this.localHostName = DEFAULT_LOCAL_HOST_NAME;
            }
        }
        return this.localHostName;
    }

    public void preWrite(boolean bl) {
    }

    public void preReply() {
    }
}

