/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Plugin;
import com.ibm.CORBA.iiop.ThreadPool;
import com.ibm.CORBA.iiop.WorkUnit;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.iiop.WorkQueue;
import com.ibm.rmi.iiop.WorkerPool;

public class ThreadPoolImpl
implements ThreadPool,
Plugin {
    private ORB orb;
    private int minPoolSize;
    private int maxPoolSize;
    private long inactivityTimeout;
    private boolean isGrowable;
    private WorkerPool workerPool;
    private WorkQueue workQueue;

    public void init(ORB oRB) {
        this.orb = oRB;
        this.workerPool = new WorkerPool(this.minPoolSize, this.maxPoolSize, this.inactivityTimeout, this.isGrowable);
        this.workQueue = new WorkQueue();
        this.workerPool.setWorkQueue(this.workQueue);
        this.workQueue.setWorkerPool(this.workerPool);
        this.workerPool.initializeThreads();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4128L, this, "init:439", "ThreadPool initialization completed. The ThreadPool properties are set as follows: MinimumSize=" + this.minPoolSize + " threads, MaximumSize=" + this.maxPoolSize + " threads, InactivityTimeout=" + this.inactivityTimeout + " milliseconds , IsGrowable=" + this.isGrowable + ".");
        }
    }

    public void cleanup() {
        this.workQueue.shutdown();
    }

    public void startWorkerThread(WorkUnit workUnit) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "startWorkerThread:462");
        }
        this.workQueue.addWorkToDo(workUnit);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "startWorkerThread:472");
        }
    }

    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public boolean isGrowable() {
        return this.isGrowable;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setInactivityTimeout(long l) {
        this.inactivityTimeout = l;
    }

    public void setGrowable(boolean bl) {
        this.isGrowable = bl;
    }

    public void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
    }

    public void setMinPoolSize(int n) {
        this.minPoolSize = n;
    }
}

