/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.ras;

import com.ibm.CORBA.iiop.OrbTrcLogger;
import com.ibm.CORBA.ras.ORBRas;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class BufferedTrcLogger
implements OrbTrcLogger {
    private static final String CLASS = (class$com$ibm$rmi$ras$BufferedTrcLogger == null ? (class$com$ibm$rmi$ras$BufferedTrcLogger = BufferedTrcLogger.class$("com.ibm.rmi.ras.BufferedTrcLogger")) : class$com$ibm$rmi$ras$BufferedTrcLogger).getName();
    private static BufferedTrcLogger instance;
    public static final int DEFAULT_MAX_TRACE_ENTRIES = 100;
    public static final String MAX_TRACE_PROPERTY = "com.ibm.CORBA.BufferedTraceLimit";
    private final CheckedList buffer;
    static /* synthetic */ Class class$com$ibm$rmi$ras$BufferedTrcLogger;

    public static BufferedTrcLogger instance() {
        if (instance == null) {
            instance = new BufferedTrcLogger();
        }
        return instance;
    }

    private BufferedTrcLogger() {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger(BufferedTrcLogger.MAX_TRACE_PROPERTY, 100);
            }
        };
        Integer n = (Integer)AccessController.doPrivileged(privilegedAction);
        this.buffer = new CheckedList(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int traceTo(OrbTrcLogger orbTrcLogger) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            Iterator iterator = this.buffer.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                TraceStatement traceStatement = (TraceStatement)iterator.next();
                traceStatement.traceTo(orbTrcLogger);
                iterator.remove();
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.clear();
        }
    }

    public void setLogging(boolean bl) {
        ORBRas.isTrcLogging = bl;
    }

    public void setLoggingOutput(String string) {
        throw new IllegalStateException("Cannot call setLoggingOutput on " + CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(long l, Object object, String string) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcEntry(l, object, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(long l, Object object, String string, Object object2) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcEntry(l, object, string, object2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(long l, Object object, String string, Object object2, Object object3) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcEntry(l, object, string, object2, object3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(long l, Object object, String string, Object[] objectArray) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcEntry(l, object, string, objectArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(long l, String string, String string2) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcEntry(l, string, string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(long l, String string, String string2, Object object) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcEntry(l, string, string2, object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(long l, String string, String string2, Object object, Object object2) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcEntry(l, string, string2, object, object2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entry(long l, String string, String string2, Object[] objectArray) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcEntry(l, string, string2, objectArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(long l, Object object, String string) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcExit(l, object, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(long l, Object object, String string, Object object2) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcExit(l, object, string, object2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(long l, String string, String string2) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcExit(l, string, string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(long l, String string, String string2, Object object) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcExit(l, string, string2, object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(long l, Object object, String string, String string2) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcInfo(l, object, string, string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(long l, Object object, String string, String string2, Object object2) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcInfo(l, object, string, string2, object2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(long l, Object object, String string, String string2, Object object2, Object object3) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcInfo(l, object, string, string2, object2, object3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(long l, Object object, String string, String string2, Object[] objectArray) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcInfo(l, object, string, string2, objectArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(long l, String string, String string2, String string3) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcInfo(l, string, string2, string3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(long l, String string, String string2, String string3, Object object) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcInfo(l, string, string2, string3, object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(long l, String string, String string2, String string3, Object object, Object object2) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcInfo(l, string, string2, string3, object, object2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(long l, String string, String string2, String string3, Object[] objectArray) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcInfo(l, string, string2, string3, objectArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(long l, Object object, String string, Exception exception) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcExc(l, object, string, exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(long l, String string, String string2, Exception exception) {
        CheckedList checkedList = this.buffer;
        synchronized (checkedList) {
            this.buffer.add(new TrcExc(l, string, string2, exception));
        }
    }

    public boolean isLoggable(long l) {
        return true;
    }

    private void bufferFull() {
        this.initializeTraceIfNecessary();
        if (ORBRas.isTrcLogging) {
            this.traceTo(ORBRas.orbTrcLogger);
        } else {
            this.buffer.clear();
        }
        this.buffer.disable();
    }

    private void initializeTraceIfNecessary() {
        if (ORBRas.isTrcLogger(this)) {
            ORBRas.disableTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CheckedList
    extends LinkedList {
        private final int maxSize;
        private boolean disabled;

        public CheckedList(int n) {
            this.maxSize = n;
            this.disabled = false;
        }

        public synchronized boolean add(Object object) {
            if (!this.disabled) {
                if (this.size() < this.maxSize) {
                    return super.add(object);
                }
                BufferedTrcLogger.this.bufferFull();
            }
            return false;
        }

        public synchronized void disable() {
            this.disabled = true;
        }

        public synchronized void clear() {
            super.clear();
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void addFirst(Object object) {
            throw new UnsupportedOperationException();
        }

        public void addLast(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private class TrcInfo
    implements TraceStatement {
        private final long type;
        private final Object clz;
        private final String meth;
        private final String msg;
        private final Object a;
        private final Object b;

        public TrcInfo(long l, Object object, String string, String string2) {
            this.type = l;
            this.clz = object;
            this.meth = string;
            this.msg = string2;
            this.a = null;
            this.b = null;
        }

        public TrcInfo(long l, Object object, String string, String string2, Object object2) {
            this.type = l;
            this.clz = object;
            this.meth = string;
            this.msg = string2;
            this.a = object2;
            this.b = null;
        }

        public TrcInfo(long l, Object object, String string, String string2, Object object2, Object object3) {
            this.type = l;
            this.clz = object;
            this.meth = string;
            this.msg = string2;
            this.a = object2;
            this.b = object3;
        }

        public void traceTo(OrbTrcLogger orbTrcLogger) {
            if (this.a == null) {
                orbTrcLogger.trace(this.type, this.clz, this.meth, this.msg);
            } else if (this.b == null) {
                orbTrcLogger.trace(this.type, this.clz, this.meth, this.msg, this.a);
            } else {
                orbTrcLogger.trace(this.type, this.clz, this.meth, this.msg, this.a, this.b);
            }
        }
    }

    private class TrcExc
    implements TraceStatement {
        private final long type;
        private final Object clz;
        private final String meth;
        private final Exception ex;

        public TrcExc(long l, Object object, String string, Exception exception) {
            this.type = l;
            this.clz = object;
            this.meth = string;
            this.ex = exception;
        }

        public void traceTo(OrbTrcLogger orbTrcLogger) {
            orbTrcLogger.exception(this.type, this.clz, this.meth, this.ex);
        }
    }

    private class TrcExit
    implements TraceStatement {
        private final long type;
        private final Object clz;
        private final String meth;
        private final Object ret;

        public TrcExit(long l, Object object, String string) {
            this.type = l;
            this.clz = object;
            this.meth = string;
            this.ret = null;
        }

        public TrcExit(long l, Object object, String string, Object object2) {
            this.type = l;
            this.clz = object;
            this.meth = string;
            this.ret = object2;
        }

        public void traceTo(OrbTrcLogger orbTrcLogger) {
            if (this.ret == null) {
                orbTrcLogger.exit(this.type, this.clz, this.meth);
            } else {
                orbTrcLogger.exit(this.type, this.clz, this.meth, this.ret);
            }
        }
    }

    private class TrcEntry
    implements TraceStatement {
        private final long type;
        private final Object clz;
        private final String meth;
        private final Object a;
        private final Object b;

        public TrcEntry(long l, Object object, String string) {
            this.type = l;
            this.clz = object;
            this.meth = string;
            this.a = null;
            this.b = null;
        }

        public TrcEntry(long l, Object object, String string, Object object2) {
            this.type = l;
            this.clz = object;
            this.meth = string;
            this.a = object2;
            this.b = null;
        }

        public TrcEntry(long l, Object object, String string, Object object2, Object object3) {
            this.type = l;
            this.clz = object;
            this.meth = string;
            this.a = object2;
            this.b = object3;
        }

        public void traceTo(OrbTrcLogger orbTrcLogger) {
            if (this.a == null) {
                orbTrcLogger.entry(this.type, this.clz, this.meth);
            } else if (this.b == null) {
                orbTrcLogger.entry(this.type, this.clz, this.meth, this.a);
            } else {
                orbTrcLogger.entry(this.type, this.clz, this.meth, this.a, this.b);
            }
        }
    }

    private static interface TraceStatement {
        public void traceTo(OrbTrcLogger var1);
    }
}

