/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.transport;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.TransportBase;
import com.ibm.rmi.ras.Utility;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ListenerThread
extends com.ibm.CORBA.transport.ListenerThread {
    protected static final int MAX_CLEANUP_RETRIES = 5;
    protected ServerSocket serverSocket;
    protected int acceptTimeout;
    protected ConnectionTable connectionTable;
    protected TransportBase transportBase = null;
    static int instanceCounter = 0;
    int thisInstanceNumber;

    public ListenerThread(ConnectionTable connectionTable, ServerSocket serverSocket, String string, TransportBase transportBase) {
        this(connectionTable, serverSocket, 0, string, transportBase);
    }

    public ListenerThread(ConnectionTable connectionTable, ServerSocket serverSocket, int n, String string, TransportBase transportBase) {
        super(string);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (Object)this, "<init>:105", (Object)("serverSocket=" + serverSocket + " timeout=" + n));
        }
        this.serverSocket = serverSocket;
        this.acceptTimeout = n;
        this.connectionTable = connectionTable;
        this.thisInstanceNumber = instanceCounter++;
        this.transportBase = transportBase;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "<init>:119");
        }
    }

    public void run() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "run:129");
        }
        final String string = "LT=" + this.thisInstanceNumber + ":" + this.getName();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ListenerThread.this.setName(string);
                return null;
            }
        });
        int n = 0;
        try {
            this.serverSocket.setSoTimeout(this.acceptTimeout);
        }
        catch (SocketException socketException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "run:163", (Exception)socketException);
        }
        while (true) {
            try {
                while (true) {
                    Socket socket;
                    block16: {
                        socket = this.serverSocket.accept();
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(8208L, this, "run:185", Utility.getMessage("ListenerThread.acceptSocket", socket.toString()));
                        }
                        try {
                            socket.setTcpNoDelay(true);
                        }
                        catch (Exception exception) {
                            if (!ORBRas.isTrcLogging) break block16;
                            ORBRas.orbTrcLogger.trace(8208L, this, "run:198", exception.toString());
                        }
                    }
                    this.transportBase.createTransportConnection(socket, this);
                    n = 0;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!this.isShutdownPending()) continue;
                if (!ORBRas.isTrcLogging) break;
                ORBRas.orbTrcLogger.trace(8208L, this, "run:215", "accept interrupted with shutdown pending");
            }
            catch (SocketException socketException) {
                if (this.isShutdownPending()) {
                    if (!ORBRas.isTrcLogging) break;
                    ORBRas.orbTrcLogger.trace(8208L, this, "run:228", socketException.getMessage() + " with shutdown pending");
                    break;
                }
                ORBRas.orbTrcLogger.exception(4104L, this, "run:235", (Exception)socketException);
                if (n == 5 || !this.connectionTable.cleanUp()) continue;
                ++n;
                continue;
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "run:257", exception);
                continue;
            }
            catch (Error error) {
                ORBRas.orbTrcLogger.trace(4104L, (Object)this, "run:262", error.getMessage(), (Object)error);
                continue;
            }
            break;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "run:270", "ListenerThread shutting down");
        }
        this.connectionTable.cleanUp();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "run:282");
        }
    }

    public void setShutdownPending(boolean bl) {
        super.setShutdownPending(bl);
        if (bl) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                ORBRas.orbTrcLogger.exception(4104L, this, "setShutdownPending:300", (Exception)iOException);
            }
        }
    }
}

