/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.pkcs11.PKCS11Object;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

final class ConstructKeys {
    ConstructKeys() {
    }

    static final Object[] constructPublicKeyAttrs(String wrappedKeyAlgorithm, Config config) throws NoSuchAlgorithmException {
        Object[] attrs = new Object[2];
        HashMap<Integer, Object> hattrs = null;
        Set<Integer> keys = null;
        int numEles = 0;
        int[] attrTypes = null;
        Object[] attrValues = null;
        if (wrappedKeyAlgorithm.equalsIgnoreCase("RSA")) {
            if (config != null) {
                hattrs = config.getAttributes("IMPORT", PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA);
                keys = hattrs.keySet();
                numEles = keys.size();
                attrTypes = new int[2 + numEles];
                attrValues = new Object[2 + numEles];
                attrTypes[0] = 0;
                attrTypes[1] = 256;
                attrValues[0] = PKCS11Object.PUBLIC_KEY;
                attrValues[1] = PKCS11Object.RSA;
                Iterator<Integer> it = keys.iterator();
                int i = 1;
                while (it.hasNext()) {
                    Integer key = it.next();
                    attrTypes[1 + i] = key;
                    attrValues[1 + i] = hattrs.get(key);
                    ++i;
                }
            } else {
                attrTypes = new int[]{0, 256, 266, 260, 262};
                attrValues = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
            }
        } else if (wrappedKeyAlgorithm.equalsIgnoreCase("DSA")) {
            if (config != null) {
                hattrs = config.getAttributes("IMPORT", PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA);
                keys = hattrs.keySet();
                numEles = keys.size();
                attrTypes = new int[2 + numEles];
                attrValues = new Object[2 + numEles];
                attrTypes[0] = 0;
                attrTypes[1] = 256;
                attrValues[0] = PKCS11Object.PUBLIC_KEY;
                attrValues[1] = PKCS11Object.DSA;
                Iterator<Integer> it = keys.iterator();
                int i = 1;
                while (it.hasNext()) {
                    Integer key = it.next();
                    attrTypes[1 + i] = key;
                    attrValues[1 + i] = hattrs.get(key);
                    ++i;
                }
            } else {
                attrTypes = new int[]{0, 256, 266};
                attrValues = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA, Boolean.TRUE};
            }
        } else if (wrappedKeyAlgorithm.equalsIgnoreCase("DH")) {
            if (config != null) {
                hattrs = config.getAttributes("IMPORT", PKCS11Object.PUBLIC_KEY, PKCS11Object.DH);
                keys = hattrs.keySet();
                numEles = keys.size();
                attrTypes = new int[2 + numEles];
                attrValues = new Object[2 + numEles];
                attrTypes[0] = 0;
                attrTypes[1] = 256;
                attrValues[0] = PKCS11Object.PUBLIC_KEY;
                attrValues[1] = PKCS11Object.DH;
                Iterator<Integer> it = keys.iterator();
                int i = 1;
                while (it.hasNext()) {
                    Integer key = it.next();
                    attrTypes[1 + i] = key;
                    attrValues[1 + i] = hattrs.get(key);
                    ++i;
                }
            } else {
                attrTypes = new int[]{0, 256};
                attrValues = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.DH};
            }
        } else {
            throw new NoSuchAlgorithmException("unsupported wrapped key algorithm " + wrappedKeyAlgorithm);
        }
        attrs[0] = attrTypes;
        attrs[1] = attrValues;
        return attrs;
    }

    static final PublicKey constructPublicKey(PKCS11Object objKey, String keyAlgorithm, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException {
        PublicKey key = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm, provider);
            PKCS11KeySpec keySpec = new PKCS11KeySpec(objKey);
            key = keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new NoSuchAlgorithmException("The IBMPKCS11Impl providers can not create keys for the " + keyAlgorithm + "algorithm");
        }
        catch (InvalidKeySpecException ikse) {
            // empty catch block
        }
        return key;
    }

    static final Object[] constructPrivateKeyAttrs(String wrappedKeyAlgorithm, Config config) throws NoSuchAlgorithmException {
        Object[] attrs = new Object[2];
        HashMap<Integer, Object> hattrs = null;
        Set<Integer> keys = null;
        int numEles = 0;
        int[] attrTypes = null;
        Object[] attrValues = null;
        if (wrappedKeyAlgorithm.equalsIgnoreCase("DSA")) {
            if (config != null) {
                hattrs = config.getAttributes("IMPORT", PKCS11Object.PRIVATE_KEY, PKCS11Object.DSA);
                keys = hattrs.keySet();
                numEles = keys.size();
                attrTypes = new int[2 + numEles];
                attrValues = new Object[2 + numEles];
                attrTypes[0] = 0;
                attrTypes[1] = 256;
                attrValues[0] = PKCS11Object.PRIVATE_KEY;
                attrValues[1] = PKCS11Object.DSA;
                Iterator<Integer> it = keys.iterator();
                int i = 1;
                while (it.hasNext()) {
                    Integer key = it.next();
                    attrTypes[1 + i] = key;
                    attrValues[1 + i] = hattrs.get(key);
                    ++i;
                }
            } else {
                attrTypes = new int[]{0, 256, 264};
                attrValues = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.DSA, Boolean.TRUE};
            }
        } else if (wrappedKeyAlgorithm.equalsIgnoreCase("RSA")) {
            if (config != null) {
                hattrs = config.getAttributes("IMPORT", PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA);
                keys = hattrs.keySet();
                numEles = keys.size();
                attrTypes = new int[2 + numEles];
                attrValues = new Object[2 + numEles];
                attrTypes[0] = 0;
                attrTypes[1] = 256;
                attrValues[0] = PKCS11Object.PRIVATE_KEY;
                attrValues[1] = PKCS11Object.RSA;
                Iterator<Integer> it = keys.iterator();
                int i = 1;
                while (it.hasNext()) {
                    Integer key = it.next();
                    attrTypes[1 + i] = key;
                    attrValues[1 + i] = hattrs.get(key);
                    ++i;
                }
            } else {
                attrTypes = new int[]{0, 256, 264, 261, 263};
                attrValues = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
            }
        } else if (wrappedKeyAlgorithm.equalsIgnoreCase("DH")) {
            if (config != null) {
                hattrs = config.getAttributes("IMPORT", PKCS11Object.PRIVATE_KEY, PKCS11Object.DH);
                keys = hattrs.keySet();
                numEles = keys.size();
                attrTypes = new int[2 + numEles];
                attrValues = new Object[2 + numEles];
                attrTypes[0] = 0;
                attrTypes[1] = 256;
                attrValues[0] = PKCS11Object.PRIVATE_KEY;
                attrValues[1] = PKCS11Object.DH;
                Iterator<Integer> it = keys.iterator();
                int i = 1;
                while (it.hasNext()) {
                    Integer key = it.next();
                    attrTypes[1 + i] = key;
                    attrValues[1 + i] = hattrs.get(key);
                    ++i;
                }
            } else {
                attrTypes = new int[]{0, 256, 268};
                attrValues = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.DH, Boolean.TRUE};
            }
        } else {
            throw new NoSuchAlgorithmException("unsupported wrapped key algorithm " + wrappedKeyAlgorithm);
        }
        attrs[0] = attrTypes;
        attrs[1] = attrValues;
        return attrs;
    }

    static final PrivateKey constructPrivateKey(PKCS11Object objKey, String keyAlgorithm, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException {
        PrivateKey key = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm, provider);
            PKCS11KeySpec keySpec = new PKCS11KeySpec(objKey);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new NoSuchAlgorithmException("The IBMPKCS11Impl providers can not create keys for the " + keyAlgorithm + "algorithm");
        }
        catch (InvalidKeySpecException ikse) {
            return key;
        }
    }

    static final Object[] constructSecretKeyAttrs(String wrappedKeyAlgorithm, Config config) throws NoSuchAlgorithmException {
        Object[] attrs = new Object[2];
        int keyType = 0;
        HashMap<Integer, Object> hattrs = null;
        Set<Integer> keys = null;
        int numEles = 0;
        int[] attrTypes = null;
        Object[] attrValues = null;
        if (wrappedKeyAlgorithm.equalsIgnoreCase("DES")) {
            keyType = PKCS11Object.DES;
        } else if (wrappedKeyAlgorithm.equalsIgnoreCase("3DES") || wrappedKeyAlgorithm.equalsIgnoreCase("DESede") || wrappedKeyAlgorithm.equalsIgnoreCase("TripleDES")) {
            keyType = PKCS11Object.DES3;
        } else if (wrappedKeyAlgorithm.equalsIgnoreCase("AES")) {
            keyType = PKCS11Object.AES;
        } else if (wrappedKeyAlgorithm.equalsIgnoreCase("RC4")) {
            keyType = PKCS11Object.RC4;
        } else if (wrappedKeyAlgorithm.equalsIgnoreCase("BLOWFISH")) {
            keyType = PKCS11Object.BLOWFISH;
        } else {
            throw new NoSuchAlgorithmException("unsupported wrapped key algorithm " + wrappedKeyAlgorithm);
        }
        if (config != null) {
            hattrs = config.getAttributes("IMPORT", PKCS11Object.SECRET_KEY, keyType);
            keys = hattrs.keySet();
            numEles = keys.size();
            attrTypes = new int[2 + numEles];
            attrValues = new Object[2 + numEles];
            attrTypes[0] = 0;
            attrTypes[1] = 256;
            attrValues[0] = PKCS11Object.SECRET_KEY;
            attrValues[1] = keyType;
            Iterator<Integer> it = keys.iterator();
            int i = 1;
            while (it.hasNext()) {
                Integer key = it.next();
                attrTypes[1 + i] = key;
                attrValues[1 + i] = hattrs.get(key);
                ++i;
            }
        } else {
            attrTypes = new int[]{0, 256, 260, 261, 262, 263};
            attrValues = new Object[]{PKCS11Object.SECRET_KEY, keyType, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
        }
        attrs[0] = attrTypes;
        attrs[1] = attrValues;
        return attrs;
    }

    static final SecretKey constructSecretKey(PKCS11Object objKey, String keyAlgorithm, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKey key = null;
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(keyAlgorithm, provider);
            PKCS11KeySpec keySpec = new PKCS11KeySpec(objKey);
            return keyFactory.generateSecret(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new NoSuchAlgorithmException("The IBMPKCS11Impl providers can not create keys for the " + keyAlgorithm + "algorithm");
        }
        catch (InvalidKeySpecException ikse) {
            ikse.printStackTrace();
            return key;
        }
    }
}

