/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.DHPKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DHPKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.pkcs11.PKCS11Session;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public final class DHPKCS11KeyFactory
extends KeyFactorySpi {
    private PKCS11Session session = null;
    private Config config = null;

    public DHPKCS11KeyFactory(Provider provider) {
        IBMPKCS11Impl.verifyJceJar();
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DHPublicKeySpec) {
                DHPublicKeySpec dhPubKeySpec = (DHPublicKeySpec)keySpec;
                return new DHPKCS11PublicKey(dhPubKeySpec.getY(), dhPubKeySpec.getP(), dhPubKeySpec.getG(), this.session, this.config);
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new DHPKCS11PublicKey(((X509EncodedKeySpec)keySpec).getEncoded(), this.session, this.config);
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DHPrivateKeySpec) {
                DHPrivateKeySpec dhPrivKeySpec = (DHPrivateKeySpec)keySpec;
                return new DHPKCS11PrivateKey(dhPrivKeySpec.getX(), dhPrivKeySpec.getP(), dhPrivKeySpec.getG(), this.session, this.config);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new DHPKCS11PrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded(), this.session, this.config);
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        try {
            if (key instanceof DHPublicKey) {
                Class<?> dhPubKeySpec = Class.forName("javax.crypto.spec.DHPublicKeySpec");
                Class<?> x509KeySpec = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (dhPubKeySpec.isAssignableFrom(keySpec)) {
                    DHPublicKey dhPubKey = (DHPublicKey)key;
                    DHParameterSpec params = dhPubKey.getParams();
                    return new DHPublicKeySpec(dhPubKey.getY(), params.getP(), params.getG());
                }
                if (x509KeySpec.isAssignableFrom(keySpec)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof DHPrivateKey) {
                Class<?> dhPrivKeySpec = Class.forName("javax.crypto.spec.DHPrivateKeySpec");
                Class<?> pkcs8KeySpec = Class.forName("java.security.spec.PKCS8EncodedKeySpec");
                if (dhPrivKeySpec.isAssignableFrom(keySpec)) {
                    DHPrivateKey dhPrivKey = (DHPrivateKey)key;
                    DHParameterSpec params = dhPrivKey.getParams();
                    return new DHPrivateKeySpec(dhPrivKey.getX(), params.getP(), params.getG());
                }
                if (pkcs8KeySpec.isAssignableFrom(keySpec)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key type");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof DHPublicKey) {
                if (key instanceof DHPKCS11PublicKey) {
                    return key;
                }
                DHPublicKeySpec dhPubKeySpec = (DHPublicKeySpec)this.engineGetKeySpec(key, DHPublicKeySpec.class);
                return this.engineGeneratePublic(dhPubKeySpec);
            }
            if (key instanceof DHPrivateKey) {
                if (key instanceof DHPKCS11PrivateKey) {
                    return key;
                }
                DHPrivateKeySpec dhPrivKeySpec = (DHPrivateKeySpec)this.engineGetKeySpec(key, DHPrivateKeySpec.class);
                return this.engineGeneratePrivate(dhPrivKeySpec);
            }
            throw new InvalidKeyException("Wrong key type");
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

