/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DHPKCS11Parameters
extends AlgorithmParametersSpi {
    private Provider provider = null;
    private DHParameterSpec dhparamSpec = null;

    public DHPKCS11Parameters(Provider provider) {
        this.provider = provider;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.dhparamSpec = (DHParameterSpec)paramSpec;
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        DerValue encoded = new DerValue(params);
        if (encoded.getTag() != 48) {
            throw new IOException("DH params parsing error");
        }
        encoded.getData().reset();
        BigInteger p = encoded.getData().getInteger();
        BigInteger g = encoded.getData().getInteger();
        int l = 0;
        l = encoded.getData().available() != 0 ? encoded.getData().getInteger().intValue() : p.bitLength() - 1;
        if (encoded.getData().available() != 0) {
            throw new IOException("DH encoded params have " + encoded.getData().available() + " extra bytes");
        }
        this.dhparamSpec = new DHParameterSpec(p, g, l);
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        this.engineInit(params);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        try {
            Class<T> dhParamSpecClass = Class.forName("javax.crypto.spec.DHParameterSpec");
            if (dhParamSpecClass.isAssignableFrom(paramSpec)) {
                return (T)this.dhparamSpec;
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        bytes.putInteger(this.dhparamSpec.getP());
        bytes.putInteger(this.dhparamSpec.getG());
        if (this.dhparamSpec.getL() > 0) {
            bytes.putInteger(this.dhparamSpec.getL());
        }
        out.write((byte)48, bytes);
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String format) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        return "\n\tp: " + this.dhparamSpec.getP().toString() + "\n\tg: " + this.dhparamSpec.getG().toString() + "\n\tl: " + Integer.toString(this.dhparamSpec.getL()) + "\n";
    }
}

