/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;

class DHPKCS11PrivateKey
implements PKCS11PrivateKey,
DHPrivateKey,
Serializable {
    private static final long serialVersionUID = 3258417222417265719L;
    private static final BigInteger PKCS8_VERSION = BigInteger.valueOf(0L);
    private BigInteger x = null;
    private byte[] key = null;
    private byte[] encodedKey = null;
    private BigInteger p = null;
    private BigInteger g = null;
    private int l = 0;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private PKCS11Object p11Object = null;

    public DHPKCS11PrivateKey(BigInteger x, BigInteger p, BigInteger g, PKCS11Session session, Config config) throws InvalidKeyException {
        this.x = x;
        this.l = this.x.bitLength();
        this.p = p;
        this.g = g;
        try {
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
        }
        catch (IOException e) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding for the private key");
        }
        this.importPrivateKeyIntoToken(session, config);
    }

    public DHPKCS11PrivateKey(PKCS11Object object) throws InvalidKeyException {
        this.p11Object = object;
        try {
            this.x = new BigInteger(1, (byte[])this.getAttrValue(this.p11Object, 17));
            this.l = this.x.bitLength();
            this.p = (BigInteger)this.getAttrValue(this.p11Object, 304);
            this.g = (BigInteger)this.getAttrValue(this.p11Object, 306);
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
        }
        catch (IOException e) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding");
        }
    }

    public DHPKCS11PrivateKey(byte[] encodedKey, PKCS11Session session, Config config) throws InvalidKeyException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(encodedKey);
        try {
            DerValue val = new DerValue((InputStream)inStream);
            if (val.getTag() != 48) {
                throw new InvalidKeyException("Key not a SEQUENCE");
            }
            BigInteger parsedVersion = val.getData().getInteger();
            if (!parsedVersion.equals(PKCS8_VERSION)) {
                throw new IOException("version mismatch: (supported: " + PKCS8_VERSION + ", parsed: " + parsedVersion);
            }
            DerValue algid = val.getData().getDerValue();
            if (algid.getTag() != 48) {
                throw new InvalidKeyException("AlgId is not a SEQUENCE");
            }
            DerInputStream derInStream = algid.toDerInputStream();
            ObjectIdentifier oid = derInStream.getOID();
            if (derInStream.available() == 0) {
                throw new InvalidKeyException("Parameters missing");
            }
            if (!oid.equals(ObjectIdentifier.newInternal((int[])this.DH_data))) {
                throw new InvalidKeyException("AlgorithID is not PKCS DH");
            }
            DerValue params = derInStream.getDerValue();
            if (params.getTag() == 5) {
                throw new InvalidKeyException("Null parameters");
            }
            if (params.getTag() != 48) {
                throw new InvalidKeyException("Parameters not a SEQUENCE");
            }
            params.getData().reset();
            this.p = params.getData().getInteger();
            this.g = params.getData().getInteger();
            if (params.getData().available() != 0) {
                this.l = params.getData().getInteger().intValue();
            }
            if (params.getData().available() != 0) {
                throw new InvalidKeyException("Extra parameter data");
            }
            this.key = val.getData().getOctetString();
            this.parseKeyBits();
            this.encodedKey = (byte[])encodedKey.clone();
            this.importPrivateKeyIntoToken(session, config);
        }
        catch (NumberFormatException e) {
            throw new InvalidKeyException("Private-value length too big");
        }
        catch (IOException e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    private void importPrivateKeyIntoToken(PKCS11Session session, Config config) {
        HashMap<Integer, Object> attribs = new HashMap<Integer, Object>();
        attribs.put(0, PKCS11Object.PRIVATE_KEY);
        attribs.put(256, PKCS11Object.DH);
        attribs.put(268, Boolean.TRUE);
        attribs.put(304, this.p);
        attribs.put(306, this.g);
        attribs.put(17, this.x.toByteArray());
        attribs.put(352, this.l);
        attribs.putAll(config.getAttributes("IMPORT", PKCS11Object.PRIVATE_KEY, PKCS11Object.DH));
        int[] pubTypes = new int[attribs.size()];
        Object[] pubValues = new Object[attribs.size()];
        Iterator it = attribs.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            pubTypes[i] = (Integer)entry.getKey();
            pubValues[i++] = entry.getValue();
        }
        this.p11Object = session.createObject(pubTypes, pubValues);
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer("IBMPKCS11 Diffie-Hellman Private Key:\nx:\n" + this.x.toString() + "\n" + "p:\n" + this.p.toString() + "\n" + "g:\n" + this.g.toString());
        return strbuf.toString();
    }

    public String getAlgorithm() {
        return "DH";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream tmp = new DerOutputStream();
                tmp.putInteger(PKCS8_VERSION);
                DerOutputStream algid = new DerOutputStream();
                algid.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream params = new DerOutputStream();
                params.putInteger(this.p);
                params.putInteger(this.g);
                if (this.l != 0) {
                    params.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue paramSequence = new DerValue(48, params.toByteArray());
                algid.putDerValue(paramSequence);
                tmp.write((byte)48, algid);
                tmp.putOctetString(this.key);
                DerOutputStream derKey = new DerOutputStream();
                derKey.write((byte)48, tmp);
                this.encodedKey = derKey.toByteArray();
            }
            catch (IOException e) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public BigInteger getX() {
        return this.x;
    }

    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.p, this.g, this.l);
    }

    private void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.key);
            this.x = in.getInteger();
            this.l = this.x.bitLength();
        }
        catch (IOException e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    public byte[] getSubject() {
        return null;
    }

    public Boolean getSensitive() {
        return (Boolean)this.getAttrValue(this.p11Object, 259);
    }

    public Boolean getSecondaryAuth() {
        return (Boolean)this.getAttrValue(this.p11Object, 512);
    }

    public Integer getAuthPinFlags() {
        return (Integer)this.getAttrValue(this.p11Object, 513);
    }

    public Boolean getDecrypt() {
        return (Boolean)this.getAttrValue(this.p11Object, 261);
    }

    public Boolean getSign() {
        return (Boolean)this.getAttrValue(this.p11Object, 264);
    }

    public Boolean getSignRecover() {
        return (Boolean)this.getAttrValue(this.p11Object, 265);
    }

    public Boolean getUnwrap() {
        return (Boolean)this.getAttrValue(this.p11Object, 263);
    }

    public Boolean getExtractable() {
        return (Boolean)this.getAttrValue(this.p11Object, 354);
    }

    public Boolean getAlwaysSensitive() {
        return (Boolean)this.getAttrValue(this.p11Object, 357);
    }

    public Boolean getNeverExtractable() {
        return (Boolean)this.getAttrValue(this.p11Object, 356);
    }

    public PKCS11Session getSession() {
        return this.p11Object.getSession();
    }

    public PKCS11Object getObject() {
        return this.p11Object;
    }

    public Boolean getToken() {
        return (Boolean)this.getAttrValue(this.p11Object, 1);
    }

    public Boolean getPrivate() {
        return (Boolean)this.getAttrValue(this.p11Object, 2);
    }

    public void rm() {
        if (this.p11Object != null) {
            try {
                this.getObject().destroy();
                this.p11Object = null;
            }
            catch (PKCS11Exception pKCS11Exception) {
                // empty catch block
            }
        }
    }

    public String getLabel() {
        return null;
    }

    public Boolean getModifiable() {
        return (Boolean)this.getAttrValue(this.p11Object, 368);
    }

    public Integer getKeyType() {
        return PKCS11Object.DH;
    }

    public byte[] getID() {
        return (byte[])this.getAttrValue(this.p11Object, 258);
    }

    public Date getStartDate() {
        return null;
    }

    public Date getEndDate() {
        return null;
    }

    public Boolean getDerive() {
        return (Boolean)this.getAttrValue(this.p11Object, 268);
    }

    public Boolean getLocal() {
        return (Boolean)this.getAttrValue(this.p11Object, 355);
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            rtn = null;
        }
        return rtn;
    }

    protected void finalize() {
    }
}

