/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.DSAParameterGenerator;
import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAKeyPairParameterSpec;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Set;

public final class DSAPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private Provider provider = null;
    private int keySize = 512;
    private PKCS11Session session = null;
    private Config config = null;
    private byte[] id = null;
    private byte[] subject = null;
    private String label = null;
    private Boolean isToken = new Boolean(false);
    private Boolean isSensitive = new Boolean(false);
    private Boolean extractable = null;
    private DSAParameterSpec dsaparams = null;
    private boolean paramsUsed = false;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DSAPKCS11KeyPairGenerator";

    public DSAPKCS11KeyPairGenerator(Provider provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPKCS11KeyPairGenerator", (Object)"Provider");
        }
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.provider = provider;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPKCS11KeyPairGenerator", (Object)"Provider");
        }
    }

    public DSAPKCS11KeyPairGenerator() {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)params, (Object)random);
        }
        if (params == null || !(params instanceof PKCS11DSAKeyPairParameterSpec)) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "initialize", "PKCS11 DSA KeyPair Parameters must be specified");
            }
            throw new InvalidAlgorithmParameterException("PKCS11 DSA KeyPair Parameters must be specified");
        }
        PKCS11DSAKeyPairParameterSpec spec = (PKCS11DSAKeyPairParameterSpec)params;
        this.keySize = spec.getKeySize();
        if (spec.getKeyID() != null) {
            try {
                this.id = spec.getKeyID().getBytes("8859_1");
            }
            catch (Exception e) {
                this.id = spec.getKeyID().getBytes();
            }
        }
        if (spec.getSubject() != null) {
            try {
                this.subject = spec.getSubject().getBytes("8859_1");
            }
            catch (Exception e) {
                this.subject = spec.getSubject().getBytes();
            }
        }
        this.label = spec.getLabel();
        this.isSensitive = spec.getSensitive();
        this.isToken = spec.getToken();
        this.extractable = spec.getExtractable();
        this.dsaparams = (DSAParameterSpec)spec.getParams();
        this.paramsUsed = true;
        if (this.dsaparams == null) {
            this.generateParameters();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int strength, SecureRandom random) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + strength), (Object)random);
        }
        if (strength < 512) {
            throw new InvalidParameterException("DSA Key size must be at least 512 bit");
        }
        if (strength > 1024 || (strength & 0x3F) != 0) {
            throw new InvalidParameterException("Key size must be a multiple of 64 and at most 1024 bit");
        }
        this.keySize = strength;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int strength) {
        this.initialize(strength, null);
    }

    public KeyPair generateKeyPair() {
        KeyPair pair;
        block46: {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "generateKeyPair");
            }
            PKCS11Object[] objs = null;
            pair = null;
            DSAPublicKey pubKey = null;
            DSAPrivateKey privKey = null;
            int sizePubArray = 8;
            int sizePrivArray = 7;
            int count = 0;
            HashMap<Integer, Object> hattrs = null;
            Set<Integer> keys = null;
            Boolean isTokenPub = this.isToken;
            Boolean isTokenPriv = this.isToken;
            if (this.dsaparams == null) {
                this.generateParameters();
            }
            if (this.isSensitive == null) {
                --sizePrivArray;
            }
            if (isTokenPub == null) {
                --sizePubArray;
            }
            if (isTokenPriv == null) {
                --sizePrivArray;
            }
            if (this.extractable == null) {
                --sizePrivArray;
            }
            if (this.config != null) {
                hattrs = this.config.getAttributes("GENERATE", PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA);
                keys = hattrs.keySet();
                block16: for (Integer key : keys) {
                    switch (key) {
                        case 1: {
                            if (this.paramsUsed) continue block16;
                            if (isTokenPub == null) {
                                ++sizePubArray;
                            }
                            isTokenPub = (Boolean)hattrs.get(key);
                            continue block16;
                        }
                        case 266: {
                            continue block16;
                        }
                    }
                    ++sizePubArray;
                }
            }
            int[] pubTypes = new int[sizePubArray];
            Object[] pubValues = new Object[sizePubArray];
            boolean verify = true;
            if (isTokenPub != null) {
                pubTypes[count] = 1;
                pubValues[count++] = isTokenPub;
            }
            pubTypes[count] = 258;
            pubValues[count++] = this.id;
            pubTypes[count] = 257;
            pubValues[count++] = this.subject;
            pubTypes[count] = 3;
            pubValues[count++] = this.label;
            if (keys != null) {
                for (Integer key : keys) {
                    if (key == 1) continue;
                    if (key == 266) {
                        verify = false;
                    }
                    pubTypes[count] = key;
                    pubValues[count++] = hattrs.get(key);
                }
            }
            if (verify) {
                pubTypes[count] = 266;
                pubValues[count++] = Boolean.TRUE;
            }
            pubTypes[count] = 304;
            pubValues[count++] = this.dsaparams.getP();
            pubTypes[count] = 305;
            pubValues[count++] = this.dsaparams.getQ();
            pubTypes[count] = 306;
            pubValues[count] = this.dsaparams.getG();
            if (this.config != null) {
                hattrs = this.config.getAttributes("GENERATE", PKCS11Object.PRIVATE_KEY, PKCS11Object.DSA);
                keys = hattrs.keySet();
                block18: for (Integer key : keys) {
                    switch (key) {
                        case 1: {
                            if (this.paramsUsed) continue block18;
                            if (isTokenPriv == null) {
                                ++sizePrivArray;
                            }
                            isTokenPriv = (Boolean)hattrs.get(key);
                            continue block18;
                        }
                        case 259: {
                            if (this.paramsUsed) continue block18;
                            if (this.isSensitive == null) {
                                ++sizePrivArray;
                            }
                            this.isSensitive = (Boolean)hattrs.get(key);
                            continue block18;
                        }
                        case 354: {
                            if (this.paramsUsed) continue block18;
                            if (this.extractable == null) {
                                ++sizePrivArray;
                            }
                            this.extractable = (Boolean)hattrs.get(key);
                            continue block18;
                        }
                        case 264: {
                            continue block18;
                        }
                    }
                    ++sizePrivArray;
                }
            }
            int[] privTypes = new int[sizePrivArray];
            Object[] privValues = new Object[sizePrivArray];
            count = 0;
            boolean sign = true;
            if (isTokenPriv != null) {
                privTypes[count] = 1;
                privValues[count++] = isTokenPriv;
            }
            privTypes[count] = 258;
            privValues[count++] = this.id;
            privTypes[count] = 257;
            privValues[count++] = this.subject;
            privTypes[count] = 3;
            privValues[count++] = this.label;
            if (this.isSensitive != null) {
                privTypes[count] = 259;
                privValues[count++] = this.isSensitive;
            }
            if (this.extractable != null) {
                privTypes[count] = 354;
                privValues[count++] = this.extractable;
            }
            if (keys != null) {
                for (Integer key : keys) {
                    if (key == 1 || key == 259 || key == 354) continue;
                    if (key == 264) {
                        sign = false;
                    }
                    privTypes[count] = key;
                    privValues[count++] = hattrs.get(key);
                }
            }
            if (sign) {
                privTypes[count] = 264;
                privValues[count++] = Boolean.TRUE;
            }
            try {
                objs = this.session.generateKeyPair(16, null, pubTypes, pubValues, privTypes, privValues);
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "generateKeyPair_1", (Throwable)e);
                }
                throw new RuntimeException(e.getMessage());
            }
            PKCS11Object[] returnobjs = this.orderObjects(objs);
            PKCS11Object pubObj = returnobjs[0];
            PKCS11Object privObj = returnobjs[1];
            try {
                pubKey = new DSAPublicKey(this.session, pubObj, this.id, this.subject, this.label, this.isToken, (BigInteger)this.getValue(pubObj, 304), (BigInteger)this.getValue(pubObj, 305), (BigInteger)this.getValue(pubObj, 306), new BigInteger(1, (byte[])this.getValue(pubObj, 17)));
                if (this.isSensitive.booleanValue()) {
                    privKey = new DSAPrivateKey(this.session, privObj, this.label, this.id, this.subject, this.isToken, this.isSensitive, this.extractable);
                } else {
                    try {
                        privKey = new DSAPrivateKey(this.session, privObj, this.label, this.id, this.subject, this.isToken, this.isSensitive, this.extractable, (BigInteger)this.getValue(privObj, 304), (BigInteger)this.getValue(privObj, 305), (BigInteger)this.getValue(privObj, 306), new BigInteger(1, (byte[])this.getValue(privObj, 17)));
                    }
                    catch (Exception ex) {
                        privKey = new DSAPrivateKey(this.session, privObj, this.label, this.id, this.subject, this.isToken, this.isSensitive, this.extractable);
                    }
                }
                pair = new KeyPair(pubKey, privKey);
            }
            catch (Exception e) {
                pair = null;
                if (debug == null) break block46;
                debug.exception(16384L, (Object)className, "generateKeyPair_2", (Throwable)e);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateKeyPair");
        }
        return pair;
    }

    private void generateParameters() {
        SecureRandom rnd;
        AlgorithmParameterGenerator gen;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generateParameters");
        }
        switch (this.keySize) {
            case 512: {
                this.dsaparams = new DSAParameterSpec(DSAParameterGenerator.p_512, DSAParameterGenerator.q_512, DSAParameterGenerator.g_512);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "generateParameters", (Object)this.dsaparams);
                }
                return;
            }
            case 768: {
                this.dsaparams = new DSAParameterSpec(DSAParameterGenerator.p_768, DSAParameterGenerator.q_768, DSAParameterGenerator.g_768);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "generateParameters", (Object)this.dsaparams);
                }
                return;
            }
            case 1024: {
                this.dsaparams = new DSAParameterSpec(DSAParameterGenerator.p_1024, DSAParameterGenerator.q_1024, DSAParameterGenerator.g_1024);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "generateParameters", (Object)this.dsaparams);
                }
                return;
            }
        }
        try {
            gen = AlgorithmParameterGenerator.getInstance("DSA", this.provider);
            rnd = SecureRandom.getInstance("IBMSecureRandom", this.provider);
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateParameters_1", (Throwable)e);
            }
            throw new RuntimeException(e.getMessage());
        }
        gen.init(this.keySize, rnd);
        AlgorithmParameters algParams = gen.generateParameters();
        try {
            this.dsaparams = algParams.getParameterSpec(DSAParameterSpec.class);
        }
        catch (InvalidParameterSpecException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateParameters_3", (Throwable)e);
            }
            throw new Error();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateParameters");
        }
    }

    private PKCS11Object[] orderObjects(PKCS11Object[] objs) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "orderObjects");
        }
        Integer objsType0 = (Integer)this.getValue(objs[0], 0);
        Integer objsType1 = (Integer)this.getValue(objs[1], 0);
        PKCS11Object privObj = null;
        PKCS11Object pubObj = null;
        if (objsType0.equals(PKCS11Object.PUBLIC_KEY) && objsType1.equals(PKCS11Object.PRIVATE_KEY)) {
            pubObj = objs[0];
            privObj = objs[1];
        } else if (objsType0.equals(PKCS11Object.PRIVATE_KEY) && objsType1.equals(PKCS11Object.PUBLIC_KEY)) {
            pubObj = objs[1];
            privObj = objs[0];
        } else {
            if (debug != null) {
                debug.text(16384L, (Object)className, "orderObjects", "Token returns invalid objects");
            }
            throw new RuntimeException("Token returns invalid objects");
        }
        objs[0] = pubObj;
        objs[1] = privObj;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "orderObjects");
        }
        return objs;
    }

    private Object getValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }
}

