/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.util.Date;

public final class GeneralKey
implements GeneralPKCS11Key,
Serializable {
    private static final long serialVersionUID = 3617574881836020272L;
    private PKCS11Object object = null;
    private PKCS11Session session = null;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private Boolean isSensitive = null;
    private Boolean isEncrypt = null;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private Boolean isVerify = null;
    private Boolean isWrap = null;
    private Boolean isUnwrap = null;
    private Boolean isExtractable = null;
    private Boolean isAlwaysSensitive = null;
    private Boolean isNeverExtractable = null;
    private int keySize;
    private byte[] value = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.GeneralKey";
    KeyMechanismBuilder mechanismBuilder;

    GeneralKey(PKCS11Session session, PKCS11Object object, String algorithm) throws InvalidKeyException {
        this.mechanismBuilder = MechanismBuilderImpl.createKeyMechanismBuilder(algorithm);
        Integer keyType = this.mechanismBuilder.getKeyType();
        this.session = session;
        this.object = object;
        this.ID = (byte[])this.getAttrValue(this.object, 258);
        this.label = (String)this.getAttrValue(this.object, 3);
        this.isToken = (Boolean)this.getAttrValue(this.object, 1);
        this.isSensitive = (Boolean)this.getAttrValue(this.object, 259);
        this.isEncrypt = (Boolean)this.getAttrValue(this.object, 260);
        this.isWrap = (Boolean)this.getAttrValue(this.object, 262);
        this.isExtractable = (Boolean)this.getAttrValue(this.object, 354);
        Integer intKeySize = (Integer)this.getAttrValue(this.object, 353);
        if (intKeySize != null) {
            this.keySize = intKeySize;
        }
        this.isPrivate = (Boolean)this.getAttrValue(this.object, 2);
        this.isModifiable = (Boolean)this.getAttrValue(this.object, 368);
        this.startDate = (Date)this.getAttrValue(this.object, 272);
        this.endDate = (Date)this.getAttrValue(this.object, 273);
        this.isDerive = (Boolean)this.getAttrValue(this.object, 268);
        this.isLocal = (Boolean)this.getAttrValue(this.object, 355);
        this.isDecrypt = (Boolean)this.getAttrValue(this.object, 261);
        this.isVerify = (Boolean)this.getAttrValue(this.object, 266);
        this.isUnwrap = (Boolean)this.getAttrValue(this.object, 263);
        this.isAlwaysSensitive = (Boolean)this.getAttrValue(this.object, 357);
        this.isNeverExtractable = (Boolean)this.getAttrValue(this.object, 356);
        if (this.isSensitive != null && !this.isSensitive.booleanValue()) {
            byte[] tempValue = (byte[])this.getAttrValue(this.object, 17);
            this.value = new byte[tempValue.length];
            System.arraycopy(tempValue, 0, this.value, 0, tempValue.length);
        }
    }

    public byte[] getEncoded() {
        if (this.value != null) {
            return (byte[])this.value.clone();
        }
        return null;
    }

    public int getValueLen() {
        return this.keySize;
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public Boolean getToken() {
        if (this.isToken != null) {
            return new Boolean(this.isToken);
        }
        return null;
    }

    public void rm() {
        if (this.object != null) {
            try {
                this.getObject().destroy();
                this.object = null;
            }
            catch (PKCS11Exception pKCS11Exception) {
                // empty catch block
            }
        }
    }

    public Boolean getPrivate() {
        if (this.isPrivate != null) {
            return new Boolean(this.isPrivate);
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getModifiable() {
        if (this.isModifiable != null) {
            return new Boolean(this.isModifiable);
        }
        return null;
    }

    public Integer getKeyType() {
        return this.mechanismBuilder.getKeyType();
    }

    public byte[] getID() {
        if (this.ID != null) {
            return (byte[])this.ID.clone();
        }
        return null;
    }

    public Date getStartDate() {
        if (this.startDate != null) {
            return (Date)this.startDate.clone();
        }
        return null;
    }

    public Date getEndDate() {
        if (this.endDate != null) {
            return (Date)this.endDate.clone();
        }
        return null;
    }

    public Boolean getDerive() {
        if (this.isDerive != null) {
            return new Boolean(this.isDerive);
        }
        return null;
    }

    public Boolean getLocal() {
        if (this.isLocal != null) {
            return new Boolean(this.isLocal);
        }
        return null;
    }

    public Boolean getSensitive() {
        if (this.isSensitive != null) {
            return new Boolean(this.isSensitive);
        }
        return null;
    }

    public Boolean getEncrypt() {
        if (this.isEncrypt != null) {
            return new Boolean(this.isEncrypt);
        }
        return null;
    }

    public Boolean getDecrypt() {
        if (this.isDecrypt != null) {
            return new Boolean(this.isDecrypt);
        }
        return null;
    }

    public Boolean getSign() {
        if (this.isSign != null) {
            return new Boolean(this.isSign);
        }
        return null;
    }

    public Boolean getVerify() {
        if (this.isVerify != null) {
            return new Boolean(this.isVerify);
        }
        return null;
    }

    public Boolean getWrap() {
        if (this.isWrap != null) {
            return new Boolean(this.isWrap);
        }
        return null;
    }

    public Boolean getUnwrap() {
        if (this.isUnwrap != null) {
            return new Boolean(this.isUnwrap);
        }
        return null;
    }

    public Boolean getExtractable() {
        if (this.isExtractable != null) {
            return new Boolean(this.isExtractable);
        }
        return null;
    }

    public Boolean getAlwaysSensitive() {
        if (this.isAlwaysSensitive != null) {
            return new Boolean(this.isAlwaysSensitive);
        }
        return null;
    }

    public Boolean getNeverExtractable() {
        if (this.isNeverExtractable != null) {
            return new Boolean(this.isNeverExtractable);
        }
        return null;
    }

    public byte[] getValue() {
        return this.value;
    }

    public int getKeySizeInBytes() {
        return this.keySize;
    }

    public PKCS11Session getSession() {
        return this.session;
    }

    public String toString() {
        String prov = "IBMPKCS11Impl";
        String output = prov + " General Key: ";
        if (this.isToken != null) {
            output = output + "\n Token: " + this.isToken;
        }
        if (this.isPrivate != null) {
            output = output + "\n Private: " + this.isPrivate;
        }
        if (this.label != null) {
            output = output + "\n Label: " + this.label;
        }
        if (this.isModifiable != null) {
            output = output + "\n Modifiable: " + this.isModifiable;
        }
        output = output + "\n KeyType: " + this.mechanismBuilder.getAlgorithm();
        if (this.ID != null) {
            output = output + "\n ID: " + new String(this.ID);
        }
        if (this.startDate != null) {
            output = output + "\n Start Date: " + this.startDate.toString();
        }
        if (this.endDate != null) {
            output = output + "\n End Date: " + this.endDate.toString();
        }
        if (this.isDerive != null) {
            output = output + "\n Derive: " + this.isDerive;
        }
        if (this.isLocal != null) {
            output = output + "\n Local: " + this.isLocal;
        }
        if (this.isSensitive != null) {
            output = output + "\n Sensitive: " + this.isSensitive;
        }
        if (this.isEncrypt != null) {
            output = output + "\n Encrypt: " + this.isEncrypt;
        }
        if (this.isDecrypt != null) {
            output = output + "\n Decrypt: " + this.isDecrypt;
        }
        if (this.isSign != null) {
            output = output + "\n Sign: " + this.isSign;
        }
        if (this.isVerify != null) {
            output = output + "\n Verify: " + this.isVerify;
        }
        if (this.isWrap != null) {
            output = output + "\n Wrap: " + this.isWrap;
        }
        if (this.isUnwrap != null) {
            output = output + "\n Unwrap: " + this.isUnwrap;
        }
        if (this.isExtractable != null) {
            output = output + "\n Extractable: " + this.isExtractable;
        }
        if (this.isAlwaysSensitive != null) {
            output = output + "\n Always Sensitive: " + this.isAlwaysSensitive;
        }
        if (this.isNeverExtractable != null) {
            output = output + "\n Never Extractable: " + this.isNeverExtractable;
        }
        if (this.value != null) {
            output = output + "\n value: " + this.value.toString();
        }
        output = output + "\n keySize in bytes: " + this.keySize;
        return output;
    }

    public String getFormat() {
        return "PKCS#11";
    }

    public String getAlgorithm() {
        return this.mechanismBuilder.getAlgorithm();
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }

    protected void finalize() {
    }
}

