/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class GeneralPKCS11Parameters
extends AlgorithmParametersSpi {
    private byte[] iv;

    public GeneralPKCS11Parameters(Provider provider, String alg) {
    }

    protected void engineInit(AlgorithmParameterSpec parmSpec) throws InvalidParameterSpecException {
        if (!(parmSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("Parameter specification must be IvParameterSpec.");
        }
        byte[] iv = ((IvParameterSpec)parmSpec).getIV();
        this.iv = (byte[])iv.clone();
    }

    protected void engineInit(byte[] encoded) throws IOException {
        DerInputStream der = null;
        try {
            der = new DerInputStream(encoded);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException(e.getMessage());
        }
        byte[] tmpIv = der.getOctetString();
        if (der.available() != 0) {
            throw new IOException("IV parsing error: extra data");
        }
        this.iv = tmpIv;
    }

    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        this.engineInit(encoded);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class parmSpec) throws InvalidParameterSpecException {
        try {
            Class<?> ivParmSpec = Class.forName("javax.crypto.spec.IvParameterSpec");
            if (ivParmSpec.isAssignableFrom(parmSpec)) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("Parameter specification must be IvParameterSpec.");
        }
        catch (ClassNotFoundException e) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        out.putOctetString(this.iv);
        return out.toByteArray();
    }

    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        String ivString = "\n    iv:\n[";
        HexDumpEncoder encoder = new HexDumpEncoder();
        ivString = ivString + encoder.encodeBuffer(this.iv);
        ivString = ivString + "]\n";
        return ivString;
    }
}

