/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

final class GeneralSignature
extends SignatureSpi {
    private Signature sig;
    private int mechanism = 0;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.GeneralSignature";

    public GeneralSignature(Provider provider, String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralSignature");
        }
        if (algorithm.equalsIgnoreCase("MD2withRSA")) {
            this.mechanism = 4;
        } else if (algorithm.equalsIgnoreCase("MD5withRSA")) {
            this.mechanism = 5;
        } else if (algorithm.equalsIgnoreCase("SHA1withRSA")) {
            this.mechanism = 6;
        } else if (algorithm.equalsIgnoreCase("SHA256withRSA")) {
            this.mechanism = 64;
        } else if (algorithm.equalsIgnoreCase("SHA384withRSA")) {
            this.mechanism = 65;
        } else if (algorithm.equalsIgnoreCase("SHA512withRSA")) {
            this.mechanism = 66;
        } else if (algorithm.equalsIgnoreCase("SHA1withDSA")) {
            this.mechanism = 18;
        } else {
            System.out.println("Algo = " + algorithm);
        }
        this.sig = new Signature(this.mechanism, provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "GeneralSignature");
        }
    }

    protected void engineSetParameter(String key, Object param) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetParameter");
            debug.exit(16384L, (Object)className, "engineSetParameter");
        }
    }

    protected Object engineGetParameter(String key) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetParameter", (Object)key);
            debug.exit(16384L, (Object)className, "engineGetParameter");
        }
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            String keyString = privateKey.toString();
            debug.entry(16384L, (Object)className, "engineInitSign", (Object)keyString);
        }
        this.sig.engineInitSign(privateKey);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitSign");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            String keyString = publicKey.toString();
            debug.entry(16384L, (Object)className, "engineInitVerify", (Object)keyString);
        }
        this.sig.engineInitVerify(publicKey);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitVerify");
        }
    }

    protected void engineUpdate(byte b) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate", (Object)b);
        }
        byte[] onebyte = new byte[]{b};
        this.sig.engineUpdate(onebyte, 0, 1);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected void engineUpdate(byte[] data, int off, int len) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate", (Object)data, (Object)new Integer(len));
        }
        this.sig.engineUpdate(data, off, len);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign");
        }
        byte[] signature = this.sig.engineSign();
        if (this.mechanism == 18) {
            try {
                byte[] r = new byte[20];
                byte[] s = new byte[20];
                System.arraycopy(signature, 0, r, 0, 20);
                System.arraycopy(signature, 20, s, 0, signature.length - 20);
                DerOutputStream out = new DerOutputStream(100);
                out.putInteger(new BigInteger(1, r));
                out.putInteger(new BigInteger(1, s));
                DerValue result = new DerValue(48, out.toByteArray());
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSign", "Signature = " + new HexDumpEncoder().encode(signature));
                    debug.text(16384L, (Object)className, "engineSign", "Encoded Sign len = " + result.toByteArray().length);
                    debug.text(16384L, (Object)className, "engineSign", "Sign len = " + signature.length);
                    debug.exit(16384L, (Object)className, "engineSign");
                }
                return result.toByteArray();
            }
            catch (IOException e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineSign", (Throwable)e);
                    debug.exit(16384L, (Object)className, "engineSign");
                }
                throw new SignatureException("error encoding signature");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSign");
        }
        return signature;
    }

    protected boolean engineVerify(byte[] signature) throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineVerify", (Object)signature);
            debug.exit(16384L, (Object)className, "engineVerify");
        }
        return this.sig.engineVerify(signature);
    }
}

