/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.module.PKCS11Principal;
import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.JarVerifier;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.SupportedServices;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Mechanism;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.pkcs11.PKCS11Slot;
import com.ibm.pkcs11.nat.NativePKCS11;
import com.ibm.security.bootstrap.DSAPublicKeyImpl;
import com.ibm.security.bootstrap.RSAPublicKeyImpl;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.AuthProvider;
import java.security.CodeSource;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.SecurityPermission;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.prefs.Preferences;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public final class IBMPKCS11Impl
extends AuthProvider {
    private static String info = "IBMPKCS11Impl Provider implements the following:\nSignature algorithms               : SHA1withDSA, SHA1withRSA, MD5withRSA, MD2withRSA \nCipher algorithms                  : AES, DES, TripleDES, Blowfish, RC4, RSA,\nKey (pair) generator               : DH, DSA, RSA, AES, Blowfish, RC4, DES, TripleDES\nMessage digest                     : MD2, MD5, SHA-1, SHA256, SHA384, SHA512\nAlgorithm parameter generator      : DH, DSA\nAlgorithm parameter                : DSA, DES, TripleDES\nKey factory                        : DH, DSA, RSA\nSecret key factory                 : AES, Blowfish, RC4, DES, TripleDES\nKey Agreement                      : DH\nCertificate                        : X.509\nSecure random                      : PKCS11DeviceRNG (IBMSecureRandom)\nKey store                          : PKCS11IMPLKS\n";
    static final boolean debug2 = false;
    private static boolean verifiedJce = false;
    private static boolean verifiedSelfIntegrity = false;
    private static X509Certificate[] trustedCaCerts = null;
    protected PKCS11Session session = null;
    private PKCS11Slot tokenSlot = null;
    private PKCS11 pkcs11 = null;
    private Config config = null;
    private static String providerName = "IBMPKCS11Impl";
    private static double providerVer = 1.5;
    private CallbackHandler callbackHand = null;
    private static HashMap<String, PKCS11> LIBS = new HashMap();
    private static final byte[][] bytesOfTrustedCaCerts = new byte[][]{{48, -126, 3, 79, 48, -126, 3, 13, -96, 3, 2, 1, 2, 2, 4, 57, 36, -91, 85, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 48, 96, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 24, 48, 22, 6, 3, 85, 4, 10, 19, 15, 73, 66, 77, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 73, 66, 77, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, 30, 23, 13, 48, 48, 48, 53, 49, 57, 48, 50, 50, 50, 49, 51, 90, 23, 13, 48, 54, 48, 53, 49, 56, 48, 50, 50, 50, 49, 51, 90, 48, 96, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 24, 48, 22, 6, 3, 85, 4, 10, 19, 15, 73, 66, 77, 32, 67, 111, 114, 112, 111, 114, 97, 116, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 11, 19, 16, 73, 66, 77, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, -126, 1, -72, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, 21, 0, -105, 96, 80, -113, 21, 35, 11, -52, -78, -110, -71, -126, -94, -21, -124, 11, -16, 88, 28, -11, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 3, -127, -123, 0, 2, -127, -127, 0, -22, 107, 0, -57, -33, 16, 59, -71, 116, 53, -89, -31, 109, 102, -126, 77, -9, 91, 86, 113, -62, 38, 69, 39, 114, 61, 81, 16, 98, -1, -77, -36, 16, -55, -5, 81, 19, -44, -83, -117, -88, 37, 110, 93, -55, 120, -46, 91, 39, -45, 19, 65, 71, 20, 6, 124, -53, -126, 56, 94, -58, 11, 97, -96, 76, -125, 45, -108, -52, -116, 46, -124, -112, 58, -113, 66, 10, 105, 82, -45, 116, 38, 119, -92, 20, 125, 42, 113, 65, -120, -119, 119, -90, 45, 98, -102, -95, 88, -104, 109, 108, -49, -50, -88, -22, -70, -35, -24, -95, 16, 68, -116, -124, 66, -63, -72, 31, 43, -76, -68, -77, 93, 116, 96, -128, -115, 66, 84, -93, 83, 48, 81, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 126, 61, 77, 77, -52, 16, 89, -70, -7, -82, 66, 61, -27, -55, 87, 90, 82, 11, 126, -121, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 126, 61, 77, 77, -52, 16, 89, -70, -7, -82, 66, 61, -27, -55, 87, 90, 82, 11, 126, -121, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 3, 47, 0, 48, 44, 2, 20, 28, -17, -10, -64, 92, -19, -109, 112, 34, -31, 75, -55, 15, -16, -99, 122, 9, -18, -122, -122, 2, 20, 18, 119, 71, 98, -62, -97, 25, 97, -36, 41, -6, -71, 73, -91, 25, -42, -91, -68, 69, 77}, {48, -126, 3, -64, 48, -126, 3, 126, -96, 3, 2, 1, 2, 2, 1, 1, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 48, -127, -112, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 11, 48, 9, 6, 3, 85, 4, 8, 19, 2, 67, 65, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 80, 97, 108, 111, 32, 65, 108, 116, 111, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 49, 35, 48, 33, 6, 3, 85, 4, 11, 19, 26, 74, 97, 118, 97, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, 30, 23, 13, 48, 48, 48, 52, 49, 50, 48, 55, 48, 48, 48, 48, 90, 23, 13, 48, 54, 48, 52, 49, 50, 48, 55, 48, 48, 48, 48, 90, 48, -127, -112, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 11, 48, 9, 6, 3, 85, 4, 8, 19, 2, 67, 65, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 80, 97, 108, 111, 32, 65, 108, 116, 111, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 83, 117, 110, 32, 77, 105, 99, 114, 111, 115, 121, 115, 116, 101, 109, 115, 32, 73, 110, 99, 49, 35, 48, 33, 6, 3, 85, 4, 11, 19, 26, 74, 97, 118, 97, 32, 83, 111, 102, 116, 119, 97, 114, 101, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 49, 28, 48, 26, 6, 3, 85, 4, 3, 19, 19, 74, 67, 69, 32, 67, 111, 100, 101, 32, 83, 105, 103, 110, 105, 110, 103, 32, 67, 65, 48, -126, 1, -73, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -21, -81, 55, 4, 30, -54, 81, 30, 105, 93, -80, -14, -113, -10, -75, 73, 31, -58, -92, -103, 5, -41, 41, -65, 116, -73, 106, -11, 25, -40, 30, -28, 27, -8, 10, 1, -102, -104, -1, 112, -85, -30, 74, 86, -122, 108, 83, -77, -4, -31, -56, -127, -116, 49, -16, -60, -13, -80, -117, -26, 112, 6, -20, -9, 105, 104, -37, -125, 76, 114, 41, -119, 41, 54, 23, 92, 59, 74, 7, -96, 32, 2, 42, 70, -105, 81, 29, 112, -56, 8, 24, 11, -50, 12, 110, -101, 118, -9, 5, -29, -25, -5, -45, 97, 121, -31, 96, -102, 36, -115, 6, -107, -125, 60, 81, 32, -31, 48, -49, 56, 87, -126, -90, 26, 114, 13, -50, -45, 2, 21, 0, -124, 37, 69, -31, -70, -71, -87, 98, -85, 121, -24, 91, 48, -72, -119, 107, 27, -1, 123, 117, 2, -127, -127, 0, -85, -55, 116, 123, 116, -17, -18, 66, -75, 106, 83, 77, 59, -35, -112, 6, 114, 104, -111, 15, 11, -92, 41, 118, 46, 85, 59, -43, -82, 77, 101, 92, 126, 42, 58, 4, -90, 103, -90, -48, 113, -86, -91, -41, -73, -30, -63, 114, 13, -92, -47, -86, 30, -110, 84, 76, 32, 0, 9, -94, -80, 9, 65, 25, 51, 0, -78, -61, 92, -82, 66, -8, -79, -117, -54, 124, -106, -40, 16, 127, 55, 68, 91, -86, -52, 120, -56, -41, 114, 118, 55, 107, 64, -103, -88, 85, 102, -6, -88, 3, 30, -117, 74, 17, 2, 105, -53, 76, -72, 37, 6, 28, -96, 119, -46, -55, -84, -46, 61, -23, 10, 16, -6, 118, 112, -73, -5, -36, 3, -127, -124, 0, 2, -127, -128, 45, 9, -104, 92, -84, -72, -100, -57, -103, 126, -18, 32, 25, 42, 52, -112, -7, -41, -85, -85, -82, -35, 107, 114, -107, 13, 102, -8, -17, 39, -113, 68, -78, -19, 40, 68, -57, -2, -81, -80, -90, 39, 111, 0, 103, 69, -126, 91, 7, -88, 86, 86, 59, -46, 41, 81, 97, 94, 105, 57, -41, 46, 116, 119, 18, -49, 25, 74, -11, 45, -56, -53, 114, 97, -60, 78, 111, -6, 71, 67, 63, 20, -69, -6, -68, 24, 102, 40, -62, -39, 102, -117, 122, 45, 47, -62, 96, -110, 75, 20, -2, 88, 62, 33, 127, 104, 98, -66, 108, 72, 73, -7, -96, 75, 94, -123, -99, 25, 16, -7, 21, 69, 81, 27, 113, -44, -9, 11, -93, 102, 48, 100, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 0, 7, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 101, -30, -12, -122, -55, -45, 78, -16, -111, 78, 88, -94, 106, -11, -40, 120, 90, -102, -63, -90, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 101, -30, -12, -122, -55, -45, 78, -16, -111, 78, 88, -94, 106, -11, -40, 120, 90, -102, -63, -90, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 3, 47, 0, 48, 44, 2, 20, 36, -97, 2, -61, -5, 49, -43, -111, 59, -7, 126, 86, 111, -106, -33, 100, 10, 4, -104, -76, 2, 20, 110, 121, -124, -89, -18, 104, -93, 2, 114, 49, 99, -37, 67, -85, 8, -20, 77, -17, 22, 58}};
    static final long serialVersionUID = -7311315630492398086L;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl";

    public IBMPKCS11Impl() {
        super(providerName, providerVer, info);
        if (debug != null) {
            System.out.println("new IBMPKCS11Impl instance");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                IBMPKCS11Impl.this.put("Alg.Alias.Signature.DONTUSETHIS", "IBMPKCS11Impl");
                return null;
            }
        });
        this.session = null;
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String dllName = prefs.get("IBMPKCSImpl DLL", null);
        String password = prefs.get("IBMPKCSImpl password", null);
        try {
            if (dllName == null) {
                this.Init(null, null);
            } else {
                char[] pswd = null;
                if (password != null) {
                    pswd = new char[password.length()];
                    password.getChars(0, password.length(), pswd, 0);
                }
                this.Init(dllName, pswd);
                for (int i = 0; i < pswd.length; ++i) {
                    pswd[i] = '\u0000';
                }
            }
        }
        catch (IOException e) {
            throw new PKCS11Exception(e.getMessage());
        }
    }

    public IBMPKCS11Impl(String fullFileName) throws Exception {
        super(providerName + Config.getProviderNameSuffix(fullFileName), providerVer, Config.getDescription(fullFileName));
        if (debug != null) {
            System.out.println("new IBMPKCS11Impl instance");
        }
        this.session = null;
        try {
            File configFile;
            this.Init(fullFileName, null);
            if (debug != null && (configFile = new File(fullFileName)).canRead()) {
                int c;
                debug.text(16384L, (Object)className, "IBMPKCS11Impl", "path and config file name: " + fullFileName);
                FileReader fileRead = new FileReader(configFile);
                StringWriter out = new StringWriter();
                while ((c = fileRead.read()) != -1) {
                    out.write(c);
                }
                debug.text(16384L, (Object)className, "IBMPKCS11Impl", "file contents:\n" + out.toString());
            }
        }
        catch (IOException e) {
            throw new PKCS11Exception(e.getMessage());
        }
    }

    public IBMPKCS11Impl(BufferedReader in) throws Exception {
        super(providerName + Config.getProviderNameSuffix(in), providerVer, Config.getDescription(in));
        if (debug != null) {
            System.out.println("new IBMPKCS11Impl instance");
        }
        this.session = null;
        try {
            if (debug != null) {
                int c;
                in.reset();
                StringWriter out = new StringWriter();
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                debug.text(16384L, (Object)className, "IBMPKCS11Impl", "file contents:\n" + out.toString());
                in.reset();
            }
            this.Init(in);
        }
        catch (IOException e) {
            throw new PKCS11Exception(e.getMessage());
        }
    }

    protected PKCS11Session getSession() {
        return this.session;
    }

    protected Config getConfig() {
        return this.config;
    }

    public void removeSession() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    public void Init(BufferedReader in) throws IOException {
        PKCS11Slot[] tokenSlots = null;
        Object dllName = null;
        String fileName = null;
        String tokenLabel = null;
        boolean findex = false;
        int slotIndex = 0;
        try {
            this.config = new Config(in);
        }
        catch (Exception e1) {
            throw new IOException("Error parsing config file: " + e1.getMessage());
        }
        fileName = this.config.getLibraryName();
        if (fileName.toLowerCase().endsWith(".dll")) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "Init", "win fileName = " + fileName);
            }
            fileName = fileName.substring(0, fileName.length() - 4);
        } else if (fileName.toLowerCase().endsWith(".so")) {
            File aFile;
            String justFileName;
            if (debug != null) {
                debug.text(16384L, (Object)className, "Init", "Unix fileName = " + fileName);
            }
            if ((justFileName = (aFile = new File(fileName)).getName()) != null && justFileName.toLowerCase().startsWith("lib")) {
                fileName = aFile.getParent() + File.separator + justFileName.substring(3);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "Init", "Unix fileName2 = " + fileName);
            }
            if (fileName.toLowerCase().endsWith(".so")) {
                fileName = fileName.substring(0, fileName.length() - 3);
            }
        }
        tokenLabel = this.config.getTokenLabel();
        if (tokenLabel == null) {
            slotIndex = this.config.getSlotIndex();
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "Init", "fileName = " + fileName);
        }
        try {
            this.pkcs11 = LIBS.get(fileName);
            if (this.pkcs11 == null) {
                this.pkcs11 = new NativePKCS11(fileName);
                this.pkcs11.libInitialize();
                LIBS.put(fileName, this.pkcs11);
            }
        }
        catch (PKCS11Exception ex) {
            throw new IOException("Invalid dll name : " + fileName);
        }
        if (debug != null) {
            System.out.println("P5");
        }
        tokenSlots = this.pkcs11.getSlotList(true);
        if (tokenLabel != null) {
            boolean found = false;
            for (int i = 0; i < tokenSlots.length; ++i) {
                String label = tokenSlots[i].getTokenInfo().label();
                if (!tokenLabel.equals(label)) continue;
                slotIndex = i;
                found = true;
                break;
            }
            if (!found) {
                throw new IOException("Invalid Token Label : " + tokenLabel);
            }
        }
        if (slotIndex < 0 || slotIndex > tokenSlots.length - 1) {
            throw new IOException("Invalid slot number : " + slotIndex);
        }
        this.tokenSlot = tokenSlots[slotIndex];
        if (debug != null) {
            debug.text(16384L, (Object)className, "Init", "Slot Info:" + this.tokenSlot.getInfo().toString());
            debug.text(16384L, (Object)className, "Init", "Token Info:" + this.tokenSlot.getTokenInfo().toString());
        }
        try {
            this.session = this.tokenSlot.openSession(6, null, null);
        }
        catch (PKCS11Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "Init", "Creation of read write session failed:" + e.getMessage());
            }
            if (e.getCode() == 226) {
                this.session = this.tokenSlot.openSession(4, null, null);
            }
            throw new IOException(e.getMessage());
        }
        int[] mechanismList = null;
        if (this.session != null) {
            mechanismList = this.session.getSlot().getMechanismList();
            if (debug != null) {
                ArrayList<String> mechanismNames = new ArrayList<String>();
                for (int i = 0; i < mechanismList.length; ++i) {
                    mechanismNames.add(PKCS11Mechanism.typeToString((int)mechanismList[i]));
                }
                debug.text(16384L, (Object)className, "Init", "Mechanisms: " + mechanismNames.toString());
            }
        }
        final IBMPKCS11Impl pkcs11impl = this;
        if (this.config == null) {
            if (this.session != null) {
                Config conf = new Config((String)null);
                final SupportedServices[] ss = conf.getSupportedServices(mechanismList);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        for (int y = 0; y < ss.length; ++y) {
                            IBMPKCS11Impl.this.putService(new PKCS11ImplService(IBMPKCS11Impl.this.session, pkcs11impl, ss[y].getType(), ss[y].getAlgorithm(), ss[y].getClassName(), ss[y].getAlaises(), ss[y].getMechanism()));
                        }
                        return null;
                    }
                });
            }
        } else {
            final SupportedServices[] ss = this.config.getSupportedServices(mechanismList);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (int y = 0; y < ss.length; ++y) {
                        IBMPKCS11Impl.this.putService(new PKCS11ImplService(IBMPKCS11Impl.this.session, pkcs11impl, ss[y].getType(), ss[y].getAlgorithm(), ss[y].getClassName(), ss[y].getAlaises(), ss[y].getMechanism()));
                    }
                    return null;
                }
            });
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "Init");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void Init(String fullFileName, char[] passwd) throws IOException {
        block73: {
            tokenSlots = null;
            dllName = null;
            fileName = null;
            tokenLabel = null;
            password = passwd;
            findex = 0;
            slotIndex = 0;
            if (IBMPKCS11Impl.debug != null) {
                IBMPKCS11Impl.debug.entry(16384L, (Object)IBMPKCS11Impl.className, "Init", (Object)fullFileName, (Object)passwd);
            }
            if (this.session == null) {
                block75: {
                    if (fullFileName == null) {
                        acc = AccessController.getContext();
                        try {
                            block74: {
                                sub = Subject.getSubject(acc);
                                principal = null;
                                princSet = null;
                                if (sub == null) break block73;
                                try {
                                    cla = Class.forName("com.ibm.crypto.pkcs11impl.module.PKCS11Principal");
                                    princSet = sub.getPrincipals(cla);
                                }
                                catch (Exception e) {
                                    if (IBMPKCS11Impl.debug == null) break block74;
                                    IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Got unexpected exception 1: " + e.getMessage());
                                }
                            }
                            if (princSet.size() != 0) {
                                it = princSet.iterator();
                                principal = (PKCS11Principal)it.next();
                                this.session = principal.getSession();
                            }
                            break block73;
                        }
                        catch (NullPointerException e) {
                            if (IBMPKCS11Impl.debug != null) {
                                IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "ACC is null: " + e.getMessage());
                            }
                            break block73;
                        }
                    }
                    dllName = fullFileName.trim();
                    if (dllName.toLowerCase().indexOf(".dll") >= 0 || dllName.toLowerCase().indexOf(".so") >= 0) {
                        if (dllName.toLowerCase().indexOf(".dll") < 0) {
                            if (IBMPKCS11Impl.debug != null) {
                                System.out.println("a unix lib:" + dllName);
                            }
                            findex = dllName.toLowerCase().indexOf(".so:") + 3;
                            if (IBMPKCS11Impl.debug != null) {
                                System.out.println("findex=" + findex);
                            }
                            if (findex > 2) {
                                fileName = dllName.substring(0, findex);
                                try {
                                    if (IBMPKCS11Impl.debug != null) {
                                        System.out.println("substring=" + dllName.substring(findex + 1, dllName.length()));
                                    }
                                    slotIndex = Integer.valueOf(dllName.substring(findex + 1, dllName.length()));
                                    if (IBMPKCS11Impl.debug == null) ** GOTO lbl70
                                    System.out.println("slotIndex=" + slotIndex);
                                }
                                catch (NumberFormatException nfe) {
                                    if (IBMPKCS11Impl.debug != null) {
                                        nfe.printStackTrace();
                                    }
                                    throw new IOException("Invalid slot number");
                                }
                            } else {
                                findex = dllName.toLowerCase().indexOf(".so64:") + 3;
                                if (findex > 2) {
                                    fileName = dllName.substring(0, findex += 2);
                                    try {
                                        if (IBMPKCS11Impl.debug != null) {
                                            System.out.println("substring=" + dllName.substring(findex + 1, dllName.length()));
                                        }
                                        slotIndex = Integer.valueOf(dllName.substring(findex + 1, dllName.length()));
                                        if (IBMPKCS11Impl.debug == null) ** GOTO lbl70
                                        System.out.println("slotIndex=" + slotIndex);
                                    }
                                    catch (NumberFormatException nfe) {
                                        throw new IOException("Invalid slot number");
                                    }
                                } else {
                                    fileName = dllName;
                                }
                            }
lbl70:
                            // 5 sources

                            aFile = new File(fileName);
                            justFileName = aFile.getName();
                            if (justFileName != null && justFileName.toLowerCase().startsWith("lib")) {
                                fileName = aFile.getParent() + File.separator + justFileName.substring(3);
                            }
                            if (fileName.toLowerCase().endsWith(".so")) {
                                fileName = fileName.substring(0, fileName.length() - 3);
                            }
                        } else {
                            if (IBMPKCS11Impl.debug != null) {
                                System.out.println("P4");
                            }
                            if (IBMPKCS11Impl.debug != null) {
                                IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "dllName: " + dllName);
                            }
                            if ((findex = dllName.toLowerCase().indexOf(".dll:") + 4) > 3) {
                                fileName = dllName.substring(0, findex);
                                if (IBMPKCS11Impl.debug != null) {
                                    IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "fileName: " + fileName);
                                    IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "findex: " + findex);
                                }
                                try {
                                    slotIndex = Integer.valueOf(dllName.substring(findex + 1, dllName.length()));
                                    if (IBMPKCS11Impl.debug == null) ** GOTO lbl94
                                    IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "slotIndex=" + slotIndex);
                                }
                                catch (NumberFormatException nfe) {
                                    throw new IOException("Invalid slot number");
                                }
                            } else {
                                fileName = dllName;
                            }
lbl94:
                            // 3 sources

                            if (fileName.toLowerCase().endsWith(".dll")) {
                                fileName = fileName.substring(0, fileName.length() - 4);
                            }
                        }
                    } else {
                        try {
                            this.config = new Config(fullFileName);
                        }
                        catch (Exception e1) {
                            throw new IOException("Error parsing config file: " + e1.getMessage());
                        }
                        fileName = this.config.getLibraryName();
                        if (fileName.toLowerCase().endsWith(".dll")) {
                            if (IBMPKCS11Impl.debug != null) {
                                IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "win fileName = " + fileName);
                            }
                            fileName = fileName.substring(0, fileName.length() - 4);
                        } else if (fileName.toLowerCase().endsWith(".so")) {
                            if (IBMPKCS11Impl.debug != null) {
                                IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Unix fileName = " + fileName);
                            }
                            if ((justFileName = (aFile = new File(fileName)).getName()) != null && justFileName.toLowerCase().startsWith("lib")) {
                                fileName = aFile.getParent() + File.separator + justFileName.substring(3);
                            }
                            if (IBMPKCS11Impl.debug != null) {
                                IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Unix fileName2 = " + fileName);
                            }
                            if (fileName.toLowerCase().endsWith(".so")) {
                                fileName = fileName.substring(0, fileName.length() - 3);
                            }
                        }
                        tokenLabel = this.config.getTokenLabel();
                        if (tokenLabel == null) {
                            slotIndex = this.config.getSlotIndex();
                        }
                    }
                    if (IBMPKCS11Impl.debug != null) {
                        IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "fileName = " + fileName);
                    }
                    try {
                        this.pkcs11 = IBMPKCS11Impl.LIBS.get(fileName);
                        if (this.pkcs11 == null) {
                            this.pkcs11 = new NativePKCS11(fileName);
                            this.pkcs11.libInitialize();
                            IBMPKCS11Impl.LIBS.put(fileName, this.pkcs11);
                        }
                    }
                    catch (PKCS11Exception ex) {
                        throw new IOException("Invalid dll name : " + fileName);
                    }
                    if (IBMPKCS11Impl.debug != null) {
                        System.out.println("P5");
                    }
                    tokenSlots = this.pkcs11.getSlotList(true);
                    if (tokenLabel != null) {
                        found = false;
                        for (i = 0; i < tokenSlots.length; ++i) {
                            label = tokenSlots[i].getTokenInfo().label();
                            if (!tokenLabel.equals(label)) continue;
                            slotIndex = i;
                            found = true;
                            break;
                        }
                        if (!found) {
                            throw new IOException("Invalid Token Label : " + tokenLabel);
                        }
                    }
                    if (slotIndex < 0 || slotIndex > tokenSlots.length - 1) {
                        throw new IOException("Invalid slot number : " + slotIndex);
                    }
                    this.tokenSlot = tokenSlots[slotIndex];
                    if (IBMPKCS11Impl.debug != null) {
                        IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Slot Info:" + this.tokenSlot.getInfo().toString());
                        IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Token Info:" + this.tokenSlot.getTokenInfo().toString());
                    }
                    try {
                        this.session = this.tokenSlot.openSession(6, null, null);
                        if (this.session == null) {
                            if (IBMPKCS11Impl.debug != null) {
                                IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "HEY Session NULL");
                            }
                            this.session = this.tokenSlot.openSession(4, null, null);
                        }
                        if (IBMPKCS11Impl.debug != null) {
                            IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "HEY open session WORKED");
                        }
                    }
                    catch (PKCS11Exception e) {
                        if (IBMPKCS11Impl.debug != null) {
                            IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Creation of read write session failed:" + e.getMessage());
                        }
                        if (e.getCode() == 226) {
                            this.session = this.tokenSlot.openSession(4, null, null);
                        }
                        throw new IOException(e.getMessage());
                    }
                    catch (Exception ex) {
                        if (IBMPKCS11Impl.debug == null) break block75;
                        IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "************** We got an Exception but not a PKCS11Exception ***************" + ex.getMessage());
                    }
                }
                if (password != null) {
                    this.session.login(false, (Object)new String(password));
                }
            }
        }
        mechanismList = null;
        if (this.session != null) {
            mechanismList = this.session.getSlot().getMechanismList();
            if (IBMPKCS11Impl.debug != null) {
                mechanismNames = new ArrayList<String>();
                for (i = 0; i < mechanismList.length; ++i) {
                    mechanismNames.add(PKCS11Mechanism.typeToString((int)mechanismList[i]));
                }
                IBMPKCS11Impl.debug.text(16384L, (Object)IBMPKCS11Impl.className, "Init", "Mechanisms: " + mechanismNames.toString());
            }
        }
        pkcs11impl = this;
        if (this.config == null) {
            if (this.session != null) {
                conf = new Config((String)null);
                ss = conf.getSupportedServices(mechanismList);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        for (int y = 0; y < ss.length; ++y) {
                            IBMPKCS11Impl.this.putService(new PKCS11ImplService(IBMPKCS11Impl.this.session, pkcs11impl, ss[y].getType(), ss[y].getAlgorithm(), ss[y].getClassName(), ss[y].getAlaises(), ss[y].getMechanism()));
                        }
                        return null;
                    }
                });
            }
        } else {
            ss = this.config.getSupportedServices(mechanismList);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (int y = 0; y < ss.length; ++y) {
                        IBMPKCS11Impl.this.putService(new PKCS11ImplService(IBMPKCS11Impl.this.session, pkcs11impl, ss[y].getType(), ss[y].getAlgorithm(), ss[y].getClassName(), ss[y].getAlaises(), ss[y].getMechanism()));
                    }
                    return null;
                }
            });
        }
        if (IBMPKCS11Impl.debug != null) {
            IBMPKCS11Impl.debug.exit(16384L, (Object)IBMPKCS11Impl.className, "Init");
        }
    }

    public void login(Subject subject, CallbackHandler handler) throws LoginException {
        char[] password;
        SecurityManager secManager;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "login", (Object)subject, (Object)handler);
        }
        if ((secManager = System.getSecurityManager()) != null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "login", "checking login permission");
            }
            secManager.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        CallbackHandler callbackHandler = null;
        callbackHandler = handler == null ? this.getCallbackHandler() : handler;
        Callback[] callbacks = new Callback[]{new PasswordCallback("password: ", false)};
        try {
            callbackHandler.handle(callbacks);
            char[] tmpPassword = ((PasswordCallback)callbacks[0]).getPassword();
            password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[0]).clearPassword();
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "login", (Throwable)e);
            }
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e1) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "login", (Throwable)e1);
            }
            throw new LoginException("Error: " + e1.getCallback().toString() + " not available to get PIN from the user");
        }
        try {
            this.session.login(false, (Object)new String(password));
        }
        catch (PKCS11Exception e) {
            if (e.getCode() == 256) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "login", (Object)"user already logged in");
                }
                return;
            }
            if (debug != null) {
                debug.exception(16384L, (Object)className, "login", (Throwable)e);
            }
            throw new LoginException("PKCS11 error code = " + e.getCode());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "login");
        }
    }

    public void logout() throws LoginException {
        SecurityManager secManager = System.getSecurityManager();
        if (secManager != null) {
            if (debug != null) {
                System.out.println("checking login permission");
            }
            secManager.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        try {
            this.session.logout();
            if (debug != null) {
                System.out.println("logout succeeded");
            }
        }
        catch (PKCS11Exception e) {
            if (e.getCode() == 257) {
                if (debug != null) {
                    System.out.println("user already logged in");
                }
                return;
            }
            throw new LoginException("PKCS11 error code = " + e.getCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallbackHandler(CallbackHandler handler) {
        SecurityManager secManager = System.getSecurityManager();
        if (secManager != null) {
            if (debug != null) {
                System.out.println("checking login permission");
            }
            secManager.checkPermission(new SecurityPermission("authProvider." + this.getName()));
        }
        CallbackHandler callbackHandler = this.callbackHand;
        synchronized (callbackHandler) {
            this.callbackHand = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallbackHandler getCallbackHandler() {
        CallbackHandler callbackHandler = this.callbackHand;
        synchronized (callbackHandler) {
            if (this.callbackHand != null) {
                return this.callbackHand;
            }
            try {
                CallbackHandler handler;
                if (debug != null) {
                    System.out.println("getting default callback handler");
                }
                this.callbackHand = handler = (CallbackHandler)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String handlerName = Security.getProperty("auth.login.defaultCallbackHandler");
                        if (handlerName == null || handlerName.length() == 0) {
                            if (debug != null) {
                                System.out.println("no default handler set");
                            }
                            return null;
                        }
                        Class<?> handlerClass = Class.forName(handlerName, true, Thread.currentThread().getContextClassLoader());
                        return handlerClass.newInstance();
                    }
                });
                return this.callbackHand;
            }
            catch (PrivilegedActionException e) {
                if (debug != null) {
                    System.out.println("Unable to load default callback handler");
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    static final void verifyJceJar() {
        if (verifiedJce) {
            return;
        }
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.compareTo("1.4") >= 0) {
            verifiedJce = true;
            return;
        }
        IBMPKCS11Impl.doVerifyJceJar();
    }

    private static final synchronized void doVerifyJceJar() {
        JarFile jf;
        if (verifiedJce) {
            return;
        }
        URL jceJarURL = null;
        try {
            Class<IBMPKCS11Impl> c = IBMPKCS11Impl.class;
            final ClassLoader cl = c.getClassLoader();
            URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return cl.getResource("javax/crypto/Cipher.class");
                }
            });
            if (url == null) {
                throw new SecurityException("Cannot get the JCE framework URL. Check that IBMPKCS11Impl can read the JCE framework");
            }
            int bang = IBMPKCS11Impl.indexOfBang(url.toString());
            if (bang == -1) {
                throw new SecurityException("The JCE framework is invalid");
            }
            jceJarURL = new URL(url.toString().substring(0, bang + 1));
            int beginIndex = 4;
            URL jceURL = new URL(url.toString().substring(beginIndex, bang - 1));
            if (!jceURL.getProtocol().equalsIgnoreCase("file")) {
                throw new SecurityException("JCE should be deployed as an installed extension");
            }
        }
        catch (IOException ioe) {
            throw new SecurityException("The provider IBMPKCS11Impl cannot authenticate JCE framework" + ioe);
        }
        try {
            final URL url = jceJarURL;
            jf = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ((JarURLConnection)url.openConnection()).getJarFile();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new SecurityException("Cannot authenticate JCE framework " + pae);
        }
        try {
            IBMPKCS11Impl.verifySingleJarFile(jf);
        }
        catch (Exception e) {
            throw new SecurityException("Cannot authenticate JCE framework " + e);
        }
        verifiedJce = true;
    }

    private static void verifySingleJarFile(JarFile jf) throws IOException, CertificateException {
        Vector<JarEntry> entriesVec = new Vector<JarEntry>();
        byte[] buffer = new byte[8192];
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            int n;
            JarEntry je = entries.nextElement();
            entriesVec.addElement(je);
            InputStream is = jf.getInputStream(je);
            while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            }
            is.close();
        }
        Manifest man = jf.getManifest();
        if (man == null) {
            throw new SecurityException("The JCE framework is not signed");
        }
        trustedCaCerts = IBMPKCS11Impl.setupTrustedCaCerts();
        Vector verifiedRootCache = new Vector(2);
        Enumeration e = entriesVec.elements();
        while (e.hasMoreElements()) {
            JarEntry je = (JarEntry)e.nextElement();
            if (je.isDirectory()) continue;
            Certificate[] certs = je.getCertificates();
            if (certs == null || certs.length == 0) {
                if (je.getName().startsWith("META-INF")) continue;
                throw new SecurityException("The JCE framework has unsigned class files.");
            }
            Certificate[] chainRoots = IBMPKCS11Impl.getChainRoots(certs);
            boolean signedAsExpected = false;
            for (int i = 0; i < chainRoots.length; ++i) {
                if (verifiedRootCache.contains((X509Certificate)chainRoots[i])) {
                    signedAsExpected = true;
                    break;
                }
                if (!IBMPKCS11Impl.isTrusted((X509Certificate)chainRoots[i])) continue;
                signedAsExpected = true;
                break;
            }
            if (signedAsExpected) continue;
            throw new SecurityException("JCE framework is not signed by a trusted signer");
        }
    }

    private static boolean isTrusted(X509Certificate cert) {
        int i;
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!((Object)cert.getSubjectDN()).equals(trustedCaCerts[i].getSubjectDN()) || !cert.equals(trustedCaCerts[i])) continue;
            return true;
        }
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!((Object)cert.getIssuerDN()).equals(trustedCaCerts[i].getSubjectDN())) continue;
            try {
                cert.verify(trustedCaCerts[i].getPublicKey());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static Certificate[] getChainRoots(Certificate[] certs) {
        Vector<Certificate> result = new Vector<Certificate>(3);
        for (int i = 0; i < certs.length - 1; ++i) {
            if (((Object)((X509Certificate)certs[i + 1]).getSubjectDN()).equals(((X509Certificate)certs[i]).getIssuerDN())) continue;
            result.addElement(certs[i]);
        }
        result.addElement(certs[certs.length - 1]);
        Object[] ret = new Certificate[result.size()];
        result.copyInto(ret);
        return ret;
    }

    private static X509Certificate[] setupTrustedCaCerts() throws IOException, CertificateException {
        int numberOfTrustedCas = bytesOfTrustedCaCerts.length;
        X509Certificate[] certs = new X509Certificate[numberOfTrustedCas];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < numberOfTrustedCas; ++i) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(bytesOfTrustedCaCerts[i]);
            certs[i] = (X509Certificate)cf.generateCertificate(inStream);
            inStream.close();
        }
        return certs;
    }

    private static int indexOfBang(String spec) {
        int indexOfBang = spec.lastIndexOf(".jar!/");
        if (indexOfBang > 0) {
            return indexOfBang + 5;
        }
        return -1;
    }

    static final boolean verifySelfIntegrity(Class c) {
        if (verifiedSelfIntegrity) {
            return true;
        }
        return IBMPKCS11Impl.doSelfVerification(c);
    }

    private static final synchronized boolean doSelfVerification(Class c) {
        Class cc;
        URL url;
        if (verifiedSelfIntegrity) {
            return true;
        }
        if (trustedCaCerts == null) {
            try {
                trustedCaCerts = IBMPKCS11Impl.setupTrustedCaCerts();
            }
            catch (Exception e) {
                return false;
            }
        }
        if ((url = (URL)AccessController.doPrivileged(new PrivilegedAction(cc = c){
            final /* synthetic */ Class val$cc;
            {
                this.val$cc = clazz;
            }

            public Object run() {
                CodeSource s1 = this.val$cc.getProtectionDomain().getCodeSource();
                return s1.getLocation();
            }
        })) == null) {
            return false;
        }
        JarVerifier jv = new JarVerifier(url);
        try {
            jv.verify(trustedCaCerts);
        }
        catch (Exception e) {
            return false;
        }
        verifiedSelfIntegrity = true;
        return true;
    }

    private static Certificate[] getSignerCertificates(Class c) {
        final Class cc = c;
        return (Certificate[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource s1 = cc.getProtectionDomain().getCodeSource();
                return s1.getCertificates();
            }
        });
    }

    synchronized PKCS11Session newSession() {
        PKCS11Session session;
        block5: {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "newSession");
            }
            session = null;
            try {
                session = this.tokenSlot.openSession(6, null, null);
            }
            catch (PKCS11Exception e) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "newSession", "Creation of read write session failed:" + e.getMessage());
                }
                if (e.getCode() != 226) break block5;
                session = this.tokenSlot.openSession(4, null, null);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "newSession");
        }
        return session;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS11ImplService
    extends Provider.Service {
        private final PKCS11Session session;
        private final int mechanism;
        private final Provider provider;
        private final String algorithm;
        private final boolean isSunOS;

        PKCS11ImplService(PKCS11Session session, Provider provider, String type, String algorithm, String className, String[] al, int mechanism) {
            super(provider, type, algorithm, className, PKCS11ImplService.toList(al), null);
            this.session = session;
            this.provider = provider;
            this.algorithm = algorithm;
            this.mechanism = mechanism;
            String name = System.getProperty("os.name");
            this.isSunOS = name.equals("SunOS");
        }

        private static List<String> toList(String[] aliases) {
            return aliases == null ? null : Arrays.asList(aliases);
        }

        @Override
        public Object newInstance(Object param) throws NoSuchAlgorithmException {
            try {
                String algorithm = this.getAlgorithm();
                String type = this.getType();
                String classname = this.getClassName();
                try {
                    Class<?> cls = Class.forName(classname);
                    Constructor<?>[] constructors = cls.getConstructors();
                    if (constructors.length == 1 && constructors[0].getParameterTypes().length == 2) {
                        return constructors[0].newInstance(this.provider, algorithm);
                    }
                    Class[] parameters = new Class[]{Class.forName("java.security.Provider")};
                    Constructor<?> constr = cls.getConstructor(parameters);
                    return constr.newInstance(this.provider);
                }
                catch (Exception clex) {
                    throw new NoSuchAlgorithmException(clex);
                }
            }
            catch (PKCS11Exception e) {
                throw new NoSuchAlgorithmException(e);
            }
        }

        @Override
        public boolean supportsParameter(Object param) {
            if (param == null) {
                return false;
            }
            if (!(param instanceof Key)) {
                throw new InvalidParameterException("Parameter must be a Key");
            }
            String alg = this.getAlgorithm();
            String type = this.getType();
            Key key = (Key)param;
            String keyAlg = key.getAlgorithm();
            if ((type.equals("Cipher") || type.equals("Signature") || type.equals("KeyAgreement")) && key instanceof PrivateKey && !(key instanceof PKCS11Key) && ((IBMPKCS11Impl)this.provider).getConfig() != null && ((IBMPKCS11Impl)this.provider).getConfig().getPublicKeyImportOnly()) {
                return false;
            }
            if (type.equals("Cipher") && this.algorithm.startsWith("RSA") || type.equals("Signature") && (this.algorithm.endsWith("RSA") || this.algorithm.startsWith("RSA"))) {
                if (!keyAlg.equals("RSA")) {
                    return false;
                }
                if (!this.isSunOS && key instanceof RSAPublicKeyImpl) {
                    return true;
                }
                return this.isLocalKey(key) || !(key instanceof PKCS11Key) && (key instanceof RSAPrivateKey || key instanceof RSAPublicKey);
            }
            if (type == "Signature" && this.algorithm.endsWith("DSA")) {
                if (!keyAlg.equals("DSA")) {
                    return false;
                }
                if (!this.isSunOS && key instanceof DSAPublicKeyImpl) {
                    return true;
                }
                boolean de = this.isLocalKey(key) || !(key instanceof PKCS11Key) && (key instanceof DSAPrivateKey || key instanceof DSAPublicKey);
                return de;
            }
            if (type == "Cipher" || type == "Mac") {
                return this.isLocalKey(key) || !(key instanceof PKCS11Key) && "RAW".equals(key.getFormat());
            }
            if (type == "KeyAgreement") {
                if (!keyAlg.equals("DH")) {
                    return false;
                }
                return this.isLocalKey(key) || !(key instanceof PKCS11Key) && (key instanceof DHPrivateKey || key instanceof DHPublicKey);
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "IBMPKCS11Impl", "PKCS11 error: " + type + ", " + this.algorithm);
            }
            return false;
        }

        private boolean isLocalKey(Key key) {
            return key instanceof PKCS11Key && ((PKCS11Key)key).getSession() == this.session;
        }

        @Override
        public String toString() {
            return super.toString() + "\n" + "session = " + this.session + "\n" + "provider = " + this.provider + "\n" + "algorithm = " + this.algorithm + "\n" + "mechanism =" + this.mechanism;
        }
    }
}

