/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.security.InvalidKeyException;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

final class PKCS11Cipher {
    private boolean decrypting = false;
    private PKCS11Session session;
    private PKCS11Session newsession;
    private PKCS11Object key;
    private IBMPKCS11Impl provider;
    private int mechanism;
    private int blocksize = 0;
    private boolean isWrap;
    private boolean isUpdate = false;
    private boolean isInitialized = false;
    private boolean doFinal = false;
    private byte[] param = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher";

    protected PKCS11Cipher(int mechanism, PKCS11Session session, Provider provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS11Cipher", (Object)(" " + mechanism));
        }
        this.session = session;
        this.mechanism = mechanism;
        this.provider = (IBMPKCS11Impl)provider;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "PKCS11Cipher");
        }
    }

    protected void engineInit(int opmode, PKCS11Object key, byte[] param, int blocksize) throws InvalidKeyException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(opmode), key, param};
            debug.entry(16384L, (Object)className, "engineInit-1", parms);
        }
        this.isUpdate = false;
        if (key == null) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("No key given"));
                debug.exit(16384L, (Object)className, "engineInit");
            }
            throw new InvalidKeyException("No key given");
        }
        this.decrypting = opmode == 2 || opmode == 4;
        this.isWrap = opmode == 4 || opmode == 3;
        this.param = param;
        this.key = key;
        this.blocksize = blocksize;
        if (this.decrypting && !this.isWrap) {
            this.initNewSession();
            this.newsession.decryptInit(this.mechanism, (Object)param, key);
        } else if (!this.decrypting && !this.isWrap) {
            this.initNewSession();
            this.newsession.encryptInit(this.mechanism, (Object)param, key);
        }
        this.isInitialized = true;
        this.doFinal = false;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInit");
        }
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        byte[] output = null;
        byte[] out = null;
        int len = 0;
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
            debug.entry(16384L, (Object)className, "engineUpdate", parms);
        }
        if (this.isWrap) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_1", (Throwable)new IllegalStateException("This can not be called for (un)wrapping keys"));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new IllegalStateException("This can not be called for (un)wrapping keys");
        }
        this.isUpdate = true;
        output = new byte[inputLen + this.blocksize];
        try {
            if (this.decrypting) {
                if (this.isWrap) {
                    len = this.session.decryptUpdate(input, inputOffset, inputLen, output, 0);
                } else {
                    if (!this.isInitialized) {
                        throw new IllegalStateException("Cipher is not initialized");
                    }
                    len = this.newsession.decryptUpdate(input, inputOffset, inputLen, output, 0);
                }
            } else if (this.isWrap) {
                len = this.session.encryptUpdate(input, inputOffset, inputLen, output, 0);
            } else {
                if (!this.isInitialized) {
                    throw new IllegalStateException("Cipher is not initialized");
                }
                len = this.newsession.encryptUpdate(input, inputOffset, inputLen, output, 0);
            }
            if (len > output.length) {
                throw new PKCS11Exception(336);
            }
        }
        catch (PKCS11Exception ex) {
            int code = ex.getCode();
            if (code == 336) {
                output = new byte[len];
                len = this.decrypting ? (this.isWrap ? this.session.decryptUpdate(input, inputOffset, inputLen, output, 0) : this.newsession.decryptUpdate(input, inputOffset, inputLen, output, 0)) : (this.isWrap ? this.session.encryptUpdate(input, inputOffset, inputLen, output, 0) : this.newsession.encryptUpdate(input, inputOffset, inputLen, output, 0));
                if (len > output.length) {
                    throw new PKCS11Exception(336);
                }
            }
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_2", (Throwable)new PKCS11Exception(code));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new PKCS11Exception(code);
        }
        if (len < output.length) {
            out = new byte[len];
            System.arraycopy(output, 0, out, 0, len);
        } else {
            out = output;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
        return out;
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int len = 0;
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(16384L, (Object)className, "engineUpdate", parms);
        }
        if (this.isWrap) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_1", (Throwable)new IllegalStateException("This can not be called for (un)wrapping keys"));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new IllegalStateException("This can not be called for (un)wrapping keys");
        }
        if (input == null) {
            return 0;
        }
        if (output == null || output.length - outputOffset < inputLen) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_2", (Throwable)new ShortBufferException("Output buffer must be (at least) " + inputLen + " bytes long"));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new ShortBufferException("Output buffer must be (at least) " + inputLen + " bytes long");
        }
        this.isUpdate = true;
        try {
            if (this.decrypting) {
                if (this.isWrap) {
                    len = this.session.decryptUpdate(input, inputOffset, inputLen, output, outputOffset);
                } else {
                    if (!this.isInitialized) {
                        throw new IllegalStateException("Cipher is not initialized");
                    }
                    len = this.newsession.decryptUpdate(input, inputOffset, inputLen, output, outputOffset);
                }
            } else if (this.isWrap) {
                len = this.session.encryptUpdate(input, inputOffset, inputLen, output, outputOffset);
            } else {
                if (!this.isInitialized) {
                    throw new IllegalStateException("Cipher is not initialized");
                }
                len = this.newsession.encryptUpdate(input, inputOffset, inputLen, output, outputOffset);
            }
            if (len > output.length - outputOffset) {
                throw new PKCS11Exception(336);
            }
        }
        catch (PKCS11Exception ex) {
            int code = ex.getCode();
            if (code == 336) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineUpdate_3", (Throwable)new ShortBufferException("Output buffer must be (at least) " + len + " bytes long"));
                    debug.exit(16384L, (Object)className, "engineUpdate");
                }
                throw new ShortBufferException("Output buffer must be (at least) " + len + " bytes long");
            }
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineUpdate_4", (Throwable)new PKCS11Exception(code));
                debug.exit(16384L, (Object)className, "engineUpdate");
            }
            throw new PKCS11Exception(code);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
        return len;
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        int len2;
        int len;
        byte[] out;
        byte[] output2;
        byte[] output;
        block46: {
            output = null;
            output2 = null;
            out = null;
            len = 0;
            len2 = 0;
            if (debug != null) {
                Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
                debug.entry(16384L, (Object)className, "engineDoFinal", parms);
            }
            if (this.isWrap) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineDoFinal_1", (Throwable)new IllegalStateException("This can not be called for (un)wrapping keys"));
                    debug.exit(16384L, (Object)className, "engineDoFinal");
                }
                throw new IllegalStateException("This can not be called for (un)wrapping keys");
            }
            if (this.doFinal) {
                throw new IllegalStateException("DoFinal() has been called proviously.");
            }
            output = new byte[inputLen + this.blocksize];
            if (this.isUpdate) {
                int code;
                try {
                    if (inputLen > 0) {
                        len = this.decrypting ? (this.isWrap ? this.session.decryptUpdate(input, inputOffset, inputLen, output, 0) : this.newsession.decryptUpdate(input, inputOffset, inputLen, output, 0)) : (this.isWrap ? this.session.encryptUpdate(input, inputOffset, inputLen, output, 0) : this.newsession.encryptUpdate(input, inputOffset, inputLen, output, 0));
                        if (len > output.length) {
                            throw new PKCS11Exception(336);
                        }
                    }
                }
                catch (PKCS11Exception ex) {
                    code = ex.getCode();
                    if (code == 336) {
                        output = new byte[len];
                        try {
                            len = this.decrypting ? (this.isWrap ? this.session.decryptUpdate(input, inputOffset, inputLen, output, 0) : this.newsession.decryptUpdate(input, inputOffset, inputLen, output, 0)) : (this.isWrap ? this.session.encryptUpdate(input, inputOffset, inputLen, output, 0) : this.newsession.encryptUpdate(input, inputOffset, inputLen, output, 0));
                            if (len > output.length) {
                                throw new PKCS11Exception(336);
                            }
                        }
                        catch (PKCS11Exception ex1) {
                            code = ex1.getCode();
                            if (debug != null) {
                                debug.exception(16384L, (Object)className, "engineDoFinal_3", (Throwable)new PKCS11Exception(code));
                                debug.exit(16384L, (Object)className, "engineDoFinal");
                            }
                            throw new PKCS11Exception(code);
                        }
                    }
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineDoFinal_4", (Throwable)new PKCS11Exception(code));
                        debug.exit(16384L, (Object)className, "engineDoFinal");
                    }
                    throw new PKCS11Exception(code);
                }
                output2 = new byte[inputLen + this.blocksize];
                try {
                    len2 = this.decrypting ? (this.isWrap ? this.session.decryptFinal(output2, 0) : this.newsession.decryptFinal(output2, 0)) : (this.isWrap ? this.session.encryptFinal(output2, 0) : this.newsession.encryptFinal(output2, 0));
                    if (len2 > output2.length) {
                        throw new PKCS11Exception(336);
                    }
                    break block46;
                }
                catch (PKCS11Exception ex) {
                    code = ex.getCode();
                    if (code == 336) {
                        output2 = new byte[len2];
                        try {
                            len2 = this.decrypting ? (this.isWrap ? this.session.decryptFinal(output2, 0) : this.newsession.decryptFinal(output2, 0)) : (this.isWrap ? this.session.encryptFinal(output2, 0) : this.newsession.encryptFinal(output2, 0));
                            if (len2 > output2.length) {
                                throw new PKCS11Exception(336);
                            }
                            break block46;
                        }
                        catch (PKCS11Exception ex1) {
                            code = ex1.getCode();
                            if (debug != null) {
                                debug.exception(16384L, (Object)className, "engineDoFinal_6", (Throwable)new PKCS11Exception(code));
                                debug.exit(16384L, (Object)className, "engineDoFinal");
                            }
                            throw new PKCS11Exception(code);
                        }
                    }
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineDoFinal_7", (Throwable)new PKCS11Exception(code));
                        debug.exit(16384L, (Object)className, "engineDoFinal");
                    }
                    throw new PKCS11Exception(code);
                }
            }
            try {
                if (this.decrypting) {
                    if (this.isWrap) {
                        len = this.session.decrypt(input, inputOffset, inputLen, output, 0);
                    } else {
                        if (!this.isInitialized) {
                            throw new IllegalStateException("Cipher is not initialized");
                        }
                        len = this.newsession.decrypt(input, inputOffset, inputLen, output, 0);
                    }
                } else if (this.isWrap) {
                    len = this.session.encrypt(input, inputOffset, inputLen, output, 0);
                } else {
                    if (!this.isInitialized) {
                        throw new IllegalStateException("Cipher is not initialized");
                    }
                    len = this.newsession.encrypt(input, inputOffset, inputLen, output, 0);
                }
                if (len > output.length) {
                    throw new PKCS11Exception(336);
                }
            }
            catch (PKCS11Exception ex) {
                int code = ex.getCode();
                if (code == 336) {
                    output = new byte[len];
                    try {
                        len = this.decrypting ? (this.isWrap ? this.session.decrypt(input, inputOffset, inputLen, output, 0) : this.newsession.decrypt(input, inputOffset, inputLen, output, 0)) : (this.isWrap ? this.session.encrypt(input, inputOffset, inputLen, output, 0) : this.newsession.encrypt(input, inputOffset, inputLen, output, 0));
                        if (len > output.length) {
                            throw new PKCS11Exception(336);
                        }
                    }
                    catch (PKCS11Exception ex1) {
                        code = ex1.getCode();
                        if (debug != null) {
                            debug.exception(16384L, (Object)className, "engineDoFinal_9", (Throwable)new PKCS11Exception(code));
                            debug.exit(16384L, (Object)className, "engineDoFinal");
                        }
                        throw new PKCS11Exception(code);
                    }
                }
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineDoFinal_10", (Throwable)new PKCS11Exception(code));
                    debug.exit(16384L, (Object)className, "engineDoFinal");
                }
                throw new PKCS11Exception(code);
            }
            catch (Exception e) {
                System.out.println("here: " + e.getMessage());
            }
        }
        out = new byte[len + len2];
        System.arraycopy(output, 0, out, 0, len);
        if (len2 > 0) {
            System.arraycopy(output2, 0, out, len, len2);
        }
        this.isInitialized = false;
        if (this.newsession != null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineDoFinal", "close session");
            }
            this.newsession.close();
            this.newsession = null;
        }
        this.doFinal = true;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDoFinal");
        }
        return out;
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int len = 0;
        int len2 = 0;
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(16384L, (Object)className, "engineDoFinal", parms);
        }
        if (this.isWrap) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineDoFinal_1", (Throwable)new IllegalStateException("This can not be called for (un)wrapping keys"));
                debug.exit(16384L, (Object)className, "engineDoFinal");
            }
            throw new IllegalStateException("This can not be called for (un)wrapping keys");
        }
        if (this.doFinal) {
            throw new IllegalStateException("DoFinal() has been called proviously.");
        }
        if (input == null) {
            return 0;
        }
        if (this.isUpdate) {
            len = this.decrypting ? (this.isWrap ? this.session.decryptUpdate(input, inputOffset, inputLen, output, outputOffset) : this.newsession.decryptUpdate(input, inputOffset, inputLen, output, outputOffset)) : (this.isWrap ? this.session.encryptUpdate(input, inputOffset, inputLen, output, outputOffset) : this.newsession.encryptUpdate(input, inputOffset, inputLen, output, outputOffset));
            if (len > output.length - outputOffset) {
                throw new PKCS11Exception(336);
            }
            len2 = this.decrypting ? (this.isWrap ? this.session.decryptFinal(output, outputOffset + len) : this.newsession.decryptFinal(output, outputOffset + len)) : (this.isWrap ? this.session.encryptFinal(output, outputOffset + len) : this.newsession.encryptFinal(output, outputOffset + len));
            if (len2 + len > output.length - outputOffset) {
                throw new PKCS11Exception(336);
            }
        } else {
            if (this.decrypting) {
                if (this.isWrap) {
                    len = this.session.decrypt(input, inputOffset, inputLen, output, outputOffset);
                } else {
                    if (!this.isInitialized) {
                        throw new IllegalStateException("Cipher is not initialized");
                    }
                    len = this.newsession.decrypt(input, inputOffset, inputLen, output, outputOffset);
                }
            } else if (this.isWrap) {
                len = this.session.encrypt(input, inputOffset, inputLen, output, outputOffset);
            } else {
                if (!this.isInitialized) {
                    throw new IllegalStateException("Cipher is not initialized");
                }
                len = this.newsession.encrypt(input, inputOffset, inputLen, output, outputOffset);
            }
            if (len > output.length - outputOffset) {
                throw new PKCS11Exception(336);
            }
        }
        this.isInitialized = false;
        if (this.newsession != null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineDoFinal", "close session");
            }
            this.newsession.close();
            this.newsession = null;
        }
        this.doFinal = true;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDoFinal");
        }
        return len + len2;
    }

    protected byte[] engineWrap(PKCS11Object key, int length) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] tempresult = new byte[length];
        byte[] result = null;
        int len = 0;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineWrap");
        }
        try {
            len = this.session.wrapKey(this.mechanism, (Object)this.param, this.key, key, tempresult, 0);
        }
        catch (PKCS11Exception ex) {
            int code = ex.getCode();
            if (code == 336) {
                tempresult = new byte[len];
                try {
                    len = this.session.wrapKey(this.mechanism, (Object)this.param, this.key, key, tempresult, 0);
                }
                catch (PKCS11Exception ex1) {
                    int code1 = ex1.getCode();
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineWrap_1", (Throwable)new PKCS11Exception(code1));
                        debug.exit(16384L, (Object)className, "engineWrap");
                    }
                    throw new PKCS11Exception(code1);
                }
            }
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineWrap_2", (Throwable)new PKCS11Exception(code));
                debug.exit(16384L, (Object)className, "engineWrap");
            }
            throw new PKCS11Exception(code);
        }
        result = new byte[len];
        System.arraycopy(tempresult, 0, result, 0, len);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineWrap");
        }
        return result;
    }

    protected PKCS11Object engineUnwrap(byte[] wrappedKey, int[] attrTypes, Object[] attrValues) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUnwrap");
        }
        PKCS11Object result = this.session.unwrapKey(this.mechanism, (Object)this.param, this.key, wrappedKey, 0, wrappedKey.length, attrTypes, attrValues);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUnwrap");
        }
        return result;
    }

    private void initNewSession() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initNewSession");
        }
        if (this.newsession != null) {
            block6: {
                try {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "initNewSession", "close");
                    }
                    this.newsession.close();
                }
                catch (PKCS11Exception ex) {
                    if (debug == null) break block6;
                    debug.exception(16384L, (Object)className, "initNewSession", (Throwable)ex);
                }
            }
            this.newsession = null;
        }
        this.newsession = this.provider.newSession();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initNewSession");
        }
    }

    protected void finalize() {
        block7: {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "finalize");
            }
            this.session = null;
            this.provider = null;
            this.key = null;
            this.param = null;
            try {
                if (this.newsession != null) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "finalize", "close session");
                    }
                    this.newsession.close();
                    super.finalize();
                } else {
                    super.finalize();
                }
            }
            catch (Throwable ex) {
                if (debug == null) break block7;
                debug.exception(16384L, (Object)className, "finalize", ex);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "finalize");
        }
    }
}

