/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DESKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DESedeKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.security.auth.Destroyable;
import javax.security.auth.callback.CallbackHandler;

public final class PKCS11KeyStore
extends KeyStoreSpi {
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"pkcs11keystore");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11KeyStore";
    private PKCS11Session session = null;
    private Hashtable entries = new Hashtable();
    private Provider provider;
    private String providerName = "IBMPKCS11Impl";

    public PKCS11KeyStore() {
        this.session = ((IBMPKCS11Impl)Security.getProvider(this.providerName)).getSession();
    }

    public PKCS11KeyStore(Provider provider) {
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.provider = provider;
        this.providerName = provider.getName();
    }

    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof PrivateKeyEntry) {
                return ((PrivateKeyEntry)entry).key;
            }
            if (entry instanceof SecretKeyEntry) {
                return ((SecretKeyEntry)entry).key;
            }
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate[] chain = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof PrivateKeyEntry && ((PrivateKeyEntry)entry).chain != null) {
            chain = (Certificate[])((PrivateKeyEntry)entry).chain.clone();
        }
        return chain;
    }

    public Certificate engineGetCertificate(String alias) {
        Certificate cert = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof TrustedCertEntry) {
                cert = ((TrustedCertEntry)entry).cert;
            } else if (entry instanceof PrivateKeyEntry && ((PrivateKeyEntry)entry).chain != null) {
                cert = ((PrivateKeyEntry)entry).chain[0];
            }
        }
        return cert;
    }

    public synchronized KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof PrivateKeyEntry) {
                PrivateKey privkey = (PrivateKey)((PrivateKeyEntry)entry).key;
                Certificate[] chain = null;
                if (((PrivateKeyEntry)entry).chain != null) {
                    chain = (Certificate[])((PrivateKeyEntry)entry).chain.clone();
                }
                return new KeyStore.PrivateKeyEntry(privkey, chain);
            }
            if (entry instanceof SecretKeyEntry) {
                SecretKey seckey = (SecretKey)((SecretKeyEntry)entry).key;
                return new KeyStore.SecretKeyEntry(seckey);
            }
            if (entry instanceof TrustedCertEntry) {
                return new KeyStore.TrustedCertificateEntry(((TrustedCertEntry)entry).cert);
            }
        }
        return null;
    }

    public synchronized void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            Certificate cert = ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
            this.engineSetCertificateEntry(alias, cert);
        } else if (entry instanceof KeyStore.PrivateKeyEntry) {
            PrivateKey key = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
            Certificate[] chain = ((KeyStore.PrivateKeyEntry)entry).getCertificateChain();
            char[] chars = null;
            this.engineSetKeyEntry(alias, key, chars, chain);
        } else if (entry instanceof KeyStore.SecretKeyEntry) {
            KeyStore.SecretKeyEntry secretKeyEnt = (KeyStore.SecretKeyEntry)entry;
            SecretKey skey = secretKeyEnt.getSecretKey();
            char[] chars = null;
            this.engineSetKeyEntry(alias, skey, chars, null);
        } else {
            throw new KeyStoreException(new UnsupportedOperationException("unsupported entry type: " + entry.getClass().getName()));
        }
    }

    public Date engineGetCreationDate(String alias) {
        Object date = null;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null) {
            if (entry instanceof PrivateKeyEntry) {
                try {
                    date = ((PrivateKeyEntry)entry).keyObject.getAttributeValue(272);
                }
                catch (PKCS11Exception pkcs11ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGetCreationDate", (Throwable)pkcs11ex);
                    }
                    date = null;
                }
                if (date == null) {
                    PublicKey pkey;
                    Certificate[] chain;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "start date attribute is not set for the private key");
                    }
                    if ((chain = ((PrivateKeyEntry)entry).chain) != null && chain.length > 0 && (pkey = ((X509Certificate)chain[0]).getPublicKey()) instanceof PKCS11PublicKey) {
                        date = ((PKCS11PublicKey)pkey).getStartDate();
                    }
                } else if (!(date instanceof Date)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "expected Date object, but got " + date);
                    }
                    date = null;
                }
            } else if (entry instanceof SecretKeyEntry) {
                try {
                    date = ((SecretKeyEntry)entry).keyObject.getAttributeValue(272);
                }
                catch (PKCS11Exception pkcs11ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGetCreationDate", (Throwable)pkcs11ex);
                    }
                    date = null;
                }
                if (date == null) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "start date attribute is not set for the secret key");
                    }
                } else if (!(date instanceof Date)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "expected Date object, but got " + date);
                    }
                    date = null;
                }
            } else if (entry instanceof TrustedCertEntry) {
                try {
                    date = ((TrustedCertEntry)entry).certObject.getAttributeValue(272);
                }
                catch (PKCS11Exception pkcs11ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineGetCreationDate", (Throwable)pkcs11ex);
                    }
                    date = null;
                }
                if (date == null) {
                    PublicKey pkey;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "start date attribute is not set for the certificate");
                    }
                    if ((pkey = ((TrustedCertEntry)entry).cert.getPublicKey()) instanceof PKCS11PublicKey) {
                        date = ((PKCS11PublicKey)pkey).getStartDate();
                    }
                } else if (!(date instanceof Date)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineGetCreationDate", "expected Date object, but got " + date);
                    }
                    date = null;
                }
            }
        }
        if (date == null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineGetCreationDate", "no entry found associated with alias " + alias);
            }
            return null;
        }
        return (Date)date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetKeyEntry");
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object entry;
            Object kf;
            String alg;
            Destroyable pkey;
            Object entry2;
            Object newEntry = null;
            if (this.engineIsCertificateEntry(alias)) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSetKeyEntry", "Alias exists for a certificate entry");
                    debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                }
                throw new KeyStoreException("Alias exists for a certificate entry");
            }
            if (this.engineIsKeyEntry(alias)) {
                Object keyentry;
                PKCS11Object destroyIt = null;
                Object keyobj = this.entries.get(alias.toLowerCase());
                if (keyobj instanceof PrivateKeyEntry) {
                    keyentry = (PrivateKeyEntry)keyobj;
                    PKCS11PrivateKey ppkey = (PKCS11PrivateKey)((PrivateKeyEntry)keyentry).key;
                    destroyIt = ppkey.getObject();
                    this.deleteChain(ppkey.getID());
                    if (key instanceof PKCS11PrivateKey && ((PKCS11PrivateKey)key).getObject() == ppkey.getObject()) {
                        destroyIt = null;
                    }
                } else {
                    keyentry = (SecretKeyEntry)keyobj;
                    PKCS11SecretKey skey = (PKCS11SecretKey)((SecretKeyEntry)keyentry).key;
                    destroyIt = ((SecretKeyEntry)keyentry).keyObject;
                    if (key instanceof PKCS11SecretKey && ((PKCS11SecretKey)key).getObject() == skey.getObject()) {
                        destroyIt = null;
                    }
                }
                if (destroyIt != null) {
                    destroyIt.destroy();
                }
            }
            if (key instanceof PKCS11PrivateKey) {
                entry2 = new PrivateKeyEntry();
                ((PrivateKeyEntry)entry2).key = key;
                ((PrivateKeyEntry)entry2).keyObject = ((PKCS11PrivateKey)key).getObject();
                if (!((Boolean)this.getValue(((PrivateKeyEntry)entry2).keyObject, 1)).booleanValue()) {
                    pkey = this.makePrivKeyToken((PKCS11PrivateKey)key, alias);
                    ((PrivateKeyEntry)entry2).key = pkey;
                    ((PrivateKeyEntry)entry2).keyObject = pkey.getObject();
                } else if (!((String)this.getValue(((PrivateKeyEntry)entry2).keyObject, 3)).equalsIgnoreCase(alias)) {
                    pkey = this.changePrivKeyLabel((PKCS11PrivateKey)key, alias);
                    ((PrivateKeyEntry)entry2).key = pkey;
                    ((PrivateKeyEntry)entry2).keyObject = pkey.getObject();
                }
                ((PrivateKeyEntry)entry2).chain = chain != null && chain[0] != null ? (Certificate[])chain.clone() : null;
                this.addCertificateChain(alias, ((PKCS11PrivateKey)key).getID(), ((PrivateKeyEntry)entry2).chain, true);
                newEntry = entry2;
            } else if (key instanceof PKCS11SecretKey) {
                entry2 = new SecretKeyEntry();
                ((SecretKeyEntry)entry2).key = key;
                ((SecretKeyEntry)entry2).keyObject = ((PKCS11SecretKey)key).getObject();
                if (!((Boolean)this.getValue(((SecretKeyEntry)entry2).keyObject, 1)).booleanValue()) {
                    pkey = this.makeSecKeyToken((PKCS11SecretKey)key, alias);
                    ((SecretKeyEntry)entry2).key = pkey;
                    ((SecretKeyEntry)entry2).keyObject = pkey.getObject();
                } else if (!((String)this.getValue(((SecretKeyEntry)entry2).keyObject, 3)).equalsIgnoreCase(alias)) {
                    pkey = this.changeSecKeyLabel((PKCS11SecretKey)key, alias);
                    ((SecretKeyEntry)entry2).key = pkey;
                    ((SecretKeyEntry)entry2).keyObject = pkey.getObject();
                }
                newEntry = entry2;
            } else if (key instanceof PrivateKey) {
                PKCS11PrivateKey ppkey;
                block45: {
                    alg = key.getAlgorithm();
                    ppkey = null;
                    kf = null;
                    try {
                        if (alg.equalsIgnoreCase("DSA")) {
                            kf = KeyFactory.getInstance("DSA", this.providerName);
                            ppkey = (PKCS11PrivateKey)((KeyFactory)kf).translateKey(key);
                            break block45;
                        }
                        if (alg.equalsIgnoreCase("RSA")) {
                            kf = KeyFactory.getInstance("RSA", this.providerName);
                            ppkey = (PKCS11PrivateKey)((KeyFactory)kf).translateKey(key);
                            break block45;
                        }
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineSetKeyEntry", "Keystore can not handle this key algorithm: " + alg);
                            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                        }
                        throw new KeyStoreException("Keystore can not handle this key algorithm: " + alg);
                    }
                    catch (Exception e) {
                        if (debug != null) {
                            debug.exception(16384L, (Object)className, "engineSetKeyEntry", (Throwable)e);
                            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                        }
                        throw new KeyStoreException("Keystore can not handle this key: " + e.getMessage());
                    }
                }
                entry = new PrivateKeyEntry();
                if (!((String)this.getValue(ppkey.getObject(), 3)).equalsIgnoreCase(alias)) {
                    PKCS11PrivateKey pkey2 = this.changePrivKeyLabel(ppkey, alias);
                    ((PrivateKeyEntry)entry).key = pkey2;
                    ((PrivateKeyEntry)entry).keyObject = pkey2.getObject();
                } else {
                    ((PrivateKeyEntry)entry).key = ppkey;
                    ((PrivateKeyEntry)entry).keyObject = ppkey.getObject();
                }
                ((PrivateKeyEntry)entry).chain = chain != null && chain[0] != null ? (Certificate[])chain.clone() : null;
                if (((Boolean)this.getValue(((PrivateKeyEntry)entry).keyObject, 1)).booleanValue()) {
                    this.addCertificateChain(alias, ppkey.getID(), ((PrivateKeyEntry)entry).chain, true);
                } else {
                    this.addCertificateChain(alias, ppkey.getID(), ((PrivateKeyEntry)entry).chain, false);
                }
                newEntry = entry;
            } else if (key instanceof SecretKey) {
                alg = key.getAlgorithm();
                PKCS11SecretKey skey = null;
                kf = null;
                try {
                    if (!(alg.equalsIgnoreCase("DES") || alg.equalsIgnoreCase("3DES") || alg.equalsIgnoreCase("DESede") || alg.equalsIgnoreCase("TripleDES") || alg.equalsIgnoreCase("ARCFOUR") || alg.equalsIgnoreCase("RC4") || alg.equalsIgnoreCase("Blowfish") || alg.equalsIgnoreCase("Generic") || alg.equalsIgnoreCase("AES"))) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineSetKeyEntry", "Keystore can not handle this key algorithm: " + alg);
                            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                        }
                        throw new KeyStoreException("Keystore can not handle this key algorithm: " + alg);
                    }
                    kf = SecretKeyFactory.getInstance(alg, this.providerName);
                    skey = (PKCS11SecretKey)((SecretKeyFactory)kf).translateKey((SecretKey)key);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineSetKeyEntry", (Throwable)e);
                        debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                    }
                    throw new KeyStoreException("Keystore can not handle this key: " + e.getMessage());
                }
                entry = new SecretKeyEntry();
                if (!((String)this.getValue(skey.getObject(), 3)).equalsIgnoreCase(alias)) {
                    PKCS11SecretKey sskey = this.changeSecKeyLabel(skey, alias);
                    ((SecretKeyEntry)entry).key = sskey;
                    ((SecretKeyEntry)entry).keyObject = sskey.getObject();
                } else {
                    ((SecretKeyEntry)entry).key = skey;
                    ((SecretKeyEntry)entry).keyObject = skey.getObject();
                }
                newEntry = entry;
            } else {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSetKeyEntry", "Invalid key type");
                    debug.exit(16384L, (Object)className, "engineSetKeyEntry");
                }
                throw new KeyStoreException("Invalid key type");
            }
            this.entries.put(alias.toLowerCase(), newEntry);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
        }
    }

    private PKCS11PrivateKey changePrivKeyLabel(PKCS11PrivateKey pkey, String alias) throws KeyStoreException {
        if (debug != null) {
            String keyString = pkey.toString();
            debug.entry(16384L, (Object)className, "changePrivKeyLabel", (Object)keyString, (Object)alias);
        }
        int[] chgtypes = new int[]{3};
        Object[] chgvalues = new Object[]{alias};
        return this.convertPrivKeyObj(chgtypes, chgvalues, pkey, alias);
    }

    private PKCS11PrivateKey makePrivKeyToken(PKCS11PrivateKey pkey, String alias) throws KeyStoreException {
        if (debug != null) {
            String keyString = pkey.toString();
            debug.entry(16384L, (Object)className, "makePrivKeyToken", (Object)keyString, (Object)alias);
        }
        int[] chgtypes = new int[]{1, 2, 3, 257};
        Object[] chgvalues = new Object[]{Boolean.TRUE, Boolean.TRUE, alias, pkey.getSubject()};
        if (debug != null) {
            debug.exit(16384L, (Object)className, "makePrivKeyToken");
        }
        return this.convertPrivKeyObj(chgtypes, chgvalues, pkey, alias);
    }

    private PKCS11PrivateKey convertPrivKeyObj(int[] chgtypes, Object[] chgvalues, PKCS11PrivateKey pkey, String alias) throws KeyStoreException {
        PrivateKeyInfo key = null;
        PKCS11Object newObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)"PKCS11KeyStore", "convertPrivKeyObj");
        }
        try {
            newObj = pkey.getObject().copy(chgtypes, chgvalues);
            if (debug != null) {
                debug.text(16384L, (Object)className, "convertPrivKeyObj", "make copy of key");
            }
        }
        catch (Exception ke) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "convertPrivKeyObj", "Create as a new key not a copy. " + ke.getMessage());
            }
            int[] attrtypes = null;
            Object[] attrvalues = null;
            if (pkey instanceof PKCS11RSAPrivateKey) {
                PKCS11RSAPrivateKey pRSA = (PKCS11RSAPrivateKey)pkey;
                int[] attrtypesRSA = new int[]{0, 1, 2, 3, 256, 257, 258, 264, 265, 288, 291, 261, 268, 259, 296, 290, 292, 293, 294, 295};
                Object[] attrvaluesRSA = new Object[]{PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE, alias, PKCS11Object.RSA, pRSA.getSubject(), pRSA.getID(), pRSA.getSign(), pRSA.getSignRecover(), pRSA.getModulus(), pRSA.getPrivateExponent(), pRSA.getDecrypt(), pRSA.getDerive(), pRSA.getSensitive(), pRSA.getCoefficient(), pRSA.getPublicExponent(), pRSA.getPrime1(), pRSA.getPrime2(), pRSA.getExponent1(), pRSA.getExponent2()};
                attrtypes = attrtypesRSA;
                attrvalues = attrvaluesRSA;
            } else if (pkey instanceof PKCS11DSAPrivateKey) {
                PKCS11DSAPrivateKey pDSA = (PKCS11DSAPrivateKey)pkey;
                int[] attrtypesDSA = new int[]{17, 0, 1, 2, 3, 256, 257, 258, 264, 265, 306, 305, 304, 261, 268, 259};
                Object[] attrvaluesDSA = new Object[]{pDSA.getValue().toByteArray(), PKCS11Object.PRIVATE_KEY, Boolean.TRUE, Boolean.TRUE, alias, PKCS11Object.DSA, pDSA.getSubject(), pDSA.getID(), pDSA.getSign(), pDSA.getSignRecover(), pDSA.getBase(), pDSA.getSubprime(), pDSA.getPrime(), pDSA.getDecrypt(), pDSA.getDerive(), pDSA.getSensitive()};
                attrtypes = attrtypesDSA;
                attrvalues = attrvaluesDSA;
            }
            try {
                newObj = this.session.createObject(attrtypes, attrvalues);
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "convertPrivKeyObj", (Throwable)e);
                    debug.exit(16384L, (Object)className, "convertPrivKeyObj");
                }
                throw new KeyStoreException(e.getMessage());
            }
        }
        try {
            if (pkey instanceof PKCS11RSAPrivateKey) {
                PKCS11RSAPrivateKey pRSA = (PKCS11RSAPrivateKey)pkey;
                key = new RSAPrivateKey(this.session, newObj, pRSA.getID(), pRSA.getSubject(), alias, Boolean.TRUE, pRSA.getSensitive(), pRSA.getSign(), pRSA.getDecrypt(), pRSA.getUnwrap(), pRSA.getExtractable(), pRSA.getModulus(), pRSA.getPublicExponent(), pRSA.getPrivateExponent(), pRSA.getPrime1(), pRSA.getPrime2(), pRSA.getExponent1(), pRSA.getExponent2(), pRSA.getCoefficient());
            } else if (pkey instanceof PKCS11DSAPrivateKey) {
                PKCS11DSAPrivateKey pDSA = (PKCS11DSAPrivateKey)pkey;
                key = new DSAPrivateKey(this.session, newObj, alias, pDSA.getID(), pDSA.getSubject(), Boolean.TRUE, pDSA.getSensitive(), pDSA.getExtractable(), pDSA.getPrime(), pDSA.getSubprime(), pDSA.getBase(), pDSA.getValue());
            }
        }
        catch (InvalidKeyException ie) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "convertPrivKeyObj", (Throwable)ie);
                debug.exit(16384L, (Object)className, "convertPrivKeyObj");
            }
            throw new KeyStoreException(ie.getMessage());
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "convertPrivKeyObj", "destroy key object");
        }
        pkey.getObject().destroy();
        if (debug != null) {
            debug.exit(16384L, (Object)"PKCS11KeyStore", "convertPrivKeyObj");
        }
        return key;
    }

    private PKCS11SecretKey changeSecKeyLabel(PKCS11SecretKey pkey, String alias) throws KeyStoreException {
        if (debug != null) {
            String keyString = pkey.toString();
            debug.entry(16384L, (Object)className, "changeSecKeyLabel", (Object)keyString, (Object)alias);
        }
        int[] chgtypes = new int[]{3};
        Object[] chgvalues = new Object[]{alias};
        if (debug != null) {
            debug.exit(16384L, (Object)className, "changeSecKeyLabel");
        }
        return this.convertSecKeyObj(chgtypes, chgvalues, pkey, alias);
    }

    private PKCS11SecretKey makeSecKeyToken(PKCS11SecretKey pkey, String alias) throws KeyStoreException {
        if (debug != null) {
            String keyString = pkey.toString();
            debug.entry(16384L, (Object)className, "makeSecKeyToken", (Object)keyString, (Object)alias);
        }
        int[] chgtypes = new int[]{1, 2, 3};
        Object[] chgvalues = new Object[]{Boolean.TRUE, Boolean.TRUE, alias};
        if (debug != null) {
            debug.exit(16384L, (Object)className, "makeSecKeyToken");
        }
        return this.convertSecKeyObj(chgtypes, chgvalues, pkey, alias);
    }

    private PKCS11SecretKey convertSecKeyObj(int[] chgtypes, Object[] chgvalues, PKCS11SecretKey pkey, String alias) throws KeyStoreException {
        PKCS11Object newObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "convertSecKeyObj");
        }
        try {
            newObj = pkey.getObject().copy(chgtypes, chgvalues);
            if (debug != null) {
                debug.text(16384L, (Object)className, "convertSecKeyObj", "make copy of secret key");
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "convertSecKeyObj", "Copy failed try to create token key");
            }
            try {
                PKCS11SecretKey gk;
                byte[] value = null;
                if (pkey instanceof GeneralKey) {
                    gk = (GeneralKey)pkey;
                    value = ((GeneralKey)gk).getValue();
                } else if (pkey instanceof PKCS11DESedeKey) {
                    gk = (PKCS11DESedeKey)pkey;
                    value = gk.getValue();
                } else if (pkey instanceof PKCS11DESKey) {
                    gk = (PKCS11DESKey)pkey;
                    value = gk.getValue();
                }
                int[] attrTypes = new int[]{0, 256, 258, 3, 2, 1, 259, 268, 260, 261, 262, 263, 17};
                Object[] attrValues = new Object[]{PKCS11Object.SECRET_KEY, pkey.getKeyType(), pkey.getID(), alias, Boolean.TRUE, Boolean.TRUE, pkey.getSensitive(), pkey.getDerive(), pkey.getEncrypt(), pkey.getDecrypt(), pkey.getWrap(), pkey.getUnwrap(), value};
                newObj = this.session.createObject(attrTypes, attrValues);
            }
            catch (PKCS11Exception pe) {
                if (newObj != null) {
                    newObj.destroy();
                }
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "convertSecKeyObj", (Throwable)pe);
                    debug.exit(16384L, (Object)className, "convertSecKeyObj");
                }
                throw new KeyStoreException(pe.getMessage());
            }
        }
        GeneralKey key = null;
        try {
            if (pkey instanceof GeneralKey) {
                GeneralKey genKey = (GeneralKey)pkey;
                key = new GeneralKey(this.session, newObj, genKey.mechanismBuilder.getAlgorithm());
                pkey.getObject().destroy();
            } else if (pkey instanceof PKCS11DESKey) {
                key = new GeneralKey(this.session, newObj, "DES");
                pkey.getObject().destroy();
            } else if (pkey instanceof PKCS11DESedeKey) {
                key = new GeneralKey(this.session, newObj, "DESede");
                pkey.getObject().destroy();
            }
        }
        catch (InvalidKeyException ke) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "convertSecKeyObj", (Throwable)ke);
                debug.exit(16384L, (Object)className, "convertSecKeyObj");
            }
            throw new KeyStoreException(ke.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "convertSecKeyObj");
        }
        return key;
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetKeyEntry");
            debug.text(16384L, (Object)className, "engineSetKeyEntry", "This method is not supported");
            debug.exit(16384L, (Object)className, "engineSetKeyEntry");
        }
        throw new KeyStoreException("This method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetCertificateEntry", (Object)alias, (Object)cert);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object entry = this.entries.get(alias.toLowerCase());
            if (entry != null && (entry instanceof PrivateKeyEntry || entry instanceof SecretKeyEntry)) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSetCertificateEntry", "Cannot overwrite key entry");
                    debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
                }
                throw new KeyStoreException("Cannot overwrite key entry");
            }
            PKCS11Object certObj = null;
            if (cert instanceof X509Certificate) {
                byte[] subject = null;
                byte[] id = null;
                try {
                    id = alias.getBytes("8859_1");
                }
                catch (UnsupportedEncodingException e) {
                    id = alias.getBytes();
                }
                byte[] issuer = null;
                BigInteger serialNumber = null;
                DerOutputStream dos = null;
                if (id.length > 20) {
                    byte[] bytes = new byte[20];
                    System.arraycopy(id, 0, bytes, 0, 20);
                    id = bytes;
                }
                try {
                    CertificateFactory certFactory = CertificateFactory.getInstance("X509", this.providerName);
                    if (cert instanceof X509CertImpl) {
                        X509CertImpl thecert = (X509CertImpl)cert;
                        dos = new DerOutputStream();
                        ((X500Name)thecert.getSubjectDN()).encode(dos);
                        subject = dos.toByteArray();
                        dos = new DerOutputStream();
                        ((X500Name)thecert.getIssuerDN()).encode(dos);
                        issuer = dos.toByteArray();
                        serialNumber = thecert.getSerialNumber();
                        certObj = this.createCertObject(alias, Boolean.TRUE, thecert.getEncoded(), subject, id, issuer, serialNumber);
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(cert.getEncoded());
                    X509CertImpl thecert = (X509CertImpl)certFactory.generateCertificate(bais);
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getSubjectDN()).encode(dos);
                    subject = dos.toByteArray();
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getIssuerDN()).encode(dos);
                    serialNumber = thecert.getSerialNumber();
                    certObj = this.createCertObject(alias, Boolean.TRUE, thecert.getEncoded(), subject, id, issuer, serialNumber);
                }
                catch (Exception ioe) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineSetCertificateEntry", (Throwable)ioe);
                        debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
                    }
                    throw new KeyStoreException("Cannot store certificate :" + ioe.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineSetCertificateEntry", "Unsupported certificate type. Only X509 certificate is supported");
                    debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
                }
                throw new KeyStoreException("Unsupported certificate type. Only X509 certificate is supported");
            }
            TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
            trustedCertEntry.cert = cert;
            trustedCertEntry.certObject = certObj;
            this.entries.put(alias.toLowerCase(), trustedCertEntry);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetCertificateEntry");
        }
    }

    private void addCertificateChain(String alias, byte[] id, Certificate[] cert, boolean isToken) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addCertificateChain", (Object)alias, (Object)isToken);
        }
        int[] attrType = new int[]{1, 0, 257, 130};
        byte[] subject = null;
        byte[] issuer = null;
        BigInteger serialNumber = null;
        DerOutputStream dos = null;
        X509CertImpl thecert = null;
        if (cert == null) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "addCertificateChain", "cert chain is null");
                debug.exit(16384L, (Object)className, "addCertificateChain");
            }
            return;
        }
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X509", this.providerName);
            if (cert[0] instanceof X509CertImpl) {
                thecert = (X509CertImpl)cert[0];
                dos = new DerOutputStream();
                ((X500Name)thecert.getSubjectDN()).encode(dos);
                subject = dos.toByteArray();
                dos = new DerOutputStream();
                ((X500Name)thecert.getIssuerDN()).encode(dos);
                issuer = dos.toByteArray();
                serialNumber = thecert.getSerialNumber();
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(cert[0].getEncoded());
                thecert = (X509CertImpl)certFactory.generateCertificate(bais);
                dos = new DerOutputStream();
                ((X500Name)thecert.getSubjectDN()).encode(dos);
                subject = dos.toByteArray();
                dos = new DerOutputStream();
                ((X500Name)thecert.getIssuerDN()).encode(dos);
                serialNumber = thecert.getSerialNumber();
            }
            if (debug != null) {
                debug.text(16384L, (Object)className, "addCertificateChain", "Alias = " + alias);
                debug.text(16384L, (Object)className, "addCertificateChain", "id = " + new HexDumpEncoder().encode(id));
            }
            this.createCertObject(alias, Boolean.TRUE, thecert.getEncoded(), subject, id, issuer, serialNumber);
            for (int i = 1; i < cert.length; ++i) {
                if (cert[i] instanceof X509CertImpl) {
                    thecert = (X509CertImpl)cert[i];
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getSubjectDN()).encode(dos);
                    subject = dos.toByteArray();
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getIssuerDN()).encode(dos);
                    issuer = dos.toByteArray();
                    serialNumber = thecert.getSerialNumber();
                } else {
                    ByteArrayInputStream bais = new ByteArrayInputStream(cert[i].getEncoded());
                    thecert = (X509CertImpl)certFactory.generateCertificate(bais);
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getSubjectDN()).encode(dos);
                    subject = dos.toByteArray();
                    dos = new DerOutputStream();
                    ((X500Name)thecert.getIssuerDN()).encode(dos);
                    serialNumber = thecert.getSerialNumber();
                }
                Object[] attrVal = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, subject, serialNumber.toByteArray()};
                this.session.findObjectsInit(attrType, attrVal);
                PKCS11Object pkcs11obj = this.session.findObject();
                this.session.findObjectsFinal();
                if (debug != null) {
                    debug.text(16384L, (Object)className, "addCertificateChain", "pkcs11obj = " + pkcs11obj);
                }
                if (pkcs11obj != null) continue;
                this.createCertObject(alias, Boolean.TRUE, thecert.getEncoded(), subject, id, issuer, serialNumber);
            }
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "addCertificateChain", (Throwable)ex);
                debug.exit(16384L, (Object)className, "addCertificateChain");
            }
            throw new KeyStoreException(ex.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addCertificateChain");
        }
    }

    private PKCS11Object createCertObject(String label, Boolean isToken, byte[] value, byte[] subject, byte[] id, byte[] issuer, BigInteger serialNumber) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "createCertObject", (Object)label, (Object)isToken);
        }
        int[] attrtypes = new int[]{0, 1, 2, 3, 128, 258, 257, 130, 17, 129};
        Object[] attrvalues = new Object[]{PKCS11Object.CERTIFICATE, isToken, Boolean.FALSE, label, PKCS11Object.X_509, id, subject, serialNumber.toByteArray(), value, issuer};
        PKCS11Object newobj = null;
        try {
            newobj = this.session.createObject(attrtypes, attrvalues);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "createCertObject", (Throwable)e);
                debug.exit(16384L, (Object)className, "createCertObject");
            }
            throw new KeyStoreException("Cannot store certificate: " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "createCertObject");
        }
        return newobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineDeleteEntry", (Object)alias);
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            if (this.engineIsKeyEntry(alias)) {
                Object entry = this.entries.get(alias.toLowerCase());
                if (entry instanceof PrivateKeyEntry) {
                    PrivateKeyEntry keyentry = (PrivateKeyEntry)entry;
                    this.deleteKey((PKCS11Key)keyentry.key, PKCS11Object.PRIVATE_KEY);
                    this.deletePublicKey(keyentry.chain, (PKCS11Key)keyentry.key);
                    this.deleteChain(((PKCS11Key)keyentry.key).getID());
                } else {
                    SecretKeyEntry keyentry = (SecretKeyEntry)entry;
                    this.deleteKey((PKCS11Key)keyentry.key, PKCS11Object.SECRET_KEY);
                }
            } else if (this.engineIsCertificateEntry(alias)) {
                TrustedCertEntry certentry = (TrustedCertEntry)this.entries.get(alias.toLowerCase());
                certentry.certObject.destroy();
            }
            this.entries.remove(alias.toLowerCase());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDeleteEntry");
        }
    }

    private void deleteKey(PKCS11Key key, int classNum) {
        if (debug != null) {
            String keyString = key.toString();
            debug.entry(16384L, (Object)className, "deleteKey", (Object)keyString, (Object)classNum);
        }
        PKCS11Object pkcs11obj = null;
        key.getObject().destroy();
        int cnt = 5;
        String label = key.getLabel();
        byte[] id = key.getID();
        if (label == null) {
            --cnt;
        }
        if (id == null || id.length == 0) {
            --cnt;
        }
        int[] attrTypeID = new int[cnt];
        Object[] val = new Object[cnt];
        int x = 0;
        attrTypeID[x] = 1;
        val[x] = Boolean.FALSE;
        attrTypeID[++x] = 0;
        val[x] = classNum;
        attrTypeID[++x] = 2;
        val[x] = Boolean.FALSE;
        ++x;
        if (label != null) {
            attrTypeID[x] = 3;
            val[x] = label;
            ++x;
        }
        if (id != null && id.length > 0) {
            attrTypeID[x] = 258;
            val[x] = id;
        }
        this.session.findObjectsInit(attrTypeID, val);
        pkcs11obj = this.session.findObject();
        this.session.findObjectsFinal();
        if (pkcs11obj == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deleteKey", (Object)"No Session object found.");
            }
            return;
        }
        pkcs11obj.destroy();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteKey", (Object)"Session object found.");
        }
    }

    private void deletePublicKey(Certificate[] cert, PKCS11Key key) {
        block17: {
            if (debug != null) {
                String keyString = key.toString();
                debug.entry(16384L, (Object)className, "deletePublicKey", (Object)cert, (Object)keyString);
            }
            PKCS11Object pkcs11obj = null;
            int[] attrTypeID = null;
            Object[] val = null;
            if (cert == null || cert[0] == null) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "deletePublicKey", "No cert associated with private key.");
                }
                int[] attrTypeIDN = new int[]{1, 256, 0, 3, 258};
                Object[] valN = new Object[]{Boolean.TRUE, key.getKeyType(), PKCS11Object.PUBLIC_KEY, key.getLabel(), key.getID()};
                this.session.findObjectsInit(attrTypeIDN, valN);
                pkcs11obj = this.session.findObject();
                this.session.findObjectsFinal();
                if (pkcs11obj == null) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"No object found.");
                    }
                    return;
                }
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "deletePublicKey", (Object)("Object = " + pkcs11obj));
                }
                pkcs11obj.destroy();
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"Object found.");
                }
                return;
            }
            PKCS11PublicKey pub = (PKCS11PublicKey)((X509Certificate)cert[0]).getPublicKey();
            if (pub.getKeyType() == PKCS11Object.RSA) {
                PKCS11RSAPublicKey pubRSA = (PKCS11RSAPublicKey)pub;
                int[] attrTypeIDRSA = new int[]{1, 256, 0, 288, 290, 3, 258};
                Object[] valRSA = new Object[]{Boolean.TRUE, PKCS11Object.RSA, PKCS11Object.PUBLIC_KEY, pubRSA.getModulus(), pubRSA.getPublicExponent(), key.getLabel(), key.getID()};
                attrTypeID = attrTypeIDRSA;
                val = valRSA;
            } else if (pub.getKeyType() == PKCS11Object.DSA) {
                PKCS11DSAPublicKey pubDSA = (PKCS11DSAPublicKey)pub;
                int[] attrTypeIDDSA = new int[]{1, 256, 0, 304, 305, 306, 17, 3, 258};
                Object[] valDSA = new Object[]{Boolean.TRUE, PKCS11Object.DSA, PKCS11Object.PUBLIC_KEY, pubDSA.getPrime(), pubDSA.getSubprime(), pubDSA.getBase(), pubDSA.getValue().toByteArray(), key.getLabel(), key.getID()};
                attrTypeID = attrTypeIDDSA;
                val = valDSA;
            } else {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"Key type not RSA or DSA");
                }
                return;
            }
            try {
                this.session.findObjectsInit(attrTypeID, val);
                pkcs11obj = this.session.findObject();
                this.session.findObjectsFinal();
                if (pkcs11obj == null) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"No object found.");
                    }
                    return;
                }
                pkcs11obj.destroy();
            }
            catch (PKCS11Exception ex) {
                if (debug == null) break block17;
                debug.exception(16384L, (Object)className, "deletePublicKey", (Throwable)ex);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deletePublicKey", (Object)"Object found.");
        }
    }

    private void deleteChain(byte[] id) {
        int[] attrTypeID = new int[]{1, 0, 258};
        int[] attrTypeSub = new int[]{1, 0, 257};
        int[] attrTypeIss = new int[]{1, 0, 129};
        byte[] subject = null;
        byte[] issuer = null;
        PKCS11Object pkcs11obj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "deleteChain", (Object)new HexDumpEncoder().encode(id));
        }
        Object[] val = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, id};
        this.session.findObjectsInit(attrTypeID, val);
        pkcs11obj = this.session.findObject();
        this.session.findObjectsFinal();
        if (pkcs11obj == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deleteChain", (Object)"Delete Cert not found.");
            }
            return;
        }
        if (debug != null) {
            debug.text(16384L, (Object)className, "deleteChain", "Delete Cert found.");
        }
        subject = (byte[])this.getValue(pkcs11obj, 257);
        issuer = (byte[])this.getValue(pkcs11obj, 129);
        pkcs11obj.destroy();
        if (this.bytesEquals(issuer, subject)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deleteChain", (Object)"Deleted Cert self-signed.");
            }
            return;
        }
        subject = issuer;
        while (true) {
            Object[] attrVal = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, issuer};
            this.session.findObjectsInit(attrTypeSub, attrVal);
            pkcs11obj = this.session.findObject();
            this.session.findObjectsFinal();
            if (debug != null) {
                debug.text(16384L, (Object)className, "deleteChain", "Delete Chain Cert pkcs11obj = " + pkcs11obj);
            }
            if (pkcs11obj == null) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "deleteChain", "Certificate chain deletion error. Certificate not found");
                    debug.exit(16384L, (Object)className, "deleteChain");
                }
                throw new RuntimeException("Certificate chain deletion error. Certificate not found");
            }
            subject = (byte[])this.getValue(pkcs11obj, 257);
            issuer = (byte[])this.getValue(pkcs11obj, 129);
            Object[] valIss = new Object[]{Boolean.TRUE, PKCS11Object.CERTIFICATE, subject};
            this.session.findObjectsInit(attrTypeIss, valIss);
            PKCS11Object delete = this.session.findObject();
            this.session.findObjectsFinal();
            if (this.bytesEquals(issuer, subject)) {
                if (debug == null) break;
                debug.text(16384L, (Object)className, "deleteChain", "Delete Chain Cert is self-signed.");
                break;
            }
            subject = issuer;
            if (debug != null) {
                debug.text(16384L, (Object)className, "deleteChain", "Delete Chain Cert delete = " + delete);
            }
            if (delete != null) continue;
            pkcs11obj.destroy();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteChain");
        }
    }

    public Enumeration engineAliases() {
        return this.entries.keys();
    }

    public boolean engineContainsAlias(String alias) {
        return this.entries.containsKey(alias.toLowerCase());
    }

    public int engineSize() {
        return this.entries.size();
    }

    public boolean engineIsKeyEntry(String alias) {
        boolean isKey = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && (entry instanceof PrivateKeyEntry || entry instanceof SecretKeyEntry)) {
            isKey = true;
        }
        return isKey;
    }

    public boolean engineIsCertificateEntry(String alias) {
        boolean isCert = false;
        Object entry = this.entries.get(alias.toLowerCase());
        if (entry != null && entry instanceof TrustedCertEntry) {
            isCert = true;
        }
        return isCert;
    }

    public String engineGetCertificateAlias(Certificate cert) {
        Enumeration e = this.entries.keys();
        while (e.hasMoreElements()) {
            Certificate certElem;
            String alias = (String)e.nextElement();
            Object entry = this.entries.get(alias);
            if (entry instanceof TrustedCertEntry) {
                certElem = ((TrustedCertEntry)entry).cert;
            } else {
                if (!(entry instanceof PrivateKeyEntry) || ((PrivateKeyEntry)entry).chain == null) continue;
                certElem = ((PrivateKeyEntry)entry).chain[0];
            }
            if (!certElem.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException("This method is not supported");
    }

    public void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (param == null) {
            throw new IllegalArgumentException("LoadStoreParameter must not be null");
        }
        KeyStore.ProtectionParameter protectionParam = param.getProtectionParameter();
        if (protectionParam instanceof KeyStore.PasswordProtection) {
            char[] pwd = ((KeyStore.PasswordProtection)protectionParam).getPassword();
            this.engineLoad(null, pwd);
        } else if (protectionParam instanceof KeyStore.CallbackHandlerProtection) {
            CallbackHandler handler = ((KeyStore.CallbackHandlerProtection)protectionParam).getCallbackHandler();
            Provider p1 = Security.getProvider(this.providerName);
            try {
                ((IBMPKCS11Impl)p1).login(null, handler);
            }
            catch (PKCS11Exception pex) {
                if (pex.getCode() != 256) {
                    throw new IOException(pex.getMessage());
                }
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
            this.engineLoad(null, null);
        } else {
            throw new IllegalArgumentException("ProtectionParameter must be aPasswordProtection or CallbackHandlerProtection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineLoad");
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            CertificateFactory certFactory;
            Object obj;
            PKCS11Object pkcs11obj;
            block116: {
                if (password != null) {
                    block115: {
                        try {
                            this.session.login(false, (Object)new String(password));
                        }
                        catch (PKCS11Exception pex) {
                            if (pex.getCode() == 256) break block115;
                            throw new IOException(pex.getMessage());
                        }
                    }
                    password = null;
                }
                this.entries.clear();
                pkcs11obj = null;
                obj = null;
                certFactory = null;
                try {
                    certFactory = CertificateFactory.getInstance("X509", this.providerName);
                }
                catch (Exception ee) {
                    if (debug == null) break block116;
                    ee.printStackTrace();
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "engineLoad");
                    }
                    System.exit(1);
                }
            }
            Vector<PKCS11Object> privKeys = new Vector<PKCS11Object>();
            Vector<PKCS11Object> secretKeys = new Vector<PKCS11Object>();
            Vector<PKCS11Object> certs = new Vector<PKCS11Object>();
            this.session.findObjectsInit(null, null);
            while ((pkcs11obj = this.session.findObject()) != null) {
                obj = this.getValue(pkcs11obj, 0);
                if (obj != null && ((Integer)obj).equals(PKCS11Object.PRIVATE_KEY)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "found PRIVATE KEY");
                    }
                    privKeys.add(pkcs11obj);
                    continue;
                }
                if (obj != null && ((Integer)obj).equals(PKCS11Object.CERTIFICATE)) {
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "found CERTIFICATE");
                    }
                    certs.add(pkcs11obj);
                    continue;
                }
                if (obj == null || !((Integer)obj).equals(PKCS11Object.SECRET_KEY)) continue;
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineLoad", "found SECRET_KEY");
                }
                secretKeys.add(pkcs11obj);
            }
            this.session.findObjectsFinal();
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineLoad", "# privkeys=" + privKeys.size() + " # certs=" + certs.size() + " # secret keys=" + secretKeys.size());
            }
            String tmpKeyName = "privateKey";
            int nameNum = 0;
            int num = 0;
            if (privKeys.size() > 0) {
                Enumeration en = privKeys.elements();
                boolean p = false;
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineLoad", "now find key and certs");
                }
                while (en.hasMoreElements()) {
                    X509Certificate[] chain;
                    PrivateKeyInfo key;
                    String label;
                    PKCS11Object pobj;
                    block120: {
                        byte[] id;
                        block117: {
                            pobj = (PKCS11Object)en.nextElement();
                            label = (String)this.getValue(pobj, 3);
                            id = (byte[])this.getValue(pobj, 258);
                            byte[] sub = (byte[])this.getValue(pobj, 257);
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "within the private key loop");
                            }
                            String empty = "e";
                            if (id == null) continue;
                            Integer keytype = (Integer)this.getValue(pobj, 256);
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "Key Type=" + keytype.toString());
                            }
                            key = null;
                            if (keytype.equals(PKCS11Object.RSA)) {
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure RSA(...) clear");
                                    }
                                    key = new RSAPrivateKey(this.session, pobj, (byte[])this.getValue(pobj, 258), (byte[])this.getValue(pobj, 257), (String)this.getValue(pobj, 3), (Boolean)this.getValue(pobj, 1), (Boolean)this.getValue(pobj, 259), (Boolean)this.getValue(pobj, 264), (Boolean)this.getValue(pobj, 261), (Boolean)this.getValue(pobj, 263), (Boolean)this.getValue(pobj, 354), (BigInteger)this.getValue(pobj, 288), (BigInteger)this.getValue(pobj, 290), (BigInteger)this.getValue(pobj, 291), (BigInteger)this.getValue(pobj, 292), (BigInteger)this.getValue(pobj, 293), (BigInteger)this.getValue(pobj, 294), (BigInteger)this.getValue(pobj, 295), (BigInteger)this.getValue(pobj, 296));
                                }
                                catch (Exception ike) {
                                    try {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "Constructure RSA() hardware");
                                        }
                                        key = new RSAPrivateKey(this.session, pobj, (byte[])this.getValue(pobj, 258), (byte[])this.getValue(pobj, 257), (String)this.getValue(pobj, 3), (Boolean)this.getValue(pobj, 1), (Boolean)this.getValue(pobj, 259), (Boolean)this.getValue(pobj, 264), (Boolean)this.getValue(pobj, 261), (Boolean)this.getValue(pobj, 263), (Boolean)this.getValue(pobj, 354), (BigInteger)this.getValue(pobj, 288), (BigInteger)this.getValue(pobj, 290));
                                        break block117;
                                    }
                                    catch (InvalidKeyException ikee) {
                                        if (debug != null) {
                                            debug.exception(16384L, (Object)className, "engineLoad_2", (Throwable)ikee);
                                        }
                                        break block117;
                                    }
                                }
                            }
                            if (!keytype.equals(PKCS11Object.DSA)) continue;
                            try {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "Constructure DSA(...) clear");
                                }
                                key = new DSAPrivateKey(this.session, pobj, (String)this.getValue(pobj, 3), (byte[])this.getValue(pobj, 258), (byte[])this.getValue(pobj, 257), (Boolean)this.getValue(pobj, 1), (Boolean)this.getValue(pobj, 259), (Boolean)this.getValue(pobj, 354), (BigInteger)this.getValue(pobj, 304), (BigInteger)this.getValue(pobj, 305), (BigInteger)this.getValue(pobj, 306), new BigInteger(1, (byte[])this.getValue(pobj, 17)));
                            }
                            catch (Exception ike) {
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure DSA() hardware");
                                    }
                                    key = new DSAPrivateKey(this.session, pobj, (String)this.getValue(pobj, 3), (byte[])this.getValue(pobj, 258), (byte[])this.getValue(pobj, 257), (Boolean)this.getValue(pobj, 1), (Boolean)this.getValue(pobj, 259), (Boolean)this.getValue(pobj, 354));
                                }
                                catch (InvalidKeyException ikee) {
                                    if (debug == null) break block117;
                                    debug.exception(16384L, (Object)className, "engineLoad_3", (Throwable)ikee);
                                }
                            }
                        }
                        int j = certs.size();
                        Enumeration e = certs.elements();
                        PKCS11Object cobj = null;
                        ArrayList<X509Certificate> certsArray = new ArrayList<X509Certificate>();
                        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
                        X509Certificate keyCert = null;
                        X509Certificate cert = null;
                        chain = null;
                        byte[] origMsg = "testmessage_a very long test message".getBytes();
                        for (int k = 0; k < j; ++k) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "going through cert objects");
                            }
                            cobj = (PKCS11Object)e.nextElement();
                            byte[] tid = (byte[])this.getValue(cobj, 258);
                            byte[] tsub = (byte[])this.getValue(cobj, 257);
                            byte[] bytearray = (byte[])this.getValue(cobj, 17);
                            ByteArrayInputStream bais = new ByteArrayInputStream(bytearray);
                            cert = (X509Certificate)certFactory.generateCertificate(bais);
                            if (tid != null && this.bytesEquals(id, tid)) {
                                block119: {
                                    Signature sig;
                                    PublicKey pubkey;
                                    block118: {
                                        pubkey = cert.getPublicKey();
                                        sig = null;
                                        try {
                                            sig = Signature.getInstance(key.getAlgorithm(), this.providerName);
                                        }
                                        catch (Exception ex) {
                                            sig = Signature.getInstance(key.getAlgorithm());
                                            if (debug == null) break block118;
                                            debug.text(16384L, (Object)className, "engineLoad", "Error creating signature: " + ex.getMessage());
                                        }
                                    }
                                    try {
                                        sig.initSign((PrivateKey)key);
                                        sig.update(origMsg);
                                        byte[] signature = sig.sign();
                                        sig.initVerify(pubkey);
                                        sig.update(origMsg);
                                        if (sig.verify(signature)) {
                                            keyCert = cert;
                                        }
                                    }
                                    catch (Exception ex) {
                                        if (debug == null) break block119;
                                        debug.text(16384L, (Object)className, "engineLoad", "Error checking signature: " + ex.getMessage());
                                    }
                                }
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "found cert at pos" + k + " # of certs now = " + certsArray.size());
                                    debug.text(16384L, (Object)className, "engineLoad", "found cert = " + keyCert);
                                }
                            }
                            certsArray.add(cert);
                            trustAnchors.add(new TrustAnchor(cert, null));
                        }
                        if (keyCert != null) {
                            try {
                                CertPathBuilder cpb = CertPathBuilder.getInstance("PKIX", "IBMCertPath");
                                X509CertSelector targetConstraints = new X509CertSelector();
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "building certpath");
                                }
                                targetConstraints.setCertificate(keyCert);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "Subject = " + ((Object)keyCert.getSubjectDN()).toString());
                                }
                                PKIXBuilderParameters params = new PKIXBuilderParameters(trustAnchors, (CertSelector)targetConstraints);
                                params.setRevocationEnabled(false);
                                params.setMaxPathLength(-1);
                                CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(certsArray);
                                CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "IBMCertPath");
                                params.addCertStore(store);
                                try {
                                    PKIXCertPathBuilderResult cpresult = (PKIXCertPathBuilderResult)cpb.build(params);
                                    CertPath cp = cpresult.getCertPath();
                                    if (cp != null) {
                                        List<? extends Certificate> cpcerts = cp.getCertificates();
                                        int i = 0;
                                        chain = new X509Certificate[cpcerts.size() + 1];
                                        Iterator<? extends Certificate> cpIterator = cpcerts.iterator();
                                        while (cpIterator.hasNext()) {
                                            chain[i++] = (X509Certificate)cpIterator.next();
                                        }
                                        chain[i] = cpresult.getTrustAnchor().getTrustedCert();
                                    }
                                }
                                catch (CertPathBuilderException cpbe) {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad_0", "could not build CertPath for certificate " + cpbe.getMessage());
                                    }
                                    chain = null;
                                }
                            }
                            catch (Exception ex) {
                                if (debug == null) break block120;
                                debug.exception(16384L, (Object)className, "engineLoad_1", (Throwable)ex);
                            }
                        }
                    }
                    PrivateKeyEntry keyEntry = new PrivateKeyEntry();
                    keyEntry.key = key;
                    keyEntry.keyObject = pobj;
                    keyEntry.chain = chain;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "Entry: \n key =" + key.toString() + "\nkeyObject =" + pobj + "\nchain = " + chain + "\nLabel = " + label);
                    }
                    if (label != null && label.length() != 0) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label != null");
                        }
                        if (!this.entries.containsKey(label.toLowerCase())) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label empty");
                            }
                            this.entries.put(label.toLowerCase(), keyEntry);
                            if (debug == null) continue;
                            debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put key entry[" + label.toLowerCase() + "] to entries");
                            continue;
                        }
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                        }
                        boolean foundLabel = false;
                        while (!foundLabel) {
                            String newLabel = label + "key" + num;
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "finding label: " + newLabel);
                            }
                            if (this.entries.get(newLabel.toLowerCase()) == null) {
                                this.entries.put(newLabel.toLowerCase(), keyEntry);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put key entry[" + newLabel.toLowerCase() + "] to entries");
                                }
                                foundLabel = true;
                                continue;
                            }
                            ++num;
                        }
                        continue;
                    }
                    boolean foundName = false;
                    while (!foundName) {
                        String keyName = tmpKeyName + nameNum;
                        if (!this.entries.containsKey(keyName.toLowerCase())) {
                            this.entries.put(keyName.toLowerCase(), keyEntry);
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put key entry[" + keyName.toLowerCase() + "] to entries");
                            }
                            foundName = true;
                            continue;
                        }
                        ++nameNum;
                    }
                }
                privKeys.removeAllElements();
            }
            tmpKeyName = "secretKey";
            nameNum = 0;
            num = 0;
            if (secretKeys.size() > 0) {
                int j = secretKeys.size();
                Enumeration e = secretKeys.elements();
                block45: for (int k = 0; k < j; ++k) {
                    GeneralKey key;
                    String label;
                    PKCS11Object sobj;
                    block122: {
                        block121: {
                            sobj = null;
                            label = null;
                            try {
                                sobj = (PKCS11Object)e.nextElement();
                                label = (String)this.getValue(sobj, 3);
                                if (debug == null) break block121;
                                debug.text(16384L, (Object)className, "engineLoad", "sobj: " + sobj);
                            }
                            catch (NoSuchElementException nsee) {
                                k = j;
                                continue;
                            }
                        }
                        Integer keytype = (Integer)this.getValue(sobj, 256);
                        key = null;
                        try {
                            switch (keytype) {
                                case 19: {
                                    key = new GeneralKey(this.session, sobj, "DES");
                                    break block122;
                                }
                                case 21: {
                                    key = new GeneralKey(this.session, sobj, "DESede");
                                    break block122;
                                }
                                case 18: {
                                    key = new GeneralKey(this.session, sobj, "RC4");
                                    break block122;
                                }
                                case 31: {
                                    key = new GeneralKey(this.session, sobj, "AES");
                                    break block122;
                                }
                                case 16: {
                                    key = new GeneralKey(this.session, sobj, "Generic");
                                    break block122;
                                }
                                case 32: {
                                    key = new GeneralKey(this.session, sobj, "BLOWFISH");
                                    break block122;
                                }
                                default: {
                                    if (debug == null) continue block45;
                                    debug.text(16384L, (Object)className, "engineLoad_4", "Key Type not supported. " + keytype);
                                    break;
                                }
                            }
                            continue;
                        }
                        catch (Exception ikee) {
                            if (debug == null) break block122;
                            debug.exception(16384L, (Object)className, "engineLoad_4.1", (Throwable)ikee);
                        }
                    }
                    SecretKeyEntry keyEntry = new SecretKeyEntry();
                    keyEntry.key = key;
                    keyEntry.keyObject = sobj;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "Secret Entry: \n key =" + ((Object)key).toString() + "\nkeyObject =" + sobj + "\nLabel = " + label);
                    }
                    if (label != null && label.length() != 0) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label != null");
                        }
                        if (this.entries.get(label.toLowerCase()) == null) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label empty");
                            }
                            this.entries.put(label.toLowerCase(), keyEntry);
                            if (debug == null) continue;
                            debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put secret key entry[" + label.toLowerCase() + "] to entries");
                            continue;
                        }
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                        }
                        boolean foundLabel = false;
                        while (!foundLabel) {
                            String newLabel;
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "finding label");
                            }
                            if (this.entries.get((newLabel = label + "sec" + num).toLowerCase()) == null) {
                                this.entries.put(newLabel.toLowerCase(), keyEntry);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put secret key entry[" + newLabel.toLowerCase() + "] to entries");
                                }
                                foundLabel = true;
                                continue;
                            }
                            ++num;
                        }
                        continue;
                    }
                    boolean foundName = false;
                    while (!foundName) {
                        String keyName = tmpKeyName + nameNum;
                        if (!this.entries.containsKey(keyName.toLowerCase())) {
                            this.entries.put(keyName.toLowerCase(), keyEntry);
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put secret key entry[" + keyName.toLowerCase() + "] to entries");
                            }
                            foundName = true;
                            continue;
                        }
                        ++nameNum;
                    }
                }
                secretKeys.removeAllElements();
            }
            String tmpCertName = "cert";
            nameNum = 0;
            if (certs.size() > 0) {
                int j = certs.size();
                Enumeration e = certs.elements();
                for (int k = 0; k < j; ++k) {
                    byte[] bytearray;
                    String label;
                    PKCS11Object cobj;
                    block124: {
                        block123: {
                            cobj = null;
                            try {
                                cobj = (PKCS11Object)e.nextElement();
                                if (debug == null) break block123;
                                debug.text(16384L, (Object)className, "engineLoad", "cobj: " + cobj);
                            }
                            catch (NoSuchElementException nsee) {
                                k = j;
                                continue;
                            }
                        }
                        label = (String)this.getValue(cobj, 3);
                        byte[] id = (byte[])this.getValue(cobj, 258);
                        bytearray = null;
                        try {
                            bytearray = (byte[])this.getValue(cobj, 17);
                        }
                        catch (Exception ex) {
                            if (debug == null) break block124;
                            debug.text(16384L, (Object)className, "engineLoad", "tries to get cert value2");
                            ex.printStackTrace();
                        }
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytearray);
                    TrustedCertEntry ce = new TrustedCertEntry();
                    ce.cert = certFactory.generateCertificate(bais);
                    ce.certObject = cobj;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "Trusted Cert Entry: \n cert =" + ce.cert.toString() + "\n CertObject =" + cobj + "\nLabel = " + label);
                    }
                    if (label != null && label.length() != 0) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label != null");
                        }
                        if (this.entries.get(label.toLowerCase()) == null) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label empty");
                            }
                            this.entries.put(label.toLowerCase(), ce);
                            if (debug == null) continue;
                            debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put cert entry[" + label.toLowerCase() + "] to entries");
                            continue;
                        }
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                        }
                        boolean foundLabel = false;
                        while (!foundLabel) {
                            String newLabel;
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "finding label");
                            }
                            if (this.entries.get((newLabel = label + "cert" + num).toLowerCase()) == null) {
                                this.entries.put(newLabel.toLowerCase(), ce);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put cert entry[" + newLabel.toLowerCase() + "] to entries");
                                }
                                foundLabel = true;
                                continue;
                            }
                            ++num;
                        }
                        continue;
                    }
                    boolean foundName = false;
                    while (!foundName) {
                        String keyName = tmpCertName + nameNum;
                        if (!this.entries.containsKey(keyName.toLowerCase())) {
                            this.entries.put(keyName.toLowerCase(), ce);
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "PKCS11IMPLKS: put cert entry[" + keyName.toLowerCase() + "] to entries");
                            }
                            foundName = true;
                            continue;
                        }
                        ++nameNum;
                    }
                }
                certs.removeAllElements();
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineLoad");
        }
    }

    private Object getValue(PKCS11Object pkcs11obj, int attr) {
        Object obj = null;
        try {
            obj = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            return null;
        }
        return obj;
    }

    private Object[] getAttributes(PKCS11Object pkcs11obj) {
        return null;
    }

    private boolean bytesEquals(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    protected void finalize() {
    }

    class TrustedCertEntry {
        Certificate cert;
        PKCS11Object certObject;

        TrustedCertEntry() {
        }
    }

    class SecretKeyEntry {
        Key key;
        PKCS11Object keyObject;

        SecretKeyEntry() {
        }
    }

    class PrivateKeyEntry {
        Key key;
        PKCS11Object keyObject;
        Certificate[] chain;

        PrivateKeyEntry() {
        }
    }
}

