/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.ConstructKeys;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Cipher;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public final class RSACipher
extends CipherSpi {
    private boolean decrypting = false;
    SecureRandom random = null;
    PKCS11Cipher cipher = null;
    private PKCS11Key hw_key_to_delete = null;
    private int mechanism;
    private PKCS11Session session = null;
    private Provider provider = null;
    private Config config = null;
    private int paddingIndicator = 0;
    private BigInteger modulus;
    private byte[] data = null;
    private int dataUsed = 0;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSACipher";

    public RSACipher(Provider provider) {
        IBMPKCS11Impl.verifyJceJar();
        if (!IBMPKCS11Impl.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBM JCE PKCS11 provider may have been tampered.");
        }
        this.provider = provider;
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.mechanism = 1;
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode != null && (mode.equals(" ") || mode.equals("SSL"))) {
            return;
        }
        if (mode != null) {
            throw new NoSuchAlgorithmException("Mode: " + mode + " not implemented");
        }
    }

    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSetPadding", (Object)("." + paddingScheme + "."));
        }
        if (paddingScheme.equalsIgnoreCase("PKCS1Padding") || paddingScheme.equalsIgnoreCase("PKCS")) {
            this.paddingIndicator = 0;
            this.mechanism = 1;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineSetPadding", (Object)"PKCS");
            }
            return;
        }
        if (paddingScheme.equals(" ") || paddingScheme.equalsIgnoreCase("NoPadding") || paddingScheme == null) {
            this.paddingIndicator = 1;
            this.mechanism = 3;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "engineSetPadding", (Object)"RAW RSA");
            }
            return;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSetPadding", (Object)"No such padding.");
        }
        throw new NoSuchPaddingException("Padding: " + paddingScheme + " not implemented");
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected int engineGetOutputSize(int inputLen) {
        return this.modulus.toByteArray().length;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        PKCS11Key p11key;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInit");
        }
        this.decrypting = opmode == 2 || opmode == 4;
        if (key == null) {
            throw new InvalidKeyException("No key given");
        }
        String pszkey = key.getAlgorithm();
        if (!pszkey.equals("RSA")) {
            throw new InvalidKeyException("Not a RSA key.  Key algorithm is " + pszkey + ".");
        }
        if (key instanceof PublicKey) {
            if (this.decrypting) {
                throw new InvalidKeyException("Public Key cannot be used to decrypt.");
            }
            if (key instanceof PKCS11Key) {
                p11key = (PKCS11Key)key;
            } else if (key instanceof RSAPublicKey) {
                KeyFactory kf = null;
                try {
                    kf = KeyFactory.getInstance("RSA", this.provider);
                    this.hw_key_to_delete = p11key = (PKCS11Key)kf.translateKey(key);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInit");
                    }
                    throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("not RSA key"));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidKeyException("not RSA key: " + key);
            }
            try {
                RSAPublicKey pub = (RSAPublicKey)key;
                this.modulus = pub.getModulus();
            }
            catch (Exception ex) {
                throw new InvalidKeyException("Bad key encoding");
            }
        } else if (key instanceof PrivateKey) {
            if (!this.decrypting) {
                throw new InvalidKeyException("Private key cannot be used to encrypt.");
            }
            if (key instanceof PKCS11Key) {
                p11key = (PKCS11Key)key;
            } else if (key instanceof RSAPrivateKey || key instanceof RSAPrivateCrtKey) {
                KeyFactory kf = null;
                try {
                    kf = KeyFactory.getInstance("RSA", this.provider);
                    this.hw_key_to_delete = p11key = (PKCS11Key)kf.translateKey(key);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInit");
                    }
                    throw new InvalidKeyException("Cannot convert key: " + key + " with reason: " + e.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInit", (Throwable)new InvalidKeyException("not RSA key"));
                    debug.exit(16384L, (Object)className, "engineInit");
                }
                throw new InvalidKeyException("not RSA key: " + key);
            }
            try {
                RSAPrivateKey priv = (RSAPrivateKey)key;
                this.modulus = priv.getModulus();
            }
            catch (Exception ex) {
                throw new InvalidKeyException("Bad key encoding");
            }
        } else {
            throw new InvalidKeyException("Must be either public key or private key.");
        }
        this.data = new byte[(this.modulus.bitLength() + 7) / 8];
        this.dataUsed = 0;
        this.cipher = new PKCS11Cipher(this.mechanism, this.session, this.provider);
        this.cipher.engineInit(opmode, p11key.getObject(), null, (this.modulus.bitLength() + 7) / 8);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInit");
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, random);
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (this.dataUsed + inputLen > this.data.length) {
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        System.arraycopy(input, inputOffset, this.data, this.dataUsed, inputLen);
        this.dataUsed += inputLen;
        return new byte[0];
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (this.dataUsed + inputLen > this.data.length) {
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        System.arraycopy(input, inputOffset, this.data, this.dataUsed, inputLen);
        this.dataUsed += inputLen;
        return 0;
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (this.dataUsed + inputLen > this.data.length) {
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        if (inputLen != 0) {
            System.arraycopy(input, inputOffset, this.data, this.dataUsed, inputLen);
        }
        byte[] saved_rc = this.cipher.engineDoFinal(this.data, 0, this.dataUsed + inputLen);
        if (this.hw_key_to_delete != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"RSACipher", "engineDoFinal", "delete generated hw key");
            }
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return saved_rc;
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (this.dataUsed + inputLen > this.data.length) {
            throw new IllegalArgumentException("Input data too long for RSA encryption");
        }
        if (inputLen != 0) {
            System.arraycopy(input, inputOffset, this.data, this.dataUsed, inputLen);
        }
        int saved_rc = this.cipher.engineDoFinal(this.data, 0, this.dataUsed + inputLen, output, outputOffset);
        if (this.hw_key_to_delete != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"RSACipher", "engineDoFinal", "delete generated hw key");
            }
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return saved_rc;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof PublicKey) {
            try {
                BigInteger n = ((RSAPublicKey)key).getModulus();
                return n.bitLength();
            }
            catch (Exception ex) {
                throw new InvalidKeyException("Bad key encoding");
            }
        }
        if (key instanceof PrivateKey) {
            try {
                RSAPrivateKey priv = (RSAPrivateKey)key;
                BigInteger n = priv.getModulus();
                return n.bitLength();
            }
            catch (Exception ex) {
                throw new InvalidKeyException("Bad key encoding");
            }
        }
        throw new InvalidKeyException("Must be either public key or private key.");
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        int len = 0;
        len = (this.modulus.bitLength() + 7) / 8;
        byte[] saved_rc = this.cipher.engineWrap(((PKCS11Key)key).getObject(), len);
        if (this.hw_key_to_delete != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"RSACipher", "engineWrap", "delete generated hw key");
            }
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return saved_rc;
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        Key result = null;
        int[] attrTypes = null;
        Object[] attrValues = null;
        Object[] attrs = new Object[2];
        PKCS11Object objKey = null;
        switch (wrappedKeyType) {
            case 3: {
                attrs = ConstructKeys.constructSecretKeyAttrs(wrappedKeyAlgorithm, this.config);
                attrTypes = (int[])attrs[0];
                attrValues = (Object[])attrs[1];
                objKey = this.cipher.engineUnwrap(wrappedKey, attrTypes, attrValues);
                result = ConstructKeys.constructSecretKey(objKey, wrappedKeyAlgorithm, this.provider);
                break;
            }
            case 2: {
                attrs = ConstructKeys.constructPrivateKeyAttrs(wrappedKeyAlgorithm, this.config);
                attrTypes = (int[])attrs[0];
                attrValues = (Object[])attrs[1];
                objKey = this.cipher.engineUnwrap(wrappedKey, attrTypes, attrValues);
                result = ConstructKeys.constructPrivateKey(objKey, wrappedKeyAlgorithm, this.provider);
                break;
            }
            case 1: {
                attrs = ConstructKeys.constructPublicKeyAttrs(wrappedKeyAlgorithm, this.config);
                attrTypes = (int[])attrs[0];
                attrValues = (Object[])attrs[1];
                objKey = this.cipher.engineUnwrap(wrappedKey, attrTypes, attrValues);
                result = ConstructKeys.constructPublicKey(objKey, wrappedKeyAlgorithm, this.provider);
            }
        }
        if (this.hw_key_to_delete != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"RSACipher", "engineUnwrap", "delete generated hw key");
            }
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return result;
    }
}

