/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPrivateKey;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Date;

public final class RSAPrivateKey
extends PrivateKeyInfo
implements PKCS11RSAPrivateKey,
Serializable {
    private PKCS11Object object = null;
    private PKCS11Session session = null;
    static final long serialVersionUID = 4424187430958879494L;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.RSA;
    private byte[] id = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isSensitive = null;
    private Boolean isSecondaryAuth = null;
    private Integer authPinFlags = null;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private Boolean isSignRecover = null;
    private Boolean isUnwrap = null;
    private Boolean isExtractable = null;
    private Boolean isAlwaysSensitive = null;
    private Boolean isNeverExtractable = null;
    private BigInteger modulus = null;
    private BigInteger publicExponent = null;
    private BigInteger privateExponent = null;
    private BigInteger prime1 = null;
    private BigInteger prime2 = null;
    private BigInteger exponent1 = null;
    private BigInteger exponent2 = null;
    private BigInteger coefficient = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey";

    public RSAPrivateKey(PKCS11Session session, PKCS11Object object, byte[] id, byte[] subject, String label, Boolean isToken, Boolean isSensitive, Boolean isSign, Boolean isDecrypt, Boolean isUnwrap, Boolean isExtractable, BigInteger modulus, BigInteger publicExponent) throws InvalidKeyException {
        if (debug != null) {
            Object[] parms = new Object[]{object, id, subject, label, isToken, isSensitive, isSign, isDecrypt, isUnwrap, isExtractable, modulus, publicExponent};
            debug.entry(16384L, (Object)className, "RSAPrivateKey", parms);
        }
        this.session = session;
        this.object = object;
        if (id != null) {
            this.id = new byte[id.length];
            System.arraycopy(id, 0, this.id, 0, id.length);
        } else {
            this.id = (byte[])this.getValue(this.object, 258);
        }
        if (subject != null) {
            this.subject = new byte[subject.length];
            System.arraycopy(subject, 0, this.subject, 0, subject.length);
        } else {
            this.subject = (byte[])this.getValue(this.object, 257);
        }
        this.label = label != null ? new String(label) : (String)this.getValue(this.object, 3);
        this.isToken = (Boolean)this.getValue(this.object, 1);
        this.isSensitive = (Boolean)this.getValue(this.object, 259);
        this.isSign = (Boolean)this.getValue(this.object, 264);
        this.isDecrypt = (Boolean)this.getValue(this.object, 261);
        this.isUnwrap = (Boolean)this.getValue(this.object, 263);
        this.isExtractable = (Boolean)this.getValue(this.object, 354);
        if (modulus != null) {
            this.modulus = new BigInteger(modulus.toByteArray());
        }
        if (publicExponent != null) {
            this.publicExponent = new BigInteger(publicExponent.toByteArray());
        }
        this.isPrivate = (Boolean)this.getValue(this.object, 2);
        this.isModifiable = (Boolean)this.getValue(this.object, 368);
        this.startDate = (Date)this.getValue(this.object, 272);
        this.endDate = (Date)this.getValue(this.object, 273);
        this.isDerive = (Boolean)this.getValue(this.object, 268);
        this.isLocal = (Boolean)this.getValue(this.object, 355);
        this.isSecondaryAuth = (Boolean)this.getValue(this.object, 512);
        this.authPinFlags = (Integer)this.getValue(this.object, 513);
        this.isSignRecover = (Boolean)this.getValue(this.object, 265);
        this.isAlwaysSensitive = (Boolean)this.getValue(this.object, 357);
        this.isNeverExtractable = (Boolean)this.getValue(this.object, 356);
        RSAKeyFactory.checkKeyLengths((int)modulus.bitLength(), (BigInteger)publicExponent, (int)512, (int)Integer.MAX_VALUE);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPrivateKey");
        }
    }

    public RSAPrivateKey(PKCS11Session session, PKCS11Object object, byte[] id, byte[] subject, String label, Boolean isToken, Boolean isSensitive, Boolean isSign, Boolean isDecrypt, Boolean isUnwrap, Boolean isExtractable, BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger prime1, BigInteger prime2, BigInteger exponent1, BigInteger exponent2, BigInteger coefficient) throws InvalidKeyException {
        this(session, object, id, subject, label, isToken, isSensitive, isSign, isDecrypt, isUnwrap, isExtractable, modulus, publicExponent);
        if (debug != null) {
            Object[] parms = new Object[]{object, id, subject, label, isToken, isSensitive, isSign, isDecrypt, isUnwrap, isExtractable, modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient};
            debug.entry(16384L, (Object)className, "RSAPrivateKey", parms);
        }
        if (privateExponent != null) {
            this.privateExponent = new BigInteger(privateExponent.toByteArray());
        }
        if (prime1 != null) {
            this.prime1 = new BigInteger(prime1.toByteArray());
        }
        if (prime2 != null) {
            this.prime2 = new BigInteger(prime2.toByteArray());
        }
        if (exponent1 != null) {
            this.exponent1 = new BigInteger(exponent1.toByteArray());
        }
        if (exponent2 != null) {
            this.exponent2 = new BigInteger(exponent2.toByteArray());
        }
        if (coefficient != null) {
            this.coefficient = new BigInteger(coefficient.toByteArray());
        }
        this.algid = new AlgIdRSA();
        if (this.modulus != null && this.privateExponent != null && this.publicExponent != null && this.prime1 != null && this.prime2 != null && this.exponent1 != null && this.exponent2 != null && this.coefficient != null) {
            try {
                DerValue[] value = new DerValue[9];
                value[0] = new DerValue(2, version.toByteArray());
                value[1] = new DerValue(2, this.modulus.toByteArray());
                value[2] = new DerValue(2, this.publicExponent.toByteArray());
                value[3] = new DerValue(2, this.privateExponent.toByteArray());
                value[4] = new DerValue(2, this.prime1.toByteArray());
                value[5] = new DerValue(2, this.prime2.toByteArray());
                value[6] = new DerValue(2, this.exponent1.toByteArray());
                value[7] = new DerValue(2, this.exponent2.toByteArray());
                value[8] = new DerValue(2, this.coefficient.toByteArray());
                DerOutputStream out = new DerOutputStream();
                out.putSequence(value);
                this.key = out.toByteArray();
                this.encode();
            }
            catch (IOException e) {
                throw new InvalidKeyException("could not DER encode: " + e.getMessage());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "RSAPrivateKey");
            }
        }
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public Boolean getToken() {
        return new Boolean(this.isToken);
    }

    public void rm() {
        if (this.object != null) {
            try {
                this.getObject().destroy();
                this.object = null;
            }
            catch (PKCS11Exception pKCS11Exception) {
                // empty catch block
            }
        }
    }

    public Boolean getPrivate() {
        return new Boolean(this.isPrivate);
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getModifiable() {
        return new Boolean(this.isModifiable);
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public byte[] getID() {
        return (byte[])this.id.clone();
    }

    public Date getStartDate() {
        if (this.startDate != null) {
            return (Date)this.startDate.clone();
        }
        return null;
    }

    public Date getEndDate() {
        if (this.endDate != null) {
            return (Date)this.endDate.clone();
        }
        return null;
    }

    public Boolean getDerive() {
        return new Boolean(this.isDerive);
    }

    public Boolean getLocal() {
        return new Boolean(this.isLocal);
    }

    public byte[] getSubject() {
        if (this.subject == null) {
            return null;
        }
        return (byte[])this.subject.clone();
    }

    public Boolean getSensitive() {
        return new Boolean(this.isSensitive);
    }

    public Boolean getSecondaryAuth() {
        return new Boolean(this.isSecondaryAuth);
    }

    public Integer getAuthPinFlags() {
        return this.authPinFlags;
    }

    public Boolean getDecrypt() {
        return new Boolean(this.isDecrypt);
    }

    public Boolean getSign() {
        return new Boolean(this.isSign);
    }

    public Boolean getSignRecover() {
        return new Boolean(this.isSignRecover);
    }

    public Boolean getUnwrap() {
        return new Boolean(this.isUnwrap);
    }

    public Boolean getExtractable() {
        if (this.isExtractable == null) {
            return null;
        }
        return new Boolean(this.isExtractable);
    }

    public Boolean getAlwaysSensitive() {
        return new Boolean(this.isAlwaysSensitive);
    }

    public Boolean getNeverExtractable() {
        return new Boolean(this.isNeverExtractable);
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    public BigInteger getPrime1() {
        return this.prime1;
    }

    public BigInteger getPrime2() {
        return this.prime2;
    }

    public BigInteger getExponent1() {
        return this.exponent1;
    }

    public BigInteger getExponent2() {
        return this.exponent2;
    }

    public BigInteger getCoefficient() {
        return this.coefficient;
    }

    public BigInteger getPrimeP() {
        return this.prime1;
    }

    public BigInteger getPrimeQ() {
        return this.prime2;
    }

    public BigInteger getPrimeExponentP() {
        return this.exponent1;
    }

    public BigInteger getPrimeExponentQ() {
        return this.exponent2;
    }

    public BigInteger getCrtCoefficient() {
        return this.coefficient;
    }

    public PKCS11Session getSession() {
        return this.session;
    }

    public String toString() {
        String prov = "IBMPKCS11Impl";
        String output = prov + " RSA Private Key: ";
        if (this.isToken != null) {
            output = output + "\n Token: " + this.isToken;
        }
        if (this.isPrivate != null) {
            output = output + "\n Private: " + this.isPrivate;
        }
        if (this.label != null) {
            output = output + "\n Label: " + this.label;
        }
        if (this.isModifiable != null) {
            output = output + "\n Modifiable: " + this.isModifiable;
        }
        output = output + "\n KeyType: " + this.keyType.toString();
        if (this.id != null) {
            output = output + "\n ID: " + new String(this.id);
        }
        if (this.startDate != null) {
            output = output + "\n Start Date: " + this.startDate.toString();
        }
        if (this.endDate != null) {
            output = output + "\n End Date: " + this.endDate.toString();
        }
        if (this.isDerive != null) {
            output = output + "\n Derive: " + this.isDerive;
        }
        if (this.isLocal != null) {
            output = output + "\n Local: " + this.isLocal;
        }
        if (this.subject != null) {
            output = output + "\n Subject: " + new String(this.subject);
        }
        if (this.isSensitive != null) {
            output = output + "\n Sensitive: " + this.isSensitive;
        }
        if (this.isSecondaryAuth != null) {
            output = output + "\n SecondaryAuth: " + this.isSecondaryAuth;
        }
        if (this.authPinFlags != null) {
            output = output + "\n AuthPinFlags: " + Integer.toBinaryString(this.authPinFlags);
        }
        if (this.isDecrypt != null) {
            output = output + "\n Decrypt: " + this.isDecrypt;
        }
        if (this.isSign != null) {
            output = output + "\n sign: " + this.isSign;
        }
        if (this.isSignRecover != null) {
            output = output + "\n SignRecover: " + this.isSignRecover;
        }
        if (this.isExtractable != null) {
            output = output + "\n isExtractable: " + this.isExtractable;
        }
        if (this.isAlwaysSensitive != null) {
            output = output + "\n Always Sensitive: " + this.isAlwaysSensitive;
        }
        if (this.isNeverExtractable != null) {
            output = output + "\n Never Extractable: " + this.isNeverExtractable;
        }
        if (this.modulus != null) {
            output = output + "\n Modulus: " + this.modulus.toString();
        }
        if (this.publicExponent != null) {
            output = output + "\n Public Exponent: " + this.publicExponent.toString();
        }
        if (this.privateExponent != null) {
            output = output + "\n Private Exponent: " + this.privateExponent.toString();
        }
        if (this.prime1 != null) {
            output = output + "\n Prime1: " + this.prime1.toString();
        }
        if (this.prime2 != null) {
            output = output + "\n Prime2: " + this.prime2.toString();
        }
        if (this.exponent1 != null) {
            output = output + "\n Exponent1: " + this.exponent1.toString();
        }
        if (this.exponent2 != null) {
            output = output + "\n Exponent2: " + this.exponent2.toString();
        }
        if (this.coefficient != null) {
            output = output + "\n Coefficient: " + this.coefficient.toString();
        }
        return output;
    }

    private Object getValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }

    public String getFormat() {
        return "PKCS#11";
    }

    public String getAlgorithm() {
        return "RSA";
    }

    protected void finalize() {
    }
}

