/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPublicKey;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;

final class Signature {
    private MessageDigest msgdig;
    private PKCS11Key hw_key_to_delete = null;
    private PKCS11Session session;
    private PKCS11Object keyObject;
    private boolean isSign;
    private int mechanism;
    private int modSize = 256;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.Signature";
    private Provider provider;

    protected Signature(int mechanism, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Signature", (Object)new Integer(mechanism));
        }
        this.mechanism = mechanism;
        this.session = ((IBMPKCS11Impl)provider).getSession();
        this.provider = provider;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "Signature");
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            String keyString = privateKey.toString();
            debug.entry(16384L, (Object)className, "engineInitSign", (Object)keyString);
        }
        this.isSign = true;
        PrivateKey ppkey = privateKey;
        if (!(privateKey instanceof RSAPrivateKey) && !(privateKey instanceof DSAPrivateKey)) {
            if (privateKey instanceof java.security.interfaces.RSAPrivateKey || privateKey instanceof RSAPrivateCrtKey || privateKey instanceof java.security.interfaces.DSAPrivateKey) {
                KeyFactory kf = null;
                String alg = privateKey.getAlgorithm();
                try {
                    if (alg.equalsIgnoreCase("DSA")) {
                        kf = KeyFactory.getInstance("DSA", this.provider);
                        ppkey = (PKCS11PrivateKey)kf.translateKey(privateKey);
                        this.hw_key_to_delete = (PKCS11Key)((Object)ppkey);
                    }
                    kf = KeyFactory.getInstance("RSA", this.provider);
                    ppkey = (PKCS11PrivateKey)kf.translateKey(privateKey);
                    this.hw_key_to_delete = (PKCS11Key)((Object)ppkey);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInitSign_1", (Throwable)new InvalidKeyException("Cannot convert private key: " + privateKey + " with reason: " + e.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInitSign");
                    }
                    throw new InvalidKeyException("Cannot convert private key: " + privateKey + " with reason: " + e.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInitSign_2", (Throwable)new InvalidKeyException("not a PKCS11 DSA or PKCS11 RSA private key"));
                    debug.exit(16384L, (Object)className, "engineInitSign");
                }
                throw new InvalidKeyException("not a DSA or RSA private key: " + privateKey);
            }
        }
        if (ppkey instanceof RSAPrivateKey) {
            this.keyObject = ((RSAPrivateKey)ppkey).getObject();
            this.modSize = ((RSAPrivateKey)ppkey).getModulus().bitLength() / 8 + 10;
            RSAKeyFactory.checkKeyLengths((int)((RSAPrivateKey)ppkey).getModulus().bitLength(), (BigInteger)((RSAPrivateKey)ppkey).getPublicExponent(), (int)512, (int)Integer.MAX_VALUE);
        }
        if (ppkey instanceof DSAPrivateKey) {
            this.keyObject = ((DSAPrivateKey)ppkey).getObject();
        }
        this.session.signInit(this.mechanism, null, this.keyObject);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitSign");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            String keyString = publicKey.toString();
            debug.entry(16384L, (Object)className, "engineInitVerify", (Object)keyString);
        }
        this.isSign = false;
        PublicKey ppkey = publicKey;
        if (!(publicKey instanceof RSAPublicKey) && !(publicKey instanceof DSAPublicKey)) {
            if (publicKey instanceof java.security.interfaces.RSAPublicKey || publicKey instanceof java.security.interfaces.DSAPublicKey) {
                KeyFactory kf = null;
                String alg = publicKey.getAlgorithm();
                try {
                    if (alg.equalsIgnoreCase("DSA")) {
                        kf = KeyFactory.getInstance("DSA", this.provider);
                        ppkey = (PKCS11PublicKey)kf.translateKey(publicKey);
                        this.hw_key_to_delete = (PKCS11Key)((Object)ppkey);
                    }
                    kf = KeyFactory.getInstance("RSA", this.provider);
                    ppkey = (PKCS11PublicKey)kf.translateKey(publicKey);
                    this.hw_key_to_delete = (PKCS11Key)((Object)ppkey);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInitVerify_1", (Throwable)new InvalidKeyException("Cannot convert public key: " + publicKey + " with reason: " + e.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInitVerify");
                    }
                    throw new InvalidKeyException("Cannot convert public key: " + publicKey + " with reason: " + e.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInitVerify_2", (Throwable)new InvalidKeyException("not a DSA or RSA public key"));
                    debug.exit(16384L, (Object)className, "engineInitVerify");
                }
                throw new InvalidKeyException("not a DSA or RSA public key: " + publicKey);
            }
        }
        if (ppkey instanceof RSAPublicKey) {
            this.keyObject = ((RSAPublicKey)ppkey).getObject();
            RSAKeyFactory.checkKeyLengths((int)((RSAPublicKey)ppkey).getModulus().bitLength(), (BigInteger)((RSAPublicKey)ppkey).getPublicExponent(), (int)512, (int)Integer.MAX_VALUE);
        }
        if (ppkey instanceof DSAPublicKey) {
            this.keyObject = ((DSAPublicKey)ppkey).getObject();
        }
        this.session.verifyInit(this.mechanism, null, this.keyObject);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitVerify");
        }
    }

    protected void engineUpdate(byte[] data, int off, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{data, new Integer(off), new Integer(len)};
            debug.entry(16384L, (Object)className, "engineUpdate", parms);
        }
        if (this.isSign) {
            this.session.signUpdate(data, off, len);
        } else {
            this.session.verifyUpdate(data, off, len);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign");
        }
        int size = 0;
        byte[] signature = null;
        byte[] outdata = new byte[this.modSize];
        size = this.session.signFinal(outdata, 0);
        signature = new byte[size];
        System.arraycopy(outdata, 0, signature, 0, size);
        if (debug != null) {
            debug.text(16384L, (Object)className, "engineSign", "Sign() size = " + size);
            HexDumpEncoder hde = new HexDumpEncoder();
            debug.text(16384L, (Object)className, "engineSign", "outdata = " + hde.encode(outdata));
            debug.text(16384L, (Object)className, "engineSign", "signature = " + hde.encode(signature));
            debug.exit(16384L, (Object)className, "engineSign");
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return signature;
    }

    protected byte[] engineSign(byte[] data, int length) throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign", (Object)data, (Object)new Integer(length));
        }
        int size = 0;
        byte[] signature = null;
        byte[] outdata = new byte[this.modSize];
        size = this.session.sign(data, 0, length, outdata, 0);
        signature = new byte[size];
        System.arraycopy(outdata, 0, signature, 0, size);
        if (debug != null) {
            debug.text(16384L, (Object)className, "engineSign", "Sign(data, len) size = " + size);
            HexDumpEncoder hde = new HexDumpEncoder();
            debug.text(16384L, (Object)className, "engineSign", "signature(data, len) = " + hde.encode(signature));
            debug.exit(16384L, (Object)className, "engineSign");
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return signature;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        result = false;
        if (Signature.debug != null) {
            Signature.debug.entry(16384L, (Object)Signature.className, "engineVerify", (Object)signature);
        }
        if (Signature.debug != null) {
            Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature.length = " + signature.length);
            hde = new HexDumpEncoder();
            Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature = " + hde.encode(signature));
        }
        signingBytes = new byte[40];
        if (this.mechanism == 18 && signature.length != 40) {
            lenr = signature[3];
            lens = signature[lenr + 3 + 2];
            startPosR = 4;
            startPosS = lenr + 6;
            if (lens > 20) {
                lens = 20;
                startPosS = lenr + 6 + 1;
            }
            if (lenr > 20) {
                lenr = 20;
                startPosR = 5;
            }
            if (Signature.debug != null) {
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature len = " + signature[1]);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature lenr = " + lenr);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature lens = " + lens);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature startPosR = " + startPosR);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature startPosS = " + startPosS);
            }
            System.arraycopy(signature, startPosR, signingBytes, 0 + (20 - lenr), lenr);
            System.arraycopy(signature, startPosS, signingBytes, 20 + (20 - lens), lens);
            try {
                if (Signature.debug != null) {
                    hde = new HexDumpEncoder();
                    Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signingBytes = " + hde.encode(signingBytes));
                }
                result = this.session.verifyFinal(signingBytes, 0, signingBytes.length);
                if (Signature.debug == null) ** GOTO lbl51
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature result = " + result);
                hde = new HexDumpEncoder();
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signingBytes = " + hde.encode(signingBytes));
            }
            catch (PKCS11Exception pe) {
                if (Signature.debug != null) {
                    Signature.debug.exception(16384L, (Object)Signature.className, "engineVerify", (Throwable)pe);
                    Signature.debug.exit(16384L, (Object)Signature.className, "engineVerify");
                }
                throw new SignatureException("PKCS11 Exception : " + pe.getMessage());
            }
        } else {
            try {
                result = this.session.verifyFinal(signature, 0, signature.length);
            }
            catch (PKCS11Exception pe) {
                if (Signature.debug != null) {
                    Signature.debug.exception(16384L, (Object)Signature.className, "engineVerify", (Throwable)pe);
                    Signature.debug.exit(16384L, (Object)Signature.className, "engineVerify");
                }
                throw new SignatureException("PKCS11 Exception : " + pe.getMessage());
            }
        }
lbl51:
        // 3 sources

        if (Signature.debug != null) {
            Signature.debug.exit(16384L, (Object)Signature.className, "engineVerify");
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean engineVerify(byte[] signature, byte[] data, int length) throws SignatureException {
        result = false;
        if (Signature.debug != null) {
            parms = new Object[]{signature, data, new Integer(length)};
            Signature.debug.entry(16384L, (Object)Signature.className, "engineVerify", parms);
        }
        signingBytes = new byte[40];
        if (Signature.debug != null) {
            Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature.length = " + signature.length);
            hde = new HexDumpEncoder();
            Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature = " + hde.encode(signature));
        }
        if (this.mechanism == 18 && signature.length != 40) {
            lenr = signature[3];
            lens = signature[lenr + 3 + 2];
            startPosR = 4;
            startPosS = lenr + 6;
            if (lens > 20) {
                lens = 20;
                startPosS = lenr + 6 + 1;
            }
            if (lenr > 20) {
                lenr = 20;
                startPosR = 5;
            }
            if (Signature.debug != null) {
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature len = " + signature[1]);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature lenr = " + lenr);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature lens = " + lens);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature startPosR = " + startPosR);
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature startPosS = " + startPosS);
            }
            System.arraycopy(signature, startPosR, signingBytes, 0 + (20 - lenr), lenr);
            System.arraycopy(signature, startPosS, signingBytes, 20 + (20 - lens), lens);
            try {
                if (Signature.debug != null) {
                    hde = new HexDumpEncoder();
                    Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signingBytes = " + hde.encode(signingBytes));
                }
                result = this.session.verify(data, 0, length, signingBytes, 0, signingBytes.length);
                if (Signature.debug == null) ** GOTO lbl52
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signature result = " + result);
                hde = new HexDumpEncoder();
                Signature.debug.text(16384L, (Object)Signature.className, "engineVerify", "signingBytes = " + hde.encode(signingBytes));
            }
            catch (PKCS11Exception pe) {
                if (Signature.debug != null) {
                    Signature.debug.exception(16384L, (Object)Signature.className, "engineVerify", (Throwable)pe);
                    Signature.debug.exit(16384L, (Object)Signature.className, "engineVerify");
                }
                throw new SignatureException("PKCS11 Exception : " + pe.getMessage());
            }
        } else {
            try {
                result = this.session.verify(data, 0, length, signature, 0, signature.length);
            }
            catch (PKCS11Exception pe) {
                if (Signature.debug != null) {
                    Signature.debug.exception(16384L, (Object)Signature.className, "engineVerify", (Throwable)pe);
                    Signature.debug.exit(16384L, (Object)Signature.className, "engineVerify");
                }
                throw new SignatureException("PKCS11 Exception : " + pe.getMessage());
            }
        }
lbl52:
        // 3 sources

        if (Signature.debug != null) {
            Signature.debug.exit(16384L, (Object)Signature.className, "engineVerify");
        }
        if (this.hw_key_to_delete != null) {
            this.hw_key_to_delete.rm();
            this.hw_key_to_delete = null;
        }
        return result;
    }
}

