/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.io.PrintStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import sun.applet.AppletClassLoader;
import sun.applet.AppletPanel;
import sun.plugin.security.PluginClassLoader;
import sun.plugin.util.Trace;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class ClassLoaderInfo {
    private URL codebase;
    private String key;
    private int references = 0;
    private HashMap jars;
    private boolean locked;
    private boolean isCachable = true;
    private static boolean initialized;
    private static HashMap infos;
    private static int zombieLimit;
    private static ArrayList zombies;
    private LoaderReference loaderRef = null;
    private static ReferenceQueue refQueue;
    private boolean localJarsLoaded = false;

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        ClassLoaderInfo.reset();
    }

    public static synchronized void reset() {
        initialized = true;
        zombieLimit = 0;
        String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.classloader.cache.enabled"));
        if (string == null || string.equals("true")) {
            zombieLimit = AccessController.doPrivileged(new GetIntegerAction("javaplugin.classloader.cache.sizes", 4));
        }
        if (zombieLimit > 4) {
            zombieLimit = 4;
        }
    }

    public static synchronized void clearClassLoaderCache() {
        Object object2;
        for (Object object2 : zombies) {
            if (object2 == null) continue;
            infos.remove(((ClassLoaderInfo)object2).key);
            super.clearLoaderRef();
        }
        zombies.clear();
        object2 = infos.values();
        if (object2 != null) {
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                ClassLoaderInfo classLoaderInfo2 = null;
                ArrayList arrayList = (ArrayList)iterator.next();
                if (arrayList == null) continue;
                for (ClassLoaderInfo classLoaderInfo2 : arrayList) {
                    if (classLoaderInfo2 == null) continue;
                    classLoaderInfo2.isCachable = false;
                }
            }
        }
        AppletPanel.flushClassLoaders();
    }

    public static synchronized void dumpClassLoaderCache(PrintStream printStream) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Dump classloader list ...\n");
        Collection collection = infos.values();
        if (collection != null) {
            for (ArrayList arrayList : collection) {
                if (arrayList == null) continue;
                for (ClassLoaderInfo classLoaderInfo : arrayList) {
                    if (classLoaderInfo == null || classLoaderInfo.loaderRef == null || classLoaderInfo.loaderRef.get() == null) continue;
                    boolean bl = zombies.contains(classLoaderInfo);
                    stringBuffer.append("    codebase=" + classLoaderInfo.codebase);
                    stringBuffer.append(", key=" + classLoaderInfo.key);
                    stringBuffer.append(", zombie=" + bl);
                    stringBuffer.append(", cache=" + classLoaderInfo.isCachable);
                    stringBuffer.append(", refcount=" + classLoaderInfo.references);
                    stringBuffer.append(", info=" + classLoaderInfo);
                    stringBuffer.append("\n");
                }
            }
        }
        stringBuffer.append("Done.");
        printStream.println(stringBuffer.toString());
    }

    public static synchronized void markNotCachable(URL uRL, String string) {
        assert (ClassLoaderInfo.checkListsValidity());
        ClassLoaderInfo classLoaderInfo = ClassLoaderInfo.getUsableClassLoaderInfo(string);
        if (classLoaderInfo != null) {
            classLoaderInfo.isCachable = false;
            if (zombies.remove(classLoaderInfo)) {
                ClassLoaderInfo.removeClassLoaderInfo(classLoaderInfo);
            }
            AppletPanel.flushClassLoader((String)string);
        }
        assert (ClassLoaderInfo.checkListsValidity());
    }

    private static synchronized void removeClassLoaderInfo(ClassLoaderInfo classLoaderInfo) {
        ArrayList arrayList = (ArrayList)infos.get(classLoaderInfo.key);
        if (arrayList != null) {
            arrayList.remove(classLoaderInfo);
            if (arrayList.size() == 0) {
                infos.remove(classLoaderInfo.key);
            }
        }
        classLoaderInfo.clearLoaderRef();
    }

    private static synchronized void addClassLoaderInfo(ClassLoaderInfo classLoaderInfo) {
        ArrayList<ClassLoaderInfo> arrayList = (ArrayList<ClassLoaderInfo>)infos.get(classLoaderInfo.key);
        if (arrayList == null) {
            arrayList = new ArrayList<ClassLoaderInfo>();
            arrayList.add(classLoaderInfo);
            infos.put(classLoaderInfo.key, arrayList);
        } else {
            arrayList.add(classLoaderInfo);
        }
    }

    private static synchronized ClassLoaderInfo getUsableClassLoaderInfo(String string) {
        ArrayList arrayList = (ArrayList)infos.get(string);
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            ClassLoaderInfo classLoaderInfo = null;
            while (iterator.hasNext()) {
                classLoaderInfo = (ClassLoaderInfo)iterator.next();
                if (!classLoaderInfo.isCachable) continue;
                return classLoaderInfo;
            }
        }
        return null;
    }

    public static synchronized ClassLoaderInfo find(URL uRL, String string) {
        assert (ClassLoaderInfo.checkListsValidity());
        ClassLoaderInfo.initialize();
        if (uRL == null) {
            return null;
        }
        ClassLoaderInfo classLoaderInfo = ClassLoaderInfo.getUsableClassLoaderInfo(string);
        if (classLoaderInfo != null) {
            zombies.remove(classLoaderInfo);
        } else {
            classLoaderInfo = new ClassLoaderInfo(uRL, string);
            ClassLoaderInfo.addClassLoaderInfo(classLoaderInfo);
        }
        assert (ClassLoaderInfo.checkListsValidity());
        return classLoaderInfo;
    }

    synchronized void addReference() {
        ++this.references;
        Trace.msgPrintln("classloaderinfo.referencing", new Object[]{this, String.valueOf(this.references)});
    }

    synchronized void removeReference() {
        --this.references;
        Trace.msgPrintln("classloaderinfo.releasing", new Object[]{this, String.valueOf(this.references)});
        if (this.references < 0) {
            throw new Error("negative ref count???");
        }
        if (this.references == 0) {
            ClassLoaderInfo.addZombie(this);
        }
    }

    private static synchronized void addZombie(ClassLoaderInfo classLoaderInfo) {
        assert (ClassLoaderInfo.checkListsValidity());
        if (zombieLimit == 0 || !classLoaderInfo.isCachable) {
            ClassLoaderInfo.removeClassLoaderInfo(classLoaderInfo);
        } else {
            Trace.msgPrintln("classloaderinfo.caching", new Object[]{classLoaderInfo});
            AppletPanel.flushClassLoader((String)classLoaderInfo.key);
            AppletClassLoader appletClassLoader = (AppletClassLoader)classLoaderInfo.loaderRef.get();
            if (appletClassLoader != null) {
                if (appletClassLoader.getExceptionStatus()) {
                    classLoaderInfo.clearLoaderRef();
                } else {
                    appletClassLoader.clearAssertionStatus();
                }
            }
            zombies.add(classLoaderInfo);
            ClassLoaderInfo.cleanupZombies();
            Trace.msgPrintln("classloaderinfo.cachesize", new Object[]{new Integer(zombies.size())});
            if (zombies.size() > zombieLimit) {
                ClassLoaderInfo classLoaderInfo2 = (ClassLoaderInfo)zombies.get(0);
                Trace.msgPrintln("classloaderinfo.num", new Object[]{String.valueOf(zombieLimit), classLoaderInfo2});
                zombies.remove(0);
                ClassLoaderInfo.removeClassLoaderInfo(classLoaderInfo2);
                classLoaderInfo2.clearLoaderRef();
            }
        }
        assert (ClassLoaderInfo.checkListsValidity());
    }

    synchronized AppletClassLoader getLoader() {
        AppletClassLoader appletClassLoader = null;
        if (this.loaderRef != null) {
            appletClassLoader = (AppletClassLoader)this.loaderRef.get();
        }
        if (appletClassLoader == null) {
            appletClassLoader = (PluginClassLoader)((Object)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new PluginClassLoader(ClassLoaderInfo.this.codebase);
                }
            }));
            this.loaderRef = new LoaderReference((ClassLoader)appletClassLoader);
            this.jars.clear();
            this.localJarsLoaded = false;
        }
        return appletClassLoader;
    }

    private synchronized void clearLoaderRef() {
        if (this.loaderRef != null) {
            this.loaderRef.clear();
            this.loaderRef = null;
        }
    }

    private static synchronized void cleanupZombies() {
        LoaderReference loaderReference = (LoaderReference)refQueue.poll();
        while (loaderReference != null) {
            String string = loaderReference.getKey();
            ArrayList arrayList = (ArrayList)infos.get(string);
            if (arrayList != null) {
                ArrayList arrayList2 = (ArrayList)arrayList.clone();
                for (ClassLoaderInfo classLoaderInfo : arrayList2) {
                    if (classLoaderInfo.loaderRef != loaderReference || !zombies.contains(classLoaderInfo)) continue;
                    arrayList.remove(classLoaderInfo);
                    zombies.remove(classLoaderInfo);
                }
            }
            loaderReference = (LoaderReference)refQueue.poll();
        }
    }

    private ClassLoaderInfo(URL uRL, String string) {
        this.codebase = uRL;
        this.key = string;
        this.jars = new HashMap();
    }

    synchronized void addJar(String string) {
        this.jars.put(string, string);
    }

    synchronized boolean hasJar(String string) {
        return this.jars.get(string) != null;
    }

    public boolean getLocalJarsLoaded() {
        return this.localJarsLoaded;
    }

    public void setLocalJarsLoaded(boolean bl) {
        this.localJarsLoaded = bl;
    }

    public final synchronized void lock() throws InterruptedException {
        while (this.locked) {
            this.wait();
        }
        this.locked = true;
    }

    public final synchronized void unlock() {
        this.locked = false;
        this.notifyAll();
    }

    public static synchronized boolean checkListsValidity() {
        ClassLoaderInfo classLoaderInfo2 = null;
        Collection collection = infos.values();
        for (ArrayList arrayList : collection) {
            if (arrayList == null) continue;
            int n = 0;
            for (ClassLoaderInfo classLoaderInfo2 : arrayList) {
                if (classLoaderInfo2 == null || !classLoaderInfo2.isCachable) continue;
                ++n;
            }
            if (n <= true) continue;
            return false;
        }
        for (ClassLoaderInfo classLoaderInfo2 : zombies) {
            if (classLoaderInfo2 == null || classLoaderInfo2.isCachable) continue;
            return false;
        }
        return true;
    }

    static {
        infos = new HashMap();
        zombieLimit = 0;
        zombies = new ArrayList();
        refQueue = new ReferenceQueue();
    }

    private class LoaderReference
    extends SoftReference {
        public LoaderReference(ClassLoader classLoader) {
            super(classLoader, refQueue);
        }

        public String getCodebase() {
            return ClassLoaderInfo.this.codebase.toString();
        }

        public String getKey() {
            return ClassLoaderInfo.this.key;
        }
    }
}

