/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import com.sun.deploy.util.DialogFactory;
import java.text.MessageFormat;
import java.util.LinkedList;
import javax.swing.table.AbstractTableModel;
import sun.plugin.cache.JarCacheEntry;
import sun.plugin.resources.ResourceHandler;

public class JarCacheTableModel
extends AbstractTableModel {
    private LinkedList list = JarCacheEntry.getEntries();
    protected Object[] tableRows = this.list.toArray();
    private String[] columnNames;

    public JarCacheTableModel(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public int getRowCount() {
        return this.list.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        if (n < this.columnNames.length) {
            return this.columnNames[n];
        }
        return null;
    }

    public void removeRows(int[] nArray) {
        if (nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                JarCacheEntry jarCacheEntry = (JarCacheEntry)this.tableRows[nArray[i]];
                if (jarCacheEntry.delete()) {
                    int n = this.list.indexOf(this.tableRows[nArray[i]]);
                    this.list.remove(n);
                    continue;
                }
                String string = ResourceHandler.getMessage("cache_viewer.delete.text");
                String string2 = ResourceHandler.getMessage("cache_viewer.delete.caption");
                MessageFormat messageFormat = new MessageFormat(string);
                string = messageFormat.format(new Object[]{jarCacheEntry.getName()});
                DialogFactory.showErrorDialog((String)string, (String)string2);
            }
            this.tableRows = this.list.toArray();
        }
    }

    public void refresh() {
        this.list = JarCacheEntry.getEntries();
        this.tableRows = this.list.toArray();
    }

    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (n < this.getRowCount() && n2 < this.getColumnCount()) {
            JarCacheEntry jarCacheEntry = (JarCacheEntry)this.tableRows[n];
            object = jarCacheEntry.getDisplayValue(this.columnNames[n2]);
        }
        return object;
    }
}

