/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionsParser;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.ILiveHelpAction;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.appserver.WebappManager;
import org.eclipse.help.internal.base.BookmarkManager;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.base.HelpDisplay;
import org.eclipse.help.internal.base.util.IErrorUtil;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.help.internal.search.SearchManager;
import org.eclipse.help.internal.workingset.WorkingSetManager;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class BaseHelpSystem {
    protected static final BaseHelpSystem instance = new BaseHelpSystem();
    private static final String WEBAPP_EXTENSION_ID = "org.eclipse.help.base.webapp";
    private static final String WEBAPP_DEFAULT_ATTRIBUTE = "default";
    public static final String BOOKMARKS = "bookmarks";
    public static final String WORKING_SETS = "workingSets";
    public static final String WORKING_SET = "workingSet";
    public static final int MODE_WORKBENCH = 0;
    public static final int MODE_INFOCENTER = 1;
    public static final int MODE_STANDALONE = 2;
    protected SearchManager searchManager;
    protected WorkingSetManager workingSetManager;
    protected BookmarkManager bookmarkManager;
    private int mode = 0;
    private boolean webappStarted = false;
    private IErrorUtil defaultErrorMessenger;
    private IBrowser browser;
    private IBrowser internalBrowser;
    private HelpDisplay helpDisplay = null;
    private boolean webappRunning = false;
    private boolean rtl = BaseHelpSystem.initializeRTL();
    private static BundleLocalization localizationService;
    private static ServiceReference localizationServiceReference;
    private static RegistryObjectManager roManager;
    static final byte EXTENSION = 2;
    static final byte CONFIGURATION_ELEMENT = 1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        roManager = new RegistryObjectManager();
    }

    private BaseHelpSystem() {
        BaseHelpSystem.start();
    }

    public static BaseHelpSystem getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchManager getSearchManager() {
        if (BaseHelpSystem.getInstance().searchManager != null) return BaseHelpSystem.getInstance().searchManager;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.help.internal.base.BaseHelpSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (BaseHelpSystem.getInstance().searchManager != null) return BaseHelpSystem.getInstance().searchManager;
            BaseHelpSystem.getInstance().searchManager = new SearchManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return BaseHelpSystem.getInstance().searchManager;
        }
    }

    public static synchronized WorkingSetManager getWorkingSetManager() {
        if (BaseHelpSystem.getInstance().workingSetManager == null) {
            BaseHelpSystem.getInstance().workingSetManager = new WorkingSetManager();
        }
        return BaseHelpSystem.getInstance().workingSetManager;
    }

    public static synchronized BookmarkManager getBookmarkManager() {
        if (BaseHelpSystem.getInstance().bookmarkManager == null) {
            BaseHelpSystem.getInstance().bookmarkManager = new BookmarkManager();
        }
        return BaseHelpSystem.getInstance().bookmarkManager;
    }

    public synchronized void setBrowserInstance(IBrowser browser) {
        this.browser = browser;
    }

    public static synchronized IBrowser getHelpBrowser(boolean forceExternal) {
        if (!forceExternal && !BrowserManager.getInstance().isAlwaysUseExternal()) {
            if (BaseHelpSystem.getInstance().internalBrowser == null) {
                BaseHelpSystem.getInstance().internalBrowser = BrowserManager.getInstance().createBrowser(false);
            }
            return BaseHelpSystem.getInstance().internalBrowser;
        }
        if (BaseHelpSystem.getInstance().browser == null) {
            BaseHelpSystem.getInstance().browser = BrowserManager.getInstance().createBrowser(true);
        }
        return BaseHelpSystem.getInstance().browser;
    }

    public static synchronized HelpDisplay getHelpDisplay() {
        if (BaseHelpSystem.getInstance().helpDisplay == null) {
            BaseHelpSystem.getInstance().helpDisplay = new HelpDisplay();
        }
        return BaseHelpSystem.getInstance().helpDisplay;
    }

    public BaseHelpSystem newInstance() {
        return null;
    }

    public static void shutdown() throws CoreException {
        if (HelpBasePlugin.DEBUG) {
            System.out.println("Base Help System is shutting down.");
        }
        if (BaseHelpSystem.getInstance().bookmarkManager != null) {
            BaseHelpSystem.getInstance().bookmarkManager.close();
            BaseHelpSystem.getInstance().bookmarkManager = null;
        }
        if (BaseHelpSystem.getInstance().searchManager != null) {
            BaseHelpSystem.getInstance().searchManager.close();
            BaseHelpSystem.getInstance().searchManager = null;
        }
        if (BaseHelpSystem.getInstance().webappStarted) {
            WebappManager.stop((String)"help");
            if (BaseHelpSystem.getMode() != 0) {
                WebappManager.stop((String)"helpControl");
            }
        }
        if (HelpBasePlugin.DEBUG) {
            System.out.println("Help System is shut down.");
        }
    }

    public static void startup() {
        try {
            BaseHelpSystem.setDefaultErrorUtil(new IErrorUtil(){

                public void displayError(String msg) {
                    System.out.println(msg);
                }

                public void displayError(String msg, Thread uiThread) {
                    System.out.println(msg);
                }
            });
            HelpBasePlugin.getDefault().getPluginPreferences();
        }
        catch (Exception e) {
            HelpBasePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.help.base", 0, "Error in launching help.", (Throwable)e));
        }
        if (HelpBasePlugin.DEBUG) {
            System.out.println("Base Help System started.");
        }
    }

    public static boolean ensureWebappRunning() {
        if (!BaseHelpSystem.getInstance().webappStarted) {
            BaseHelpSystem.getInstance().webappStarted = true;
            String webappPlugin = BaseHelpSystem.getWebappPlugin();
            if (BaseHelpSystem.getMode() != 0) {
                try {
                    WebappManager.start((String)"helpControl", (String)webappPlugin, (IPath)Path.EMPTY);
                }
                catch (CoreException e) {
                    HelpBasePlugin.logError("Stand-alone help control web application failed to run.", e);
                    return false;
                }
            }
            try {
                WebappManager.start((String)"help", (String)webappPlugin, (IPath)Path.EMPTY);
            }
            catch (CoreException e) {
                HelpBasePlugin.logError("The embedded application server could not run help web application.", e);
                BaseHelpSystem.getDefaultErrorUtil().displayError(HelpBaseResources.HelpWebappNotStarted);
                return false;
            }
            BaseHelpSystem.getInstance().webappRunning = true;
        }
        return BaseHelpSystem.getInstance().webappRunning;
    }

    public static URL resolve(String href, boolean documentOnly) {
        String url = null;
        if (href == null || href.indexOf("://") != -1) {
            url = href;
        } else {
            BaseHelpSystem.ensureWebappRunning();
            String base = BaseHelpSystem.getBase(documentOnly);
            url = href.startsWith("/") ? String.valueOf(base) + href : String.valueOf(base) + "/" + href;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL resolve(String href, String servlet) {
        String url = null;
        if (href == null || href.indexOf("://") != -1) {
            url = href;
        } else {
            BaseHelpSystem.ensureWebappRunning();
            String base = BaseHelpSystem.getBase(servlet);
            url = href.startsWith("/") ? String.valueOf(base) + href : String.valueOf(base) + "/" + href;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String unresolve(URL url) {
        return BaseHelpSystem.unresolve(url.toString());
    }

    public static String unresolve(String href) {
        String[] baseVariants = new String[]{BaseHelpSystem.getBase("/help/topic"), BaseHelpSystem.getBase("/help/nftopic"), BaseHelpSystem.getBase("/help/ntopic")};
        int i = 0;
        while (i < baseVariants.length) {
            if (href.startsWith(baseVariants[i])) {
                return href.substring(baseVariants[i].length());
            }
            ++i;
        }
        return href;
    }

    private static String getBase(boolean documentOnly) {
        String servlet = documentOnly ? "/help/nftopic" : "/help/topic";
        return BaseHelpSystem.getBase(servlet);
    }

    private static String getBase(String servlet) {
        return "http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + servlet;
    }

    public static int getMode() {
        return BaseHelpSystem.getInstance().mode;
    }

    public static void setMode(int mode) {
        BaseHelpSystem.getInstance().mode = mode;
    }

    public static void setDefaultErrorUtil(IErrorUtil em) {
        BaseHelpSystem.getInstance().defaultErrorMessenger = em;
    }

    public static IErrorUtil getDefaultErrorUtil() {
        return BaseHelpSystem.getInstance().defaultErrorMessenger;
    }

    private static String getWebappPlugin() {
        IExtension[] extensions;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(WEBAPP_EXTENSION_ID);
        if (point != null && (extensions = point.getExtensions()).length != 0) {
            IConfigurationElement[] elements = extensions[0].getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String defaultValue = elements[i].getAttribute(WEBAPP_DEFAULT_ATTRIBUTE);
                if (defaultValue == null || defaultValue.equals("false")) {
                    return elements[i].getNamespace();
                }
                ++i;
            }
            if (elements.length > 0) {
                return elements[0].getNamespace();
            }
        }
        return "org.eclipse.help.webapp";
    }

    private static boolean initializeRTL() {
        String orientation = System.getProperty("eclipse.orientation");
        if ("rtl".equals(orientation)) {
            return true;
        }
        if ("ltr".equals(orientation)) {
            return false;
        }
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if ("-dir".equalsIgnoreCase(args[i])) {
                return i + 1 < args.length && "rtl".equalsIgnoreCase(args[i + 1]);
            }
            ++i;
        }
        String locale = Platform.getNL();
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        return locale.startsWith("ar") || locale.startsWith("fa") || locale.startsWith("he") || locale.startsWith("iw") || locale.startsWith("ur");
    }

    public static boolean isRTL() {
        return BaseHelpSystem.getInstance().rtl;
    }

    public static void runLiveHelp(String pluginID, String className, String arg) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        if (bundle == null) {
            return;
        }
        try {
            Class c = bundle.loadClass(className);
            Object o = c.newInstance();
            if (o != null && o instanceof ILiveHelpAction) {
                ILiveHelpAction helpExt = (ILiveHelpAction)o;
                if (arg != null) {
                    helpExt.setInitializationString(arg);
                }
                Thread runnableLiveHelp = new Thread((Runnable)helpExt);
                runnableLiveHelp.setDaemon(true);
                runnableLiveHelp.start();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Exception exception) {}
    }

    public static String getProductName() {
        IProduct product = Platform.getProduct();
        if (product == null) {
            return "";
        }
        String name = product.getName();
        return name == null ? "" : name;
    }

    public static String getProductName(String locale) {
        IProduct product = Platform.getProduct();
        if (product == null) {
            return "";
        }
        Bundle bundle = product.getDefiningBundle();
        Contribution cb = BaseHelpSystem.getBundleModel(bundle, locale);
        if (cb == null) {
            return "";
        }
        String productID = System.getProperty("eclipse.product");
        int[] extensions = cb.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            Extension extension = (Extension)roManager.getObject(extensions[i], (byte)2);
            if (extension.getUniqueIdentifier().equals(productID)) {
                IConfigurationElement productConfigElement = (IConfigurationElement)roManager.getHandles(extension.getRawChildren(), (byte)1)[0];
                return productConfigElement.getAttribute("name");
            }
            ++i;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Contribution getBundleModel(Bundle bundle, String locale) {
        Contribution contribution;
        Bundle[] hosts;
        if (bundle.getBundleId() == 0L) {
            return null;
        }
        if (bundle.getSymbolicName() == null) {
            return null;
        }
        if (!BaseHelpSystem.isSingleton(bundle)) {
            return null;
        }
        boolean isFragment = InternalPlatform.getDefault().isFragment(bundle);
        if (isFragment && (hosts = InternalPlatform.getDefault().getHosts(bundle)) != null && !BaseHelpSystem.isSingleton(hosts[0])) {
            return null;
        }
        InputStream is = null;
        String manifestType = null;
        String manifestName = isFragment ? "fragment.xml" : "plugin.xml";
        try {
            URL url = bundle.getEntry(manifestName);
            if (url != null) {
                is = url.openStream();
                manifestType = isFragment ? "fragment" : "plugin";
            }
        }
        catch (IOException iOException) {
            return null;
        }
        if (is == null) {
            return null;
        }
        BundleContext bundleContext = InternalPlatform.getDefault().getBundleContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("javax.xml.parsers.SAXParserFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$1 = clazz2;
        }
        ServiceTracker xmlTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        xmlTracker.open();
        try {
            try {
                String message = NLS.bind((String)Messages.parse_problems, (Object)bundle.getLocation());
                MultiStatus problems = new MultiStatus("org.eclipse.core.runtime", 1, message, null);
                ResourceBundle b = null;
                try {
                    b = localizationService.getLocalization(bundle, locale);
                }
                catch (MissingResourceException missingResourceException) {}
                ExtensionsParser parser = new ExtensionsParser(problems);
                Contribution bundleModel = new Contribution(bundle);
                Contribution contribution2 = parser.parseManifest(xmlTracker, new InputSource(is), manifestType, manifestName, roManager, bundleModel, b);
                if (problems.getSeverity() != 0) {
                    InternalPlatform.getDefault().log((IStatus)problems);
                }
                contribution = contribution2;
                Object var13_17 = null;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Contribution contribution3 = null;
                Object var13_18 = null;
                try {
                    is.close();
                    return contribution3;
                }
                catch (IOException iOException) {}
                return contribution3;
            }
            catch (SAXException sAXException) {
                Contribution contribution4 = null;
                Object var13_19 = null;
                try {}
                catch (IOException iOException) {}
                is.close();
                return contribution4;
            }
            catch (IOException iOException) {
                Contribution contribution5 = null;
                Object var13_20 = null;
                try {}
                catch (IOException iOException2) {}
                is.close();
                return contribution5;
            }
        }
        catch (Throwable throwable) {
            Object var13_21 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            is.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        is.close();
        return contribution;
    }

    private static boolean isSingleton(Bundle bundle) {
        Dictionary allHeaders = bundle.getHeaders("");
        String symbolicNameHeader = (String)allHeaders.get("Bundle-SymbolicName");
        try {
            ManifestElement[] symbolicNameElements;
            if (symbolicNameHeader != null && (symbolicNameElements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicNameHeader)).length > 0) {
                String singleton = symbolicNameElements[0].getDirective("singleton");
                if (singleton == null) {
                    singleton = symbolicNameElements[0].getAttribute("singleton");
                }
                if (!"true".equalsIgnoreCase(singleton)) {
                    int status = 1;
                    String manifestVersion = (String)allHeaders.get("Bundle-ManifestVersion");
                    if (manifestVersion == null) {
                        if (InternalPlatform.getDefault().getBundle(symbolicNameElements[0].getValue()) == bundle) {
                            return true;
                        }
                        status = 4;
                    }
                    if (InternalPlatform.DEBUG_REGISTRY || status == 4) {
                        String message = NLS.bind((String)Messages.parse_nonSingleton, (Object)bundle.getLocation());
                        InternalPlatform.getDefault().log((IStatus)new Status(status, "org.eclipse.core.runtime", 0, message, null));
                    }
                    return false;
                }
            }
        }
        catch (BundleException bundleException) {}
        return true;
    }

    private static void start() {
        BundleContext context = InternalPlatform.getDefault().getBundleContext();
        BundleContext bundleContext = InternalPlatform.getDefault().getBundleContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.service.localization.BundleLocalization");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((localizationServiceReference = bundleContext.getServiceReference(clazz.getName())) == null) {
            return;
        }
        localizationService = (BundleLocalization)context.getService(localizationServiceReference);
    }
}

