/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.QueryWordsExactPhrase;
import org.eclipse.help.internal.search.QueryWordsPhrase;
import org.eclipse.help.internal.search.QueryWordsToken;

public class QueryBuilder {
    private static final int MAX_TERMS = 10;
    private static final int MAX_UNIONS = 4;
    private static final int MAX_WILD_TERMS = 2;
    private String searchWords;
    private AnalyzerDescriptor analyzerDesc;
    private Analyzer analyzer;
    private List analyzedTokens;
    private List highlightWords = new ArrayList();
    private Locale locale;

    public QueryBuilder(String searchWords, AnalyzerDescriptor analyzerDesc) {
        this.searchWords = searchWords;
        String language = analyzerDesc.getLang();
        this.locale = language.length() >= 5 ? new Locale(language.substring(0, 2), language.substring(3, 5)) : new Locale(language.substring(0, 2), "");
        this.analyzerDesc = analyzerDesc;
        this.analyzer = analyzerDesc.getAnalyzer();
    }

    private List tokenizeUserQuery(String searchWords) {
        ArrayList<QueryWordsToken> tokenList = new ArrayList<QueryWordsToken>();
        boolean withinQuotation = false;
        String quotedString = "";
        int termCount = 0;
        int fromIndex = -1;
        searchWords = searchWords.trim();
        while ((fromIndex = searchWords.indexOf("\"", fromIndex + 1)) != -1) {
            boolean bl = withinQuotation = !withinQuotation;
        }
        if (withinQuotation) {
            searchWords = String.valueOf(searchWords) + "\"";
            withinQuotation = !withinQuotation;
        }
        StringTokenizer qTokenizer = new StringTokenizer(searchWords, "\"", true);
        int orCount = 0;
        while (qTokenizer.hasMoreTokens()) {
            String curToken = qTokenizer.nextToken();
            if (curToken.equals("\"")) {
                if (withinQuotation) {
                    if (BaseHelpSystem.getMode() == 1 && ++termCount > 10) {
                        throw new QueryTooComplexException();
                    }
                    tokenList.add(QueryWordsToken.exactPhrase(quotedString));
                } else {
                    quotedString = "";
                }
                withinQuotation = !withinQuotation;
                continue;
            }
            if (withinQuotation) {
                quotedString = curToken;
                continue;
            }
            StringTokenizer parser = new StringTokenizer(curToken.trim());
            while (parser.hasMoreTokens()) {
                String token = parser.nextToken();
                if (token.equalsIgnoreCase(QueryWordsToken.AND().value)) {
                    tokenList.add(QueryWordsToken.AND());
                    continue;
                }
                if (token.equalsIgnoreCase(QueryWordsToken.OR().value)) {
                    if (BaseHelpSystem.getMode() == 1 && ++orCount > 4) {
                        throw new QueryTooComplexException();
                    }
                    tokenList.add(QueryWordsToken.OR());
                    continue;
                }
                if (token.equalsIgnoreCase(QueryWordsToken.NOT().value)) {
                    tokenList.add(QueryWordsToken.NOT());
                    continue;
                }
                if (BaseHelpSystem.getMode() == 1 && ++termCount > 10) {
                    throw new QueryTooComplexException();
                }
                tokenList.add(QueryWordsToken.word(token));
            }
        }
        return tokenList;
    }

    private List analyzeTokens(List tokens) {
        boolean isTokensAfterNot = false;
        ArrayList<QueryWordsToken> newTokens = new ArrayList<QueryWordsToken>();
        int wildCardTermCount = 0;
        int i = 0;
        while (i < tokens.size()) {
            String word;
            QueryWordsToken token = (QueryWordsToken)tokens.get(i);
            if (token.type == 5) {
                int questionMIndex = token.value.indexOf(63);
                int starIndex = token.value.indexOf(42);
                if (starIndex >= 0 || questionMIndex >= 0) {
                    if (BaseHelpSystem.getMode() == 1 && ++wildCardTermCount > 2) {
                        throw new QueryTooComplexException();
                    }
                    if (questionMIndex != 0 && starIndex != 0) {
                        newTokens.add(QueryWordsToken.word(token.value.toLowerCase(this.locale)));
                        if (!isTokensAfterNot & !this.highlightWords.contains(token.value)) {
                            this.highlightWords.add(token.value);
                        }
                    }
                } else {
                    List wordList = this.analyzeText(this.analyzer, "contents", token.value);
                    if (wordList.size() > 0) {
                        if (!isTokensAfterNot & !this.highlightWords.contains(token.value)) {
                            this.highlightWords.add(token.value);
                        }
                        if (wordList.size() == 1) {
                            word = (String)wordList.get(0);
                            newTokens.add(QueryWordsToken.word(word));
                            if (!isTokensAfterNot & !this.highlightWords.contains(word)) {
                                this.highlightWords.add(word);
                            }
                        } else {
                            QueryWordsPhrase phrase = QueryWordsToken.phrase();
                            Iterator it = wordList.iterator();
                            while (it.hasNext()) {
                                String word2 = (String)it.next();
                                phrase.addWord(word2);
                                if (this.analyzerDesc.getId().startsWith("org.eclipse.help.base#") || !(!isTokensAfterNot & !this.highlightWords.contains(token.value))) continue;
                                this.highlightWords.add(word2);
                            }
                            newTokens.add(phrase);
                        }
                    }
                }
                isTokensAfterNot = false;
            } else if (token.type == 1) {
                newTokens.add(token);
                isTokensAfterNot = false;
            } else if (token.type == 2) {
                newTokens.add(token);
                isTokensAfterNot = true;
            } else if (token.type == 3) {
                List wordList = this.analyzeText(this.analyzer, "exact_contents", token.value);
                if (wordList.size() > 0 && !isTokensAfterNot & !this.highlightWords.contains(token.value)) {
                    this.highlightWords.add(token.value);
                }
                QueryWordsExactPhrase phrase = QueryWordsToken.exactPhrase();
                Iterator it = wordList.iterator();
                while (it.hasNext()) {
                    word = (String)it.next();
                    phrase.addWord(word);
                }
                if (phrase.getWords().size() > 0) {
                    newTokens.add(phrase);
                }
                isTokensAfterNot = false;
            }
            ++i;
        }
        return newTokens;
    }

    private List analyzeText(Analyzer analyzer, String fieldName, String text) {
        ArrayList<String> words = new ArrayList<String>(1);
        StringReader reader = new StringReader(text);
        TokenStream tStream = analyzer.tokenStream(fieldName, (Reader)reader);
        try {
            Token tok;
            while ((tok = tStream.next()) != null) {
                words.add(tok.termText());
            }
            ((Reader)reader).close();
        }
        catch (IOException iOException) {}
        return words;
    }

    private Query createLuceneQuery(List searchTokens, String[] fieldNames, float[] boosts) {
        List requiredQueries = this.getRequiredQueries(searchTokens, fieldNames, boosts);
        if (requiredQueries.size() == 0) {
            return null;
        }
        if (requiredQueries.size() <= 1) {
            return (Query)requiredQueries.get(0);
        }
        return this.orQueries(requiredQueries);
    }

    private List getRequiredQueries(List tokens, String[] fieldNames, float[] boosts) {
        ArrayList<Query> oredQueries = new ArrayList<Query>();
        ArrayList<QueryWordsToken> requiredQueryTokens = new ArrayList<QueryWordsToken>();
        int i = 0;
        while (i < tokens.size()) {
            QueryWordsToken token = (QueryWordsToken)tokens.get(i);
            if (token.type != 1) {
                requiredQueryTokens.add(token);
            } else {
                Query reqQuery = this.getRequiredQuery(requiredQueryTokens, fieldNames, boosts);
                if (reqQuery != null) {
                    oredQueries.add(reqQuery);
                }
                requiredQueryTokens = new ArrayList();
            }
            ++i;
        }
        Query reqQuery = this.getRequiredQuery(requiredQueryTokens, fieldNames, boosts);
        if (reqQuery != null) {
            oredQueries.add(reqQuery);
        }
        return oredQueries;
    }

    private Query orQueries(Collection queries) {
        BooleanQuery bq = new BooleanQuery();
        Iterator it = queries.iterator();
        while (it.hasNext()) {
            Query q = (Query)it.next();
            bq.add(q, false, false);
        }
        return bq;
    }

    private Query getRequiredQuery(List requiredTokens, String[] fieldNames, float[] boosts) {
        BooleanQuery retQuery = new BooleanQuery();
        boolean requiredTermExist = false;
        QueryWordsToken operator = null;
        int i = 0;
        while (i < requiredTokens.size()) {
            QueryWordsToken token = (QueryWordsToken)requiredTokens.get(i);
            if (token.type == 0 || token.type == 2) {
                operator = token;
            } else {
                Query[] qs = new Query[fieldNames.length];
                int f = 0;
                while (f < fieldNames.length) {
                    qs[f] = token.createLuceneQuery(fieldNames[f], boosts[f]);
                    ++f;
                }
                Query q = qs[0];
                if (fieldNames.length > 1) {
                    BooleanQuery allFieldsQuery = new BooleanQuery();
                    int f2 = 0;
                    while (f2 < fieldNames.length) {
                        allFieldsQuery.add(qs[f2], false, false);
                        ++f2;
                    }
                    q = allFieldsQuery;
                }
                if (operator != null && operator.type == 2) {
                    retQuery.add(q, false, true);
                } else {
                    retQuery.add(q, true, false);
                    requiredTermExist = true;
                }
            }
            ++i;
        }
        if (!requiredTermExist) {
            return null;
        }
        return retQuery;
    }

    private Query getLuceneQuery(String[] fieldNames, float[] boosts) {
        Query luceneQuery = this.createLuceneQuery(this.analyzedTokens, fieldNames, boosts);
        return luceneQuery;
    }

    public Query getLuceneQuery(Collection fieldNames, boolean fieldSearchOnly) throws QueryTooComplexException {
        List userTokens = this.tokenizeUserQuery(this.searchWords);
        this.analyzedTokens = this.analyzeTokens(userTokens);
        return this.buildLuceneQuery(fieldNames, fieldSearchOnly);
    }

    private Query buildLuceneQuery(Collection fieldNames, boolean fieldSearchOnly) {
        Iterator fieldNamesIt;
        float[] boosts;
        String[] fields;
        if (fieldSearchOnly) {
            fields = new String[fieldNames.size()];
            boosts = new float[fieldNames.size()];
            fieldNamesIt = fieldNames.iterator();
            int i = 0;
            while (i < fieldNames.size()) {
                fields[i] = (String)fieldNamesIt.next();
                boosts[i] = 5.0f;
                ++i;
            }
        } else {
            fields = new String[fieldNames.size() + 2];
            boosts = new float[fieldNames.size() + 2];
            fieldNamesIt = fieldNames.iterator();
            int i = 0;
            while (i < fieldNames.size()) {
                fields[i] = (String)fieldNamesIt.next();
                boosts[i] = 5.0f;
                ++i;
            }
            fields[fieldNames.size()] = "contents";
            boosts[fieldNames.size()] = 1.0f;
            fields[fieldNames.size() + 1] = "title";
            boosts[fieldNames.size() + 1] = 1.3f;
        }
        Query query = this.getLuceneQuery(fields, boosts);
        query = this.improveRankingForUnqotedPhrase(query, fields, boosts);
        return query;
    }

    private Query improveRankingForUnqotedPhrase(Query query, String[] fields, float[] boosts) {
        if (query == null) {
            return query;
        }
        int i = 0;
        while (i < this.analyzedTokens.size()) {
            if (((QueryWordsToken)this.analyzedTokens.get((int)i)).type != 5) {
                return query;
            }
            ++i;
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        booleanQuery.add(query, false, false);
        PhraseQuery[] phraseQueries = new PhraseQuery[fields.length];
        int f = 0;
        while (f < fields.length) {
            phraseQueries[f] = new PhraseQuery();
            int i2 = 0;
            while (i2 < this.analyzedTokens.size()) {
                Term t = new Term(fields[f], ((QueryWordsToken)this.analyzedTokens.get((int)i2)).value);
                phraseQueries[f].add(t);
                ++i2;
            }
            phraseQueries[f].setBoost(10.0f * boosts[f]);
            booleanQuery.add((Query)phraseQueries[f], false, false);
            ++f;
        }
        return booleanQuery;
    }

    public String gethighlightTerms() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.highlightWords.iterator();
        while (it.hasNext()) {
            buf.append('\"');
            buf.append(it.next());
            buf.append("\" ");
        }
        return buf.toString();
    }
}

