/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.model.INavigationElement;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.Topic;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.WorkingSet;

public class SearchResults
implements ISearchHitCollector {
    private ArrayList scopes;
    private int maxHits;
    private String locale;
    protected SearchHit[] searchHits = new SearchHit[0];
    private boolean isQuickSingleTopicSearch = false;
    private String singleTopicHref;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SearchResults(WorkingSet[] workingSets, int maxHits, String locale) {
        this.maxHits = maxHits;
        this.locale = locale;
        this.scopes = this.getScopes(workingSets);
    }

    public SearchResults(WorkingSet[] workingSets, int maxHits, String locale, String singleTopicHref) {
        this.maxHits = maxHits;
        this.locale = locale;
        this.scopes = this.getScopes(workingSets);
        this.isQuickSingleTopicSearch = true;
        this.singleTopicHref = singleTopicHref.indexOf("#") != -1 ? singleTopicHref.substring(0, singleTopicHref.indexOf("#")) : singleTopicHref;
    }

    public void addHits(Hits hits, String highlightTerms) {
        String urlEncodedWords = URLCoder.encode((String)highlightTerms);
        ArrayList<SearchHit> searchHitList = new ArrayList<SearchHit>();
        float scoreScale = 1.0f;
        boolean scoreScaleSet = false;
        int h = 0;
        int j = 0;
        while (h < hits.length() && j < this.maxHits && h < 500) {
            block14: {
                ITopic t;
                AdaptableHelpResource scope;
                IToc toc;
                String href;
                float score;
                Document doc;
                block16: {
                    block15: {
                        try {
                            doc = hits.doc(h);
                            score = hits.score(h);
                        }
                        catch (IOException iOException) {
                            break block14;
                        }
                        href = doc.get("name");
                        toc = null;
                        scope = null;
                        if (this.scopes != null) break block15;
                        toc = this.getTocForTopic(href, this.locale);
                        break block16;
                    }
                    scope = this.getScopeForTopic(href);
                    if (scope == null) break block14;
                    toc = this.getTocForScope(scope, this.locale);
                }
                if (!scoreScaleSet) {
                    if (score > 0.0f) {
                        scoreScale = 0.99f / score;
                        score = 1.0f;
                    }
                    scoreScaleSet = true;
                } else {
                    score = score * scoreScale + 0.01f;
                }
                String label = doc.get("raw_title");
                if ("".equals(label) && toc != null && (t = scope != null ? scope.getTopic(href) : toc.getTopic(href)) != null) {
                    label = t.getLabel();
                }
                if (label == null || "".equals(label)) {
                    label = href;
                }
                String summary = doc.get("summary");
                ++j;
                if (this.isQuickSingleTopicSearch) {
                    if (href.equals(this.singleTopicHref)) {
                        href = String.valueOf(href) + "?resultof=" + urlEncodedWords;
                        searchHitList.add(new SearchHit(href, label, summary, score, toc));
                    }
                } else {
                    href = String.valueOf(href) + "?resultof=" + urlEncodedWords;
                    searchHitList.add(new SearchHit(href, label, summary, score, toc));
                }
            }
            ++h;
        }
        this.searchHits = searchHitList.toArray(new SearchHit[searchHitList.size()]);
    }

    private AdaptableHelpResource getScopeForTopic(String href) {
        int i = 0;
        while (i < this.scopes.size()) {
            Toc toc;
            AdaptableHelpResource scope = (AdaptableHelpResource)this.scopes.get(i);
            if (scope.getTopic(href) != null) {
                return scope;
            }
            IToc tocRoot = this.getTocForScope(scope, this.locale);
            if (tocRoot != null && (toc = (Toc)tocRoot).getOwnedExtraTopic(href) != null) {
                return scope;
            }
            if (scope instanceof AdaptableToc) {
                Toc tocScope;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.help.IToc");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (this.isExtraDirTopic((INavigationElement)(tocScope = (Toc)scope.getAdapter(clazz)), href)) {
                    return scope;
                }
            } else {
                Topic topicScope;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.help.ITopic");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (this.isExtraDirTopic((INavigationElement)(topicScope = (Topic)scope.getAdapter(clazz)), href)) {
                    return scope;
                }
            }
            ++i;
        }
        return null;
    }

    private IToc getTocForScope(AdaptableHelpResource scope, String locale) {
        if (scope == null) {
            return null;
        }
        String href = scope.getHref();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.help.IToc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (scope.getAdapter(clazz) instanceof IToc) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.help.IToc");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Toc toc = (Toc)scope.getAdapter(clazz2);
            href = toc.getTocTopicHref();
        }
        if (href != null && href.length() > 0) {
            return this.getTocForTopic(href, locale);
        }
        AdaptableHelpResource[] childrenScopes = scope.getChildren();
        if (childrenScopes != null) {
            int i = 0;
            while (i < childrenScopes.length) {
                IToc toc = this.getTocForScope(childrenScopes[i], locale);
                if (toc != null) {
                    return toc;
                }
                ++i;
            }
        }
        return null;
    }

    private IToc getTocForTopic(String href, String locale) {
        ITocElement[] tocs = HelpPlugin.getTocManager().getTocs(locale);
        int i = 0;
        while (i < tocs.length) {
            ITopic topic = tocs[i].getTopic(href);
            if (topic != null) {
                return tocs[i];
            }
            ++i;
        }
        return null;
    }

    public SearchHit[] getSearchHits() {
        return this.searchHits;
    }

    private ArrayList getScopes(WorkingSet[] wSets) {
        if (wSets == null) {
            return null;
        }
        this.scopes = new ArrayList(wSets.length);
        int w = 0;
        while (w < wSets.length) {
            AdaptableHelpResource[] elements = wSets[w].getElements();
            int i = 0;
            while (i < elements.length) {
                this.scopes.add(elements[i]);
                ++i;
            }
            ++w;
        }
        return this.scopes;
    }

    boolean isExtraDirTopic(INavigationElement navElement, String href) {
        Toc toc;
        if (navElement instanceof Toc && (toc = (Toc)navElement).getOwnedExtraTopic(href) != null) {
            return true;
        }
        List list = navElement.getChildren();
        int i = 0;
        while (i < list.size()) {
            Object tocNode = list.get(i);
            if (this.isExtraDirTopic((INavigationElement)tocNode, href)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

