/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;

public class ResourceHandler {
    public static final String PROPERTIES_FILE = "runtimeibm";

    public static ResourceBundle getBundle(FacesContext context) {
        if (context == null) {
            context = FacesContext.getCurrentInstance();
        }
        if (context != null) {
            return ResourceBundle.getBundle(PROPERTIES_FILE, context.getViewRoot().getLocale());
        }
        return ResourceBundle.getBundle(PROPERTIES_FILE);
    }

    public static String getServerString(String key) {
        try {
            return ResourceBundle.getBundle(PROPERTIES_FILE).getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    public static String getString(ResourceBundle bundle, String key) {
        if (bundle == null) {
            bundle = ResourceHandler.getBundle(null);
        }
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException e) {
                return "!" + key + "!";
            }
        }
        return "!" + key + "!";
    }

    public static String getString(ResourceBundle bundle, String key, Object[] args) {
        try {
            return MessageFormat.format(ResourceHandler.getString(bundle, key), args);
        }
        catch (IllegalArgumentException e) {
            return ResourceHandler.getString(bundle, key);
        }
    }

    public static String buildLocalizedLibName(ResourceBundle bundle, String lib) {
        if (bundle == null) {
            bundle = ResourceHandler.getBundle(null);
        }
        if (bundle == null) {
            return lib;
        }
        String suffix = bundle.getString("Locale.suffix");
        if (suffix == null || suffix.trim().length() == 0 || suffix.equals("!Locale.suffix!")) {
            return lib;
        }
        int n = lib.lastIndexOf(".js");
        return String.valueOf(lib.substring(0, n)) + "_" + suffix + ".js";
    }
}

