/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.component;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.UIFileProp;
import com.ibm.faces.fileupload.util.ContentElement;
import com.ibm.faces.util.Base64;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class UIFileupload
extends UIInput {
    public static final int VALUE_REF_BYTE_ARRAY = 0;
    public static final int VALUE_REF_STRING = 1;
    public static final int VALUE_REF_STREAM = 2;
    private int valueRefType;
    private ContentElement value;
    private String filename;
    private String mimetype;
    public static final String IAE_MSG = "Runtime Error: attribute ValueRef must be of type java.lang.String or byte[]";
    public static final String COMPONENT_FAMILY = "com.ibm.faces.Fileupload";
    static /* synthetic */ Class class$0;

    public String getComponentType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.faces.component.UIFileupload");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    public void setValue(Object valueRef) {
        this.value = (ContentElement)valueRef;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getLocalValue() {
        return this.value;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid()) {
            return;
        }
        if (this.value == null) {
            return;
        }
        try {
            ValueBinding vb = this.getValueBinding("value");
            if (vb != null) {
                Class valueType = vb.getType(context);
                if (valueType.getName().equals("java.lang.String")) {
                    this.valueRefType = 1;
                } else if (valueType.getName().equals("[B")) {
                    this.valueRefType = 0;
                } else {
                    Object val = vb.getValue(context);
                    if (val instanceof OutputStream) {
                        this.valueRefType = 2;
                    } else {
                        throw new IllegalArgumentException(IAE_MSG);
                    }
                }
                String fname = this.getFilename();
                String fmime = this.getMimetype();
                switch (this.valueRefType) {
                    case 0: {
                        vb.setValue(context, (Object)this.value.getContentValue());
                        break;
                    }
                    case 1: {
                        vb.setValue(context, (Object)Base64.encode(this.value.getContentValue()));
                        break;
                    }
                    case 2: {
                        OutputStream os = (OutputStream)vb.getValue(context);
                        os.write(this.value.getContentValue());
                        vb.setValue(context, (Object)os);
                    }
                }
                Iterator kids = this.getChildren().iterator();
                while (kids.hasNext()) {
                    UIFileProp prop;
                    Object kid = kids.next();
                    if (!(kid instanceof UIFileProp) || (prop = (UIFileProp)((Object)kid)).getName() == null || !prop.getName().equalsIgnoreCase("filename") && !prop.getName().equalsIgnoreCase("contenttype")) continue;
                    if (prop.getName().equalsIgnoreCase("filename")) {
                        prop.setValue(this.getFilename());
                    } else {
                        prop.setValue(this.getMimetype());
                    }
                    ValueBinding pvb = prop.getValueBinding("value");
                    if (pvb == null) continue;
                    pvb.setValue(context, (Object)prop.getValue());
                }
                this.setValid(true);
                return;
            }
        }
        catch (OutOfMemoryError e) {
            ResourceBundle rb = ResourceHandler.getBundle(context);
            System.err.println("OutOfMemoryError=fileupload : " + ResourceHandler.getString(rb, "FileUpload.ServerOutOfMemoryErr"));
            FacesMessage m = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(rb, "FileUpload.ServerOutOfMemoryErr"), ResourceHandler.getString(rb, "FileUpload.ServerOutOfMemoryErr"));
            context.addMessage(this.getClientId(context), m);
            this.setValid(false);
        }
        catch (FacesException e) {
            System.err.println("FacesException=" + e.getMessage());
            this.setValid(false);
            throw e;
        }
        catch (IllegalArgumentException e) {
            System.err.println("IllegalArgumentException=" + e.getMessage());
            this.setValid(false);
            throw e;
        }
        catch (Exception e) {
            System.err.println("Exception=" + e.getMessage());
            this.setValid(false);
            throw new FacesException((Throwable)e);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setMimetype(String string) {
        this.mimetype = string;
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void validate(FacesContext context) {
        if (this.isValid() && this.isRequired() && this.getValue() == null) {
            ResourceBundle rb = ResourceHandler.getBundle(context);
            FacesMessage message = new FacesMessage(ResourceHandler.getString(rb, "ValidationMessage.value_is_required"));
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
    }
}

