/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.component;

import com.ibm.faces.event.PagerEvent;
import javax.faces.component.UICommand;
import javax.faces.component.UIData;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;

public class UIPager
extends UICommand
implements ActionListener {
    public static final String COMPONENT_FAMILY = "com.ibm.faces.Pager";

    public void processAction(ActionEvent event) throws AbortProcessingException {
        if (event instanceof PagerEvent) {
            this.processAction((PagerEvent)event);
        }
    }

    private void processAction(PagerEvent pagerEvent) {
        UIData data = pagerEvent.getData();
        int rows = data.getRows();
        if (rows <= 0) {
            return;
        }
        int page = pagerEvent.getPage();
        page = this.getCheckRange(data, page, rows);
        int first = data.getFirst();
        int currentPage = (first + 1) / rows;
        if (rows == 1) {
            currentPage = first;
        }
        if ((first + 1) % rows > 1) {
            ++currentPage;
        }
        if (page > currentPage) {
            first += (page - currentPage) * rows;
        }
        if (page < currentPage) {
            first -= (currentPage - page) * rows;
        }
        if (first < 0) {
            first = 0;
        }
        data.setFirst(first);
    }

    private int getCheckRange(UIData data, int page, int rows) {
        if (page <= 0) {
            return 0;
        }
        int max = data.getRowCount();
        if (max > 0) {
            int first = data.getFirst();
            int lastPage = first / rows;
            if (first % rows > 0) {
                ++lastPage;
            }
            lastPage += (max - (first + rows)) / rows;
            if (first + rows <= max && (max - (first + rows)) % rows > 0) {
                ++lastPage;
            }
            if (page > lastPage) {
                page = lastPage;
            }
        }
        return page;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof ActionEvent) {
            this.processAction((ActionEvent)event);
        }
        super.broadcast(event);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }
}

