/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.component;

import com.ibm.faces.component.IScriptContributor;
import com.ibm.faces.util.JavaScriptUtil;
import com.ibm.faces.util.LifecycleUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;

public class UIScriptCollector
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "com.ibm.faces.ScriptCollector";
    public static final String COMPONENT_FAMILY = "com.ibm.faces.ScriptCollector";
    public static final int FIND_NEAREST = 1;
    public static final int FIND_TOPMOST = 2;
    public static final int ADD_AT_TOP = 1;
    public static final int ADD_AT_BOTTOM = 2;
    private Vector scriptsTop = null;
    private Vector scriptsBottom = null;
    private HashMap contributors = null;
    private HashMap libraries = null;
    private Vector writtenLibraries = null;
    private Vector writtenScripts = null;
    private MethodBinding preRender = null;
    private MethodBinding postRender = null;
    private MethodBinding decode = null;

    public UIScriptCollector() {
        this.setRendererType("ScriptCollector");
        this.scriptsTop = new Vector();
        this.scriptsBottom = new Vector();
        this.contributors = new HashMap();
        this.libraries = new HashMap();
        this.writtenLibraries = new Vector();
        this.writtenScripts = new Vector();
    }

    public String getFamily() {
        return "com.ibm.faces.ScriptCollector";
    }

    public void addScript(String newScript, int addWhere) {
        if (addWhere == 1) {
            this.scriptsTop.add(newScript);
        } else {
            this.scriptsBottom.add(newScript);
        }
    }

    public void addScript(String newScript) {
        this.addScript(newScript, 2);
    }

    public void addScriptOnce(String newScript) {
        this.addScriptOnce(newScript, 2);
    }

    public void addScriptOnce(String newScript, int addWhere) {
        Vector scripts = addWhere == 1 ? this.scriptsTop : this.scriptsBottom;
        int i = 0;
        while (i < scripts.size()) {
            String str = (String)scripts.get(i);
            if (str.equals(newScript)) {
                return;
            }
            ++i;
        }
        scripts.add(newScript);
    }

    public Vector getScriptsTop() {
        return this.scriptsTop;
    }

    public Vector getScriptsBottom() {
        return this.scriptsBottom;
    }

    public void reset() {
        this.scriptsTop.clear();
        this.scriptsBottom.clear();
        this.contributors.clear();
        this.libraries.clear();
        this.writtenLibraries.clear();
        this.writtenScripts.clear();
    }

    public void register(IScriptContributor contributor, UIComponent component) {
        this.contributors.put(component, contributor);
    }

    public HashMap getContributors() {
        return this.contributors;
    }

    public static UIScriptCollector find(UIComponent component, int scope) {
        UIScriptCollector scriptCollector = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof UIScriptCollector)) continue;
            scriptCollector = (UIScriptCollector)component;
            if (scope != 1) continue;
            return scriptCollector;
        }
        return scriptCollector;
    }

    public static UIScriptCollector find(UIComponent component) {
        return UIScriptCollector.find(component, 2);
    }

    public void addLibrary(String newLib, String libBlock) {
        this.libraries.put(newLib, libBlock);
    }

    public void addLibrary(String newLib) {
        if (!this.libraries.containsKey(newLib)) {
            StringBuffer libBlock = new StringBuffer();
            libBlock.append(JavaScriptUtil.getStartTag(newLib));
            libBlock.append(JavaScriptUtil.getEndTag());
            this.addLibrary(newLib, libBlock.toString());
        }
    }

    public void writeLibraryReference(String newLib, FacesContext context) {
        int i = 0;
        while (i < this.writtenLibraries.size()) {
            String str = (String)this.writtenLibraries.get(i);
            if (str.equals(newLib)) {
                return;
            }
            ++i;
        }
        ResponseWriter writer = context.getResponseWriter();
        String lib = String.valueOf(LifecycleUtil.getContextPath(context)) + "/" + newLib;
        try {
            writer.write(JavaScriptUtil.getStartTag(lib));
            writer.write(JavaScriptUtil.getEndTag());
            writer.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writtenLibraries.add(newLib);
    }

    public void writeLibraryReference(FacesContext context, String newLib, String libBlock) {
        int i = 0;
        while (i < this.writtenLibraries.size()) {
            String str = (String)this.writtenLibraries.get(i);
            if (str.equals(newLib)) {
                return;
            }
            ++i;
        }
        ResponseWriter writer = context.getResponseWriter();
        String lib = String.valueOf(LifecycleUtil.getContextPath(context)) + "/" + newLib;
        try {
            writer.write("\n");
            writer.write(libBlock);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writtenLibraries.add(newLib);
    }

    public void writeScriptOnce(String newScript, FacesContext context, boolean bWrapInScriptBlock) {
        int i = 0;
        while (i < this.writtenScripts.size()) {
            String str = (String)this.writtenScripts.get(i);
            if (str.equals(newScript)) {
                return;
            }
            ++i;
        }
        ResponseWriter writer = context.getResponseWriter();
        try {
            if (bWrapInScriptBlock) {
                writer.write("\n");
                writer.write(JavaScriptUtil.getStartTag());
            }
            writer.write("\n");
            writer.write(newScript);
            if (bWrapInScriptBlock) {
                writer.write("\n");
                writer.write(JavaScriptUtil.getEndTag());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writtenScripts.add(newScript);
    }

    public Vector getLibraries() {
        return new Vector(this.libraries.keySet());
    }

    public HashMap getLibraryBlocks() {
        return this.libraries;
    }

    public MethodBinding getDecode() {
        return this.decode;
    }

    public MethodBinding getPostRender() {
        return this.postRender;
    }

    public MethodBinding getPreRender() {
        return this.preRender;
    }

    public void setDecode(MethodBinding binding) {
        this.decode = binding;
    }

    public void setPostRender(MethodBinding binding) {
        this.postRender = binding;
    }

    public void setPreRender(MethodBinding binding) {
        this.preRender = binding;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.decode), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.preRender), UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.postRender)};
        return values;
    }

    public void restoreState(FacesContext context, Object valueArray) {
        Object[] values = (Object[])valueArray;
        super.restoreState(context, values[0]);
        this.decode = (MethodBinding)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[1]);
        this.preRender = (MethodBinding)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[2]);
        this.postRender = (MethodBinding)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[3]);
    }
}

