/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.converter;

import com.ibm.faces.ResourceHandler;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;

public class MaskConverter
implements Converter,
StateHolder {
    private String mask;
    private boolean asis;
    private String sourceObjType;
    public static final String CONVERTER_ID = "com.ibm.faces.Mask";
    private boolean transientFlag = false;
    static /* synthetic */ Class class$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        ResourceBundle rb = ResourceHandler.getBundle(context);
        if (context == null) throw new NullPointerException(ResourceHandler.getString(rb, "ConstraintValidator.FacesContext_or_UIComponent_is_null._5"));
        if (component == null) {
            throw new NullPointerException(ResourceHandler.getString(rb, "ConstraintValidator.FacesContext_or_UIComponent_is_null._5"));
        }
        if (value == null) return null;
        if (value.length() < 1) {
            return null;
        }
        try {
            if (this.asis) {
                this.removeNonDataCharacter(value, this.mask, rb);
                return value;
            }
            String modValue = this.removeNonDataCharacter(value, this.mask, rb);
            if (this.sourceObjType != null) return this.convertToOrignType(this.sourceObjType, modValue, rb);
            ValueBinding valuebinding = component.getValueBinding("value");
            if (valuebinding == null) return this.removeNonDataCharacter(value, this.mask, rb);
            String type = valuebinding.getType(context).getName();
            if (type == null) {
                MessageFormat format = new MessageFormat(ResourceHandler.getString(rb, "MaskConverter.Failed_to_convert___{0}___to_the_object_due_to_unknown_data_type._1"));
                Object[] obj = new Object[]{value};
                throw new ConverterException(format.format(obj));
            }
            this.sourceObjType = type;
            return this.convertToOrignType(this.sourceObjType, modValue, rb);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        ResourceBundle rb = ResourceHandler.getBundle(context);
        if (context == null || component == null) {
            throw new NullPointerException(ResourceHandler.getString(rb, "ConstraintValidator.FacesContext_or_UIComponent_is_null._5"));
        }
        if (value == null) {
            return "";
        }
        try {
            String sourceString;
            if (value instanceof String) {
                sourceString = (String)value;
            } else if (value instanceof Number) {
                sourceString = value.toString();
                int nDigits = this.getNumberOfDigitsInMask();
                if (sourceString.length() < nDigits) {
                    StringBuffer str = new StringBuffer();
                    int i = 0;
                    while (i < nDigits - sourceString.length()) {
                        str.append("0");
                        ++i;
                    }
                    str.append(sourceString);
                    sourceString = str.toString();
                }
            } else {
                sourceString = value.toString();
            }
            this.sourceObjType = value.getClass().getName();
            return this.getMaskedString(this.mask, sourceString, rb, context, component);
        }
        catch (Exception e) {
            throw new ConverterException((Throwable)e);
        }
    }

    private String removeNonDataCharacter(String data, String mask, ResourceBundle rb) {
        boolean b = true;
        char[] dataArray = data.toCharArray();
        char[] maskArray = mask.toCharArray();
        StringBuffer result = new StringBuffer();
        if (dataArray.length == maskArray.length) {
            int i = 0;
            while (i < dataArray.length) {
                String temp = String.valueOf(maskArray[i]);
                if (temp.equals("?") || temp.equals("#")) {
                    boolean tmp = this.isValidType(temp, dataArray[i]);
                    if (!tmp) {
                        b = false;
                        break;
                    }
                    result.append(dataArray[i]);
                } else if (maskArray[i] != dataArray[i]) {
                    b = false;
                    break;
                }
                ++i;
            }
        } else {
            b = false;
        }
        if (b) {
            return result.toString();
        }
        throw new ConverterException(ResourceHandler.getString(rb, "MaskConverter.Data_String_and_mask_pattern_are_mismatched._1"));
    }

    private Object convertToOrignType(String type, String value, ResourceBundle rb) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] classes = classArray;
        Object[] values = new String[]{value};
        try {
            Constructor<?> construtor = Class.forName(type).getConstructor(classes);
            Object obj = construtor.newInstance(values);
            return obj;
        }
        catch (Exception e) {
            throw new ConverterException(ResourceHandler.getString(rb, "MaskConverter.Error__Fail_to_covert_original_Object_type._2"));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getMaskedString(String mask, String source, ResourceBundle rb, FacesContext context, UIComponent component) {
        StringBuffer tmp = new StringBuffer();
        char[] maskChars = mask.toCharArray();
        char[] sourceChars = source.toCharArray();
        int sourceCharIndex = 0;
        int sourceLength = sourceChars.length;
        int maskLength = maskChars.length;
        int i = 0;
        while (i < maskLength) {
            block11: {
                block12: {
                    String temp = String.valueOf(maskChars[i]);
                    if (temp.equals("?") || temp.equals("#")) {
                        if (sourceLength <= sourceCharIndex) {
                            return source;
                        }
                        if (Character.isLetterOrDigit(sourceChars[sourceCharIndex])) {
                            boolean b = this.isValidType(temp, sourceChars[sourceCharIndex]);
                            if (!b) {
                                FacesMessage errMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(rb, "MaskConverter.Conversion_Error__Source_string_is_unmatched_with_mask_pattern._3"), ResourceHandler.getString(rb, "MaskConverter.Conversion_Error__Source_string_is_unmatched_with_mask_pattern._3"));
                                context.addMessage(component.getClientId(context), errMsg);
                                return source;
                            }
                            tmp.append(sourceChars[sourceCharIndex]);
                            ++sourceCharIndex;
                            break block11;
                        } else {
                            if (Character.isSpaceChar(sourceChars[sourceCharIndex])) {
                                return source;
                            }
                            FacesMessage errMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(rb, "MaskConverter.Conversion_Error__Source_string_is_unmatched_with_mask_pattern._4"), ResourceHandler.getString(rb, "MaskConverter.Conversion_Error__Source_string_is_unmatched_with_mask_pattern._4"));
                            context.addMessage(component.getClientId(context), errMsg);
                            return source;
                        }
                    }
                    if (sourceLength <= sourceCharIndex) break block12;
                    if (Character.isSpaceChar(sourceChars[sourceCharIndex])) {
                        tmp.append(maskChars[i]);
                        ++sourceCharIndex;
                        break block11;
                    } else if (Character.isLetterOrDigit(sourceChars[sourceCharIndex])) {
                        tmp.append(maskChars[i]);
                        break block11;
                    } else {
                        tmp.append(maskChars[i]);
                        ++sourceCharIndex;
                    }
                    break block11;
                }
                tmp.append(maskChars[i]);
            }
            ++i;
        }
        return tmp.toString();
    }

    private boolean isValidType(String placeHolder, char targetChar) {
        if (placeHolder.equals("?")) {
            return Character.isLetter(targetChar);
        }
        if (placeHolder.equals("#")) {
            return Character.isDigit(targetChar);
        }
        return false;
    }

    private int getNumberOfDigitsInMask() {
        int result = 0;
        char[] maskChars = this.mask.toCharArray();
        int maskLength = maskChars.length;
        int i = 0;
        while (i < maskLength) {
            String temp = String.valueOf(maskChars[i]);
            if (temp.equals("#")) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public boolean isAsis() {
        return this.asis;
    }

    public String getMask() {
        return this.mask;
    }

    public void setAsis(boolean b) {
        this.asis = b;
    }

    public void setMask(String string) {
        this.mask = string;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.mask = (String)values[0];
        this.asis = (Boolean)values[2];
        this.sourceObjType = (String)values[3];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[4];
        values[0] = this.mask;
        values[2] = new Boolean(this.asis);
        values[3] = this.sourceObjType;
        return values;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientFlag = newTransientValue;
    }
}

