/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.fileupload.util;

import com.ibm.faces.fileupload.util.ContentElement;
import com.ibm.faces.fileupload.util.ContentLine;
import com.ibm.faces.fileupload.util.ContentLineReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class MultipartContent {
    private InputStream is;
    private boolean debug = false;
    private byte[] dump;
    private Vector contents;

    public MultipartContent(InputStream i) {
        this.is = i;
        this.dump = null;
    }

    public void setDebug(boolean isDebug) {
        this.debug = isDebug;
    }

    public byte[] getDump() {
        return this.dump;
    }

    public Vector getContents(String encoding) throws IOException {
        if (this.contents == null) {
            this.contents = new Vector();
            ContentLineReader processOutputReader = new ContentLineReader(new BufferedInputStream(this.is), encoding, this.debug);
            ContentLine line = processOutputReader.readLine();
            if (line == null) {
                return this.contents;
            }
            String mark = line.getString();
            String endmark = String.valueOf(mark) + "--";
            boolean eoc = false;
            ContentElement elem = null;
            while (line != null && !eoc) {
                if (line.equals(mark)) {
                    if (elem != null) {
                        this.contents.addElement(elem);
                    }
                    elem = new ContentElement(encoding);
                } else if (line.equals(endmark)) {
                    if (elem != null) {
                        this.contents.addElement(elem);
                    }
                    eoc = true;
                } else {
                    elem.addToContent(line);
                }
                line = processOutputReader.readLine();
            }
            if (this.debug) {
                this.dump = processOutputReader.getDump();
            }
        }
        return this.contents;
    }
}

