/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.event.PagerEvent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.Renderer;

abstract class AbstractPagerRenderer
extends Renderer {
    AbstractPagerRenderer() {
    }

    protected UIData findDataComponent(UIComponent component) {
        String dataId = (String)component.getAttributes().get("for");
        UIComponent data = null;
        if (dataId != null) {
            data = component.findComponent(dataId);
        }
        if (data == null) {
            data = this.findDataParent(component);
        }
        return (UIData)data;
    }

    private UIComponent findDataParent(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof UIData) {
            return component;
        }
        return this.findDataParent(component.getParent());
    }

    protected int getCurrentPage(UIData data) {
        if (data == null) {
            return 0;
        }
        int rows = data.getRows();
        if (rows <= 0) {
            return 0;
        }
        int current = data.getFirst() / rows;
        if (data.getFirst() % rows > 0) {
            ++current;
        }
        if (current > this.getLastPage(data)) {
            current = 0;
            data.setFirst(0);
        }
        return current;
    }

    protected int getLastPage(UIData data) {
        if (data == null) {
            return 0;
        }
        int rows = data.getRows();
        if (rows <= 0) {
            return 0;
        }
        int max = data.getRowCount();
        if (max < 0) {
            return -1;
        }
        if (max > 0) {
            int first = data.getFirst();
            int lastPage = first / rows;
            if (first % rows > 0) {
                ++lastPage;
            }
            lastPage += (max - (first + rows)) / rows;
            if (first + rows <= max && (max - (first + rows)) % rows > 0) {
                ++lastPage;
            }
            return lastPage;
        }
        return 0;
    }

    protected boolean isPaged(UIData data) {
        if (data == null) {
            return false;
        }
        return data.getRows() > 0;
    }

    protected void queueEvent(UIComponent component, UIData target, int currentPage, int newPage, int lastPage) {
        if (newPage > lastPage && lastPage >= 0) {
            newPage = lastPage;
        }
        if (newPage < 0) {
            newPage = 0;
        }
        if (newPage != currentPage) {
            PagerEvent pagerEvent = new PagerEvent(component, target, newPage);
            pagerEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            component.queueEvent((FacesEvent)pagerEvent);
        }
    }
}

