/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.IScriptContributor;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlInputHelperAssist;
import com.ibm.faces.converter.MaskConverter;
import com.ibm.faces.converter.NumberConverterEx;
import com.ibm.faces.renderkit.html_extended.AssistVariables;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.util.ScriptObject;
import com.ibm.faces.validator.ConstraintValidator;
import com.ibm.faces.validator.DateTimeRangeValidator;
import com.ibm.faces.validator.ExpressionValidator;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.convert.NumberConverter;
import javax.faces.render.Renderer;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.LongRangeValidator;
import javax.faces.validator.Validator;

public class AssistRendererValidation
extends Renderer
implements IScriptContributor {
    private static final String ARG_SEP = ", ";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        if (!(component.getParent() instanceof UIInput)) {
            return;
        }
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
        if (HxClientRenderUtil.isContainedInPanel(component.getParent())) {
            this.encode(context, component, false);
        } else {
            scriptCollector.register(this, component);
        }
    }

    public void contributeScript(FacesContext context, UIComponent component) throws IOException {
        this.encode(context, component, true);
    }

    private void encode(FacesContext context, UIComponent component, boolean writeNow) throws IOException {
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        UIInput input = (UIInput)component.getParent();
        Converter converter = input.getConverter();
        BehaviorArgs behavior = new BehaviorArgs(component);
        if (!behavior.isValidation && !behavior.isAssist) {
            return;
        }
        ScriptObject converterScript = null;
        ScriptObject validatorScript = null;
        String maxLength = null;
        ExpressionValidator expressionValidator = HxClientRenderUtil.getExpressionValidator(input);
        if (converter instanceof DateTimeConverter) {
            converterScript = HxClientRenderUtil.buildJsDateConverter(context, (DateTimeConverter)converter);
            if (converterScript != null) {
                validatorScript = HxClientRenderUtil.buildJsRangeValidator(context, HxClientRenderUtil.getRangeValidator(input), input.isRequired(), expressionValidator);
            }
        } else if (converter instanceof NumberConverterEx) {
            converterScript = HxClientRenderUtil.buildJsNumberConverter(context, (NumberConverterEx)converter);
            if (converterScript != null) {
                validatorScript = HxClientRenderUtil.buildJsRangeValidator(context, HxClientRenderUtil.getRangeValidator(input), input.isRequired(), expressionValidator);
            }
        } else if (converter instanceof MaskConverter) {
            converterScript = HxClientRenderUtil.buildJsMaskConverter(context, (MaskConverter)converter);
        } else if (converter == null) {
            Validator[] validators = input.getValidators();
            ConstraintValidator constraint = null;
            LengthValidator length = null;
            int i = 0;
            while (i < validators.length) {
                Validator validator = validators[i];
                if (validator instanceof ConstraintValidator) {
                    constraint = (ConstraintValidator)validator;
                }
                if (validator instanceof LengthValidator) {
                    length = (LengthValidator)validator;
                }
                ++i;
            }
            String exp = constraint != null ? constraint.getRegex() : null;
            String minLength = length != null && length.getMinimum() > 0 ? Integer.toString(length.getMinimum()) : null;
            maxLength = length != null && length.getMaximum() > 0 ? Integer.toString(length.getMaximum()) : null;
            validatorScript = null;
            validatorScript = HxClientRenderUtil.buildJsAddStringValidator(context, exp, minLength, maxLength, input.isRequired(), expressionValidator);
        }
        String assistScript = null;
        String validateScript = null;
        if (behavior.isAssist) {
            assistScript = this.genAssistBehavior(input.getClientId(context), converterScript, validatorScript, behavior, maxLength);
        }
        if (behavior.isValidation) {
            behavior.setDefaultClass((String)input.getAttributes().get("styleClass"));
            validateScript = this.genValidateBehavior(input.getClientId(context), converterScript, validatorScript, behavior);
        }
        if (writeNow) {
            ResponseWriter writer = context.getResponseWriter();
            if (converterScript != null) {
                scriptCollector.writeScriptOnce(converterScript.getScript(), context, false);
            }
            if (validatorScript != null) {
                scriptCollector.writeScriptOnce(validatorScript.getScript(), context, false);
            }
            if (assistScript != null) {
                writer.write(assistScript);
            }
            if (validateScript != null) {
                writer.write(validateScript);
            }
        } else {
            if (converterScript != null) {
                scriptCollector.addScriptOnce(converterScript.getScript());
            }
            if (validatorScript != null) {
                scriptCollector.addScriptOnce(validatorScript.getScript());
            }
            if (assistScript != null) {
                scriptCollector.addScript(assistScript);
            }
            if (validateScript != null) {
                scriptCollector.addScript(validateScript);
            }
        }
    }

    private void checkConflict(AssistVariables variables) {
        if (variables.getAttributeFromMap("regex") != null) {
            String regex = (String)variables.getAttributeFromMap("regex");
            if (regex.equals("AlphabetOnly")) {
                String type;
                if (variables.isHasDateTimeConverter() || variables.isHasNumberConverter()) {
                    System.err.println(ResourceHandler.getServerString("AssistRenderer.Using_constraint___AlphabetOnly___is_inconsistent_with_DateTimeConverter_or_NumberConverter._13"));
                } else if (variables.isHasLongRangeValidator() || variables.isHasDoubleRangeValidator()) {
                    System.err.println(ResourceHandler.getServerString("AssistRenderer.Using_constraint___AlphabetOnly___is_inconsistent_with_LongRangeValidator_or_DoubleRangeValidator._14"));
                } else if (variables.isHasMaskConverter()) {
                    String mask;
                    boolean b;
                    if (variables.getAttributeFromMap("mask") != null && !(b = this.checkMaskWithConstraint(mask = (String)variables.getAttributeFromMap("mask"), "AlphabetOnly"))) {
                        System.err.println(ResourceHandler.getServerString("AssistRenderer.Using_constraint___AlphabetOnly___is_inconsistent_with_digit_place_holder_contained_mask_pattern._15"));
                    }
                } else if (variables.isHasNumberConverter() && variables.getAttributeFromMap("type") != null && (type = (String)variables.getAttributeFromMap("type")).equals("currency")) {
                    System.err.println(ResourceHandler.getServerString("AssistRenderer.Using_constraint___AlphabetOnly___is_inconsistent_with_converting_to_currency_type._17"));
                }
            } else if (regex.equals("DigitOnly")) {
                String mask;
                boolean b;
                if (variables.isHasDateTimeConverter()) {
                    System.err.println(ResourceHandler.getServerString("AssistRenderer.Using_constraint___DigitOnly___is_inconsistent_with_DateTimeConverter._18"));
                } else if (variables.isHasMaskConverter() && variables.getAttributeFromMap("mask") != null && !(b = this.checkMaskWithConstraint(mask = (String)variables.getAttributeFromMap("mask"), "DigitOnly"))) {
                    System.err.println(ResourceHandler.getServerString("AssistRenderer.Using_constraint___DigitOnly___is_inconsistent_with_letter_place_holder_or_literal_contained_mask_pattern._19"));
                }
            } else if (regex.equals("AlnumOnly") && (variables.isHasDoubleRangeValidator() || variables.isHasLongRangeValidator())) {
                System.err.println(ResourceHandler.getServerString("AssistRenderer.Using_constraint___AlnumOnly___is_inconsistent_with_LongRangeValidator_or_DoubleRangeConverter._20"));
            }
        }
        if (variables.isHasDoubleRangeValidator() && variables.isHasLongRangeValidator() || variables.isHasDoubleRangeValidator() && variables.isHasLengthValidator() || variables.isHasLongRangeValidator() && variables.isHasLengthValidator()) {
            System.err.println(ResourceHandler.getServerString("AssistRenderer.Two_or_more_validator_were_set._Unexpected_client_side_validation_may_be_occurred._21"));
        }
    }

    private boolean checkUnsupportedPattern(String pattern) {
        if (pattern != null) {
            String[] unsupportedChars = new String[]{"-", "E", ";", "%", "\u2030", "\u00a4", "'"};
            int i = 0;
            while (i < unsupportedChars.length) {
                if (pattern.indexOf(unsupportedChars[i]) != -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return true;
    }

    private boolean checkUniCodeRange(Character c) {
        Character lim1 = new Character('!');
        Character lim2 = new Character('Z');
        Character lim3 = new Character('a');
        Character lim4 = new Character('z');
        Character lim5 = new Character('_');
        return c.compareTo(lim1) >= 0 && c.compareTo(lim2) <= 0 || c.compareTo(lim3) >= 0 && c.compareTo(lim4) <= 0 || c.compareTo(lim5) == 0;
    }

    private String replaceDecimalSeparator(String value, String decimalSeparator) {
        if (value != null && decimalSeparator != null) {
            char separator = decimalSeparator.charAt(0);
            return value.replace('.', separator);
        }
        return null;
    }

    private String genValidDateMask(String dateStyle, Locale locale, String pattern, String timeStyle, TimeZone timeZone, String type) {
        String datePattern = null;
        if (pattern != null) {
            SimpleDateFormat sd = new SimpleDateFormat(pattern, locale);
            if (timeZone != null) {
                sd.setTimeZone(timeZone);
            }
            datePattern = sd.toPattern();
        } else if (type.equals("both")) {
            DateFormat df = DateFormat.getDateTimeInstance(this.getStyle(dateStyle), this.getStyle(timeStyle), locale);
            try {
                datePattern = ((SimpleDateFormat)df).toPattern();
            }
            catch (Exception e) {
                SimpleDateFormat sd = new SimpleDateFormat("MMM d, yyyy h:mm:ss a", locale);
                if (timeZone != null) {
                    sd.setTimeZone(timeZone);
                }
                datePattern = sd.toPattern();
            }
        } else if (type.equals("date")) {
            DateFormat df = DateFormat.getDateInstance(this.getStyle(dateStyle), locale);
            try {
                datePattern = ((SimpleDateFormat)df).toPattern();
            }
            catch (Exception e) {
                SimpleDateFormat sd = new SimpleDateFormat("MMM d, yyyy", locale);
                if (timeZone != null) {
                    sd.setTimeZone(timeZone);
                }
                datePattern = sd.toPattern();
            }
        } else if (type.equals("time")) {
            DateFormat df = DateFormat.getTimeInstance(this.getStyle(timeStyle), locale);
            try {
                datePattern = ((SimpleDateFormat)df).toPattern();
            }
            catch (Exception e) {
                SimpleDateFormat sd = new SimpleDateFormat("h:mm:ss a", locale);
                if (timeZone != null) {
                    sd.setTimeZone(timeZone);
                }
                datePattern = sd.toPattern();
            }
        }
        if (datePattern != null) {
            return this.checkDatePattern(datePattern);
        }
        return null;
    }

    private String checkDatePattern(String pattern) {
        String tmp = pattern;
        char[] targetChars = new char[]{'G', 'y', 'M', 'E', 'a', 'z'};
        int i = 0;
        while (i < targetChars.length) {
            Object[] obj = this.checkUpperLimit(pattern, targetChars[i]);
            boolean b = new Boolean((String)obj[0]);
            if (!b) {
                int j = 1;
                while (j < obj.length) {
                    int num = Integer.parseInt((String)obj[j]);
                    tmp = this.replaceValidString(targetChars[i], num, tmp);
                    ++j;
                }
            }
            ++i;
        }
        return tmp;
    }

    private int getStyle(String style) {
        if (style.equals("default")) {
            return 2;
        }
        if (style.equals("short")) {
            return 3;
        }
        if (style.equals("medium")) {
            return 2;
        }
        if (style.equals("long")) {
            return 1;
        }
        return 0;
    }

    private String replaceValidString(char target, int num, String pattern) {
        String tmp = null;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < num) {
            sb.append(target);
            ++i;
        }
        String oldStr = sb.toString();
        StringBuffer nb = new StringBuffer();
        int i2 = 0;
        while (i2 < 4) {
            nb.append(target);
            ++i2;
        }
        String newStr = nb.toString();
        int start = pattern.indexOf(oldStr);
        if (start != -1) {
            tmp = start != 0 ? String.valueOf(pattern.substring(0, start)) + newStr + pattern.substring(start + num) : String.valueOf(newStr) + pattern.substring(num);
        }
        return tmp;
    }

    private Object[] checkUpperLimit(String pattern, char target) {
        boolean isFirst = true;
        boolean b = true;
        boolean isOnlyOne = true;
        int num = 0;
        int recentPosition = 0;
        int index = 1;
        ArrayList<String> info = new ArrayList<String>();
        info.add(0, String.valueOf(b));
        char[] patArray = pattern.toCharArray();
        int len = patArray.length;
        int i = 0;
        while (i < len) {
            if (patArray[i] == target) {
                if (isFirst) {
                    recentPosition = i;
                    isFirst = false;
                }
                if (i - recentPosition <= 1) {
                    ++num;
                    recentPosition = i;
                } else {
                    if (num > 4) {
                        b = false;
                        isOnlyOne = false;
                        info.remove(0);
                        info.add(0, String.valueOf(b));
                        info.add(index, String.valueOf(num));
                        ++index;
                    }
                    num = 0;
                    isFirst = true;
                    --i;
                }
            }
            ++i;
        }
        if (isOnlyOne) {
            if (num > 4) {
                b = false;
            }
            info.remove(0);
            info.add(0, String.valueOf(b));
            info.add(1, String.valueOf(num));
        }
        return info.toArray();
    }

    private String[] genValidNumPatterns(String pattern, String type, Locale locale, AssistVariables variables) {
        int minBound;
        int maxBound;
        String[] numPatterns = new String[4];
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
        numPatterns[0] = String.valueOf(dfs.getGroupingSeparator());
        numPatterns[1] = String.valueOf(dfs.getDecimalSeparator());
        numPatterns[2] = pattern != null ? String.valueOf(this.getDecimalPlaces(pattern, locale)) : ((maxBound = ((Integer)variables.getAttributeFromMap("maxFractionDigits")).intValue()) >= (minBound = ((Integer)variables.getAttributeFromMap("minFractionDigits")).intValue()) && maxBound != 0 ? String.valueOf(maxBound) : null);
        numPatterns[2] = this.checkDecimalPlaces(numPatterns[2], pattern);
        numPatterns[3] = type.equals("currency") ? (variables.getAttributeFromMap("currencySymbol") != null ? (String)variables.getAttributeFromMap("currencySymbol") : dfs.getCurrencySymbol()) : null;
        return numPatterns;
    }

    private String checkDecimalPlaces(String decimalPlaces, String pattern) {
        if (decimalPlaces == null) {
            return null;
        }
        if (pattern == null) {
            return null;
        }
        if (decimalPlaces.equals("0")) {
            if (pattern.indexOf(".") != -1) {
                return "0";
            }
            return null;
        }
        return decimalPlaces;
    }

    private String[] genValueLimits(boolean isNumber, boolean isConstraint, AssistVariables variables) {
        String[] valueLimits = new String[]{this.getMax("value", variables), this.getMin("value", variables), this.getMaxDigits(variables), this.getMax("length", variables), this.getMin("length", variables)};
        if (!variables.isHasDateTimeRangeValidator()) {
            int maxValueLength;
            String tmp;
            int minLength;
            Long l;
            Double d;
            if (valueLimits[0] != null) {
                if (valueLimits[0].indexOf("E") != -1 || valueLimits[0].indexOf(".") != -1) {
                    d = new Double(valueLimits[0]);
                    if (d.compareTo(new Double(Double.MAX_VALUE)) == 0) {
                        valueLimits[0] = null;
                    }
                } else {
                    l = new Long(valueLimits[0]);
                    if (l.compareTo(new Long(0L)) == 0) {
                        valueLimits[0] = null;
                    }
                }
            }
            if (valueLimits[1] != null) {
                if (valueLimits[1].indexOf("E") != -1 || valueLimits[1].indexOf(".") != -1) {
                    d = new Double(valueLimits[1]);
                    if (d.compareTo(new Double(Double.MIN_VALUE)) == 0) {
                        valueLimits[1] = null;
                    }
                } else {
                    l = new Long(valueLimits[1]);
                    if (l.compareTo(new Long(0L)) == 0) {
                        valueLimits[1] = null;
                    }
                }
            }
            if (valueLimits[0] != null && valueLimits[1] != null) {
                double maxValue = Double.parseDouble(valueLimits[0]);
                double minValue = Double.parseDouble(valueLimits[1]);
                if (minValue > maxValue) {
                    System.err.println(ResourceHandler.getServerString("AssistRenderer.Minimum_value_is_larger_than_maximum_value._Unexpected_behavior_occurred._Check_the_attribute_value._126"));
                }
            }
            if (valueLimits[3] != null && valueLimits[4] != null) {
                int maxLength = Integer.parseInt(valueLimits[3]);
                minLength = Integer.parseInt(valueLimits[4]);
                if (minLength > maxLength) {
                    System.err.println(ResourceHandler.getServerString("AssistRenderer.Minimum_length_is_larger_than_maximum_length._Unexpected_behavior_occurred._Check_the_attribute_value._127"));
                }
            }
            if (valueLimits[2] != null && valueLimits[4] != null) {
                int maxDigits = Integer.parseInt(valueLimits[2]);
                minLength = Integer.parseInt(valueLimits[4]);
                if (minLength > maxDigits) {
                    System.err.println(ResourceHandler.getServerString("AssistRenderer.Minimum_length_is_larger_than_maximum_digits._Unexpected_behavior_occurred._Check_the_attribute_value._128"));
                }
            }
            if (isNumber && valueLimits[2] != null && valueLimits[0] != null) {
                int maxDigits = Integer.parseInt(valueLimits[2]);
                int indexE = valueLimits[0].indexOf("E");
                if (indexE != -1) {
                    tmp = this.removeExp(valueLimits[0]);
                    maxValueLength = tmp.length() - 1;
                } else {
                    maxValueLength = valueLimits[0].indexOf(".") != -1 ? this.removeExp(valueLimits[0]).length() - 1 : this.removeExp(valueLimits[0]).length();
                }
                if (maxDigits < maxValueLength) {
                    System.err.println(ResourceHandler.getServerString("AssistRenderer.Digits_of_maximum_value_is_larger_than_maximum_digits._Unexpected_behavior_may_be_occurred._Check_the_attribute_value._131"));
                }
            }
            if (isConstraint && !variables.isMaxDigitUsed() && valueLimits[0] != null && valueLimits[3] != null) {
                int maxLength = Integer.parseInt(valueLimits[3]);
                int indexE = valueLimits[0].indexOf("E");
                if (indexE != -1) {
                    tmp = this.removeExp(valueLimits[0]);
                    maxValueLength = tmp.length() - 1;
                } else {
                    maxValueLength = valueLimits[0].indexOf(".") != -1 ? this.removeExp(valueLimits[0]).length() - 1 : this.removeExp(valueLimits[0]).length();
                }
                if (maxLength < maxValueLength) {
                    System.err.println(ResourceHandler.getServerString("AssistRenderer.Digits_of_maximum_value_is_larger_than_maximum_length._Unexpected_behavior_may_be_occurred._Check_the_attribute_value._134"));
                }
            }
        }
        return valueLimits;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getMax(String type, AssistVariables variables) {
        if (variables.isHasDateTimeConverter() && variables.isHasDateTimeRangeValidator()) {
            if (variables.getAttributeFromMap("maxDate") == null) return null;
            String dateString = this.createDateString((Date)variables.getAttributeFromMap("maxDate"));
            if (!type.equals("value")) return null;
            return dateString;
        }
        if (variables.isHasDateTimeRangeValidator() || !variables.isIsSpecifiedMaxLength() && !variables.isHasDoubleRangeValidator() && !variables.isHasLongRangeValidator() && !variables.isHasLengthValidator()) return null;
        Integer maxInputLength = (Integer)variables.getAttributeFromMap("maxlength");
        Double maxDoubleRange = (Double)variables.getAttributeFromMap("maxDoubleRange");
        Long maxLongRange = (Long)variables.getAttributeFromMap("maxLongRange");
        Integer maxLength = (Integer)variables.getAttributeFromMap("maxValidateLength");
        String maxValue = this.compareValue(maxDoubleRange, maxLongRange, "max");
        if (type.equals("value")) {
            return maxValue;
        }
        int[] values = new int[5];
        if (maxInputLength != null) {
            values[0] = maxInputLength < 0 ? 0 : maxInputLength;
        }
        if (maxLength != null) {
            values[1] = maxLength < 0 ? 0 : maxLength;
        }
        values[3] = 0;
        values[4] = 0;
        return this.getMinInt(values);
    }

    private String getMinInt(int[] values) {
        int[] temp = values;
        int num = temp.length;
        int tmpMin = 0;
        int i = 0;
        while (i < num) {
            if (temp[i] > 0) {
                if (tmpMin == 0) {
                    tmpMin = temp[i];
                } else if (tmpMin > temp[i]) {
                    tmpMin = temp[i];
                }
            }
            ++i;
        }
        if (tmpMin > 0) {
            return String.valueOf(tmpMin);
        }
        return null;
    }

    private String getMin(String type, AssistVariables variables) {
        if (variables.isHasDateTimeConverter() && variables.isHasDateTimeRangeValidator()) {
            if (variables.getAttributeFromMap("minDate") != null) {
                String dateString = this.createDateString((Date)variables.getAttributeFromMap("minDate"));
                if (type.equals("value")) {
                    return dateString;
                }
                return String.valueOf(dateString.length());
            }
            return null;
        }
        if (!variables.isHasDateTimeRangeValidator() && (variables.isHasDoubleRangeValidator() || variables.isHasLongRangeValidator() || variables.isHasLengthValidator())) {
            Double minDoubleValue = (Double)variables.getAttributeFromMap("minDoubleRange");
            Long minLongValue = (Long)variables.getAttributeFromMap("minLongRange");
            Integer minLength = (Integer)variables.getAttributeFromMap("minValidateLength");
            String minValue = this.compareValue(minDoubleValue, minLongValue, "min");
            if (type.equals("value")) {
                return minValue;
            }
            if (minLength != null) {
                return String.valueOf(minLength);
            }
            return null;
        }
        return null;
    }

    private String compareValue(Double dVal, Long lVal, String limitType) {
        if (dVal != null && lVal != null) {
            double parseDVal = dVal;
            double parseLVal = lVal.doubleValue();
            if (limitType.equals("max")) {
                if (parseDVal > parseLVal) {
                    return String.valueOf(parseLVal);
                }
                if (parseDVal < parseLVal) {
                    return String.valueOf(parseDVal);
                }
                return null;
            }
            if (parseDVal > parseLVal) {
                return String.valueOf(parseDVal);
            }
            if (parseDVal < parseLVal) {
                return String.valueOf(parseLVal);
            }
            return null;
        }
        if (dVal != null && lVal == null) {
            return Double.toString(dVal);
        }
        if (dVal == null && lVal != null) {
            return Long.toString(lVal);
        }
        return null;
    }

    private String getMaxDigits(AssistVariables variables) {
        int[] maxDigits = new int[]{variables.getAttributeFromMap("maxlength") != null ? (Integer)variables.getAttributeFromMap("maxlength") : 0, 0, variables.getAttributeFromMap("maxValidateLength") != null ? (Integer)variables.getAttributeFromMap("maxValidateLength") : 0, 0, 0, variables.isHasNumberConverter() ? this.getMaxDigitsFromNumberConverter(variables) : 0};
        return this.getMinInt(maxDigits);
    }

    private String removeExp(String doubleValue) {
        int indexM;
        String tmp = doubleValue;
        int indexE = tmp.indexOf("E");
        if (indexE != -1) {
            tmp = tmp.substring(0, indexE);
        }
        if ((indexM = tmp.indexOf("-")) != -1) {
            tmp = tmp.substring(indexM + 1);
        }
        return tmp;
    }

    private int getMaxDigitsFromNumberConverter(AssistVariables variables) {
        int maxIntDigits = 0;
        int maxFracDigits = 0;
        if (variables.getAttributeFromMap("maxIntegerDigits") != null) {
            maxIntDigits = (Integer)variables.getAttributeFromMap("maxIntegerDigits");
        }
        if (variables.getAttributeFromMap("maxFractionDigits") != null) {
            maxFracDigits = (Integer)variables.getAttributeFromMap("maxFractionDigits");
        }
        int intDigits = 0;
        int fracDigits = 0;
        if (maxIntDigits != 0) {
            intDigits = maxIntDigits;
        }
        if (maxFracDigits != 0) {
            fracDigits = maxFracDigits;
        }
        return intDigits + fracDigits;
    }

    private String createDateString(Date date) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyyMMddhhmmsszzz");
        String dateString = sd.format(date);
        return dateString;
    }

    private int getDecimalPlaces(String pattern, Locale locale) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
        DecimalFormat df = new DecimalFormat(pattern, dfs);
        return df.getMaximumFractionDigits();
    }

    private boolean checkMaskWithConstraint(String mask, String constraint) {
        char[] maskArray = mask.toCharArray();
        int length = maskArray.length;
        int i = 0;
        while (i < length) {
            boolean tmp = this.isMaskCharValid(maskArray[i], constraint);
            if (!tmp) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isMaskCharValid(char c, String constraint) {
        boolean b = true;
        String cs = String.valueOf(c);
        if (constraint.equals("AlphabetOnly")) {
            if (cs.equals("#")) {
                b = false;
            }
        } else if (constraint.equals("DigitOnly")) {
            if (!cs.equals("#")) {
                b = false;
            }
        } else if (constraint.equals("AlnumOnly")) {
            b = true;
        }
        return b;
    }

    private void lookupConverterAttribute(Converter converter, AssistVariables variables) {
        if (converter instanceof MaskConverter) {
            MaskConverter mConv = (MaskConverter)converter;
            if (mConv.getMask() != null) {
                variables.setAttributeToMap("mask", mConv.getMask());
            }
            variables.setHasMaskConverter(true);
        } else if (converter instanceof DateTimeConverter) {
            DateTimeConverter dtConv = (DateTimeConverter)converter;
            if (dtConv.getDateStyle() != null) {
                variables.setAttributeToMap("dateStyle", dtConv.getDateStyle());
            }
            if (dtConv.getPattern() != null) {
                variables.setAttributeToMap("pattern", dtConv.getPattern());
            }
            if (dtConv.getTimeStyle() != null) {
                variables.setAttributeToMap("timeStyle", dtConv.getTimeStyle());
            }
            if (dtConv.getType() != null) {
                variables.setAttributeToMap("type", dtConv.getType());
            }
            if (dtConv.getLocale() != null) {
                variables.setAttributeToMap("parseLocale", dtConv.getLocale());
            }
            if (dtConv.getTimeZone() != null) {
                variables.setAttributeToMap("timeZone", dtConv.getTimeZone());
            }
            variables.setHasDateTimeConverter(true);
        } else if (converter instanceof NumberConverter) {
            NumberConverter nConv = (NumberConverter)converter;
            variables.setAttributeToMap("groupingUsed", new Boolean(nConv.isGroupingUsed()));
            variables.setAttributeToMap("maxIntegerDigits", new Integer(nConv.getMaxIntegerDigits()));
            variables.setAttributeToMap("minIntegerDigits", new Integer(nConv.getMinIntegerDigits()));
            variables.setAttributeToMap("maxFractionDigits", new Integer(nConv.getMaxFractionDigits()));
            variables.setAttributeToMap("minFractionDigits", new Integer(nConv.getMinFractionDigits()));
            if (nConv.getPattern() != null) {
                variables.setAttributeToMap("pattern", nConv.getPattern());
            }
            if (nConv.getCurrencyCode() != null) {
                variables.setAttributeToMap("currencyCode", nConv.getCurrencyCode());
            }
            if (nConv.getCurrencySymbol() != null) {
                variables.setAttributeToMap("currencySymbol", nConv.getCurrencySymbol());
            }
            if (nConv.getLocale() != null) {
                variables.setAttributeToMap("parseLocale", nConv.getLocale());
            }
            if (nConv.getType() != null) {
                variables.setAttributeToMap("type", nConv.getType());
            }
            variables.setHasNumberConverter(true);
        }
    }

    private void lookupValidatorAttribute(Validator validator, AssistVariables variables) {
        if (validator instanceof ConstraintValidator) {
            ConstraintValidator cVal = (ConstraintValidator)validator;
            if (cVal.getRegex() != null) {
                variables.setAttributeToMap("regex", cVal.getRegex());
            }
            variables.setHasConstraintValidator(true);
        } else if (validator instanceof DoubleRangeValidator) {
            DoubleRangeValidator dVal = (DoubleRangeValidator)validator;
            variables.setAttributeToMap("maxDoubleRange", new Double(dVal.getMaximum()));
            variables.setAttributeToMap("minDoubleRange", new Double(dVal.getMinimum()));
            variables.setHasDoubleRangeValidator(true);
        } else if (validator instanceof LengthValidator) {
            LengthValidator lVal = (LengthValidator)validator;
            variables.setAttributeToMap("maxValidateLength", new Integer(lVal.getMaximum()));
            variables.setAttributeToMap("minValidateLength", new Integer(lVal.getMinimum()));
            variables.setHasLengthValidator(true);
        } else if (validator instanceof LongRangeValidator) {
            LongRangeValidator lrVal = (LongRangeValidator)validator;
            variables.setAttributeToMap("maxLongRange", new Long(lrVal.getMaximum()));
            variables.setAttributeToMap("minLongRange", new Long(lrVal.getMinimum()));
            variables.setHasLongRangeValidator(true);
        } else if (validator instanceof DateTimeRangeValidator) {
            DateTimeRangeValidator dtVal = (DateTimeRangeValidator)validator;
            if (dtVal.getMaximum() != null) {
                variables.setAttributeToMap("maxDate", dtVal.getMaximum());
            }
            if (dtVal.getMinimum() != null) {
                variables.setAttributeToMap("minDate", dtVal.getMinimum());
            }
            variables.setHasDateTimeRangeValidator(true);
        }
    }

    private String genAssistBehavior(String scope, ScriptObject converter, ScriptObject validator, BehaviorArgs behavior, String maxLength) {
        StringBuffer script = new StringBuffer();
        String[] basicArgs = new String[7];
        int iBaseArg = 0;
        String s = null;
        if (validator != null) {
            basicArgs[iBaseArg++] = "validator:" + validator.getId();
        }
        if (converter != null) {
            basicArgs[iBaseArg++] = "converter:" + converter.getId();
        }
        if ((s = behavior.getPromptCharacter()) != null) {
            if (s.equals("")) {
                s = "default";
            }
            basicArgs[iBaseArg++] = "prompt-char:" + s;
        }
        if ((s = behavior.getImeMode()) != null) {
            basicArgs[iBaseArg++] = "ime-mode:" + s;
        }
        if (behavior.getAutoTab() != null && behavior.getAutoTab().equalsIgnoreCase("true")) {
            basicArgs[iBaseArg++] = "auto-tab:" + maxLength;
        }
        if (basicArgs.length > 0) {
            script.append("\n").append("hX_4").append(".addBehavior(\"").append(scope).append("\", \"oninput\", new ").append("hX_4").append(".JSFBehaviorAssist(\"").append(basicArgs[--iBaseArg]).append('\"');
            while (iBaseArg > 0) {
                script.append(", \"").append(basicArgs[--iBaseArg]).append('\"');
            }
            script.append("));");
        }
        return script.toString();
    }

    private String genValidateBehavior(String scope, ScriptObject converter, ScriptObject validator, BehaviorArgs behavior) {
        StringBuffer script = new StringBuffer();
        String[] validateArgs = new String[11];
        int iValArg = 0;
        String s = null;
        if (validator != null) {
            validateArgs[iValArg++] = "validator:" + validator.getId();
        }
        if (converter != null) {
            validateArgs[iValArg++] = "converter:" + converter.getId();
        }
        if ((s = behavior.getSuccessAction()) != null) {
            validateArgs[iValArg++] = "success-action:" + s;
        }
        if ((s = behavior.getErrorAction()) != null) {
            validateArgs[iValArg++] = "error-action:" + s;
        }
        if ((s = behavior.getSuccessClass()) != null) {
            validateArgs[iValArg++] = "success-class:" + s;
        }
        if ((s = behavior.getErrorClass()) != null) {
            validateArgs[iValArg++] = "error-class:" + s;
        }
        if ((s = behavior.getDefaultClass()) != null) {
            validateArgs[iValArg++] = "default-class:" + s;
        }
        if ((s = behavior.getOnsuccess()) != null) {
            validateArgs[iValArg++] = "success-function:" + s;
        }
        if ((s = behavior.getOnerror()) != null) {
            validateArgs[iValArg++] = "error-function:" + s;
        }
        if (validateArgs.length > 0) {
            script.append("\n").append("hX_4").append(".addBehavior(\"").append(scope).append("\", \"onblur\", new ").append("hX_4").append(".JSFBehaviorValidate(\"").append(validateArgs[--iValArg]).append('\"');
            while (iValArg > 0) {
                script.append(", \"").append(validateArgs[--iValArg]).append('\"');
            }
            script.append("));");
        }
        return script.toString();
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    private class BehaviorArgs {
        String autoTab;
        String imeMode;
        String errorClass;
        String successClass;
        String errorAction;
        String successAction;
        String onerror;
        String onsuccess;
        String trigger;
        String inputAssist;
        String validation;
        String promptCharacter;
        String defaultClass = null;
        boolean isValidation = false;
        boolean isAssist = false;

        BehaviorArgs(UIComponent component) {
            HtmlInputHelperAssist assistComponent = null;
            if (component instanceof HtmlInputHelperAssist) {
                assistComponent = (HtmlInputHelperAssist)component;
            }
            if (assistComponent != null) {
                this.validation = assistComponent.getValidation();
                if (this.validation != null) {
                    this.isValidation = true;
                    this.errorClass = assistComponent.getErrorClass();
                    this.successClass = assistComponent.getSuccessClass();
                    this.errorAction = assistComponent.getErrorAction();
                    this.successAction = assistComponent.getSuccessAction();
                    this.onerror = assistComponent.getOnerror();
                    this.onsuccess = assistComponent.getOnsuccess();
                    this.trigger = (String)component.getAttributes().get("trigger");
                }
                if ((this.inputAssist = assistComponent.getInputAssist()) != null) {
                    this.isAssist = true;
                    this.promptCharacter = assistComponent.getPromptCharacter();
                    this.autoTab = assistComponent.getAutoTab();
                    this.imeMode = assistComponent.getImeMode();
                }
            } else {
                this.validation = (String)component.getAttributes().get("validation");
                if (this.validation != null) {
                    this.errorClass = (String)component.getAttributes().get("errorClass");
                    this.successClass = (String)component.getAttributes().get("successClass");
                    this.errorAction = (String)component.getAttributes().get("errorAction");
                    this.successAction = (String)component.getAttributes().get("successAction");
                    this.onerror = (String)component.getAttributes().get("onerror");
                    this.onsuccess = (String)component.getAttributes().get("onsuccess");
                    this.trigger = (String)component.getAttributes().get("trigger");
                }
                if ((this.inputAssist = (String)component.getAttributes().get("inputAssist")) != null) {
                    this.autoTab = (String)component.getAttributes().get("autoTab");
                    this.imeMode = (String)component.getAttributes().get("imeMode");
                    this.promptCharacter = (String)component.getAttributes().get("promptCharacter");
                }
            }
        }

        public String getAutoTab() {
            return this.autoTab;
        }

        public String getErrorAction() {
            return this.errorAction;
        }

        public String getErrorClass() {
            return this.errorClass;
        }

        public String getImeMode() {
            return this.imeMode;
        }

        public String getInputAssist() {
            return this.inputAssist;
        }

        public boolean isAssist() {
            return this.isAssist;
        }

        public boolean isValidation() {
            return this.isValidation;
        }

        public String getOnerror() {
            return this.onerror;
        }

        public String getOnsuccess() {
            return this.onsuccess;
        }

        public String getPromptCharacter() {
            return this.promptCharacter;
        }

        public String getSuccessAction() {
            return this.successAction;
        }

        public String getSuccessClass() {
            return this.successClass;
        }

        public String getTrigger() {
            return this.trigger;
        }

        public String getValidation() {
            return this.validation;
        }

        public void setAutoTab(String string) {
            this.autoTab = string;
        }

        public void setErrorAction(String string) {
            this.errorAction = string;
        }

        public void setErrorClass(String string) {
            this.errorClass = string;
        }

        public void setImeMode(String string) {
            this.imeMode = string;
        }

        public void setInputAssist(String string) {
            this.inputAssist = string;
        }

        public void setAssist(boolean b) {
            this.isAssist = b;
        }

        public void setValidation(boolean b) {
            this.isValidation = b;
        }

        public void setOnerror(String string) {
            this.onerror = string;
        }

        public void setOnsuccess(String string) {
            this.onsuccess = string;
        }

        public void setPromptCharacter(String string) {
            this.promptCharacter = string;
        }

        public void setSuccessAction(String string) {
            this.successAction = string;
        }

        public void setSuccessClass(String string) {
            this.successClass = string;
        }

        public void setTrigger(String string) {
            this.trigger = string;
        }

        public void setValidation(String string) {
            this.validation = string;
        }

        public String getDefaultClass() {
            return this.defaultClass;
        }

        public void setDefaultClass(String string) {
            this.defaultClass = string;
        }
    }
}

