/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.component.IScriptContributor;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlInputHelperDatePicker;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.util.ScriptObject;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.render.Renderer;

public class DatePickerRenderer
extends Renderer
implements IScriptContributor {
    private static final String DEFAULT_BUTTON_BORDER = "-1";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        UIComponent parent = component.getParent();
        if (parent == null || !(parent instanceof UIInput)) {
            return;
        }
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
        if (HxClientRenderUtil.isContainedInPanel(component.getParent())) {
            this.encode(context, component, false);
        } else {
            scriptCollector.register(this, component);
        }
    }

    public void contributeScript(FacesContext context, UIComponent component) throws IOException {
        this.encode(context, component, true);
    }

    private void encode(FacesContext context, UIComponent component, boolean writeNow) throws IOException {
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        UIInput input = (UIInput)component.getParent();
        DateTimeConverter dtConverter = (DateTimeConverter)input.getConverter();
        ScriptObject converterScript = HxClientRenderUtil.buildJsDateConverter(context, dtConverter);
        ScriptObject validatorScript = null;
        if (converterScript != null) {
            validatorScript = HxClientRenderUtil.buildJsRangeValidator(context, HxClientRenderUtil.getRangeValidator(input), input.isRequired(), HxClientRenderUtil.getExpressionValidator(input));
        }
        String assistScript = null;
        assistScript = dtConverter.getType().indexOf("date") != -1 ? this.getDatePickerScript(context, component, dtConverter.getLocale(), converterScript != null ? converterScript.getId() : null, validatorScript != null ? validatorScript.getId() : null) : this.getTimePickerScript(context, component, converterScript != null ? converterScript.getId() : null, validatorScript != null ? validatorScript.getId() : null);
        if (writeNow) {
            ResponseWriter writer = context.getResponseWriter();
            if (converterScript != null) {
                scriptCollector.writeScriptOnce(converterScript.getScript(), context, false);
            }
            if (validatorScript != null) {
                scriptCollector.writeScriptOnce(validatorScript.getScript(), context, false);
            }
            if (assistScript != null) {
                writer.write("\n");
                writer.write(assistScript);
            }
        } else {
            if (converterScript != null) {
                scriptCollector.addScriptOnce(converterScript.getScript());
            }
            if (validatorScript != null) {
                scriptCollector.addScriptOnce(validatorScript.getScript());
            }
            if (assistScript != null) {
                scriptCollector.addScript(assistScript);
            }
        }
    }

    private String getDatePickerScript(FacesContext context, UIComponent component, Locale converterLocale, String converterId, String validatorId) {
        String sBtnColor;
        String sCSSPrefix;
        String buttonBorder;
        String firstDay;
        String sRequired = null;
        UIInput input = null;
        HtmlInputHelperDatePicker dateComponent = null;
        if (component instanceof HtmlInputHelperDatePicker) {
            dateComponent = (HtmlInputHelperDatePicker)component;
        }
        Locale locale = converterLocale == null ? context.getViewRoot().getLocale() : converterLocale;
        Calendar cal = Calendar.getInstance(locale);
        int DefaultFirstDay = cal.getFirstDayOfWeek();
        --DefaultFirstDay;
        UIComponent parent = component.getParent();
        if (parent == null || !(parent instanceof UIInput)) {
            return "";
        }
        input = (UIInput)parent;
        Boolean bRequired = (Boolean)input.getAttributes().get("required");
        if (bRequired.booleanValue()) {
            sRequired = "true";
        }
        if (dateComponent != null) {
            firstDay = dateComponent.getFirstDay();
            buttonBorder = dateComponent.getButtonBorder();
        } else {
            firstDay = (String)component.getAttributes().get("firstDay");
            buttonBorder = (String)component.getAttributes().get("buttonBorder");
        }
        String sFirstDay = this.getNumericAttribute(component, firstDay, "first-day-of-week:", new Integer(DefaultFirstDay).toString(), new Integer(0), new Integer(6));
        String sBtnBorder = this.getNumericAttribute(component, buttonBorder, "button-border:", DEFAULT_BUTTON_BORDER, new Integer(-1), new Integer(3));
        if (dateComponent != null) {
            sCSSPrefix = dateComponent.getStyleClass();
            sBtnColor = dateComponent.getButtonColor();
        } else {
            sCSSPrefix = (String)component.getAttributes().get("styleClass");
            sBtnColor = (String)component.getAttributes().get("buttonColor");
        }
        StringBuffer script = new StringBuffer("hX_4").append(".addComponent(\"").append(parent.getClientId(context)).append("\", new ").append("hX_4").append(".JSFDatePicker(");
        if (converterId != null) {
            script.append("\"converter:");
            script.append(converterId);
            script.append('\"');
        }
        if (validatorId != null) {
            script.append(", \"");
            script.append("validator:");
            script.append(validatorId);
            script.append('\"');
        }
        if (sCSSPrefix != null && sCSSPrefix != "") {
            script.append(", \"CSS-prefix:");
            script.append(sCSSPrefix);
            script.append('\"');
        }
        if (sBtnColor != null && sBtnColor != "") {
            script.append(", \"button-color:");
            script.append(sBtnColor);
            script.append('\"');
        }
        if (sRequired != null && sRequired != "") {
            script.append(", \"required:");
            script.append(sRequired);
            script.append('\"');
        }
        script.append(", \"");
        script.append(sFirstDay);
        script.append('\"');
        script.append(", \"");
        script.append(sBtnBorder);
        script.append('\"');
        script.append("));");
        return script.toString();
    }

    private String getNumericAttribute(UIComponent component, String sValue, String sAttOutName, String DefaultValue, Integer MinValue, Integer MaxValue) {
        if (sValue == null || sValue == "") {
            sValue = DefaultValue;
        } else {
            try {
                int iValue = Integer.parseInt(sValue);
                if (MinValue != null && iValue < MinValue) {
                    sValue = DefaultValue;
                } else if (MaxValue != null && iValue > MaxValue) {
                    sValue = DefaultValue;
                }
            }
            catch (NumberFormatException e) {
                sValue = DefaultValue;
            }
        }
        sValue = String.valueOf(sAttOutName) + sValue;
        return sValue;
    }

    private String getTimePickerScript(FacesContext context, UIComponent component, String converterId, String validatorId) {
        String delta;
        HtmlInputHelperDatePicker dateComponent = null;
        if (component instanceof HtmlInputHelperDatePicker) {
            dateComponent = (HtmlInputHelperDatePicker)component;
        }
        if ((delta = dateComponent != null ? dateComponent.getDelta() : (String)component.getAttributes().get("delta")) == null) {
            delta = "1800";
        }
        StringBuffer script = new StringBuffer("hX_4");
        script.append(".addComponent(\"");
        script.append(component.getParent().getClientId(context));
        script.append("\", new ");
        script.append("hX_4");
        script.append(".JSFSpinner(\"type:datetime\", \"increment:");
        script.append(delta);
        script.append('\"');
        if (converterId != null) {
            script.append(",\"converter:");
            script.append(converterId);
            script.append('\"');
        }
        if (validatorId != null) {
            script.append(",\"validator:");
            script.append(validatorId);
            script.append('\"');
        }
        script.append("));");
        return script.toString();
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }
}

