/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlPagerDeluxe;
import com.ibm.faces.renderkit.html_extended.AbstractPagerRenderer;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.util.HtmlUtil;
import com.ibm.faces.util.JavaScriptUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class DeluxePagerRenderer
extends AbstractPagerRenderer {
    private static final String PAGER_PREVIOUS = "__pagerPrevious";
    private static final String PAGER_NEXT = "__pagerNext";
    private static final String PAGER_FIRST = "__pagerFirst";
    private static final String PAGER_LAST = "__pagerLast";
    private static final String PAGER_TEXT = "__pagerText";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String useButtonsVal;
        String styleClass;
        String style;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        HtmlPagerDeluxe deluxeComponent = null;
        if (component instanceof HtmlPagerDeluxe) {
            deluxeComponent = (HtmlPagerDeluxe)component;
        }
        UIData data = this.findDataComponent(component);
        ResponseWriter writer = context.getResponseWriter();
        ResourceBundle bundle = ResourceHandler.getBundle(context);
        int currentPage = this.getCurrentPage(data);
        int lastPage = this.getLastPage(data);
        Object[] args = new Object[]{new Integer(currentPage + 1), new Integer(lastPage + 1)};
        String localizedPageOf = ResourceHandler.getString(bundle, "PagerRenderer.pageof", args);
        String localizedFirst = ResourceHandler.getString(bundle, "PagerRenderer.first");
        String localizedPrevious = ResourceHandler.getString(bundle, "PagerRenderer.previous");
        String localizedNext = ResourceHandler.getString(bundle, "PagerRenderer.next");
        String localizedLast = ResourceHandler.getString(bundle, "PagerRenderer.last");
        String pagerId = component.getClientId(context);
        if (deluxeComponent != null) {
            style = deluxeComponent.getStyle();
            styleClass = deluxeComponent.getStyleClass();
            useButtonsVal = deluxeComponent.getUseButtons();
        } else {
            style = (String)component.getAttributes().get("style");
            styleClass = (String)component.getAttributes().get("styleClass");
            useButtonsVal = component.getAttributes().get("useButtons");
        }
        String idFirst = String.valueOf(pagerId) + PAGER_FIRST;
        String idPrevious = String.valueOf(pagerId) + PAGER_PREVIOUS;
        String idNext = String.valueOf(pagerId) + PAGER_NEXT;
        String idLast = String.valueOf(pagerId) + PAGER_LAST;
        boolean useButtons = "true".equals(useButtonsVal) || Boolean.TRUE.equals(useButtonsVal);
        boolean canPrev = currentPage > 0;
        boolean canNext = currentPage < lastPage || lastPage < 0;
        HtmlUtil.writeTagStartOpen((Writer)writer, "table", false, false);
        HtmlUtil.writeTagAttribute((Writer)writer, "id", pagerId);
        HtmlUtil.writeTagAttribute((Writer)writer, "style", style);
        HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass);
        HtmlUtil.writeTagAttribute((Writer)writer, "border", "0");
        HtmlUtil.writeTagAttribute((Writer)writer, "cellspacing", "0");
        HtmlUtil.writeTagAttribute((Writer)writer, "cellpadding", "0");
        HtmlUtil.writeTagStartCloseLn((Writer)writer, false);
        HtmlUtil.writeTagStartOpenLn((Writer)writer, "tbody", true, false);
        HtmlUtil.writeTagStartOpenLn((Writer)writer, "tr", true, false);
        if (useButtons) {
            this.writeInputSubmit((Writer)writer, idFirst, localizedFirst, styleClass, canPrev);
            this.writeInputSubmit((Writer)writer, idPrevious, localizedPrevious, styleClass, canPrev);
            this.writeText((Writer)writer, pagerId, localizedPageOf, styleClass);
            this.writeInputSubmit((Writer)writer, idNext, localizedNext, styleClass, canNext);
            if (lastPage >= 0) {
                this.writeInputSubmit((Writer)writer, idLast, localizedLast, styleClass, canNext);
            }
        } else {
            String srcLast;
            String srcNext;
            String srcPrevious;
            String srcFirst;
            String path = JavaScriptUtil.getImagePath(context);
            if (deluxeComponent != null) {
                srcFirst = deluxeComponent.getSrcFirst();
                srcPrevious = deluxeComponent.getSrcPrevious();
                srcNext = deluxeComponent.getSrcNext();
                srcLast = deluxeComponent.getSrcLast();
            } else {
                srcFirst = (String)component.getAttributes().get("srcFirst");
                srcPrevious = (String)component.getAttributes().get("srcPrevious");
                srcNext = (String)component.getAttributes().get("srcNext");
                srcLast = (String)component.getAttributes().get("srcLast");
            }
            String imgFirst = this.getNonNull(srcFirst, String.valueOf(path) + "datagrid_pager_first.gif");
            String imgPrevious = this.getNonNull(srcPrevious, String.valueOf(path) + "datagrid_pager_previous.gif");
            String imgNext = this.getNonNull(srcNext, String.valueOf(path) + "datagrid_pager_next.gif");
            String imgLast = this.getNonNull(srcLast, String.valueOf(path) + "datagrid_pager_last.gif");
            String img1x1 = String.valueOf(path) + "1x1.gif";
            img1x1 = context.getExternalContext().encodeResourceURL(img1x1);
            boolean iconSupported = this.useScript(context);
            StringBuffer buffer = null;
            if (iconSupported && srcFirst == null) {
                imgFirst = img1x1;
                buffer = this.bufferScript(buffer, idFirst, false, true);
            } else {
                imgFirst = context.getExternalContext().encodeResourceURL(imgFirst);
            }
            if (iconSupported && srcPrevious == null) {
                imgPrevious = img1x1;
                buffer = this.bufferScript(buffer, idPrevious, false, false);
            } else {
                imgPrevious = context.getExternalContext().encodeResourceURL(imgPrevious);
            }
            if (iconSupported && srcNext == null) {
                imgNext = img1x1;
                buffer = this.bufferScript(buffer, idNext, true, false);
            } else {
                imgNext = context.getExternalContext().encodeResourceURL(imgNext);
            }
            if (iconSupported && srcLast == null) {
                imgLast = img1x1;
                buffer = this.bufferScript(buffer, idLast, true, true);
            } else {
                imgLast = context.getExternalContext().encodeResourceURL(imgLast);
            }
            this.writeInputImage((Writer)writer, idFirst, localizedFirst, imgFirst, styleClass, canPrev);
            this.writeInputImage((Writer)writer, idPrevious, localizedPrevious, imgPrevious, styleClass, canPrev);
            this.writeText((Writer)writer, pagerId, localizedPageOf, styleClass);
            this.writeInputImage((Writer)writer, idNext, localizedNext, imgNext, styleClass, canNext);
            if (lastPage >= 0) {
                this.writeInputImage((Writer)writer, idLast, localizedLast, imgLast, styleClass, canNext);
            }
            if (buffer != null) {
                this.writeJavaScript(context, component, buffer);
            }
        }
        HtmlUtil.writeTagEndLn((Writer)writer, "tr");
        HtmlUtil.writeTagEndLn((Writer)writer, "tbody");
        HtmlUtil.writeTagEndLn((Writer)writer, "table");
    }

    private String getNonNull(String str1, String str2) {
        if (str1 != null) {
            return str1;
        }
        return str2;
    }

    private void writeText(Writer writer, String id, String localizedPageOf, String styleClass) throws IOException {
        String textId = String.valueOf(id) + PAGER_TEXT;
        this.writeTdStart(writer, styleClass);
        if (styleClass != null) {
            styleClass = String.valueOf(styleClass) + "_text";
        }
        HtmlUtil.writeTagStartOpen(writer, "span", false, false);
        HtmlUtil.writeTagAttribute(writer, "id", textId);
        HtmlUtil.writeTagAttribute(writer, "class", styleClass);
        HtmlUtil.writeTagStartClose(writer, false);
        HtmlUtil.writeText(writer, localizedPageOf);
        HtmlUtil.writeTagEndLn(writer, "span");
        this.writeTdEnd(writer);
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        UIData data = this.findDataComponent(component);
        if (data == null) {
            return;
        }
        if (!this.isPaged(data)) {
            return;
        }
        int newPage = -1;
        int currentPage = 0;
        int lastPage = 0;
        String id = component.getClientId(context);
        if (this.wasInputClicked(context, String.valueOf(id) + PAGER_FIRST)) {
            currentPage = this.getCurrentPage(data);
            lastPage = this.getLastPage(data);
            newPage = 0;
        } else if (this.wasInputClicked(context, String.valueOf(id) + PAGER_PREVIOUS)) {
            currentPage = this.getCurrentPage(data);
            lastPage = this.getLastPage(data);
            newPage = currentPage - 1;
        } else if (this.wasInputClicked(context, String.valueOf(id) + PAGER_NEXT)) {
            currentPage = this.getCurrentPage(data);
            lastPage = this.getLastPage(data);
            newPage = currentPage + 1;
        } else if (this.wasInputClicked(context, String.valueOf(id) + PAGER_LAST) && lastPage >= 0) {
            currentPage = this.getCurrentPage(data);
            newPage = lastPage = this.getLastPage(data);
        } else {
            return;
        }
        this.queueEvent(component, data, currentPage, newPage, lastPage);
    }

    private void writeInputImage(Writer writer, String id, String label, String image, String css, boolean enabled) throws IOException {
        this.writeTdStart(writer, css);
        if (css != null) {
            css = String.valueOf(css) + "_button";
        }
        HtmlUtil.writeTagStartOpen(writer, "input", false, false);
        HtmlUtil.writeTagAttribute(writer, "type", "image");
        HtmlUtil.writeTagAttribute(writer, "id", id);
        HtmlUtil.writeTagAttribute(writer, "name", id);
        HtmlUtil.writeTagAttribute(writer, "alt", label);
        HtmlUtil.writeTagAttribute(writer, "src", image);
        HtmlUtil.writeTagAttribute(writer, "class", css);
        if (!enabled) {
            HtmlUtil.writeTagAttribute(writer, "disabled", "disabled");
        }
        HtmlUtil.writeTagStartCloseLn(writer, true);
        this.writeTdEnd(writer);
    }

    private void writeInputSubmit(Writer writer, String id, String label, String css, boolean enabled) throws IOException {
        this.writeTdStart(writer, css);
        if (css != null) {
            css = String.valueOf(css) + "_button";
        }
        HtmlUtil.writeTagStartOpen(writer, "input", false, false);
        HtmlUtil.writeTagAttribute(writer, "type", "submit");
        HtmlUtil.writeTagAttribute(writer, "id", id);
        HtmlUtil.writeTagAttribute(writer, "name", id);
        HtmlUtil.writeTagAttribute(writer, "value", label);
        HtmlUtil.writeTagAttribute(writer, "class", css);
        if (!enabled) {
            HtmlUtil.writeTagAttribute(writer, "disabled", "disabled");
        }
        HtmlUtil.writeTagStartCloseLn(writer, true);
        this.writeTdEnd(writer);
    }

    private void writeTdStart(Writer writer, String styleClass) throws IOException {
        if (styleClass != null) {
            styleClass = String.valueOf(styleClass) + "_cell";
        }
        HtmlUtil.writeTagStartOpen(writer, "td", false, false);
        HtmlUtil.writeTagAttribute(writer, "align", "left");
        HtmlUtil.writeTagAttribute(writer, "valign", "top");
        HtmlUtil.writeTagStartCloseLn(writer, false);
    }

    private void writeTdEnd(Writer writer) throws IOException {
        HtmlUtil.writeTagEndLn(writer, "td");
    }

    private void writeJavaScript(FacesContext context, UIComponent component, StringBuffer buffer) throws IOException {
        if (buffer == null) {
            return;
        }
        String onPageLoad = "hX_4.onPageLoad();\r\n";
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        ResponseWriter writer = context.getResponseWriter();
        if (scriptCollector == null) {
            ResourceBundle bundle = ResourceHandler.getBundle(context);
            String src = String.valueOf(JavaScriptUtil.getJavaScriptPath(context)) + ResourceHandler.buildLocalizedLibName(bundle, "hxclient_v1.js");
            writer.write(JavaScriptUtil.getStartTag(src));
            writer.write(JavaScriptUtil.getEndTag());
            writer.write(JavaScriptUtil.getStartTag());
            writer.write(buffer.toString());
            writer.write(JavaScriptUtil.getEndTag());
            writer.write("hX_4.onPageLoad();\r\n");
        } else {
            HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
            scriptCollector.addScript(buffer.toString());
            scriptCollector.addScriptOnce("hX_4.onPageLoad();\r\n", 2);
        }
    }

    private StringBuffer bufferScript(StringBuffer buffer, String id, boolean rightFacing, boolean drawBar) {
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        int direction = rightFacing ? 3 : 2;
        int barStyle = drawBar ? 1 : 0;
        buffer.append("hX_4").append(".addComponent(\"").append(id).append("\", new ").append("hX_4").append(".JSFTwistie(\"direction:").append(direction).append("\", \"bar-style:").append(barStyle).append("\"));\r\n");
        return buffer;
    }

    private boolean wasInputClicked(FacesContext context, String name) {
        return context.getExternalContext().getRequestParameterMap().get(name) != null || context.getExternalContext().getRequestParameterMap().get(String.valueOf(name) + ".x") != null;
    }

    private boolean useScript(FacesContext context) {
        Object obj = context.getExternalContext().getRequestHeaderMap().get("User-Agent");
        if (obj == null) {
            return false;
        }
        if (obj.toString().indexOf("MSIE") >= 0) {
            if (obj.toString().indexOf("Windows") < 0) {
                return false;
            }
            if (obj.toString().indexOf("MSIE 5.0") >= 0) {
                return false;
            }
            if (obj.toString().indexOf("MSIE 4.") >= 0) {
                return false;
            }
            return obj.toString().indexOf("MSIE 3.") < 0;
        }
        return obj.toString().indexOf("Gecko") >= 0;
    }
}

