/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlPagerGoto;
import com.ibm.faces.converter.NumberConverterEx;
import com.ibm.faces.renderkit.html_extended.AbstractPagerRenderer;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.util.HtmlUtil;
import com.ibm.faces.util.ScriptObject;
import com.ibm.faces.validator.LongRangeValidatorEx;
import java.io.IOException;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.validator.Validator;

public class GotoPagerRenderer
extends AbstractPagerRenderer {
    private static final String PAGER_GO = "__pagerGoButton";
    private static final String PAGER_TEXT = "__pagerGoText";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String type;
        String styleClass;
        String style;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        HtmlPagerGoto gotoComponent = null;
        if (component instanceof HtmlPagerGoto) {
            gotoComponent = (HtmlPagerGoto)component;
        }
        UIData data = this.findDataComponent(component);
        ResponseWriter writer = context.getResponseWriter();
        ResourceBundle bundle = ResourceHandler.getBundle(context);
        String localizedGo = ResourceHandler.getString(bundle, "PagerRenderer.go");
        int currentPage = 0;
        if (data != null) {
            currentPage = this.getCurrentPage(data);
        }
        String id = component.getClientId(context);
        if (gotoComponent != null) {
            style = gotoComponent.getStyle();
            styleClass = gotoComponent.getStyleClass();
            type = gotoComponent.getType();
        } else {
            style = (String)component.getAttributes().get("style");
            styleClass = (String)component.getAttributes().get("styleClass");
            type = (String)component.getAttributes().get("type");
        }
        writer.startElement("span", component);
        writer.writeAttribute("id", (Object)id, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (type == null || type.equalsIgnoreCase("text") || !this.isTypeValid(type).booleanValue()) {
            this.writeTextInput(writer, id, currentPage, this.getFieldSize(data));
        } else if (type.equalsIgnoreCase("combobox")) {
            this.writeCombobox(writer, component, id, currentPage);
        } else if (type.equalsIgnoreCase("spinner") || type.equalsIgnoreCase("slider")) {
            int size = this.getFieldSize(data);
            writer.startElement("table", component);
            writer.startElement("tr", component);
            writer.startElement("td", component);
            writer.writeAttribute("width", (Object)String.valueOf(size * 8 + 20), null);
            this.writeSpinnerSlider(context, writer, component, id, currentPage, type, size);
            writer.endElement("td");
            writer.startElement("td", component);
        }
        writer.startElement("span", component);
        this.writeInputSubmit((Writer)writer, String.valueOf(id) + PAGER_GO, localizedGo, styleClass, true);
        writer.endElement("span");
        if (type != null && (type.equalsIgnoreCase("spinner") || type.equalsIgnoreCase("slider"))) {
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
        }
        writer.endElement("span");
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        UIData data = this.findDataComponent(component);
        if (data == null) {
            return;
        }
        if (!this.isPaged(data)) {
            return;
        }
        String id = component.getClientId(context);
        String keyButton = String.valueOf(id) + PAGER_GO;
        if (this.wasInputClicked(context, keyButton)) {
            String keyText = String.valueOf(id) + PAGER_TEXT;
            String valueText = (String)context.getExternalContext().getRequestParameterMap().get(keyText);
            if (valueText != null) {
                try {
                    Integer objI = new Integer(valueText);
                    int newPage = objI - 1;
                    int currentPage = this.getCurrentPage(data);
                    int lastPage = this.getLastPage(data);
                    this.queueEvent(component, data, currentPage, newPage, lastPage);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    private void writeTextInput(ResponseWriter writer, String id, int currentPage, int size) throws IOException {
        String textId = String.valueOf(id) + PAGER_TEXT;
        HtmlUtil.writeTagStartOpen((Writer)writer, "input", false, false);
        HtmlUtil.writeTagAttribute((Writer)writer, "type", "text");
        HtmlUtil.writeTagAttribute((Writer)writer, "size", String.valueOf(size));
        HtmlUtil.writeTagAttribute((Writer)writer, "id", textId);
        HtmlUtil.writeTagAttribute((Writer)writer, "name", textId);
        HtmlUtil.writeTagAttribute((Writer)writer, "value", "" + (currentPage + 1));
        HtmlUtil.writeTagStartCloseLn((Writer)writer, true);
    }

    private void writeCombobox(ResponseWriter writer, UIComponent component, String id, int currentPage) throws IOException {
        String textId = String.valueOf(id) + PAGER_TEXT;
        writer.startElement("select", component);
        writer.writeAttribute("id", (Object)textId, null);
        writer.writeAttribute("name", (Object)textId, null);
        UIData data = this.findDataComponent(component);
        int total = this.getLastPage(data) + 1;
        if (total < 1) {
            total = 1;
        }
        int i = 1;
        while (i <= total) {
            writer.startElement("option", component);
            if (i == currentPage + 1) {
                writer.writeAttribute("selected", (Object)Boolean.TRUE, null);
            }
            writer.writeAttribute("value", (Object)String.valueOf(i), null);
            writer.writeText((Object)String.valueOf(i), null);
            writer.endElement("option");
            ++i;
        }
        writer.endElement("select");
    }

    private void writeSpinnerSlider(FacesContext context, ResponseWriter writer, UIComponent component, String id, int currentPage, String type, int size) throws IOException {
        String textId = String.valueOf(id) + PAGER_TEXT;
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("size", (Object)String.valueOf(size), null);
        writer.writeAttribute("id", (Object)textId, null);
        writer.writeAttribute("name", (Object)textId, null);
        writer.writeAttribute("value", (Object)String.valueOf(currentPage + 1), null);
        writer.endElement("input");
        UIData data = this.findDataComponent(component);
        int total = this.getLastPage(data) + 1;
        if (total < 1) {
            total = 1;
        }
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
        NumberConverterEx nc = new NumberConverterEx();
        nc.setIntegerOnly(true);
        LongRangeValidatorEx lrv = new LongRangeValidatorEx();
        lrv.setMinimum(1L);
        lrv.setMaximum(total);
        ScriptObject converterScript = HxClientRenderUtil.buildJsNumberConverter(context, nc);
        ScriptObject validatorScript = HxClientRenderUtil.buildJsRangeValidator(context, (Validator)lrv, false, null);
        scriptCollector.addScriptOnce(converterScript.getScript());
        scriptCollector.addScriptOnce(validatorScript.getScript());
        StringBuffer script = new StringBuffer("hX_4");
        script.append(".addComponent(\"");
        script.append(textId);
        if (type.equalsIgnoreCase("slider")) {
            script.append("\", new ");
            script.append("hX_4");
            script.append(".JSFSlider(\"increment:1\"");
        } else {
            script.append("\", new ");
            script.append("hX_4");
            script.append(".JSFSpinner(\"increment:1\"");
        }
        script.append(",\"converter:");
        script.append(converterScript.getId());
        script.append('\"');
        script.append(",\"validator:");
        script.append(validatorScript.getId());
        script.append('\"');
        script.append("));");
        scriptCollector.addScript(script.toString());
    }

    private void writeInputSubmit(Writer writer, String id, String label, String css, boolean enabled) throws IOException {
        HtmlUtil.writeTagStartOpen(writer, "input", false, false);
        HtmlUtil.writeTagAttribute(writer, "type", "submit");
        HtmlUtil.writeTagAttribute(writer, "id", id);
        HtmlUtil.writeTagAttribute(writer, "name", id);
        HtmlUtil.writeTagAttribute(writer, "value", label);
        HtmlUtil.writeTagAttribute(writer, "class", css);
        if (!enabled) {
            HtmlUtil.writeTagAttribute(writer, "disabled", "disabled");
        }
        HtmlUtil.writeTagStartCloseLn(writer, true);
    }

    private boolean wasInputClicked(FacesContext context, String name) {
        return context.getExternalContext().getRequestParameterMap().get(name) != null || context.getExternalContext().getRequestParameterMap().get(String.valueOf(name) + ".x") != null;
    }

    private Boolean isTypeValid(String type) {
        String[] types = new String[]{"text", "combobox", "spinner", "slider"};
        Boolean valid = Boolean.FALSE;
        int x = 0;
        while (x < types.length) {
            if (type.equalsIgnoreCase(types[x])) {
                valid = Boolean.TRUE;
                break;
            }
            ++x;
        }
        return valid;
    }

    private int getFieldSize(UIData data) {
        int size = 4;
        if (data == null) {
            return size;
        }
        size = data.getRows() > 0 ? String.valueOf(data.getRowCount() / data.getRows()).length() : 0;
        if (size == 0) {
            size = 1;
        }
        return ++size;
    }
}

