/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.component.IScriptContributor;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlPanelMenu;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.renderkit.html_extended.Utils;
import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class MenuRenderer
extends Renderer
implements IScriptContributor {
    private static final String MENU_ITEM_DELIMITER = "-";
    private static final String MENU_FACET = "header";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String style;
        String styleClass;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (this.isNestedMenu(component)) {
            return;
        }
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        scriptCollector.register(this, component);
        HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
        HtmlPanelMenu menuComponent = null;
        if (component instanceof HtmlPanelMenu) {
            menuComponent = (HtmlPanelMenu)component;
        }
        String id = component.getClientId(context);
        if (menuComponent != null) {
            styleClass = menuComponent.getStyleClass();
            style = menuComponent.getStyle();
        } else {
            styleClass = (String)component.getAttributes().get("styleClass");
            style = (String)component.getAttributes().get("style");
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("DIV", component);
        writer.writeAttribute("id", (Object)id, "id");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.endElement("DIV");
        writer.startElement("DIV", component);
        writer.writeAttribute("style", (Object)"display:none;position:absolute", null);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        UIComponent child;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (component instanceof HtmlPanelMenu && (child = component.getFacet(MENU_FACET)) != null) {
            Utils.encodeComponent(context, child);
        }
        List children = component.getChildren();
        int i = 0;
        while (i < children.size()) {
            UIComponent child2 = (UIComponent)children.get(i);
            Utils.encodeComponent(context, child2);
            ++i;
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (this.isNestedMenu(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("DIV");
    }

    private boolean isNestedMenu(UIComponent component) {
        UIComponent parent = component.getParent();
        if (parent == null) {
            return false;
        }
        if (!(parent instanceof UIPanel)) {
            return false;
        }
        String renderer = component.getRendererType();
        String parentRenderer = parent.getRendererType();
        return parentRenderer != null && parentRenderer.equals(renderer);
    }

    public void contributeScript(FacesContext context, UIComponent component) throws IOException {
        String tabIndex;
        String initialSelection;
        String flyOpen;
        String verticalBody;
        String vertical;
        ResponseWriter writer = context.getResponseWriter();
        HtmlPanelMenu menuComponent = null;
        if (component instanceof HtmlPanelMenu) {
            menuComponent = (HtmlPanelMenu)component;
        }
        if (menuComponent != null) {
            vertical = menuComponent.getVertical();
            verticalBody = menuComponent.getVerticalBody();
            flyOpen = menuComponent.getFlyOpen();
            initialSelection = menuComponent.getInitialSelection();
            tabIndex = menuComponent.getTabIndex();
        } else {
            vertical = (String)component.getAttributes().get("vertical");
            verticalBody = (String)component.getAttributes().get("verticalBody");
            flyOpen = (String)component.getAttributes().get("flyOpen");
            initialSelection = (String)component.getAttributes().get("initialSelection");
            tabIndex = (String)component.getAttributes().get("tabIndex");
        }
        StringBuffer params = new StringBuffer();
        if (vertical != null && vertical.length() > 0) {
            params.append("\"vertical:");
            params.append(vertical);
            params.append("\",");
        }
        if (verticalBody != null && verticalBody.length() > 0) {
            params.append("\"vertical-body:");
            params.append(verticalBody);
            params.append("\",");
        }
        if (flyOpen != null && flyOpen.length() > 0) {
            params.append("\"fly-open:");
            params.append(flyOpen);
            params.append("\",");
        }
        if (initialSelection != null && initialSelection.length() > 0) {
            params.append("\"initial-selection:");
            params.append(initialSelection);
            params.append("\",");
        }
        if (tabIndex != null && tabIndex.length() > 0) {
            params.append("\"tab-index:");
            params.append(tabIndex);
            params.append("\",");
        }
        if (params.length() > 0) {
            params.deleteCharAt(params.length() - 1);
        }
        String id = component.getClientId(context);
        StringBuffer menu = new StringBuffer();
        menu.append("hX_4");
        menu.append(".addComponent(\"");
        menu.append(id);
        menu.append("\", new ");
        menu.append("hX_4");
        menu.append(".JSFMenu(");
        menu.append(params);
        menu.append("));\n");
        writer.write(menu.toString());
        String parentId = id;
        UIComponent headerFacet = component.getFacet(MENU_FACET);
        if (headerFacet != null) {
            parentId = String.valueOf(id) + MENU_ITEM_DELIMITER + "1";
            this.writeMenuItem(context, headerFacet, id, parentId);
        }
        this.writeMenuItems(context, component, parentId);
    }

    protected void writeMenuItems(FacesContext context, UIComponent parentMenu, String parentId) throws IOException {
        List children = parentMenu.getChildren();
        int i = 0;
        while (i < children.size()) {
            UIComponent item = (UIComponent)children.get(i);
            UIComponent nestedMenu = null;
            if (this.isNestedMenu(item)) {
                nestedMenu = item;
                item = item.getFacet(MENU_FACET);
            }
            String itemId = String.valueOf(parentId) + MENU_ITEM_DELIMITER + (i + 1);
            this.writeMenuItem(context, item, parentId, itemId);
            if (nestedMenu != null) {
                this.writeMenuItems(context, nestedMenu, itemId);
            }
            ++i;
        }
    }

    protected void writeMenuItem(FacesContext context, UIComponent item, String parentId, String itemId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StringBuffer menuItem = new StringBuffer();
        menuItem.append("hX_4");
        menuItem.append(".addSubComponent(\"");
        menuItem.append(parentId);
        menuItem.append("\", \"");
        menuItem.append(itemId);
        menuItem.append("\", new ");
        menuItem.append("hX_4");
        menuItem.append(".JSFMenuItem('item:");
        menuItem.append(item.getClientId(context));
        menuItem.append("'));\n");
        writer.write(menuItem.toString());
    }
}

