/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlInputRowSelect;
import com.ibm.faces.renderkit.html_extended.AbstractRowRenderer;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.util.HtmlUtil;
import com.ibm.faces.util.JavaScriptUtil;
import com.ibm.faces.util.LifecycleUtil;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class RowSelectRenderer
extends AbstractRowRenderer {
    private static final String PAD_INPUT_SEL = "__input_sel";
    private static final String PAD_HIDDEN_SEL = "__hidden_sel";
    private static final String IMAGE_SELECTED = "datagrid_selected.gif";
    private static final String IMAGE_UNSELECTED = "datagrid_unselected.gif";
    private static final String JS_SELECTION = "__jsSelection";
    private static final String JS_OBJGROUP = "__jsObjGroup";
    private static final String VALUE_STORE = "com.ibm.faces.renderkit.html_extended.RowSelectRenderer___TEMP_STORE";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!this.isRendered(context, component)) {
            return;
        }
        UIData data = AbstractRowRenderer.findUIData(component);
        data.getAttributes().remove(VALUE_STORE);
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getClientId(context);
        HtmlUtil.writeTagStartOpen((Writer)writer, "span", false, false);
        HtmlUtil.writeTagAttribute((Writer)writer, "id", id);
        HtmlUtil.writeTagStartCloseLn((Writer)writer, false);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String styleClass;
        String style;
        String noscriptString;
        if (!this.isRendered(context, component)) {
            return;
        }
        HtmlInputRowSelect selectComponent = null;
        if (component instanceof HtmlInputRowSelect) {
            selectComponent = (HtmlInputRowSelect)component;
        }
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getClientId(context);
        boolean selected = RowSelectRenderer.isRowSelected(component);
        if (selectComponent != null) {
            noscriptString = selectComponent.getNoscript();
            style = selectComponent.getStyle();
            styleClass = selectComponent.getStyleClass();
        } else {
            noscriptString = (String)component.getAttributes().get("noscript");
            style = (String)component.getAttributes().get("style");
            styleClass = (String)component.getAttributes().get("styleClass");
        }
        boolean noscript = "true".equals(noscriptString);
        if (noscript) {
            String paddedId = String.valueOf(id) + PAD_INPUT_SEL;
            HtmlUtil.writeTagStartOpen((Writer)writer, "input", false, false);
            HtmlUtil.writeTagAttribute((Writer)writer, "type", "checkbox");
            HtmlUtil.writeTagAttribute((Writer)writer, "id", paddedId);
            HtmlUtil.writeTagAttribute((Writer)writer, "name", paddedId);
            HtmlUtil.writeTagAttribute((Writer)writer, "style", style);
            HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass);
            if (selected) {
                HtmlUtil.writeTagAttribute((Writer)writer, "checked", "true");
            }
            HtmlUtil.writeTagStartCloseLn((Writer)writer, true);
        } else {
            ResourceBundle bundle = ResourceHandler.getBundle(context);
            String paddedId = String.valueOf(id) + PAD_INPUT_SEL;
            String localizedUnselected = ResourceHandler.getString(bundle, "DataRendererSelect.unselected");
            String localizedSelected = ResourceHandler.getString(bundle, "DataRendererSelect.selected");
            String src = this.getImage(context, component, selected);
            String alt = selected ? localizedSelected : localizedUnselected;
            HtmlUtil.writeTagStartOpen((Writer)writer, "input", false, false);
            HtmlUtil.writeTagAttribute((Writer)writer, "type", "image");
            HtmlUtil.writeTagAttribute((Writer)writer, "id", paddedId);
            HtmlUtil.writeTagAttribute((Writer)writer, "name", paddedId);
            HtmlUtil.writeTagAttribute((Writer)writer, "src", src);
            HtmlUtil.writeTagAttribute((Writer)writer, "alt", alt);
            HtmlUtil.writeTagAttribute((Writer)writer, "style", style);
            HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass);
            HtmlUtil.writeTagStartCloseLn((Writer)writer, true);
            HtmlUtil.writeInputHidden((Writer)writer, String.valueOf(id) + PAD_HIDDEN_SEL, selected ? "true" : "false");
            this.encodeJavaScript(context, component, selected);
        }
        this.encodeParameters(context, component);
        HtmlUtil.writeTagEndLn((Writer)writer, "span");
    }

    private void encodeJavaScript(FacesContext context, UIComponent component, boolean selected) throws IOException {
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        String dataId = this.findUIDataId(context, component);
        HtmlInputRowSelect selectComponent = null;
        if (component instanceof HtmlInputRowSelect) {
            selectComponent = (HtmlInputRowSelect)component;
        }
        if (dataId != null) {
            ResourceBundle bundle = ResourceHandler.getBundle(context);
            String id = component.getClientId(context);
            String localizedUnselected = ResourceHandler.getString(bundle, "DataRendererSelect.unselected");
            String localizedSelected = ResourceHandler.getString(bundle, "DataRendererSelect.selected");
            String src_sel = this.getImage(context, component, true);
            String src_usel = this.getImage(context, component, false);
            StringBuffer buffer = new StringBuffer();
            String varCellGroup = RowSelectRenderer.getJsSelectionGroupVariable(dataId);
            buffer.append("\r\n if(!").append(varCellGroup).append(") { var ").append(varCellGroup).append(" = new ").append("HxG_4").append(".prototype.HxCheckCellGroup(); } \r\n");
            this.writeJavaScriptOnce(context, scriptCollector, buffer.toString());
            buffer.setLength(0);
            String varSelection = RowSelectRenderer.getJsSelectionVariable(id);
            buffer.append("\r\n if(!").append(varSelection).append(") { var ").append(varSelection).append(" = new ").append("HxG_4").append(".prototype.HxSelection(").append(selected ? "true" : "false").append("); } \r\n");
            buffer.append(varSelection).append(".addSelectionListener(new ").append("HxG_4").append(".prototype.HxCheckImageListener(\"").append(id).append(PAD_INPUT_SEL).append("\", \"").append(src_usel).append("\", \"").append(src_sel).append("\", \"").append(localizedUnselected).append("\", \"").append(localizedSelected).append("\")); \r\n");
            buffer.append("new ").append("HxG_4").append(".prototype.HxCheckCellListener(\"").append(id).append("\", \"").append(id).append(PAD_HIDDEN_SEL).append("\", ").append(varCellGroup).append(", ").append(varSelection).append("); \r\n");
            String columnClasses = selectComponent != null ? selectComponent.getColumnClasses() : (String)component.getAttributes().get("columnClasses");
            if (columnClasses != null) {
                buffer.append("new ").append("HxG_4").append(".prototype.HxStyleRegister(").append(varSelection).append(", \"").append(dataId).append("\", \"").append(id).append("\", \"").append(columnClasses).append("\"); \r\n");
            }
            this.writeJavaScript(context, scriptCollector, buffer.toString());
        }
    }

    private void writeJavaScriptOnce(FacesContext context, UIScriptCollector scriptCollector, String script) throws IOException {
        if (scriptCollector != null) {
            HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
            scriptCollector.addScriptOnce(script);
        } else {
            this.writeJavaScript(context, null, script);
        }
    }

    public void decode(FacesContext context, UIComponent component) {
        String noscriptString;
        boolean noscript;
        if (!this.isRendered(context, component)) {
            return;
        }
        String id = component.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        HtmlInputRowSelect selectComponent = null;
        if (component instanceof HtmlInputRowSelect) {
            selectComponent = (HtmlInputRowSelect)component;
        }
        boolean selected = (noscript = "true".equals(noscriptString = selectComponent != null ? selectComponent.getNoscript() : (String)component.getAttributes().get("noscript"))) ? requestMap.get(String.valueOf(id) + PAD_INPUT_SEL) != null : "true".equals(requestMap.get(String.valueOf(id) + PAD_HIDDEN_SEL));
        this.setRowSelected(component, selected);
    }

    private boolean isRendered(FacesContext context, UIComponent component) throws NullPointerException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        return component.isRendered();
    }

    static boolean isRowSelected(UIComponent component) throws IndexOutOfBoundsException {
        if (!(component instanceof UIInput)) {
            return false;
        }
        UIInput input = (UIInput)component;
        Object value = input.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Boolean[]) {
            return RowSelectRenderer.isRowSelected(component, (Boolean[])value);
        }
        if (value instanceof boolean[]) {
            return RowSelectRenderer.isRowSelected(component, (boolean[])value);
        }
        if (value instanceof Integer[]) {
            return RowSelectRenderer.isRowSelected(component, (Integer[])value);
        }
        if (value instanceof int[]) {
            return RowSelectRenderer.isRowSelected(component, (int[])value);
        }
        if (value instanceof Collection) {
            return RowSelectRenderer.isRowSelected(component, (Collection)value);
        }
        return false;
    }

    private static boolean isRowSelected(UIComponent component, Boolean[] arr) {
        int idx = RowSelectRenderer.getCurrentRowIndex(component);
        if (idx < 0) {
            return false;
        }
        if (arr[idx] == null) {
            return false;
        }
        return arr[idx];
    }

    private static boolean isRowSelected(UIComponent component, boolean[] arr) {
        int idx = RowSelectRenderer.getCurrentRowIndex(component);
        if (idx < 0) {
            return false;
        }
        return arr[idx];
    }

    private static boolean isRowSelected(UIComponent component, Integer[] arr) {
        int idx = RowSelectRenderer.getCurrentRowIndex(component);
        if (idx < 0) {
            return false;
        }
        int i = 0;
        int len = arr.length;
        while (i < len) {
            if (arr[i] != null && arr[i] == idx) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isRowSelected(UIComponent component, int[] arr) {
        int idx = RowSelectRenderer.getCurrentRowIndex(component);
        if (idx < 0) {
            return false;
        }
        int i = 0;
        int len = arr.length;
        while (i < len) {
            if (arr[i] == idx) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isRowSelected(UIComponent component, Collection arr) {
        UIParameter[] params = LifecycleUtil.getParameters(component);
        if (params == null || params.length == 0) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        int len = params.length;
        while (i < len) {
            map.put(params[i].getName(), params[i].getValue());
            ++i;
        }
        return arr.contains(map);
    }

    private static int getCurrentRowIndex(UIComponent component) {
        UIData data = AbstractRowRenderer.findUIData(component);
        if (data == null) {
            return -1;
        }
        return data.getRowIndex();
    }

    private void setRowSelected(UIComponent component, boolean selected) {
        if (!(component instanceof UIInput)) {
            return;
        }
        UIInput input = (UIInput)component;
        Object value = input.getValue();
        if (value instanceof Boolean) {
            input.setValue((Object)(selected ? Boolean.TRUE : Boolean.FALSE));
        } else {
            Object v;
            UIData data = AbstractRowRenderer.findUIData(component);
            boolean last = this.isLastRow(data);
            if (!last && RowSelectRenderer.isRowSelected(component) == selected) {
                return;
            }
            Object newValue = FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(VALUE_STORE);
            boolean copy = false;
            if (newValue == null) {
                copy = true;
            } else {
                value = newValue;
            }
            if (value instanceof Collection) {
                v = value;
                if (copy) {
                    v = this.getCopy((Collection)v);
                    value = v;
                }
                this.setRowSelected(input, (Collection)v, selected);
            }
            if (value instanceof Boolean[]) {
                v = value;
                if (copy) {
                    v = this.getCopy((Boolean[])v);
                    value = v;
                }
                this.setRowSelected(input, (Boolean[])v, selected);
            } else if (value instanceof boolean[]) {
                v = value;
                if (copy) {
                    boolean[] blArray = this.getCopy((boolean[])v);
                    v = blArray;
                    value = blArray;
                }
                this.setRowSelected(input, (boolean[])v, selected);
            } else if (value instanceof Integer[]) {
                v = (Integer[])value;
                if (copy) {
                    v = this.getCopy((Integer[])v);
                    value = v;
                }
                value = this.setRowSelected(input, (Integer[])v, selected);
            } else if (value instanceof int[]) {
                v = (int[])value;
                if (copy) {
                    int[] nArray = this.getCopy((int[])v);
                    v = nArray;
                    value = nArray;
                }
                value = this.setRowSelected(input, (int[])v, selected);
            }
            FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(VALUE_STORE, value);
            if (last && (newValue != null || copy)) {
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove(VALUE_STORE);
                input.setValue(value);
            }
        }
    }

    private boolean isLastRow(UIData data) {
        int lastRow;
        boolean last = false;
        int currentRow = data.getRowIndex();
        if (data.getRows() >= 1 && (lastRow = data.getFirst() + data.getRows() - 1) == currentRow) {
            last = true;
        }
        if (last) {
            return last;
        }
        int rowCount = data.getRowCount();
        if (rowCount >= 0) {
            if (currentRow + 1 == rowCount) {
                last = true;
            }
        } else {
            int nextRow = currentRow + 1;
            data.setRowIndex(nextRow);
            if (!data.isRowAvailable()) {
                last = true;
            }
            data.setRowIndex(currentRow);
        }
        return last;
    }

    private int[] getCopy(int[] array) {
        int[] copy = new int[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private Integer[] getCopy(Integer[] array) {
        Integer[] copy = new Integer[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private boolean[] getCopy(boolean[] array) {
        boolean[] copy = new boolean[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private Boolean[] getCopy(Boolean[] array) {
        Boolean[] copy = new Boolean[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    private Collection getCopy(Collection collection) {
        if (collection instanceof Cloneable) {
            try {
                Class[] params = new Class[]{};
                Method clone = collection.getClass().getMethod("clone", params);
                Object[] args = new Object[]{};
                Collection ret = (Collection)clone.invoke((Object)collection, args);
                return ret;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return collection;
    }

    private void setRowSelected(UIInput component, Boolean[] arr, boolean selected) {
        int idx = RowSelectRenderer.getCurrentRowIndex((UIComponent)component);
        if (idx < 0) {
            return;
        }
        if (arr[idx] != null && arr[idx] == selected) {
            return;
        }
        arr[idx] = selected ? Boolean.TRUE : Boolean.FALSE;
    }

    private void setRowSelected(UIInput component, boolean[] arr, boolean selected) {
        int idx = RowSelectRenderer.getCurrentRowIndex((UIComponent)component);
        if (idx < 0) {
            return;
        }
        if (arr[idx] == selected) {
            return;
        }
        arr[idx] = selected;
    }

    private Object setRowSelected(UIInput component, Integer[] arr, boolean selected) {
        int idx = RowSelectRenderer.getCurrentRowIndex((UIComponent)component);
        if (idx < 0) {
            return arr;
        }
        if (selected) {
            int i = 0;
            int len = arr.length;
            while (i < len) {
                if (arr[i] != null && arr[i] == idx) {
                    return arr;
                }
                ++i;
            }
            Integer[] copy = new Integer[arr.length + 1];
            System.arraycopy(arr, 0, copy, 0, arr.length);
            copy[arr.length] = new Integer(idx);
            return copy;
        }
        int found = -1;
        int i = 0;
        int len = arr.length;
        while (i < len) {
            if (arr[i] != null && arr[i] == idx) {
                found = i;
                break;
            }
            ++i;
        }
        if (found < 0) {
            return arr;
        }
        Integer[] copy = new Integer[arr.length - 1];
        System.arraycopy(arr, 0, copy, 0, found);
        System.arraycopy(arr, found + 1, copy, found, arr.length - found - 1);
        return copy;
    }

    private Object setRowSelected(UIInput component, int[] arr, boolean selected) {
        int idx = RowSelectRenderer.getCurrentRowIndex((UIComponent)component);
        if (idx < 0) {
            return arr;
        }
        if (selected) {
            int i = 0;
            int len = arr.length;
            while (i < len) {
                if (arr[i] == idx) {
                    return arr;
                }
                ++i;
            }
            int[] copy = new int[arr.length + 1];
            System.arraycopy(arr, 0, copy, 0, arr.length);
            copy[arr.length] = idx;
            return copy;
        }
        int found = -1;
        int i = 0;
        int len = arr.length;
        while (i < len) {
            if (arr[i] == idx) {
                found = i;
                break;
            }
            ++i;
        }
        if (found < 0) {
            return arr;
        }
        int[] copy = new int[arr.length - 1];
        System.arraycopy(arr, 0, copy, 0, found);
        System.arraycopy(arr, found + 1, copy, found, arr.length - found - 1);
        return copy;
    }

    private void setRowSelected(UIInput component, Collection arr, boolean selected) {
        Map map = this.decodeParameters(FacesContext.getCurrentInstance(), (UIComponent)component);
        if (map == null) {
            return;
        }
        try {
            if (selected && !arr.contains(map)) {
                arr.add(map);
            } else if (!selected && arr.contains(map)) {
                arr.remove(map);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    static String getJsSelectionVariable(String id) {
        return JavaScriptUtil.makeVariableName(String.valueOf(id) + JS_SELECTION);
    }

    static String getJsSelectionGroupVariable(String id) {
        return JavaScriptUtil.makeVariableName(String.valueOf(id) + JS_OBJGROUP);
    }

    private String getImage(FacesContext context, UIComponent component, boolean selected) {
        String ret;
        HtmlInputRowSelect selectComponent = null;
        if (component instanceof HtmlInputRowSelect) {
            selectComponent = (HtmlInputRowSelect)component;
        }
        if (selected) {
            String img = selectComponent != null ? selectComponent.getSrcSelected() : (String)component.getAttributes().get("srcSelected");
            ret = img != null ? img : String.valueOf(JavaScriptUtil.getImagePath(context)) + IMAGE_SELECTED;
        } else {
            String img = selectComponent != null ? selectComponent.getSrcUnselected() : (String)component.getAttributes().get("srcUnselected");
            ret = img != null ? img : String.valueOf(JavaScriptUtil.getImagePath(context)) + IMAGE_UNSELECTED;
        }
        return context.getExternalContext().encodeResourceURL(ret);
    }
}

