/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.html.HtmlOutputSelecticons;
import com.ibm.faces.renderkit.html_extended.AbstractSelectRenderer;
import com.ibm.faces.util.HtmlUtil;
import com.ibm.faces.util.JavaScriptUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class SelecticonsRenderer
extends AbstractSelectRenderer {
    private static final String SELCTL_ICONS_ALL = "__selectCtrlIconsAll";
    private static final String SELCTL_ICONS_NONE = "__selectCtrlIconsNone";
    private static final String SELCTL_ICONS_INVERSE = "__selectCtrlIconsInverse";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String useButtonsVal;
        String styleClass;
        String style;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        HtmlOutputSelecticons selectComponent = null;
        if (component instanceof HtmlOutputSelecticons) {
            selectComponent = (HtmlOutputSelecticons)component;
        }
        ResponseWriter writer = context.getResponseWriter();
        ResourceBundle bundle = ResourceHandler.getBundle(context);
        String localizedSelectAll = ResourceHandler.getString(bundle, "DatagridSelectionRenderer.Select_All");
        String localizedSelectNone = ResourceHandler.getString(bundle, "DatagridSelectionRenderer.Select_None");
        String localizedSelectInverse = ResourceHandler.getString(bundle, "DatagridSelectionRenderer.Select_Inverse");
        String id = component.getClientId(context);
        String jsObjSelGroup = this.getJsSelectionGroupVariable(context, component);
        StringBuffer buffer = new StringBuffer();
        String onclickSelectAll = this.makeOnclickCode(buffer, jsObjSelGroup, "selectAll");
        String onclickSelectNone = this.makeOnclickCode(buffer, jsObjSelGroup, "selectNone");
        String onclickSelectInverse = this.makeOnclickCode(buffer, jsObjSelGroup, "selectInverse");
        if (selectComponent != null) {
            style = selectComponent.getStyle();
            styleClass = selectComponent.getStyleClass();
            useButtonsVal = selectComponent.getUseButtons();
        } else {
            style = (String)component.getAttributes().get("style");
            styleClass = (String)component.getAttributes().get("styleClass");
            useButtonsVal = component.getAttributes().get("useButtons");
        }
        boolean useButtons = "true".equals(useButtonsVal) || Boolean.TRUE.equals(useButtonsVal);
        HtmlUtil.writeTagStartOpen((Writer)writer, "span", false, false);
        HtmlUtil.writeTagAttribute((Writer)writer, "id", id);
        HtmlUtil.writeTagAttribute((Writer)writer, "style", style);
        HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass);
        HtmlUtil.writeTagStartCloseLn((Writer)writer, false);
        if (useButtons) {
            this.writeInputSubmit((Writer)writer, String.valueOf(id) + SELCTL_ICONS_ALL, localizedSelectAll, onclickSelectAll, styleClass);
            this.writeInputSubmit((Writer)writer, String.valueOf(id) + SELCTL_ICONS_NONE, localizedSelectNone, onclickSelectNone, styleClass);
            this.writeInputSubmit((Writer)writer, String.valueOf(id) + SELCTL_ICONS_INVERSE, localizedSelectInverse, onclickSelectInverse, styleClass);
        } else {
            String srcInverse;
            String srcNone;
            String srcAll;
            if (selectComponent != null) {
                srcAll = selectComponent.getSrcAll();
                srcNone = selectComponent.getSrcNone();
                srcInverse = selectComponent.getSrcInverse();
            } else {
                srcAll = (String)component.getAttributes().get("srcAll");
                srcNone = (String)component.getAttributes().get("srcNone");
                srcInverse = (String)component.getAttributes().get("srcInverse");
            }
            String path = JavaScriptUtil.getImagePath(context);
            String imgAll = this.getNonNull(srcAll, String.valueOf(path) + "datagrid_select_all.gif");
            String imgNone = this.getNonNull(srcNone, String.valueOf(path) + "datagrid_select_none.gif");
            String imgInverse = this.getNonNull(srcInverse, String.valueOf(path) + "datagrid_select_inverse.gif");
            imgAll = context.getExternalContext().encodeResourceURL(imgAll);
            imgNone = context.getExternalContext().encodeResourceURL(imgNone);
            imgInverse = context.getExternalContext().encodeResourceURL(imgInverse);
            this.writeInputImage((Writer)writer, String.valueOf(id) + SELCTL_ICONS_ALL, localizedSelectAll, imgAll, onclickSelectAll, styleClass);
            this.writeInputImage((Writer)writer, String.valueOf(id) + SELCTL_ICONS_NONE, localizedSelectNone, imgNone, onclickSelectNone, styleClass);
            this.writeInputImage((Writer)writer, String.valueOf(id) + SELCTL_ICONS_INVERSE, localizedSelectInverse, imgInverse, onclickSelectInverse, styleClass);
        }
        HtmlUtil.writeTagEndLn((Writer)writer, "span");
    }

    private String makeOnclickCode(StringBuffer buffer, String jsObjSelectGroup, String method) {
        buffer.setLength(0);
        buffer.append(jsObjSelectGroup);
        buffer.append(".");
        buffer.append(method);
        buffer.append("(); return false;");
        return buffer.toString();
    }

    private void writeInputImage(Writer writer, String id, String alt, String src, String onclick, String css) throws IOException {
        HtmlUtil.writeTagStartOpen(writer, "input", false, false);
        HtmlUtil.writeTagAttribute(writer, "type", "image");
        HtmlUtil.writeTagAttribute(writer, "id", id);
        HtmlUtil.writeTagAttribute(writer, "name", id);
        HtmlUtil.writeTagAttribute(writer, "alt", alt);
        HtmlUtil.writeTagAttribute(writer, "src", src);
        HtmlUtil.writeTagAttribute(writer, "onclick", onclick);
        HtmlUtil.writeTagAttribute(writer, "class", css);
        HtmlUtil.writeTagStartCloseLn(writer, true);
    }

    private String getNonNull(String attribute, String defaultImage) {
        return attribute == null ? defaultImage : attribute;
    }
}

