/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlOutputStatistics;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.renderkit.html_extended.RowSelectRenderer;
import com.ibm.faces.util.HtmlUtil;
import com.ibm.faces.util.JavaScriptUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class StatisticsRenderer
extends Renderer {
    private static final String PAD_STATISTICS = "__stats";
    private static final String JS_STATISTICS = "__jsStatistics";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String styleClass;
        String style;
        UIData data;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        HtmlOutputStatistics statComponent = null;
        if (component instanceof HtmlOutputStatistics) {
            statComponent = (HtmlOutputStatistics)component;
        }
        if ((data = this.findUIData(component)) == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        ResourceBundle bundle = ResourceHandler.getBundle(context);
        String id = component.getClientId(context);
        int currentPage = this.getCurrentPage(data);
        int lastPage = this.getLastPage(data);
        String localisedSelected = ResourceHandler.getString(bundle, "DatagridStatisticsRenderer.Selected");
        if (statComponent != null) {
            style = statComponent.getStyle();
            styleClass = statComponent.getStyleClass();
        } else {
            style = (String)component.getAttributes().get("style");
            styleClass = (String)component.getAttributes().get("styleClass");
        }
        HtmlUtil.writeTagStartOpen((Writer)writer, "span", false, false);
        HtmlUtil.writeTagAttribute((Writer)writer, "id", id);
        HtmlUtil.writeTagAttribute((Writer)writer, "style", style);
        HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass);
        HtmlUtil.writeTagStartCloseLn((Writer)writer, false);
        String jsStatistics = String.valueOf(id) + JS_STATISTICS;
        jsStatistics = JavaScriptUtil.makeVariableName(jsStatistics);
        Job job = new Job(jsStatistics);
        boolean supportsSelection = this.getSelectedRows(data, (UIComponent)data, job);
        if (lastPage >= 0) {
            Object[] args = new Object[]{new Integer(currentPage + 1), new Integer(lastPage + 1)};
            String localizedPageOf = ResourceHandler.getString(bundle, "PagerRenderer.pageof", args);
            HtmlUtil.writeText((Writer)writer, localizedPageOf);
        }
        if (supportsSelection) {
            writer.write(" ");
            HtmlUtil.writeTagStartOpen((Writer)writer, "span", true, false);
            HtmlUtil.writeText((Writer)writer, localisedSelected);
            HtmlUtil.writeTagStartOpen((Writer)writer, "span", false, false);
            HtmlUtil.writeTagAttribute((Writer)writer, "id", String.valueOf(id) + PAD_STATISTICS);
            HtmlUtil.writeTagStartClose((Writer)writer, false);
            writer.write("" + job.getSelected());
            HtmlUtil.writeTagEndLn((Writer)writer, "span");
            HtmlUtil.writeTagEndLn((Writer)writer, "span");
        }
        HtmlUtil.writeTagEndLn((Writer)writer, "span");
        if (supportsSelection) {
            StringBuffer script = new StringBuffer();
            script.append("var ").append(jsStatistics).append(" = new ").append("HxG_4").append(".prototype.HxStatisticsListener(\"").append(String.valueOf(id) + PAD_STATISTICS).append("\", ").append(job.getSelected()).append(");\r\n");
            this.writeJavaScript(context, component, script.toString());
            this.writeJavaScript(context, component, job.getScript().toString());
        }
    }

    private UIData findUIData(UIComponent component) {
        String _for;
        HtmlOutputStatistics statComponent = null;
        if (component instanceof HtmlOutputStatistics) {
            statComponent = (HtmlOutputStatistics)component;
        }
        if ((_for = statComponent != null ? statComponent.getFor() : (String)component.getAttributes().get("for")) == null) {
            return this.getUIDataParent(component);
        }
        UIComponent c = component.findComponent(_for);
        if (c == null || !(c instanceof UIData)) {
            return null;
        }
        return (UIData)c;
    }

    private UIData getUIDataParent(UIComponent component) {
        if ((component = component.getParent()) == null) {
            return null;
        }
        if (component instanceof UIData) {
            return (UIData)component;
        }
        return this.getUIDataParent(component);
    }

    private boolean getSelectedRows(UIData data, UIComponent component, Job job) {
        if (data == null) {
            return false;
        }
        if ("com.ibm.faces.RowSelect".equals(component.getRendererType())) {
            int start = data.getFirst();
            int rows = data.getRows();
            int len = rows > 0 ? start + rows : data.getRowCount();
            int i = start;
            while (i < len) {
                data.setRowIndex(i);
                if (!data.isRowAvailable()) break;
                job.processRow(component);
                ++i;
            }
            data.setRowIndex(-1);
            return true;
        }
        List children = component.getChildren();
        int i = 0;
        int len = children.size();
        while (i < len) {
            UIComponent child = (UIComponent)children.get(i);
            if (this.getSelectedRows(data, child, job)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void writeJavaScript(FacesContext context, UIComponent component, String script) throws IOException {
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        if (scriptCollector != null) {
            HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
            scriptCollector.addScriptOnce(script);
        } else {
            ResponseWriter writer = context.getResponseWriter();
            writer.write(JavaScriptUtil.getStartTag());
            writer.write(script);
            writer.write(JavaScriptUtil.getEndTag());
        }
    }

    private int getCurrentPage(UIData data) {
        if (data == null) {
            return 0;
        }
        int rows = data.getRows();
        if (rows <= 0) {
            return 0;
        }
        return data.getFirst() / rows;
    }

    private int getLastPage(UIData data) {
        if (data == null) {
            return 0;
        }
        int rows = data.getRows();
        if (rows <= 0) {
            return 0;
        }
        int max = data.getRowCount();
        if (max < 0) {
            return -1;
        }
        if (max > 0) {
            int lastPage = max / rows;
            if (max % rows == 0) {
                --lastPage;
            }
            return lastPage;
        }
        return 0;
    }

    private class Job {
        private int selected = 0;
        private String jsStatistics;
        private StringBuffer script = new StringBuffer();

        Job(String jsStatistics) {
            this.jsStatistics = jsStatistics;
        }

        void processRow(UIComponent component) {
            boolean bSelected = false;
            if (RowSelectRenderer.isRowSelected(component)) {
                ++this.selected;
                bSelected = true;
            }
            String selectionVar = RowSelectRenderer.getJsSelectionVariable(component.getClientId(FacesContext.getCurrentInstance()));
            this.script.append("if(!").append(selectionVar).append(") var ").append(selectionVar).append(" = new ").append("HxG_4").append(".prototype.HxSelection(").append(bSelected).append("); \r\n");
            this.script.append(selectionVar).append(".addSelectionListener(").append(this.jsStatistics).append(");\r\n");
        }

        StringBuffer getScript() {
            return this.script;
        }

        int getSelected() {
            return this.selected;
        }
    }
}

