/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.renderkit.html_extended;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.component.UIScriptCollector;
import com.ibm.faces.component.html.HtmlPagerWeb;
import com.ibm.faces.renderkit.html_extended.AbstractPagerRenderer;
import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.util.HtmlUtil;
import com.ibm.faces.util.JavaScriptUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class WebPagerRenderer
extends AbstractPagerRenderer {
    private static final String PAGER_SIMPLE_NUMBERLIST = "__pagerWeb";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        UIScriptCollector scriptCollector = UIScriptCollector.find(component);
        HxClientRenderUtil.initJSLibraries((UIComponent)scriptCollector, context);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String styleClass;
        String style;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        HtmlPagerWeb webComponent = null;
        if (component instanceof HtmlPagerWeb) {
            webComponent = (HtmlPagerWeb)component;
        }
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getClientId(context);
        String idHidden = String.valueOf(id) + PAGER_SIMPLE_NUMBERLIST;
        String formId = this.getFormId(context, component);
        UIData data = this.findDataComponent(component);
        if (webComponent != null) {
            style = webComponent.getStyle();
            styleClass = webComponent.getStyleClass();
        } else {
            style = (String)component.getAttributes().get("style");
            styleClass = (String)component.getAttributes().get("styleClass");
        }
        boolean isBinaryNavigation = this.isAttributeTrue(component, "binaryNavigation");
        HtmlUtil.writeTagStartOpen((Writer)writer, "span", false, false);
        HtmlUtil.writeTagAttribute((Writer)writer, "id", id);
        HtmlUtil.writeTagAttribute((Writer)writer, "style", style);
        HtmlUtil.writeTagAttribute((Writer)writer, "class", styleClass);
        HtmlUtil.writeTagStartCloseLn((Writer)writer, false);
        StringBuffer buffer = new StringBuffer();
        int currentPage = this.getCurrentPage(data);
        HtmlUtil.writeInputHidden((Writer)writer, idHidden, "" + currentPage);
        int[] pageList = null;
        if (isBinaryNavigation) {
            pageList = this.getBinaryTraversalPageList(component, data);
        } else {
            pageList = this.getSimplePageList(component, data);
            if (pageList.length > 0 && pageList[0] > 0) {
                ResourceBundle bundle = ResourceHandler.getBundle(context);
                String localizedNext = ResourceHandler.getString(bundle, "PagerRenderer.previous");
                this.writePagerWebElement(component, (Writer)writer, localizedNext, currentPage - 1, idHidden, formId, buffer, "_prev");
            }
        }
        int i = 0;
        int len = pageList.length;
        while (i < len) {
            if (pageList[i] >= 0) {
                if (pageList[i] == currentPage) {
                    HtmlUtil.writeTagStartOpen((Writer)writer, "strong", false, false);
                    HtmlUtil.writeTagStartClose((Writer)writer, false);
                    writer.write("" + (currentPage + 1));
                    HtmlUtil.writeTagEndLn((Writer)writer, "strong");
                } else {
                    String indexDisplay = "" + (pageList[i] + 1);
                    this.writePagerWebElement(component, (Writer)writer, indexDisplay, pageList[i], idHidden, formId, buffer, null);
                }
            }
            ++i;
        }
        if (!isBinaryNavigation) {
            int lastPage = this.getLastPage(data);
            if (pageList.length > 0 && pageList[pageList.length - 1] < lastPage) {
                ResourceBundle bundle = ResourceHandler.getBundle(context);
                String localizedPrevious = ResourceHandler.getString(bundle, "PagerRenderer.next");
                this.writePagerWebElement(component, (Writer)writer, localizedPrevious, currentPage + 1, idHidden, formId, buffer, "_next");
            }
        }
        HtmlUtil.writeTagEndLn((Writer)writer, "span");
        ResourceBundle bundle = ResourceHandler.getBundle(context);
        String src = String.valueOf(JavaScriptUtil.getJavaScriptPath(context)) + ResourceHandler.buildLocalizedLibName(bundle, "hxclient_v1.js");
        if (UIScriptCollector.find(component) == null) {
            writer.write(JavaScriptUtil.getStartTag(src));
            writer.write(JavaScriptUtil.getEndTag());
        }
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        UIData data = this.findDataComponent(component);
        if (data == null) {
            return;
        }
        if (!this.isPaged(data)) {
            return;
        }
        HtmlPagerWeb webComponent = null;
        if (component instanceof HtmlPagerWeb) {
            webComponent = (HtmlPagerWeb)component;
        }
        String key = String.valueOf(component.getClientId(context)) + PAGER_SIMPLE_NUMBERLIST;
        String value = (String)context.getExternalContext().getRequestParameterMap().get(key);
        if (value != null) {
            int currentPage = this.getCurrentPage(data);
            int lastPage = this.getLastPage(data);
            int newPage = -1;
            try {
                Integer intObj = new Integer(value);
                newPage = intObj;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.queueEvent(component, data, currentPage, newPage, lastPage);
        }
    }

    private void writePagerWebElement(UIComponent component, Writer writer, String text, int index, String id, String formId, StringBuffer buffer, String idSuffix) throws IOException {
        if (formId == null) {
            formId = "notNestedInUIForm_csdfvfbdbfdfbdwbwrbrbgwrgtrwgwvwvfvfw";
        }
        String linkId = String.valueOf(id) + "__" + index;
        if (idSuffix != null) {
            linkId = String.valueOf(linkId) + idSuffix;
        }
        buffer.setLength(0);
        buffer.append("hX_4").append(".addBehavior(\"").append(linkId).append("\",\"onclick\",new ").append("hX_4").append(".JSFBehaviorPager(").append("\"input-id:").append(id).append("\",").append("\"index:").append(index).append("\",").append("\"form-id:").append(formId).append("\",").append("\"action:").append("submit\"").append("));\n");
        HtmlUtil.writeTagStartOpen(writer, "a", false, false);
        HtmlUtil.writeTagAttribute(writer, "id", linkId);
        HtmlUtil.writeTagAttribute(writer, "href", "#");
        HtmlUtil.writeTagStartClose(writer, false);
        writer.write(text);
        HtmlUtil.writeTagEndLn(writer, "a");
        UIScriptCollector.find(component).addScriptOnce(buffer.toString());
    }

    private int[] getBinaryTraversalPageList(UIComponent pager, UIData data) {
        int next;
        int lenMinusTwo;
        int lenMinusOne;
        int prev;
        boolean ok;
        int numberOfPages = this.getAttributeInteger(pager, "numberOfPages", 10);
        if (numberOfPages < 7) {
            numberOfPages = 7;
        }
        int[] numberList = new int[numberOfPages];
        int len = numberList.length;
        Arrays.fill(numberList, -1);
        int firstPage = 0;
        int lastPage = this.getLastPage(data);
        int page = this.getCurrentPage(data);
        if (lastPage < 0) {
            lastPage = page + 1;
        }
        int idx = 0;
        numberList[idx++] = firstPage;
        if (page > firstPage) {
            numberList[idx++] = page;
        }
        if (lastPage > page) {
            numberList[idx++] = lastPage;
        }
        int pre = page - 1;
        int post = page + 1;
        do {
            ok = false;
            if (pre > firstPage) {
                numberList[idx++] = pre--;
                if (idx >= len) break;
                ok = true;
            }
            if (post >= lastPage) continue;
            numberList[idx++] = post++;
            if (idx >= len) break;
            ok = true;
        } while (ok);
        Arrays.sort(numberList);
        if (numberList[1] - numberList[0] > 1 && (prev = (numberList[1] - numberList[0]) / 2 + numberList[0]) != numberList[0]) {
            numberList[1] = prev;
        }
        if (numberList[lenMinusOne = len - 1] - numberList[lenMinusTwo = len - 2] > 1 && (next = numberList[lenMinusOne] - (numberList[lenMinusOne] - numberList[lenMinusTwo]) / 2) != numberList[lenMinusTwo]) {
            numberList[lenMinusTwo] = next;
        }
        return numberList;
    }

    private int[] getSimplePageList(UIComponent pager, UIData data) {
        int delta;
        int currentPage = this.getCurrentPage(data);
        int firstPage = 0;
        int lastPage = this.getLastPage(data);
        if (lastPage < 0) {
            lastPage = Integer.MAX_VALUE;
        }
        boolean currentPageLast = this.isAttributeTrue(pager, "currentPageLast");
        int numberOfPages = this.getAttributeInteger(pager, "numberOfPages", 5);
        if (numberOfPages < 2) {
            numberOfPages = 2;
        }
        int midPos = numberOfPages / 2;
        if (numberOfPages % 2 > 0) {
            ++midPos;
        }
        int first = currentPage - (midPos - 1);
        int last = currentPage + (numberOfPages - midPos);
        if (last > lastPage) {
            delta = last - lastPage;
            first -= delta;
            last -= delta;
        }
        if (first < firstPage) {
            delta = firstPage - first;
            first += delta;
            last += delta;
        }
        if (last > lastPage) {
            last = lastPage;
        }
        int[] range = new int[last - first + 1];
        int i = 0;
        int len = range.length;
        while (i < len) {
            range[i] = first++;
            ++i;
        }
        return range;
    }

    private boolean isAttributeTrue(UIComponent component, String key) {
        Object value = component.getAttributes().get(key);
        if (value == null) {
            return false;
        }
        if (Boolean.FALSE.equals(value)) {
            return false;
        }
        return Boolean.TRUE.equals(value) || "true".equalsIgnoreCase(value.toString());
    }

    private int getAttributeInteger(UIComponent component, String key, int defaultValue) {
        Object value = component.getAttributes().get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            String str = value.toString();
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private String getFormId(FacesContext context, UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof UIForm) {
            return component.getClientId(context);
        }
        return this.getFormId(context, component.getParent());
    }
}

