/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.taglib.html_extended;

import com.ibm.faces.validator.DateTimeRangeValidator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.validator.Validator;
import javax.faces.webapp.UIComponentTag;
import javax.faces.webapp.ValidatorTag;
import javax.servlet.jsp.JspException;

public class ValidateDateTimeRangeTag
extends ValidatorTag {
    protected Boolean maxSet = Boolean.FALSE;
    protected Boolean minSet = Boolean.FALSE;
    protected String maximum = null;
    protected String minimum = null;
    protected Date maxDate = null;
    protected Date minDate = null;
    private static final String DATE_ATTR_TODAY = "today";
    private static final String DATE_ATTR_TOMORROW = "tomorrow";
    private static final String DATE_ATTR_YESTERDAY = "yesterday";
    private static final String TIME_ATTR_NOW = "now";

    public ValidateDateTimeRangeTag() {
        super.setId("DateTimeRange");
        super.setValidatorId("DateTimeRange");
    }

    public String getMaximum() {
        return this.maximum;
    }

    public void setMaximum(String newMaximum) {
        this.maxSet = Boolean.TRUE;
        this.maximum = newMaximum;
    }

    public String getMinimum() {
        return this.minimum;
    }

    public void setMinimum(String newMinimum) {
        this.minSet = Boolean.TRUE;
        this.minimum = newMinimum;
    }

    protected Validator createValidator() throws JspException {
        DateTimeRangeValidator result = null;
        result = (DateTimeRangeValidator)super.createValidator();
        this.evaluateExpressions();
        if (this.maxSet.booleanValue()) {
            result.setMaximum(this.maxDate);
        }
        if (this.minSet.booleanValue()) {
            result.setMinimum(this.minDate);
        }
        return result;
    }

    private void evaluateExpressions() {
        Long longObj;
        Date dateObj;
        Object result;
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.minSet.booleanValue()) {
            if (UIComponentTag.isValueReference((String)this.minimum)) {
                this.minimum = this.changeKeywordsToLong(this.minimum);
                result = context.getApplication().createValueBinding(this.minimum).getValue(context);
                if (result instanceof Date) {
                    dateObj = (Date)result;
                    this.minimum = new Long(dateObj.getTime()).toString();
                    this.minDate = dateObj;
                } else {
                    longObj = (Long)result;
                    this.minimum = new Long(longObj).toString();
                    this.minDate = new Date(longObj);
                }
            } else {
                this.minimum = this.changeDateToLong(this.minimum);
                this.minDate = new Date(Long.parseLong(this.minimum));
            }
        }
        if (this.maxSet.booleanValue()) {
            if (UIComponentTag.isValueReference((String)this.maximum)) {
                this.maximum = this.changeKeywordsToLong(this.maximum);
                result = context.getApplication().createValueBinding(this.maximum).getValue(context);
                if (result instanceof Date) {
                    dateObj = (Date)result;
                    this.maximum = new Long(dateObj.getTime()).toString();
                    this.maxDate = dateObj;
                } else {
                    longObj = (Long)result;
                    this.maximum = new Long(longObj).toString();
                    this.maxDate = new Date(longObj);
                }
            } else {
                this.maximum = this.changeDateToLong(this.maximum);
                this.maxDate = new Date(Long.parseLong(this.maximum));
            }
        }
    }

    private String changeDateToLong(String attr) {
        String dateFormat = "yyyy/MM/dd HH:mm:ss";
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        try {
            date = sdf.parse(attr);
        }
        catch (ParseException d_t) {
            dateFormat = "yyyy/MM/dd";
            try {
                sdf.applyPattern(dateFormat);
                date = sdf.parse(attr);
            }
            catch (ParseException d_o) {
                dateFormat = "HH:mm:ss";
                try {
                    sdf.applyPattern(dateFormat);
                    date = sdf.parse(attr);
                }
                catch (ParseException t_o) {
                    throw new ConverterException(String.valueOf(d_t.getMessage()) + "\n" + d_o.getMessage() + "\n" + t_o.getMessage());
                }
            }
        }
        return new Long(date.getTime()).toString();
    }

    private String changeKeywordsToLong(String date) {
        String newDate = date;
        while (true) {
            String day = null;
            Date keyword = null;
            if (newDate.indexOf(TIME_ATTR_NOW) != -1) {
                day = TIME_ATTR_NOW;
                keyword = new Date();
            } else if (newDate.indexOf(DATE_ATTR_TODAY) != -1) {
                day = DATE_ATTR_TODAY;
                keyword = new Date();
            } else if (newDate.indexOf(DATE_ATTR_TOMORROW) != -1) {
                day = DATE_ATTR_TOMORROW;
                keyword = new Date(System.currentTimeMillis() + 86400000L);
            } else if (newDate.indexOf(DATE_ATTR_YESTERDAY) != -1) {
                day = DATE_ATTR_YESTERDAY;
                keyword = new Date(System.currentTimeMillis() - 86400000L);
            } else {
                return newDate;
            }
            int start = 0;
            int end = 0;
            start = newDate.indexOf(day);
            end = start + day.length();
            String tmp = newDate.substring(0, start);
            tmp = String.valueOf(tmp) + " " + new Long(keyword.getTime()).toString();
            newDate = tmp = String.valueOf(tmp) + " " + newDate.substring(end, newDate.length());
        }
    }
}

