/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.util;

import com.ibm.faces.util.JavaScriptUtil;
import java.io.IOException;
import java.io.Writer;
import javax.faces.context.FacesContext;

public class HtmlUtil {
    private static final String[][] ENTITIES = HtmlUtil.setEntities();
    private static final int S_CHAR = 0;
    private static final int S_ENITITY = 1;

    public static String addHtmlEntities(String str) {
        if (str == null) {
            return str;
        }
        boolean found = false;
        int i = 0;
        int len = ENTITIES.length;
        while (i < len) {
            if (str.indexOf(ENTITIES[i][0]) >= 0) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            return str;
        }
        StringBuffer buffer = new StringBuffer(str);
        int i2 = 0;
        int len2 = ENTITIES.length;
        while (i2 < len2) {
            int offset = 0;
            while ((offset = HtmlUtil.indexOf(buffer, ENTITIES[i2][0], offset)) >= 0) {
                buffer.replace(offset, offset + ENTITIES[i2][0].length(), ENTITIES[i2][1]);
                offset += ENTITIES[i2][1].length();
            }
            ++i2;
        }
        return buffer.toString();
    }

    private static synchronized String[][] setEntities() {
        String[][] entities = new String[][]{{"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}};
        return entities;
    }

    private static int indexOf(StringBuffer buffer, String find, int offset) {
        int i = offset;
        int ilen = buffer.length() - find.length() + 1;
        while (i < ilen) {
            int lastChar = find.length() - 1;
            int j = 0;
            int jlen = find.length();
            while (j < jlen) {
                if (buffer.charAt(i + j) == find.charAt(j) && j == lastChar) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public static final void writeTagStartOpen(Writer writer, String tag, boolean close, boolean end) throws IOException {
        writer.write("<");
        writer.write(tag);
        if (close) {
            HtmlUtil.writeTagStartClose(writer, end);
        }
    }

    public static final void writeTagStartOpenLn(Writer writer, String tag, boolean close, boolean end) throws IOException {
        HtmlUtil.writeTagStartOpen(writer, tag, close, end);
        HtmlUtil.writeLn(writer);
    }

    public static final void writeTagAttribute(Writer writer, String name, String value) throws IOException {
        if (value == null) {
            return;
        }
        value = HtmlUtil.addHtmlEntities(value);
        writer.write(" ");
        writer.write(name);
        writer.write("=\"");
        writer.write(value);
        writer.write("\"");
    }

    public static final void writeTagStartClose(Writer writer, boolean end) throws IOException {
        if (end) {
            writer.write(" />");
        } else {
            writer.write(">");
        }
    }

    public static final void writeTagStartCloseLn(Writer writer, boolean end) throws IOException {
        HtmlUtil.writeTagStartClose(writer, end);
        HtmlUtil.writeLn(writer);
    }

    public static final void writeTagEnd(Writer writer, String tag) throws IOException {
        writer.write("</");
        writer.write(tag);
        writer.write(">");
    }

    public static final void writeTagEndLn(Writer writer, String tag) throws IOException {
        HtmlUtil.writeTagEnd(writer, tag);
        HtmlUtil.writeLn(writer);
    }

    public static final void writeInputHidden(Writer writer, String idName, String value) throws IOException {
        HtmlUtil.writeTagStartOpen(writer, "input", false, false);
        HtmlUtil.writeTagAttribute(writer, "type", "hidden");
        HtmlUtil.writeTagAttribute(writer, "id", idName);
        HtmlUtil.writeTagAttribute(writer, "name", idName);
        HtmlUtil.writeTagAttribute(writer, "value", value);
        HtmlUtil.writeTagStartCloseLn(writer, true);
    }

    public static final void writeHiddenAudioLabel(Writer writer, String label) throws IOException {
        String image = String.valueOf(JavaScriptUtil.getImagePath(FacesContext.getCurrentInstance())) + "1x1.gif";
        HtmlUtil.writeTagStartOpen(writer, "image", false, false);
        HtmlUtil.writeTagAttribute(writer, "src", image);
        HtmlUtil.writeTagAttribute(writer, "alt", label);
        HtmlUtil.writeTagAttribute(writer, "style", "width: 0px; height: 0px; overflow: hidden; font-size: 0px; position: absolute");
        HtmlUtil.writeTagStartCloseLn(writer, true);
    }

    public static final void writeText(Writer writer, String text) throws IOException {
        text = HtmlUtil.addHtmlEntities(text);
        writer.write(text);
    }

    public static final void writeOption(Writer writer, String label, String value) throws IOException {
        HtmlUtil.writeTagStartOpen(writer, "option", false, false);
        HtmlUtil.writeTagAttribute(writer, "label", label);
        HtmlUtil.writeTagAttribute(writer, "value", value);
        HtmlUtil.writeTagStartClose(writer, false);
        HtmlUtil.writeText(writer, label);
        HtmlUtil.writeTagEndLn(writer, "option");
    }

    private static final void writeLn(Writer writer) throws IOException {
        writer.write("\r\n");
    }
}

