/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;

public class LifecycleUtil {
    public static final String USE_UNENCODED_CONTEXT_PATH = "com.ibm.faces.USE_UNENCODED_CONTEXT_PATH";
    private static String contextPath;
    public static final String JS_RESOURCE_SERVLET_URL_PATTERN = "com.ibm.faces.JS_RESOURCE_SERVLET_URL_PATTERN";
    private static String jsResourceURLPattern;
    private static String contextPathWithURLPattern;

    public static String getRequestParam(FacesContext context, String requestParamName) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        return (String)requestMap.get(requestParamName);
    }

    public static UIParameter[] getParameters(UIComponent c) {
        ArrayList list = new ArrayList();
        Iterator children = c.getChildren().iterator();
        while (children.hasNext()) {
            Object child = children.next();
            if (!(child instanceof UIParameter)) continue;
            list.add(child);
        }
        UIParameter[] ret = new UIParameter[list.size()];
        list.toArray(ret);
        return ret;
    }

    public static String getContextPath(FacesContext context) {
        if (contextPath == null) {
            String unencodedSetting = context.getExternalContext().getInitParameter(USE_UNENCODED_CONTEXT_PATH);
            if (unencodedSetting == null) {
                contextPath = context.getExternalContext().getRequestContextPath();
            } else {
                unencodedSetting = unencodedSetting.trim();
                Boolean isNumber = Boolean.TRUE;
                int len = unencodedSetting.length();
                int i = 0;
                while (i < len) {
                    if (!Character.isDigit(unencodedSetting.charAt(i))) {
                        isNumber = Boolean.FALSE;
                        break;
                    }
                    ++i;
                }
                if (isNumber.booleanValue()) {
                    String path = context.getExternalContext().getRequestContextPath();
                    StringBuffer s = new StringBuffer();
                    if (path.lastIndexOf("/") > 0) {
                        int nodes = Integer.parseInt(unencodedSetting);
                        if (nodes < 1) {
                            nodes = 1;
                        }
                        int pos1 = 0;
                        int pos2 = 1;
                        int pathLength = path.length();
                        int x = 1;
                        while (x <= nodes) {
                            if ((pos2 = path.indexOf("/", pos2)) == -1) {
                                pos2 = pathLength;
                            }
                            s.append(path.substring(pos1, pos2));
                            if (pos2 == pathLength) break;
                            pos1 = pos2++;
                            ++x;
                        }
                        contextPath = s.toString();
                    } else {
                        contextPath = path;
                    }
                } else {
                    contextPath = unencodedSetting;
                }
            }
        }
        return contextPath;
    }

    public static String getJSResourceURLPattern(String pattern) {
        if (jsResourceURLPattern == null) {
            if (pattern != null && !pattern.equals("")) {
                jsResourceURLPattern = pattern;
                if (jsResourceURLPattern.startsWith("/")) {
                    jsResourceURLPattern = jsResourceURLPattern.substring(1, jsResourceURLPattern.length());
                }
                if (jsResourceURLPattern.endsWith("/*")) {
                    jsResourceURLPattern = jsResourceURLPattern.substring(0, jsResourceURLPattern.length() - 2);
                }
                if (jsResourceURLPattern.endsWith("/")) {
                    jsResourceURLPattern = jsResourceURLPattern.substring(0, jsResourceURLPattern.length() - 1);
                }
            } else {
                jsResourceURLPattern = ".ibmjsfres";
            }
        }
        return jsResourceURLPattern;
    }

    public static String getResourceServletContextPath(FacesContext context) {
        if (contextPathWithURLPattern == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(LifecycleUtil.getContextPath(context)).append("/").append(LifecycleUtil.getJSResourceURLPattern(context.getExternalContext().getInitParameter(JS_RESOURCE_SERVLET_URL_PATTERN)));
            contextPathWithURLPattern = sb.toString();
        }
        return contextPathWithURLPattern;
    }
}

