/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebXmlHandler
extends DefaultHandler {
    private ArrayList facesMappings = null;
    private String facesServletName = null;
    private ServletBean currentServlet = null;
    private ServletMappingBean currentServletMapping = null;
    private String currentElementName = null;
    private Boolean processingServlet = Boolean.FALSE;
    private Boolean processingServletMapping = Boolean.FALSE;

    public WebXmlHandler(FacesContext context) {
        try {
            URL url = context.getExternalContext().getResource("/WEB-INF/web.xml");
            SAXParser parser = new SAXParser();
            parser.setContentHandler((ContentHandler)this);
            parser.parse(url.toExternalForm());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List getFacesMappings() {
        return this.facesMappings;
    }

    public String getFacesServletName() {
        return this.facesServletName;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("servlet")) {
            this.processingServlet = Boolean.TRUE;
            this.currentServlet = new ServletBean();
        } else if (localName.equals("servlet-mapping")) {
            this.processingServletMapping = Boolean.TRUE;
            this.currentServletMapping = new ServletMappingBean();
        }
        this.currentElementName = localName;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String data;
        if (this.processingServlet.booleanValue() && (data = String.valueOf(ch, start, length).trim()).length() > 0) {
            if (this.currentElementName.equals("servlet-name")) {
                this.currentServlet.setServletName(data);
            } else if (this.currentElementName.equals("servlet-class")) {
                this.currentServlet.setServletClass(data);
            }
        }
        if (this.processingServletMapping.booleanValue() && (data = String.valueOf(ch, start, length).trim()).length() > 0) {
            if (this.currentElementName.equals("servlet-name")) {
                this.currentServletMapping.setServletName(data);
            } else if (this.currentElementName.equals("url-pattern")) {
                this.currentServletMapping.setUrlPattern(data);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("servlet")) {
            if (this.currentServlet != null && this.currentServlet.getServletClass().equals("javax.faces.webapp.FacesServlet")) {
                this.facesServletName = this.currentServlet.getServletName();
            }
            this.currentServlet = null;
            this.processingServlet = Boolean.FALSE;
        } else if (localName.equals("servlet-mapping")) {
            if (this.facesServletName != null && this.currentServletMapping != null && this.currentServletMapping.getServletName().equals(this.facesServletName)) {
                if (this.facesMappings == null) {
                    this.facesMappings = new ArrayList();
                }
                this.facesMappings.add(this.currentServletMapping.getUrlPattern());
                this.currentServletMapping = null;
            }
            this.processingServletMapping = Boolean.FALSE;
        }
    }

    public class ServletBean {
        private String servletName = null;
        private String servletClass = null;

        public String getServletClass() {
            return this.servletClass;
        }

        public void setServletClass(String servletClass) {
            this.servletClass = servletClass;
        }

        public String getServletName() {
            return this.servletName;
        }

        public void setServletName(String servletName) {
            this.servletName = servletName;
        }
    }

    public class ServletMappingBean {
        private String servletName = null;
        private String urlPattern = null;

        public String getServletName() {
            return this.servletName;
        }

        public void setServletName(String servletName) {
            this.servletName = servletName;
        }

        public String getUrlPattern() {
            return this.urlPattern;
        }

        public void setUrlPattern(String urlPattern) {
            this.urlPattern = urlPattern;
        }
    }
}

