/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.validator;

import com.ibm.faces.ResourceHandler;
import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class ConstraintValidator
implements Validator,
StateHolder {
    private String regex;
    private ResourceBundle rb;
    private boolean transientFlag = false;

    public ConstraintValidator() {
    }

    public ConstraintValidator(String regex) {
        this.setRegex(regex);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException(ResourceHandler.getString(this.rb, "ConstraintValidator.FacesContext_or_UIComponent_is_null._5"));
        }
        this.rb = ResourceHandler.getBundle(context);
        String convertedValue = "";
        if (value != null) {
            convertedValue = value instanceof String ? (String)value : value.toString();
            if (this.regex.equals("AlphabetOnly")) {
                this.validateAlphabetOnly(convertedValue, context, (UIInput)component);
            } else if (this.regex.equals("DigitOnly")) {
                this.validateDigitOnly(convertedValue, context, (UIInput)component);
            } else if (this.regex.equals("AlnumOnly")) {
                this.validateAlnumOnly(convertedValue, context, (UIInput)component);
            } else {
                this.validateRegEx(convertedValue, context, (UIInput)component);
            }
        }
    }

    protected void validateAlphabetOnly(String convertedValue, FacesContext context, UIInput component) {
        char[] checkString = convertedValue.toCharArray();
        boolean isValid = true;
        int length = checkString.length;
        int i = 0;
        while (i < length) {
            boolean b = Character.isLetter(checkString[i]);
            if (!b) {
                isValid = false;
                break;
            }
            ++i;
        }
        if (!isValid) {
            FacesMessage errMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ConstraintValidator.Validation_Error._8"), ResourceHandler.getString(this.rb, "ConstraintValidator.This_field_may_only_contain_alphabetic_characters_between_A_to_Z._1"));
            context.addMessage(component.getClientId(context), errMsg);
            component.setValid(false);
        }
    }

    protected void validateDigitOnly(String convertedValue, FacesContext context, UIInput component) {
        char[] checkString = convertedValue.toCharArray();
        boolean isValid = true;
        int length = checkString.length;
        int i = 0;
        while (i < length) {
            boolean b = Character.isDigit(checkString[i]);
            if (!b) {
                isValid = false;
                break;
            }
            ++i;
        }
        if (!isValid) {
            FacesMessage errMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ConstraintValidator.Validation_Error._9"), ResourceHandler.getString(this.rb, "ConstraintValidator.This_field_may_only_contain_digits_between_0_to_9._2"));
            context.addMessage(component.getClientId(context), errMsg);
            component.setValid(false);
        }
    }

    protected void validateAlnumOnly(String convertedValue, FacesContext context, UIInput component) {
        char[] checkString = convertedValue.toCharArray();
        boolean isValid = true;
        int length = checkString.length;
        int i = 0;
        while (i < length) {
            boolean b = Character.isLetterOrDigit(checkString[i]);
            if (!b) {
                isValid = false;
                break;
            }
            ++i;
        }
        if (!isValid) {
            FacesMessage errMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ConstraintValidator.Validation_Error._10"), ResourceHandler.getString(this.rb, "ConstraintValidator.This_field_may_contain_alphabetic_characters_and_digits._3"));
            context.addMessage(component.getClientId(context), errMsg);
            component.setValid(false);
        }
    }

    protected void validateRegEx(String convertedValue, FacesContext context, UIInput component) {
        try {
            if (!convertedValue.matches(this.regex)) {
                FacesMessage errMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ConstraintValidator.Validation_Error._10"), ResourceHandler.getString(this.rb, "ConstraintValidator.MatchRegExp"));
                context.addMessage(component.getClientId(context), errMsg);
                component.setValid(false);
            }
        }
        catch (PatternSyntaxException e) {
            FacesMessage errMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ConstraintValidator.Validation_Error._10"), ResourceHandler.getString(this.rb, "ConstraintValidator.InvalidRegExp"));
            context.addMessage(component.getClientId(context), errMsg);
            component.setValid(false);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.regex};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.regex = (String)values[0];
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientFlag = newTransientValue;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }
}

