/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.validator;

import com.ibm.faces.ResourceHandler;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;

public class DateTimeRangeValidator
implements Validator,
StateHolder {
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MINIMUM";
    private String _globalDateFormat = "yyyy/MM/dd HH:mm:ss";
    private static final String DATE_ATTR_TODAY = "today";
    private static final String DATE_ATTR_TOMORROW = "tomorrow";
    private static final String DATE_ATTR_YESTERDAY = "yesterday";
    private static final String TIME_ATTR_NOW = "now";
    private Date minimum = null;
    private Date maximum = null;
    private boolean minimumSet = false;
    private boolean maximumSet = false;
    private boolean transientValue = false;

    public DateTimeRangeValidator() {
    }

    public DateTimeRangeValidator(Date maximum) {
        this.setMaximum(maximum);
    }

    public DateTimeRangeValidator(Date maximum, Date minimum) {
        this.setMaximum(maximum);
        this.setMinimum(minimum);
    }

    public Date getMaximum() {
        return this.isMaximumSet() ? this.maximum : null;
    }

    public void setMaximum(Date newMaximum) {
        this.maximum = newMaximum;
        this.maximumSet = true;
    }

    public boolean isMaximumSet() {
        return this.maximumSet;
    }

    public Date getMinimum() {
        return this.isMinimumSet() ? this.minimum : null;
    }

    public void setMinimum(Date newMinimum) {
        this.minimum = newMinimum;
        this.minimumSet = true;
    }

    public boolean isMinimumSet() {
        return this.minimumSet;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws FacesException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Date convertedValue = null;
        if (value != null) {
            if (value instanceof Date) {
                convertedValue = (Date)value;
            } else if (value instanceof Long) {
                convertedValue = new Date((Long)value);
            } else {
                throw new FacesException("Validation Error: Specified attribute cannot be converted to proper type.");
            }
            this.calculateTimeAndPrintErrors(convertedValue, context, (UIInput)component);
        }
    }

    protected String stringValue(Object attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeValue instanceof String) {
            return (String)attributeValue;
        }
        return attributeValue.toString();
    }

    protected void calculateTimeAndPrintErrors(Date convertedValue, FacesContext context, UIInput component) {
        MessageFormat message;
        ResourceBundle bundle;
        FacesMessage errMsg = null;
        Date minDate = null;
        Date maxDate = null;
        if (this.isMinimumSet()) {
            minDate = this.getMinimum();
        }
        if (this.isMaximumSet()) {
            maxDate = this.getMaximum();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (minDate != null && convertedValue.before(minDate)) {
            Object[] tmpMin = new Object[]{sdf.format(minDate)};
            bundle = ResourceHandler.getBundle(context);
            message = new MessageFormat(ResourceHandler.getString(bundle, "ValidationMessage.less_than_minimum"));
            errMsg = new FacesMessage(message.format(tmpMin));
            errMsg.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(component.getClientId(context), errMsg);
            component.setValid(false);
        }
        if (maxDate != null && convertedValue.after(maxDate)) {
            Object[] tmpMax = new Object[]{sdf.format(maxDate)};
            bundle = ResourceHandler.getBundle(context);
            message = new MessageFormat(ResourceHandler.getString(bundle, "ValidationMessage.more_than_maximum"));
            errMsg = new FacesMessage(message.format(tmpMax));
            context.addMessage(component.getClientId(context), errMsg);
            component.setValid(false);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.maximum, this.maximumSet ? Boolean.TRUE : Boolean.FALSE, this.minimum, this.minimumSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maximum = (Date)values[0];
        this.maximumSet = (Boolean)values[1];
        this.minimum = (Date)values[2];
        this.minimumSet = (Boolean)values[3];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }
}

