/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.validator;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.validator.ExpressionValidatorVariableResolver;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class ExpressionValidator
implements Validator,
StateHolder {
    public static String ALPHABET_ONLY_MESSAGE;
    public static String DIGIT_ONLY_MESSAGE;
    public static String ALPHABET_NUMBER_ONLY_MESSAGE;
    public static String REGEX_IS_INVALID_MESSAGE;
    public static String NULL_MESSAGE;
    private String expression;
    private ResourceBundle rb;
    private boolean transientFlag = false;

    public ExpressionValidator() {
    }

    public ExpressionValidator(String exp) {
        this.setExpression(exp);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (value == null) {
            return;
        }
        if (this.expression == null || this.expression.length() == 0) {
            return;
        }
        this.rb = ResourceHandler.getBundle(context);
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        boolean bValid = true;
        FacesMessage errMsg = null;
        VariableResolver oldResolver = context.getApplication().getVariableResolver();
        ExpressionValidatorVariableResolver newResolver = new ExpressionValidatorVariableResolver(oldResolver, value);
        context.getApplication().setVariableResolver((VariableResolver)newResolver);
        Object result = null;
        try {
            result = context.getApplication().createValueBinding(this.expression).getValue(context);
        }
        catch (EvaluationException e) {
            errMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ExpressionValidator.ValidationError"), ResourceHandler.getString(this.rb, "ExpressionValidator.InvalidExpression"));
            bValid = false;
        }
        if (!(result instanceof Boolean)) {
            errMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ExpressionValidator.ValidationError"), ResourceHandler.getString(this.rb, "ExpressionValidator.NotBoolean"));
            bValid = false;
        } else {
            Boolean bResult = (Boolean)result;
            if (bResult != Boolean.TRUE) {
                errMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, ResourceHandler.getString(this.rb, "ExpressionValidator.ValidationError"), ResourceHandler.getString(this.rb, "ExpressionValidator.FalseExpression"));
                bValid = false;
            }
        }
        context.getApplication().setVariableResolver(oldResolver);
        if (!bValid) {
            context.addMessage(component.getClientId(context), errMsg);
            ((UIInput)component).setValid(false);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.expression};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.expression = (String)values[0];
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientFlag = newTransientValue;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }
}

