/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.webapp;

import com.ibm.faces.util.Base64;
import com.ibm.faces.util.WebXmlHandler;
import com.ibm.faces.webapp.IValueResourceListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ValueResourcePhaseListener
implements PhaseListener,
IValueResourceListener {
    public static final String VIEWID_PARAM = "vrViewID";
    public static final String CLIENTID_PARAM = "vrClientId";
    public static final String PARENTID_PARAM = "vrParentId";
    public static final String CLIENTINDEX_PARAM = "vrClientIndex";
    private static final String MIMETYPE_ATTR = "mimeType";
    private static IValueResourceListener valueResourceListener = null;
    private String facesMapping = null;

    public void beforePhase(PhaseEvent event) {
    }

    public void afterPhase(PhaseEvent event) {
        block25: {
            String clientIdParam = null;
            UIComponent client = null;
            try {
                Object value;
                ValueBinding vb;
                HttpServletResponse response;
                FacesContext context = event.getFacesContext();
                if (context == null) {
                    return;
                }
                UIViewRoot viewRoot = context.getViewRoot();
                if (viewRoot == null) {
                    return;
                }
                ExternalContext extContext = context.getExternalContext();
                Map parameters = extContext.getRequestParameterMap();
                clientIdParam = (String)parameters.get(CLIENTID_PARAM);
                String parentClientIDParam = (String)parameters.get(PARENTID_PARAM);
                String clientIndexParam = (String)parameters.get(CLIENTINDEX_PARAM);
                if (clientIdParam == null) {
                    return;
                }
                context.responseComplete();
                if (parentClientIDParam != null && clientIndexParam != null) {
                    int clientIndex;
                    UIComponent parent = viewRoot.findComponent(parentClientIDParam);
                    if (parent == null) {
                        return;
                    }
                    try {
                        clientIndex = Integer.parseInt(clientIndexParam);
                    }
                    catch (NumberFormatException nfe) {
                        return;
                    }
                    UIData datagrid = (UIData)parent;
                    client = viewRoot.findComponent(clientIdParam);
                    if (client == null) {
                        return;
                    }
                    String datagridVar = (String)datagrid.getAttributes().get("var");
                    ValueBinding vb2 = client.getValueBinding("value");
                    String clientVar = vb2.getExpressionString();
                    if (clientVar.indexOf(datagridVar) != -1) {
                        datagrid.setRowIndex(clientIndex);
                    }
                } else {
                    client = viewRoot.findComponent(clientIdParam);
                }
                if ((response = (HttpServletResponse)extContext.getResponse()) == null) {
                    return;
                }
                byte[] bytes = null;
                if (client == null || (vb = client.getValueBinding("value")) == null) break block25;
                try {
                    value = vb.getValue(context);
                }
                catch (Exception e) {
                    return;
                }
                if (value instanceof String) {
                    bytes = Base64.decode((String)value);
                } else if (value instanceof byte[]) {
                    bytes = (byte[])value;
                } else if (value instanceof InputStream) {
                    InputStream is = (InputStream)value;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while (is.available() > 0) {
                        baos.write(is.read());
                    }
                    bytes = baos.toByteArray();
                } else {
                    return;
                }
                String clientType = (String)client.getAttributes().get(MIMETYPE_ATTR);
                if (clientType != null) {
                    response.setContentLength(bytes.length);
                    response.setContentType(clientType);
                }
                if (bytes == null || bytes.length <= 0) break block25;
                ServletOutputStream out = response.getOutputStream();
                if (out != null) {
                    out.write(bytes);
                    break block25;
                }
                return;
            }
            catch (SocketException se) {
                return;
            }
            catch (Exception e) {
                System.err.println("Exception thrown in ValueResourcePhaseListener:" + e);
                e.printStackTrace();
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    private static String computeUrl(String viewId, Map params) {
        String pathInfo = "";
        String key = null;
        Iterator iter = params.entrySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            Map.Entry elem = iter.next();
            key = (String)elem.getKey();
            if (first) {
                pathInfo = String.valueOf(pathInfo) + key + "=" + params.get(key);
                first = false;
                continue;
            }
            pathInfo = String.valueOf(pathInfo) + "&" + key + "=" + params.get(key);
        }
        return String.valueOf(viewId) + "?" + pathInfo;
    }

    private static String extractComponentId(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        StringTokenizer tokenizer = new StringTokenizer(clientId, ":");
        String id = null;
        String result = "";
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            id = tokenizer.nextToken();
            if (Character.isDigit(id.charAt(0))) continue;
            if (first) {
                result = id;
                first = false;
                continue;
            }
            result = String.valueOf(result) + ":" + id;
        }
        return result;
    }

    private static UIComponent extractParentComponent(UIComponent component) {
        boolean parent_not_found = true;
        UIComponent lookup = component;
        ValueBinding vb = component.getValueBinding("value");
        String source_string = vb.getExpressionString();
        String lookup_string = null;
        UIComponent parent = null;
        do {
            if ((lookup = lookup.getParent()) == null) {
                return null;
            }
            lookup_string = (String)lookup.getAttributes().get("var");
            if (lookup_string == null || source_string.indexOf(lookup_string) == -1) continue;
            parent = lookup;
            parent_not_found = false;
        } while (parent_not_found && lookup != null);
        return parent;
    }

    public static String getUrl(FacesContext context, UIComponent component) {
        if (valueResourceListener == null) {
            Lifecycle lifecycle = null;
            try {
                LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
                String lifecycleId = "DEFAULT";
                lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
            }
            catch (FacesException e) {
                System.out.println(e.getLocalizedMessage());
                return null;
            }
            if (lifecycle == null) {
                return null;
            }
            PhaseListener[] listeners = lifecycle.getPhaseListeners();
            PhaseListener next = null;
            int i = 0;
            while (i < listeners.length) {
                next = listeners[i];
                if (next instanceof IValueResourceListener) {
                    valueResourceListener = (IValueResourceListener)next;
                    break;
                }
                ++i;
            }
        }
        if (valueResourceListener != null) {
            return valueResourceListener.getResourceURL(context, component);
        }
        return null;
    }

    public String getResourceURL(FacesContext context, UIComponent component) {
        if (this.facesMapping == null) {
            WebXmlHandler handler = new WebXmlHandler(context);
            List facesMappingsList = handler.getFacesMappings();
            if (facesMappingsList != null && facesMappingsList.size() > 0) {
                this.facesMapping = (String)facesMappingsList.get(0);
                if (this.facesMapping.startsWith("*.")) {
                    this.facesMapping = this.facesMapping.substring(1);
                } else if (this.facesMapping.endsWith("/*")) {
                    this.facesMapping = this.facesMapping.substring(0, this.facesMapping.length() - 2);
                }
            } else {
                this.facesMapping = "";
            }
        }
        String viewId = context.getViewRoot().getViewId();
        if (this.facesMapping.length() > 1 && this.facesMapping.startsWith("/")) {
            viewId = String.valueOf(this.facesMapping) + viewId;
        } else if (this.facesMapping.length() > 1 && this.facesMapping.startsWith(".")) {
            if (viewId.indexOf(".") > -1) {
                viewId = viewId.substring(0, viewId.lastIndexOf("."));
            }
            viewId = String.valueOf(viewId) + this.facesMapping;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String clientId = component.getClientId(context);
        UIComponent parent = null;
        if (clientId.indexOf(":") != -1) {
            clientId = ValueResourcePhaseListener.extractComponentId(context, component);
            parent = ValueResourcePhaseListener.extractParentComponent(component);
            if (parent != null && parent instanceof UIData) {
                String parentClientId = parent.getClientId(context);
                parentClientId = ValueResourcePhaseListener.extractComponentId(context, parent);
                int cindex = ((UIData)parent).getRowIndex();
                params.put(PARENTID_PARAM, parentClientId);
                params.put(CLIENTINDEX_PARAM, String.valueOf(cindex));
            }
        }
        params.put(CLIENTID_PARAM, clientId);
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UIParameter)) continue;
            UIParameter uiParam = (UIParameter)kid;
            String value = uiParam.getValue().toString();
            String name = uiParam.getName();
            if (name == null || value == null) continue;
            params.put(name, value);
        }
        return ValueResourcePhaseListener.computeUrl(viewId, params);
    }
}

