/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.CommandResult;
import com.ibm.java.diagnostics.collector.IpStreamHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingCommandRunner {
    private final int SIGTERM_RC = 143;
    private ArrayList<String> command;
    private String commandLabel;
    private Logger logger;
    private ProcessBuilder pb;

    public BlockingCommandRunner(ArrayList<String> command, String commandLabel, boolean redirectErrorStream, Logger logger) {
        this.command = command;
        this.commandLabel = commandLabel;
        this.logger = logger;
        this.pb = new ProcessBuilder(command);
        this.pb.redirectErrorStream(redirectErrorStream);
    }

    private void logCommand() {
        StringBuffer cmdString = new StringBuffer();
        for (String cmdItem : this.command) {
            cmdString.append(cmdItem);
            cmdString.append(" ");
        }
        this.logger.fine("Running command: " + cmdString.toString());
    }

    public CommandResult runCommand(int timeout, boolean tee) {
        this.logCommand();
        Process p = null;
        int rc = -1;
        try {
            p = this.pb.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.log(Level.FINE, "IOException when starting process for: " + this.commandLabel, e);
            rc = -1;
        }
        if (p == null) {
            return new CommandResult(null, null, rc, false);
        }
        StringBuffer stdOut = new StringBuffer();
        StringBuffer stdErr = new StringBuffer();
        IpStreamHandler outHandler = new IpStreamHandler(stdOut, this.commandLabel, p.getInputStream(), true, tee, this.logger);
        IpStreamHandler errHandler = new IpStreamHandler(stdErr, this.commandLabel, p.getErrorStream(), false, tee, this.logger);
        Thread outT = new Thread(outHandler);
        Thread errT = new Thread(errHandler);
        outT.start();
        errT.start();
        boolean timedOut = false;
        for (int i = 0; i <= timeout; ++i) {
            try {
                rc = p.exitValue();
                this.logger.fine(this.commandLabel + ": return code: " + rc);
                break;
            }
            catch (IllegalThreadStateException itse) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.log(Level.FINE, "Interrupted waiting for " + this.commandLabel + " process", e);
                }
                if (i + 1 < timeout) continue;
                this.logger.fine("Timed out waiting for command to complete: " + this.commandLabel);
                this.logger.fine("Requesting to terminate process for: " + this.commandLabel);
                p.destroy();
                try {
                    rc = p.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    rc = 143;
                    this.logger.log(Level.FINE, "IllegalThreadStateException trying to get rc after destroying " + this.commandLabel + " process", e);
                }
                timedOut = true;
                continue;
            }
        }
        try {
            outT.join(timeout * 1000);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.FINE, "Interrupted waiting for " + this.commandLabel + " stdout", e);
        }
        try {
            errT.join(timeout * 1000);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.FINE, "Interrupted waiting for " + this.commandLabel + " stderr", e);
        }
        return new CommandResult(stdOut.toString(), stdErr.toString(), rc, timedOut);
    }
}

