/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.collector;

import com.ibm.java.diagnostics.collector.BlockingCommandRunner;
import com.ibm.java.diagnostics.collector.CommandResult;
import com.ibm.java.diagnostics.collector.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UlimitCheck {
    protected String ulimitHardAllOutput = "";
    protected String ulimitHardCoreOutput = "";
    private boolean isAIX;
    private boolean isLinux;
    private Logger logger;
    private String osName;
    private static final String[] ULIMIT_AIX_ALL = new String[]{"/usr/bin/ulimit", "-H", "-a"};
    private static final String[] ULIMIT_AIX_CORE = new String[]{"/usr/bin/ulimit", "-H", "-c"};
    private static final String[] ULIMIT_LINUX_CORE = new String[]{"/bin/bash", "-c", "ulimit -H -c"};
    private static final String[] ULIMIT_LINUX_ALL = new String[]{"/bin/bash", "-c", "ulimit -H -a"};

    public UlimitCheck(Logger l) {
        this.logger = l;
        this.osName = System.getProperty("os.name");
        this.isAIX = this.osName.equals("AIX");
        this.isLinux = this.osName.equals("Linux");
        if (this.isAIX || this.isLinux) {
            this.ulimitHardAllOutput = this.getUlimitStdOut(true);
            this.ulimitHardCoreOutput = this.getUlimitStdOut(false);
        }
    }

    public UlimitCheck(Logger l, String ulimitCore) {
        this.logger = l;
        this.ulimitHardCoreOutput = ulimitCore;
        this.isLinux = true;
    }

    private String getUlimitStdOut(boolean ulimitAll) {
        if (!this.appliesToPlatform()) {
            return null;
        }
        String[] cmdArray = null;
        String cmdLabel = null;
        if (ulimitAll) {
            cmdLabel = "ulimit all";
            cmdArray = this.isAIX ? ULIMIT_AIX_ALL : ULIMIT_LINUX_ALL;
        } else {
            cmdLabel = "ulimit core";
            cmdArray = this.isAIX ? ULIMIT_AIX_CORE : ULIMIT_LINUX_CORE;
        }
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(cmdArray));
        BlockingCommandRunner ulimitRunner = new BlockingCommandRunner(cmd, cmdLabel, false, this.logger);
        CommandResult cr = ulimitRunner.runCommand(60, false);
        return cr.getStdOut();
    }

    public boolean appliesToPlatform() {
        return this.isAIX || this.isLinux;
    }

    public Level getUlimitReportPriority() {
        Level l = null;
        if (this.appliesToPlatform()) {
            l = this.isUnlimited(this.ulimitHardCoreOutput) ? Level.CONFIG : Level.WARNING;
        }
        return l;
    }

    private boolean isUnlimited(String ulimitCore) {
        if (ulimitCore != null) {
            return ulimitCore.startsWith("unlimited");
        }
        return false;
    }

    public String getReport() {
        if (!this.appliesToPlatform()) {
            return null;
        }
        String report = null;
        String lineSep = System.getProperty("line.separator");
        report = this.isUnlimited(this.ulimitHardCoreOutput) ? Messages.getString("UlimitCheck.0") + lineSep + this.ulimitHardAllOutput : Messages.getString("UlimitCheck.1") + lineSep + Messages.getString("UlimitCheck.2") + lineSep + Messages.getString("UlimitCheck.3") + lineSep + this.ulimitHardAllOutput;
        return report;
    }

    void setUlimitCore(String s) {
        this.ulimitHardCoreOutput = s;
    }
}

