/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders;

import java.io.File;

public class HealthCenterLibraryFinder {
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final String PATH_SEPARATOR = "path.separator";
    private static final String BIN = "bin";
    private static final String JAVA_HOME = "java.home";
    private static final String LIBHEALTHCENTER_SO = "libhealthcenter.so";
    private static final String HEALTHCENTER_DLL = "healthcenter.dll";
    private static final String X86 = "x86";
    private static final String I386 = "i386";
    private static final String OS_ARCH = "os.arch";
    private static final String LIB = "lib";

    public File findHealthCenterLibrary() {
        String javaHome = System.getProperty(JAVA_HOME);
        File libPath = new File(javaHome, LIB);
        File library = this.checkForPlatformVersionsInFolder(libPath);
        if (library == null) {
            File binPath = new File(javaHome, BIN);
            library = this.checkForPlatformVersionsInFolder(binPath);
        }
        if (library == null) {
            String[] paths;
            String ldLibraryPath;
            String architecture;
            String architectureFolder = architecture = System.getProperty(OS_ARCH);
            if (X86.equals(architecture)) {
                architectureFolder = I386;
            } else if ("ppc32".equals(architecture)) {
                architectureFolder = "ppc";
            } else if ("ppc64".equals(architecture)) {
                architectureFolder = "ppc";
            } else if ("s390_64".equals(architecture)) {
                architectureFolder = "s390x";
            }
            File archPath = new File(libPath, architectureFolder);
            library = this.checkForPlatformVersionsInFolder(archPath);
            if (library == null) {
                ldLibraryPath = System.getProperty(JAVA_LIBRARY_PATH);
                for (String path : paths = ldLibraryPath.split(System.getProperty(PATH_SEPARATOR))) {
                    if (path.endsWith(HEALTHCENTER_DLL)) {
                        library = new File(path);
                        break;
                    }
                    if (!path.endsWith(LIBHEALTHCENTER_SO)) continue;
                    library = new File(path);
                    break;
                }
            }
            if (library == null && (ldLibraryPath = System.getenv(JAVA_LIBRARY_PATH)) != null) {
                for (String path : paths = ldLibraryPath.split(System.getProperty(PATH_SEPARATOR))) {
                    if (path.endsWith(HEALTHCENTER_DLL)) {
                        library = new File(path);
                        break;
                    }
                    if (!path.endsWith(LIBHEALTHCENTER_SO)) continue;
                    library = new File(path);
                    break;
                }
            }
        }
        return library;
    }

    private File checkForPlatformVersionsInFolder(File libPath) {
        File library = new File(libPath, HEALTHCENTER_DLL);
        if (!library.exists()) {
            library = new File(libPath, LIBHEALTHCENTER_SO);
        }
        if (!library.exists()) {
            library = null;
        }
        return library;
    }
}

